# AUTOGENERATED! DO NOT EDIT! File to edit: 03_metric.ipynb (unless otherwise specified).

__all__ = ['auc_roc_score', 'ROCAUC']

# Cell
from fastai.vision import *
from fastai.tabular import *
from sklearn.metrics import roc_auc_score

# Cell
def auc_roc_score(input:Tensor, target:Tensor):
    """
    Helper function to run sklearn's roc_auc_score on tensors
    """
    # convert to numpy array
    input, target = input.cpu().numpy(), target.cpu().numpy()
    return roc_auc_score(target, input)

@dataclass
class ROCAUC(AUROC):
    """
    Calculate area under the ROC curve metric after epoch ends.
    """
    def on_epoch_end(self, last_metrics, **kwargs):
        return add_metrics(last_metrics, auc_roc_score(self.preds, self.targs))