/**
 * Connection endpoint of a database cluster or instance.
 *
 * Consists of a combination of hostname and port.
 *
 * @stability stable
 */
export declare class Endpoint {
    /**
     * The hostname of the endpoint.
     *
     * @stability stable
     */
    readonly hostname: string;
    /**
     * The port of the endpoint.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * The combination of "HOSTNAME:PORT" for this endpoint.
     *
     * @stability stable
     */
    readonly socketAddress: string;
    /**
     * @stability stable
     */
    constructor(address: string, port: number);
}
