# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetNotificationConfigResult',
    'AwaitableGetNotificationConfigResult',
    'get_notification_config',
    'get_notification_config_output',
]

@pulumi.output_type
class GetNotificationConfigResult:
    def __init__(__self__, description=None, name=None, pubsub_topic=None, service_account=None, streaming_config=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pubsub_topic and not isinstance(pubsub_topic, str):
            raise TypeError("Expected argument 'pubsub_topic' to be a str")
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if service_account and not isinstance(service_account, str):
            raise TypeError("Expected argument 'service_account' to be a str")
        pulumi.set(__self__, "service_account", service_account)
        if streaming_config and not isinstance(streaming_config, dict):
            raise TypeError("Expected argument 'streaming_config' to be a dict")
        pulumi.set(__self__, "streaming_config", streaming_config)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the notification config (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The relative resource name of this notification config. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name Example: "organizations/{organization_id}/notificationConfigs/notify_public_bucket".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The Pub/Sub topic to send notifications to. Its format is "projects/[project_id]/topics/[topic]".
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The service account that needs "pubsub.topics.publish" permission to publish to the Pub/Sub topic.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="streamingConfig")
    def streaming_config(self) -> 'outputs.StreamingConfigResponse':
        """
        The config for triggering streaming-based notifications.
        """
        return pulumi.get(self, "streaming_config")


class AwaitableGetNotificationConfigResult(GetNotificationConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotificationConfigResult(
            description=self.description,
            name=self.name,
            pubsub_topic=self.pubsub_topic,
            service_account=self.service_account,
            streaming_config=self.streaming_config)


def get_notification_config(notification_config_id: Optional[str] = None,
                            organization_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotificationConfigResult:
    """
    Gets a notification config.
    """
    __args__ = dict()
    __args__['notificationConfigId'] = notification_config_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:securitycenter/v1:getNotificationConfig', __args__, opts=opts, typ=GetNotificationConfigResult).value

    return AwaitableGetNotificationConfigResult(
        description=__ret__.description,
        name=__ret__.name,
        pubsub_topic=__ret__.pubsub_topic,
        service_account=__ret__.service_account,
        streaming_config=__ret__.streaming_config)


@_utilities.lift_output_func(get_notification_config)
def get_notification_config_output(notification_config_id: Optional[pulumi.Input[str]] = None,
                                   organization_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNotificationConfigResult]:
    """
    Gets a notification config.
    """
    ...
