# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AvroFileFormatArgs',
    'BackfillAllStrategyArgs',
    'BackfillNoneStrategyArgs',
    'BigQueryDestinationConfigArgs',
    'BigQueryProfileArgs',
    'DatasetTemplateArgs',
    'DestinationConfigArgs',
    'DropLargeObjectsArgs',
    'ForwardSshTunnelConnectivityArgs',
    'GcsDestinationConfigArgs',
    'GcsProfileArgs',
    'JsonFileFormatArgs',
    'MysqlColumnArgs',
    'MysqlDatabaseArgs',
    'MysqlProfileArgs',
    'MysqlRdbmsArgs',
    'MysqlSourceConfigArgs',
    'MysqlSslConfigArgs',
    'MysqlTableArgs',
    'OracleColumnArgs',
    'OracleProfileArgs',
    'OracleRdbmsArgs',
    'OracleSchemaArgs',
    'OracleSourceConfigArgs',
    'OracleTableArgs',
    'PostgresqlColumnArgs',
    'PostgresqlProfileArgs',
    'PostgresqlRdbmsArgs',
    'PostgresqlSchemaArgs',
    'PostgresqlSourceConfigArgs',
    'PostgresqlTableArgs',
    'PrivateConnectivityArgs',
    'SingleTargetDatasetArgs',
    'SourceConfigArgs',
    'SourceHierarchyDatasetsArgs',
    'StaticServiceIpConnectivityArgs',
    'StreamLargeObjectsArgs',
    'VpcPeeringConfigArgs',
]

@pulumi.input_type
class AvroFileFormatArgs:
    def __init__(__self__):
        """
        AVRO file format configuration.
        """
        pass


@pulumi.input_type
class BackfillAllStrategyArgs:
    def __init__(__self__, *,
                 mysql_excluded_objects: Optional[pulumi.Input['MysqlRdbmsArgs']] = None,
                 oracle_excluded_objects: Optional[pulumi.Input['OracleRdbmsArgs']] = None,
                 postgresql_excluded_objects: Optional[pulumi.Input['PostgresqlRdbmsArgs']] = None):
        """
        Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
        :param pulumi.Input['MysqlRdbmsArgs'] mysql_excluded_objects: MySQL data source objects to avoid backfilling.
        :param pulumi.Input['OracleRdbmsArgs'] oracle_excluded_objects: Oracle data source objects to avoid backfilling.
        :param pulumi.Input['PostgresqlRdbmsArgs'] postgresql_excluded_objects: PostgreSQL data source objects to avoid backfilling.
        """
        if mysql_excluded_objects is not None:
            pulumi.set(__self__, "mysql_excluded_objects", mysql_excluded_objects)
        if oracle_excluded_objects is not None:
            pulumi.set(__self__, "oracle_excluded_objects", oracle_excluded_objects)
        if postgresql_excluded_objects is not None:
            pulumi.set(__self__, "postgresql_excluded_objects", postgresql_excluded_objects)

    @property
    @pulumi.getter(name="mysqlExcludedObjects")
    def mysql_excluded_objects(self) -> Optional[pulumi.Input['MysqlRdbmsArgs']]:
        """
        MySQL data source objects to avoid backfilling.
        """
        return pulumi.get(self, "mysql_excluded_objects")

    @mysql_excluded_objects.setter
    def mysql_excluded_objects(self, value: Optional[pulumi.Input['MysqlRdbmsArgs']]):
        pulumi.set(self, "mysql_excluded_objects", value)

    @property
    @pulumi.getter(name="oracleExcludedObjects")
    def oracle_excluded_objects(self) -> Optional[pulumi.Input['OracleRdbmsArgs']]:
        """
        Oracle data source objects to avoid backfilling.
        """
        return pulumi.get(self, "oracle_excluded_objects")

    @oracle_excluded_objects.setter
    def oracle_excluded_objects(self, value: Optional[pulumi.Input['OracleRdbmsArgs']]):
        pulumi.set(self, "oracle_excluded_objects", value)

    @property
    @pulumi.getter(name="postgresqlExcludedObjects")
    def postgresql_excluded_objects(self) -> Optional[pulumi.Input['PostgresqlRdbmsArgs']]:
        """
        PostgreSQL data source objects to avoid backfilling.
        """
        return pulumi.get(self, "postgresql_excluded_objects")

    @postgresql_excluded_objects.setter
    def postgresql_excluded_objects(self, value: Optional[pulumi.Input['PostgresqlRdbmsArgs']]):
        pulumi.set(self, "postgresql_excluded_objects", value)


@pulumi.input_type
class BackfillNoneStrategyArgs:
    def __init__(__self__):
        """
        Backfill strategy to disable automatic backfill for the Stream's objects.
        """
        pass


@pulumi.input_type
class BigQueryDestinationConfigArgs:
    def __init__(__self__, *,
                 data_freshness: Optional[pulumi.Input[str]] = None,
                 single_target_dataset: Optional[pulumi.Input['SingleTargetDatasetArgs']] = None,
                 source_hierarchy_datasets: Optional[pulumi.Input['SourceHierarchyDatasetsArgs']] = None):
        """
        :param pulumi.Input[str] data_freshness: The guaranteed data freshness (in seconds) when querying tables created by the stream. Editing this field will only affect new tables created in the future, but existing tables will not be impacted. Lower values mean that queries will return fresher data, but may result in higher cost.
        :param pulumi.Input['SingleTargetDatasetArgs'] single_target_dataset: Single destination dataset.
        :param pulumi.Input['SourceHierarchyDatasetsArgs'] source_hierarchy_datasets: Source hierarchy datasets.
        """
        if data_freshness is not None:
            pulumi.set(__self__, "data_freshness", data_freshness)
        if single_target_dataset is not None:
            pulumi.set(__self__, "single_target_dataset", single_target_dataset)
        if source_hierarchy_datasets is not None:
            pulumi.set(__self__, "source_hierarchy_datasets", source_hierarchy_datasets)

    @property
    @pulumi.getter(name="dataFreshness")
    def data_freshness(self) -> Optional[pulumi.Input[str]]:
        """
        The guaranteed data freshness (in seconds) when querying tables created by the stream. Editing this field will only affect new tables created in the future, but existing tables will not be impacted. Lower values mean that queries will return fresher data, but may result in higher cost.
        """
        return pulumi.get(self, "data_freshness")

    @data_freshness.setter
    def data_freshness(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_freshness", value)

    @property
    @pulumi.getter(name="singleTargetDataset")
    def single_target_dataset(self) -> Optional[pulumi.Input['SingleTargetDatasetArgs']]:
        """
        Single destination dataset.
        """
        return pulumi.get(self, "single_target_dataset")

    @single_target_dataset.setter
    def single_target_dataset(self, value: Optional[pulumi.Input['SingleTargetDatasetArgs']]):
        pulumi.set(self, "single_target_dataset", value)

    @property
    @pulumi.getter(name="sourceHierarchyDatasets")
    def source_hierarchy_datasets(self) -> Optional[pulumi.Input['SourceHierarchyDatasetsArgs']]:
        """
        Source hierarchy datasets.
        """
        return pulumi.get(self, "source_hierarchy_datasets")

    @source_hierarchy_datasets.setter
    def source_hierarchy_datasets(self, value: Optional[pulumi.Input['SourceHierarchyDatasetsArgs']]):
        pulumi.set(self, "source_hierarchy_datasets", value)


@pulumi.input_type
class BigQueryProfileArgs:
    def __init__(__self__):
        """
        BigQuery warehouse profile.
        """
        pass


@pulumi.input_type
class DatasetTemplateArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 dataset_id_prefix: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        Dataset template used for dynamic dataset creation.
        :param pulumi.Input[str] location: The geographic location where the dataset should reside. See https://cloud.google.com/bigquery/docs/locations for supported locations.
        :param pulumi.Input[str] dataset_id_prefix: If supplied, every created dataset will have its name prefixed by the provided value. The prefix and name will be separated by an underscore. i.e. _.
        :param pulumi.Input[str] kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key. i.e. projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}. See https://cloud.google.com/bigquery/docs/customer-managed-encryption for more information.
        """
        pulumi.set(__self__, "location", location)
        if dataset_id_prefix is not None:
            pulumi.set(__self__, "dataset_id_prefix", dataset_id_prefix)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The geographic location where the dataset should reside. See https://cloud.google.com/bigquery/docs/locations for supported locations.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="datasetIdPrefix")
    def dataset_id_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        If supplied, every created dataset will have its name prefixed by the provided value. The prefix and name will be separated by an underscore. i.e. _.
        """
        return pulumi.get(self, "dataset_id_prefix")

    @dataset_id_prefix.setter
    def dataset_id_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id_prefix", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table. The BigQuery Service Account associated with your project requires access to this encryption key. i.e. projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{cryptoKey}. See https://cloud.google.com/bigquery/docs/customer-managed-encryption for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class DestinationConfigArgs:
    def __init__(__self__, *,
                 destination_connection_profile: pulumi.Input[str],
                 bigquery_destination_config: Optional[pulumi.Input['BigQueryDestinationConfigArgs']] = None,
                 gcs_destination_config: Optional[pulumi.Input['GcsDestinationConfigArgs']] = None):
        """
        The configuration of the stream destination.
        :param pulumi.Input[str] destination_connection_profile: Destination connection profile resource. Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        :param pulumi.Input['BigQueryDestinationConfigArgs'] bigquery_destination_config: BigQuery destination configuration.
        :param pulumi.Input['GcsDestinationConfigArgs'] gcs_destination_config: A configuration for how data should be loaded to Cloud Storage.
        """
        pulumi.set(__self__, "destination_connection_profile", destination_connection_profile)
        if bigquery_destination_config is not None:
            pulumi.set(__self__, "bigquery_destination_config", bigquery_destination_config)
        if gcs_destination_config is not None:
            pulumi.set(__self__, "gcs_destination_config", gcs_destination_config)

    @property
    @pulumi.getter(name="destinationConnectionProfile")
    def destination_connection_profile(self) -> pulumi.Input[str]:
        """
        Destination connection profile resource. Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        """
        return pulumi.get(self, "destination_connection_profile")

    @destination_connection_profile.setter
    def destination_connection_profile(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_connection_profile", value)

    @property
    @pulumi.getter(name="bigqueryDestinationConfig")
    def bigquery_destination_config(self) -> Optional[pulumi.Input['BigQueryDestinationConfigArgs']]:
        """
        BigQuery destination configuration.
        """
        return pulumi.get(self, "bigquery_destination_config")

    @bigquery_destination_config.setter
    def bigquery_destination_config(self, value: Optional[pulumi.Input['BigQueryDestinationConfigArgs']]):
        pulumi.set(self, "bigquery_destination_config", value)

    @property
    @pulumi.getter(name="gcsDestinationConfig")
    def gcs_destination_config(self) -> Optional[pulumi.Input['GcsDestinationConfigArgs']]:
        """
        A configuration for how data should be loaded to Cloud Storage.
        """
        return pulumi.get(self, "gcs_destination_config")

    @gcs_destination_config.setter
    def gcs_destination_config(self, value: Optional[pulumi.Input['GcsDestinationConfigArgs']]):
        pulumi.set(self, "gcs_destination_config", value)


@pulumi.input_type
class DropLargeObjectsArgs:
    def __init__(__self__):
        """
        Configuration to drop large object values.
        """
        pass


@pulumi.input_type
class ForwardSshTunnelConnectivityArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str],
                 username: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_key: Optional[pulumi.Input[str]] = None):
        """
        Forward SSH Tunnel connectivity.
        :param pulumi.Input[str] hostname: Hostname for the SSH tunnel.
        :param pulumi.Input[str] username: Username for the SSH tunnel.
        :param pulumi.Input[str] password: Input only. SSH password.
        :param pulumi.Input[int] port: Port for the SSH tunnel, default value is 22.
        :param pulumi.Input[str] private_key: Input only. SSH private key.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. SSH password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port for the SSH tunnel, default value is 22.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. SSH private key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)


@pulumi.input_type
class GcsDestinationConfigArgs:
    def __init__(__self__, *,
                 avro_file_format: Optional[pulumi.Input['AvroFileFormatArgs']] = None,
                 file_rotation_interval: Optional[pulumi.Input[str]] = None,
                 file_rotation_mb: Optional[pulumi.Input[int]] = None,
                 json_file_format: Optional[pulumi.Input['JsonFileFormatArgs']] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Google Cloud Storage destination configuration
        :param pulumi.Input['AvroFileFormatArgs'] avro_file_format: AVRO file format configuration.
        :param pulumi.Input[str] file_rotation_interval: The maximum duration for which new events are added before a file is closed and a new file is created.
        :param pulumi.Input[int] file_rotation_mb: The maximum file size to be saved in the bucket.
        :param pulumi.Input['JsonFileFormatArgs'] json_file_format: JSON file format configuration.
        :param pulumi.Input[str] path: Path inside the Cloud Storage bucket to write data to.
        """
        if avro_file_format is not None:
            pulumi.set(__self__, "avro_file_format", avro_file_format)
        if file_rotation_interval is not None:
            pulumi.set(__self__, "file_rotation_interval", file_rotation_interval)
        if file_rotation_mb is not None:
            pulumi.set(__self__, "file_rotation_mb", file_rotation_mb)
        if json_file_format is not None:
            pulumi.set(__self__, "json_file_format", json_file_format)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="avroFileFormat")
    def avro_file_format(self) -> Optional[pulumi.Input['AvroFileFormatArgs']]:
        """
        AVRO file format configuration.
        """
        return pulumi.get(self, "avro_file_format")

    @avro_file_format.setter
    def avro_file_format(self, value: Optional[pulumi.Input['AvroFileFormatArgs']]):
        pulumi.set(self, "avro_file_format", value)

    @property
    @pulumi.getter(name="fileRotationInterval")
    def file_rotation_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum duration for which new events are added before a file is closed and a new file is created.
        """
        return pulumi.get(self, "file_rotation_interval")

    @file_rotation_interval.setter
    def file_rotation_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_rotation_interval", value)

    @property
    @pulumi.getter(name="fileRotationMb")
    def file_rotation_mb(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum file size to be saved in the bucket.
        """
        return pulumi.get(self, "file_rotation_mb")

    @file_rotation_mb.setter
    def file_rotation_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_rotation_mb", value)

    @property
    @pulumi.getter(name="jsonFileFormat")
    def json_file_format(self) -> Optional[pulumi.Input['JsonFileFormatArgs']]:
        """
        JSON file format configuration.
        """
        return pulumi.get(self, "json_file_format")

    @json_file_format.setter
    def json_file_format(self, value: Optional[pulumi.Input['JsonFileFormatArgs']]):
        pulumi.set(self, "json_file_format", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path inside the Cloud Storage bucket to write data to.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class GcsProfileArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 root_path: Optional[pulumi.Input[str]] = None):
        """
        Cloud Storage bucket profile.
        :param pulumi.Input[str] bucket: The Cloud Storage bucket name.
        :param pulumi.Input[str] root_path: The root path inside the Cloud Storage bucket.
        """
        pulumi.set(__self__, "bucket", bucket)
        if root_path is not None:
            pulumi.set(__self__, "root_path", root_path)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="rootPath")
    def root_path(self) -> Optional[pulumi.Input[str]]:
        """
        The root path inside the Cloud Storage bucket.
        """
        return pulumi.get(self, "root_path")

    @root_path.setter
    def root_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_path", value)


@pulumi.input_type
class JsonFileFormatArgs:
    def __init__(__self__, *,
                 compression: Optional[pulumi.Input['JsonFileFormatCompression']] = None,
                 schema_file_format: Optional[pulumi.Input['JsonFileFormatSchemaFileFormat']] = None):
        """
        JSON file format configuration.
        :param pulumi.Input['JsonFileFormatCompression'] compression: Compression of the loaded JSON file.
        :param pulumi.Input['JsonFileFormatSchemaFileFormat'] schema_file_format: The schema file format along JSON data files.
        """
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if schema_file_format is not None:
            pulumi.set(__self__, "schema_file_format", schema_file_format)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input['JsonFileFormatCompression']]:
        """
        Compression of the loaded JSON file.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input['JsonFileFormatCompression']]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="schemaFileFormat")
    def schema_file_format(self) -> Optional[pulumi.Input['JsonFileFormatSchemaFileFormat']]:
        """
        The schema file format along JSON data files.
        """
        return pulumi.get(self, "schema_file_format")

    @schema_file_format.setter
    def schema_file_format(self, value: Optional[pulumi.Input['JsonFileFormatSchemaFileFormat']]):
        pulumi.set(self, "schema_file_format", value)


@pulumi.input_type
class MysqlColumnArgs:
    def __init__(__self__, *,
                 collation: Optional[pulumi.Input[str]] = None,
                 column: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[int]] = None,
                 nullable: Optional[pulumi.Input[bool]] = None,
                 ordinal_position: Optional[pulumi.Input[int]] = None,
                 primary_key: Optional[pulumi.Input[bool]] = None):
        """
        MySQL Column.
        :param pulumi.Input[str] collation: Column collation.
        :param pulumi.Input[str] column: Column name.
        :param pulumi.Input[str] data_type: The MySQL data type. Full data types list can be found here: https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        :param pulumi.Input[int] length: Column length.
        :param pulumi.Input[bool] nullable: Whether or not the column can accept a null value.
        :param pulumi.Input[int] ordinal_position: The ordinal position of the column in the table.
        :param pulumi.Input[bool] primary_key: Whether or not the column represents a primary key.
        """
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        Column collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter
    def column(self) -> Optional[pulumi.Input[str]]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The MySQL data type. Full data types list can be found here: https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def length(self) -> Optional[pulumi.Input[int]]:
        """
        Column length.
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter
    def nullable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @nullable.setter
    def nullable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nullable", value)

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[pulumi.Input[int]]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @ordinal_position.setter
    def ordinal_position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ordinal_position", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary_key", value)


@pulumi.input_type
class MysqlDatabaseArgs:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input[str]] = None,
                 mysql_tables: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlTableArgs']]]] = None):
        """
        MySQL database.
        :param pulumi.Input[str] database: Database name.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlTableArgs']]] mysql_tables: Tables in the database.
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if mysql_tables is not None:
            pulumi.set(__self__, "mysql_tables", mysql_tables)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="mysqlTables")
    def mysql_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlTableArgs']]]]:
        """
        Tables in the database.
        """
        return pulumi.get(self, "mysql_tables")

    @mysql_tables.setter
    def mysql_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlTableArgs']]]]):
        pulumi.set(self, "mysql_tables", value)


@pulumi.input_type
class MysqlProfileArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 ssl_config: Optional[pulumi.Input['MysqlSslConfigArgs']] = None):
        """
        MySQL database profile.
        :param pulumi.Input[str] hostname: Hostname for the MySQL connection.
        :param pulumi.Input[str] password: Input only. Password for the MySQL connection.
        :param pulumi.Input[str] username: Username for the MySQL connection.
        :param pulumi.Input[int] port: Port for the MySQL connection, default value is 3306.
        :param pulumi.Input['MysqlSslConfigArgs'] ssl_config: SSL configuration for the MySQL connection.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl_config is not None:
            pulumi.set(__self__, "ssl_config", ssl_config)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        Hostname for the MySQL connection.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Input only. Password for the MySQL connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username for the MySQL connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port for the MySQL connection, default value is 3306.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="sslConfig")
    def ssl_config(self) -> Optional[pulumi.Input['MysqlSslConfigArgs']]:
        """
        SSL configuration for the MySQL connection.
        """
        return pulumi.get(self, "ssl_config")

    @ssl_config.setter
    def ssl_config(self, value: Optional[pulumi.Input['MysqlSslConfigArgs']]):
        pulumi.set(self, "ssl_config", value)


@pulumi.input_type
class MysqlRdbmsArgs:
    def __init__(__self__, *,
                 mysql_databases: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseArgs']]]] = None):
        """
        MySQL database structure
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseArgs']]] mysql_databases: Mysql databases on the server
        """
        if mysql_databases is not None:
            pulumi.set(__self__, "mysql_databases", mysql_databases)

    @property
    @pulumi.getter(name="mysqlDatabases")
    def mysql_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseArgs']]]]:
        """
        Mysql databases on the server
        """
        return pulumi.get(self, "mysql_databases")

    @mysql_databases.setter
    def mysql_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseArgs']]]]):
        pulumi.set(self, "mysql_databases", value)


@pulumi.input_type
class MysqlSourceConfigArgs:
    def __init__(__self__, *,
                 exclude_objects: Optional[pulumi.Input['MysqlRdbmsArgs']] = None,
                 include_objects: Optional[pulumi.Input['MysqlRdbmsArgs']] = None,
                 max_concurrent_cdc_tasks: Optional[pulumi.Input[int]] = None):
        """
        MySQL source configuration
        :param pulumi.Input['MysqlRdbmsArgs'] exclude_objects: MySQL objects to exclude from the stream.
        :param pulumi.Input['MysqlRdbmsArgs'] include_objects: MySQL objects to retrieve from the source.
        :param pulumi.Input[int] max_concurrent_cdc_tasks: Maximum number of concurrent CDC tasks. The number should be non negative. If not set (or set to 0), the system's default value will be used.
        """
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if max_concurrent_cdc_tasks is not None:
            pulumi.set(__self__, "max_concurrent_cdc_tasks", max_concurrent_cdc_tasks)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional[pulumi.Input['MysqlRdbmsArgs']]:
        """
        MySQL objects to exclude from the stream.
        """
        return pulumi.get(self, "exclude_objects")

    @exclude_objects.setter
    def exclude_objects(self, value: Optional[pulumi.Input['MysqlRdbmsArgs']]):
        pulumi.set(self, "exclude_objects", value)

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional[pulumi.Input['MysqlRdbmsArgs']]:
        """
        MySQL objects to retrieve from the source.
        """
        return pulumi.get(self, "include_objects")

    @include_objects.setter
    def include_objects(self, value: Optional[pulumi.Input['MysqlRdbmsArgs']]):
        pulumi.set(self, "include_objects", value)

    @property
    @pulumi.getter(name="maxConcurrentCdcTasks")
    def max_concurrent_cdc_tasks(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of concurrent CDC tasks. The number should be non negative. If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_cdc_tasks")

    @max_concurrent_cdc_tasks.setter
    def max_concurrent_cdc_tasks(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_cdc_tasks", value)


@pulumi.input_type
class MysqlSslConfigArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None):
        """
        MySQL SSL configuration information.
        :param pulumi.Input[str] ca_certificate: Input only. PEM-encoded certificate of the CA that signed the source database server's certificate.
        :param pulumi.Input[str] client_certificate: Input only. PEM-encoded certificate that will be used by the replica to authenticate against the source database server. If this field is used then the 'client_key' and the 'ca_certificate' fields are mandatory.
        :param pulumi.Input[str] client_key: Input only. PEM-encoded private key associated with the Client Certificate. If this field is used then the 'client_certificate' and the 'ca_certificate' fields are mandatory.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. PEM-encoded certificate of the CA that signed the source database server's certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. PEM-encoded certificate that will be used by the replica to authenticate against the source database server. If this field is used then the 'client_key' and the 'ca_certificate' fields are mandatory.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. PEM-encoded private key associated with the Client Certificate. If this field is used then the 'client_certificate' and the 'ca_certificate' fields are mandatory.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)


@pulumi.input_type
class MysqlTableArgs:
    def __init__(__self__, *,
                 mysql_columns: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlColumnArgs']]]] = None,
                 table: Optional[pulumi.Input[str]] = None):
        """
        MySQL table.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlColumnArgs']]] mysql_columns: MySQL columns in the database. When unspecified as part of include/exclude objects, includes/excludes everything.
        :param pulumi.Input[str] table: Table name.
        """
        if mysql_columns is not None:
            pulumi.set(__self__, "mysql_columns", mysql_columns)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="mysqlColumns")
    def mysql_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlColumnArgs']]]]:
        """
        MySQL columns in the database. When unspecified as part of include/exclude objects, includes/excludes everything.
        """
        return pulumi.get(self, "mysql_columns")

    @mysql_columns.setter
    def mysql_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlColumnArgs']]]]):
        pulumi.set(self, "mysql_columns", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class OracleColumnArgs:
    def __init__(__self__, *,
                 column: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[int]] = None,
                 nullable: Optional[pulumi.Input[bool]] = None,
                 ordinal_position: Optional[pulumi.Input[int]] = None,
                 precision: Optional[pulumi.Input[int]] = None,
                 primary_key: Optional[pulumi.Input[bool]] = None,
                 scale: Optional[pulumi.Input[int]] = None):
        """
        Oracle Column.
        :param pulumi.Input[str] column: Column name.
        :param pulumi.Input[str] data_type: The Oracle data type.
        :param pulumi.Input[str] encoding: Column encoding.
        :param pulumi.Input[int] length: Column length.
        :param pulumi.Input[bool] nullable: Whether or not the column can accept a null value.
        :param pulumi.Input[int] ordinal_position: The ordinal position of the column in the table.
        :param pulumi.Input[int] precision: Column precision.
        :param pulumi.Input[bool] primary_key: Whether or not the column represents a primary key.
        :param pulumi.Input[int] scale: Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[pulumi.Input[str]]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle data type.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        Column encoding.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter
    def length(self) -> Optional[pulumi.Input[int]]:
        """
        Column length.
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter
    def nullable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @nullable.setter
    def nullable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nullable", value)

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[pulumi.Input[int]]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @ordinal_position.setter
    def ordinal_position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ordinal_position", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[int]]:
        """
        Column precision.
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input[int]]:
        """
        Column scale.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scale", value)


@pulumi.input_type
class OracleProfileArgs:
    def __init__(__self__, *,
                 database_service: pulumi.Input[str],
                 hostname: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 connection_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None):
        """
        Oracle database profile.
        :param pulumi.Input[str] database_service: Database for the Oracle connection.
        :param pulumi.Input[str] hostname: Hostname for the Oracle connection.
        :param pulumi.Input[str] password: Password for the Oracle connection.
        :param pulumi.Input[str] username: Username for the Oracle connection.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] connection_attributes: Connection string attributes
        :param pulumi.Input[int] port: Port for the Oracle connection, default value is 1521.
        """
        pulumi.set(__self__, "database_service", database_service)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if connection_attributes is not None:
            pulumi.set(__self__, "connection_attributes", connection_attributes)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="databaseService")
    def database_service(self) -> pulumi.Input[str]:
        """
        Database for the Oracle connection.
        """
        return pulumi.get(self, "database_service")

    @database_service.setter
    def database_service(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_service", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        Hostname for the Oracle connection.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password for the Oracle connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username for the Oracle connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="connectionAttributes")
    def connection_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Connection string attributes
        """
        return pulumi.get(self, "connection_attributes")

    @connection_attributes.setter
    def connection_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "connection_attributes", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port for the Oracle connection, default value is 1521.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class OracleRdbmsArgs:
    def __init__(__self__, *,
                 oracle_schemas: Optional[pulumi.Input[Sequence[pulumi.Input['OracleSchemaArgs']]]] = None):
        """
        Oracle database structure.
        :param pulumi.Input[Sequence[pulumi.Input['OracleSchemaArgs']]] oracle_schemas: Oracle schemas/databases in the database server.
        """
        if oracle_schemas is not None:
            pulumi.set(__self__, "oracle_schemas", oracle_schemas)

    @property
    @pulumi.getter(name="oracleSchemas")
    def oracle_schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OracleSchemaArgs']]]]:
        """
        Oracle schemas/databases in the database server.
        """
        return pulumi.get(self, "oracle_schemas")

    @oracle_schemas.setter
    def oracle_schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OracleSchemaArgs']]]]):
        pulumi.set(self, "oracle_schemas", value)


@pulumi.input_type
class OracleSchemaArgs:
    def __init__(__self__, *,
                 oracle_tables: Optional[pulumi.Input[Sequence[pulumi.Input['OracleTableArgs']]]] = None,
                 schema: Optional[pulumi.Input[str]] = None):
        """
        Oracle schema.
        :param pulumi.Input[Sequence[pulumi.Input['OracleTableArgs']]] oracle_tables: Tables in the schema.
        :param pulumi.Input[str] schema: Schema name.
        """
        if oracle_tables is not None:
            pulumi.set(__self__, "oracle_tables", oracle_tables)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="oracleTables")
    def oracle_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OracleTableArgs']]]]:
        """
        Tables in the schema.
        """
        return pulumi.get(self, "oracle_tables")

    @oracle_tables.setter
    def oracle_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OracleTableArgs']]]]):
        pulumi.set(self, "oracle_tables", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)


@pulumi.input_type
class OracleSourceConfigArgs:
    def __init__(__self__, *,
                 drop_large_objects: Optional[pulumi.Input['DropLargeObjectsArgs']] = None,
                 exclude_objects: Optional[pulumi.Input['OracleRdbmsArgs']] = None,
                 include_objects: Optional[pulumi.Input['OracleRdbmsArgs']] = None,
                 max_concurrent_cdc_tasks: Optional[pulumi.Input[int]] = None,
                 stream_large_objects: Optional[pulumi.Input['StreamLargeObjectsArgs']] = None):
        """
        Oracle data source configuration
        :param pulumi.Input['DropLargeObjectsArgs'] drop_large_objects: Drop large object values.
        :param pulumi.Input['OracleRdbmsArgs'] exclude_objects: Oracle objects to exclude from the stream.
        :param pulumi.Input['OracleRdbmsArgs'] include_objects: Oracle objects to include in the stream.
        :param pulumi.Input[int] max_concurrent_cdc_tasks: Maximum number of concurrent CDC tasks. The number should be non negative. If not set (or set to 0), the system's default value will be used.
        :param pulumi.Input['StreamLargeObjectsArgs'] stream_large_objects: Stream large object values.
        """
        if drop_large_objects is not None:
            pulumi.set(__self__, "drop_large_objects", drop_large_objects)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)
        if max_concurrent_cdc_tasks is not None:
            pulumi.set(__self__, "max_concurrent_cdc_tasks", max_concurrent_cdc_tasks)
        if stream_large_objects is not None:
            pulumi.set(__self__, "stream_large_objects", stream_large_objects)

    @property
    @pulumi.getter(name="dropLargeObjects")
    def drop_large_objects(self) -> Optional[pulumi.Input['DropLargeObjectsArgs']]:
        """
        Drop large object values.
        """
        return pulumi.get(self, "drop_large_objects")

    @drop_large_objects.setter
    def drop_large_objects(self, value: Optional[pulumi.Input['DropLargeObjectsArgs']]):
        pulumi.set(self, "drop_large_objects", value)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional[pulumi.Input['OracleRdbmsArgs']]:
        """
        Oracle objects to exclude from the stream.
        """
        return pulumi.get(self, "exclude_objects")

    @exclude_objects.setter
    def exclude_objects(self, value: Optional[pulumi.Input['OracleRdbmsArgs']]):
        pulumi.set(self, "exclude_objects", value)

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional[pulumi.Input['OracleRdbmsArgs']]:
        """
        Oracle objects to include in the stream.
        """
        return pulumi.get(self, "include_objects")

    @include_objects.setter
    def include_objects(self, value: Optional[pulumi.Input['OracleRdbmsArgs']]):
        pulumi.set(self, "include_objects", value)

    @property
    @pulumi.getter(name="maxConcurrentCdcTasks")
    def max_concurrent_cdc_tasks(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of concurrent CDC tasks. The number should be non negative. If not set (or set to 0), the system's default value will be used.
        """
        return pulumi.get(self, "max_concurrent_cdc_tasks")

    @max_concurrent_cdc_tasks.setter
    def max_concurrent_cdc_tasks(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_cdc_tasks", value)

    @property
    @pulumi.getter(name="streamLargeObjects")
    def stream_large_objects(self) -> Optional[pulumi.Input['StreamLargeObjectsArgs']]:
        """
        Stream large object values.
        """
        return pulumi.get(self, "stream_large_objects")

    @stream_large_objects.setter
    def stream_large_objects(self, value: Optional[pulumi.Input['StreamLargeObjectsArgs']]):
        pulumi.set(self, "stream_large_objects", value)


@pulumi.input_type
class OracleTableArgs:
    def __init__(__self__, *,
                 oracle_columns: Optional[pulumi.Input[Sequence[pulumi.Input['OracleColumnArgs']]]] = None,
                 table: Optional[pulumi.Input[str]] = None):
        """
        Oracle table.
        :param pulumi.Input[Sequence[pulumi.Input['OracleColumnArgs']]] oracle_columns: Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        :param pulumi.Input[str] table: Table name.
        """
        if oracle_columns is not None:
            pulumi.set(__self__, "oracle_columns", oracle_columns)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="oracleColumns")
    def oracle_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OracleColumnArgs']]]]:
        """
        Oracle columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        """
        return pulumi.get(self, "oracle_columns")

    @oracle_columns.setter
    def oracle_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OracleColumnArgs']]]]):
        pulumi.set(self, "oracle_columns", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class PostgresqlColumnArgs:
    def __init__(__self__, *,
                 column: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[int]] = None,
                 nullable: Optional[pulumi.Input[bool]] = None,
                 ordinal_position: Optional[pulumi.Input[int]] = None,
                 precision: Optional[pulumi.Input[int]] = None,
                 primary_key: Optional[pulumi.Input[bool]] = None,
                 scale: Optional[pulumi.Input[int]] = None):
        """
        PostgreSQL Column.
        :param pulumi.Input[str] column: Column name.
        :param pulumi.Input[str] data_type: The PostgreSQL data type.
        :param pulumi.Input[int] length: Column length.
        :param pulumi.Input[bool] nullable: Whether or not the column can accept a null value.
        :param pulumi.Input[int] ordinal_position: The ordinal position of the column in the table.
        :param pulumi.Input[int] precision: Column precision.
        :param pulumi.Input[bool] primary_key: Whether or not the column represents a primary key.
        :param pulumi.Input[int] scale: Column scale.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if ordinal_position is not None:
            pulumi.set(__self__, "ordinal_position", ordinal_position)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def column(self) -> Optional[pulumi.Input[str]]:
        """
        Column name.
        """
        return pulumi.get(self, "column")

    @column.setter
    def column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        The PostgreSQL data type.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def length(self) -> Optional[pulumi.Input[int]]:
        """
        Column length.
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter
    def nullable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the column can accept a null value.
        """
        return pulumi.get(self, "nullable")

    @nullable.setter
    def nullable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nullable", value)

    @property
    @pulumi.getter(name="ordinalPosition")
    def ordinal_position(self) -> Optional[pulumi.Input[int]]:
        """
        The ordinal position of the column in the table.
        """
        return pulumi.get(self, "ordinal_position")

    @ordinal_position.setter
    def ordinal_position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ordinal_position", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[int]]:
        """
        Column precision.
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "precision", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the column represents a primary key.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input[int]]:
        """
        Column scale.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scale", value)


@pulumi.input_type
class PostgresqlProfileArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[str],
                 hostname: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None):
        """
        PostgreSQL database profile.
        :param pulumi.Input[str] database: Database for the PostgreSQL connection.
        :param pulumi.Input[str] hostname: Hostname for the PostgreSQL connection.
        :param pulumi.Input[str] password: Password for the PostgreSQL connection.
        :param pulumi.Input[str] username: Username for the PostgreSQL connection.
        :param pulumi.Input[int] port: Port for the PostgreSQL connection, default value is 5432.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        Database for the PostgreSQL connection.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        Hostname for the PostgreSQL connection.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password for the PostgreSQL connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username for the PostgreSQL connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port for the PostgreSQL connection, default value is 5432.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class PostgresqlRdbmsArgs:
    def __init__(__self__, *,
                 postgresql_schemas: Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlSchemaArgs']]]] = None):
        """
        PostgreSQL database structure.
        :param pulumi.Input[Sequence[pulumi.Input['PostgresqlSchemaArgs']]] postgresql_schemas: PostgreSQL schemas in the database server.
        """
        if postgresql_schemas is not None:
            pulumi.set(__self__, "postgresql_schemas", postgresql_schemas)

    @property
    @pulumi.getter(name="postgresqlSchemas")
    def postgresql_schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlSchemaArgs']]]]:
        """
        PostgreSQL schemas in the database server.
        """
        return pulumi.get(self, "postgresql_schemas")

    @postgresql_schemas.setter
    def postgresql_schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlSchemaArgs']]]]):
        pulumi.set(self, "postgresql_schemas", value)


@pulumi.input_type
class PostgresqlSchemaArgs:
    def __init__(__self__, *,
                 postgresql_tables: Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlTableArgs']]]] = None,
                 schema: Optional[pulumi.Input[str]] = None):
        """
        PostgreSQL schema.
        :param pulumi.Input[Sequence[pulumi.Input['PostgresqlTableArgs']]] postgresql_tables: Tables in the schema.
        :param pulumi.Input[str] schema: Schema name.
        """
        if postgresql_tables is not None:
            pulumi.set(__self__, "postgresql_tables", postgresql_tables)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="postgresqlTables")
    def postgresql_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlTableArgs']]]]:
        """
        Tables in the schema.
        """
        return pulumi.get(self, "postgresql_tables")

    @postgresql_tables.setter
    def postgresql_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlTableArgs']]]]):
        pulumi.set(self, "postgresql_tables", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        Schema name.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)


@pulumi.input_type
class PostgresqlSourceConfigArgs:
    def __init__(__self__, *,
                 publication: pulumi.Input[str],
                 replication_slot: pulumi.Input[str],
                 exclude_objects: Optional[pulumi.Input['PostgresqlRdbmsArgs']] = None,
                 include_objects: Optional[pulumi.Input['PostgresqlRdbmsArgs']] = None):
        """
        PostgreSQL data source configuration
        :param pulumi.Input[str] publication: The name of the publication that includes the set of all tables that are defined in the stream's include_objects.
        :param pulumi.Input[str] replication_slot: The name of the logical replication slot that's configured with the pgoutput plugin.
        :param pulumi.Input['PostgresqlRdbmsArgs'] exclude_objects: PostgreSQL objects to exclude from the stream.
        :param pulumi.Input['PostgresqlRdbmsArgs'] include_objects: PostgreSQL objects to include in the stream.
        """
        pulumi.set(__self__, "publication", publication)
        pulumi.set(__self__, "replication_slot", replication_slot)
        if exclude_objects is not None:
            pulumi.set(__self__, "exclude_objects", exclude_objects)
        if include_objects is not None:
            pulumi.set(__self__, "include_objects", include_objects)

    @property
    @pulumi.getter
    def publication(self) -> pulumi.Input[str]:
        """
        The name of the publication that includes the set of all tables that are defined in the stream's include_objects.
        """
        return pulumi.get(self, "publication")

    @publication.setter
    def publication(self, value: pulumi.Input[str]):
        pulumi.set(self, "publication", value)

    @property
    @pulumi.getter(name="replicationSlot")
    def replication_slot(self) -> pulumi.Input[str]:
        """
        The name of the logical replication slot that's configured with the pgoutput plugin.
        """
        return pulumi.get(self, "replication_slot")

    @replication_slot.setter
    def replication_slot(self, value: pulumi.Input[str]):
        pulumi.set(self, "replication_slot", value)

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Optional[pulumi.Input['PostgresqlRdbmsArgs']]:
        """
        PostgreSQL objects to exclude from the stream.
        """
        return pulumi.get(self, "exclude_objects")

    @exclude_objects.setter
    def exclude_objects(self, value: Optional[pulumi.Input['PostgresqlRdbmsArgs']]):
        pulumi.set(self, "exclude_objects", value)

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Optional[pulumi.Input['PostgresqlRdbmsArgs']]:
        """
        PostgreSQL objects to include in the stream.
        """
        return pulumi.get(self, "include_objects")

    @include_objects.setter
    def include_objects(self, value: Optional[pulumi.Input['PostgresqlRdbmsArgs']]):
        pulumi.set(self, "include_objects", value)


@pulumi.input_type
class PostgresqlTableArgs:
    def __init__(__self__, *,
                 postgresql_columns: Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlColumnArgs']]]] = None,
                 table: Optional[pulumi.Input[str]] = None):
        """
        PostgreSQL table.
        :param pulumi.Input[Sequence[pulumi.Input['PostgresqlColumnArgs']]] postgresql_columns: PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        :param pulumi.Input[str] table: Table name.
        """
        if postgresql_columns is not None:
            pulumi.set(__self__, "postgresql_columns", postgresql_columns)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter(name="postgresqlColumns")
    def postgresql_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlColumnArgs']]]]:
        """
        PostgreSQL columns in the schema. When unspecified as part of include/exclude objects, includes/excludes everything.
        """
        return pulumi.get(self, "postgresql_columns")

    @postgresql_columns.setter
    def postgresql_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PostgresqlColumnArgs']]]]):
        pulumi.set(self, "postgresql_columns", value)

    @property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[str]]:
        """
        Table name.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class PrivateConnectivityArgs:
    def __init__(__self__, *,
                 private_connection: pulumi.Input[str]):
        """
        Private Connectivity
        :param pulumi.Input[str] private_connection: A reference to a private connection resource. Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        """
        pulumi.set(__self__, "private_connection", private_connection)

    @property
    @pulumi.getter(name="privateConnection")
    def private_connection(self) -> pulumi.Input[str]:
        """
        A reference to a private connection resource. Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        """
        return pulumi.get(self, "private_connection")

    @private_connection.setter
    def private_connection(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_connection", value)


@pulumi.input_type
class SingleTargetDatasetArgs:
    def __init__(__self__, *,
                 dataset_id: Optional[pulumi.Input[str]] = None):
        """
        A single target dataset to which all data will be streamed.
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)


@pulumi.input_type
class SourceConfigArgs:
    def __init__(__self__, *,
                 source_connection_profile: pulumi.Input[str],
                 mysql_source_config: Optional[pulumi.Input['MysqlSourceConfigArgs']] = None,
                 oracle_source_config: Optional[pulumi.Input['OracleSourceConfigArgs']] = None,
                 postgresql_source_config: Optional[pulumi.Input['PostgresqlSourceConfigArgs']] = None):
        """
        The configuration of the stream source.
        :param pulumi.Input[str] source_connection_profile: Source connection profile resoource. Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        :param pulumi.Input['MysqlSourceConfigArgs'] mysql_source_config: MySQL data source configuration.
        :param pulumi.Input['OracleSourceConfigArgs'] oracle_source_config: Oracle data source configuration.
        :param pulumi.Input['PostgresqlSourceConfigArgs'] postgresql_source_config: PostgreSQL data source configuration.
        """
        pulumi.set(__self__, "source_connection_profile", source_connection_profile)
        if mysql_source_config is not None:
            pulumi.set(__self__, "mysql_source_config", mysql_source_config)
        if oracle_source_config is not None:
            pulumi.set(__self__, "oracle_source_config", oracle_source_config)
        if postgresql_source_config is not None:
            pulumi.set(__self__, "postgresql_source_config", postgresql_source_config)

    @property
    @pulumi.getter(name="sourceConnectionProfile")
    def source_connection_profile(self) -> pulumi.Input[str]:
        """
        Source connection profile resoource. Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        """
        return pulumi.get(self, "source_connection_profile")

    @source_connection_profile.setter
    def source_connection_profile(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_connection_profile", value)

    @property
    @pulumi.getter(name="mysqlSourceConfig")
    def mysql_source_config(self) -> Optional[pulumi.Input['MysqlSourceConfigArgs']]:
        """
        MySQL data source configuration.
        """
        return pulumi.get(self, "mysql_source_config")

    @mysql_source_config.setter
    def mysql_source_config(self, value: Optional[pulumi.Input['MysqlSourceConfigArgs']]):
        pulumi.set(self, "mysql_source_config", value)

    @property
    @pulumi.getter(name="oracleSourceConfig")
    def oracle_source_config(self) -> Optional[pulumi.Input['OracleSourceConfigArgs']]:
        """
        Oracle data source configuration.
        """
        return pulumi.get(self, "oracle_source_config")

    @oracle_source_config.setter
    def oracle_source_config(self, value: Optional[pulumi.Input['OracleSourceConfigArgs']]):
        pulumi.set(self, "oracle_source_config", value)

    @property
    @pulumi.getter(name="postgresqlSourceConfig")
    def postgresql_source_config(self) -> Optional[pulumi.Input['PostgresqlSourceConfigArgs']]:
        """
        PostgreSQL data source configuration.
        """
        return pulumi.get(self, "postgresql_source_config")

    @postgresql_source_config.setter
    def postgresql_source_config(self, value: Optional[pulumi.Input['PostgresqlSourceConfigArgs']]):
        pulumi.set(self, "postgresql_source_config", value)


@pulumi.input_type
class SourceHierarchyDatasetsArgs:
    def __init__(__self__, *,
                 dataset_template: Optional[pulumi.Input['DatasetTemplateArgs']] = None):
        """
        Destination datasets are created so that hierarchy of the destination data objects matches the source hierarchy.
        """
        if dataset_template is not None:
            pulumi.set(__self__, "dataset_template", dataset_template)

    @property
    @pulumi.getter(name="datasetTemplate")
    def dataset_template(self) -> Optional[pulumi.Input['DatasetTemplateArgs']]:
        return pulumi.get(self, "dataset_template")

    @dataset_template.setter
    def dataset_template(self, value: Optional[pulumi.Input['DatasetTemplateArgs']]):
        pulumi.set(self, "dataset_template", value)


@pulumi.input_type
class StaticServiceIpConnectivityArgs:
    def __init__(__self__):
        """
        Static IP address connectivity.
        """
        pass


@pulumi.input_type
class StreamLargeObjectsArgs:
    def __init__(__self__):
        """
        Configuration to stream large object values.
        """
        pass


@pulumi.input_type
class VpcPeeringConfigArgs:
    def __init__(__self__, *,
                 subnet: pulumi.Input[str],
                 vpc: pulumi.Input[str]):
        """
        The VPC Peering configuration is used to create VPC peering between Datastream and the consumer's VPC.
        :param pulumi.Input[str] subnet: A free subnet for peering. (CIDR of /29)
        :param pulumi.Input[str] vpc: Fully qualified name of the VPC that Datastream will peer to. Format: `projects/{project}/global/{networks}/{name}`
        """
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        A free subnet for peering. (CIDR of /29)
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def vpc(self) -> pulumi.Input[str]:
        """
        Fully qualified name of the VPC that Datastream will peer to. Format: `projects/{project}/global/{networks}/{name}`
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc", value)


