# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AnalysisCompletedResponse',
    'ArtifactResponse',
    'AttestationAuthorityHintResponse',
    'AttestationAuthorityResponse',
    'AttestationResponse',
    'BasisResponse',
    'BindingResponse',
    'BuildDetailsResponse',
    'BuildProvenanceResponse',
    'BuildSignatureResponse',
    'BuildTypeResponse',
    'BuilderConfigResponse',
    'CVSSResponse',
    'CisBenchmarkResponse',
    'CommandResponse',
    'CompletenessResponse',
    'ComplianceNoteResponse',
    'ComplianceOccurrenceResponse',
    'ComplianceVersionResponse',
    'DSSEAttestationNoteResponse',
    'DSSEAttestationOccurrenceResponse',
    'DSSEHintResponse',
    'DeployableResponse',
    'DeploymentResponse',
    'DerivedResponse',
    'DetailResponse',
    'DigestResponse',
    'DiscoveredResponse',
    'DiscoveryResponse',
    'DistributionResponse',
    'DocumentNoteResponse',
    'DocumentOccurrenceResponse',
    'EnvelopeResponse',
    'EnvelopeSignatureResponse',
    'ExprResponse',
    'ExternalRefResponse',
    'FileLocationResponse',
    'FileNoteResponse',
    'FileOccurrenceResponse',
    'FingerprintResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaBuilderResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaCompletenessResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaConfigSourceResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaInvocationResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMaterialResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMetadataResponse',
    'GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse',
    'HashResponse',
    'InTotoProvenanceResponse',
    'InTotoStatementResponse',
    'InstallationResponse',
    'LayerResponse',
    'LicenseResponse',
    'LocationResponse',
    'MaterialResponse',
    'MetadataResponse',
    'NonCompliantFileResponse',
    'OperationResponse',
    'PackageInfoNoteResponse',
    'PackageInfoOccurrenceResponse',
    'PackageIssueResponse',
    'PackageResponse',
    'PgpSignedAttestationResponse',
    'RecipeResponse',
    'RelatedUrlResponse',
    'RelationshipNoteResponse',
    'RelationshipOccurrenceResponse',
    'RepoSourceResponse',
    'ResourceResponse',
    'SlsaBuilderResponse',
    'SlsaCompletenessResponse',
    'SlsaMetadataResponse',
    'SlsaProvenanceResponse',
    'SlsaProvenanceZeroTwoResponse',
    'SlsaRecipeResponse',
    'SourceResponse',
    'StatusResponse',
    'StorageSourceResponse',
    'SubjectResponse',
    'UpgradeDistributionResponse',
    'UpgradeNoteResponse',
    'UpgradeOccurrenceResponse',
    'VersionResponse',
    'VulnerabilityDetailsResponse',
    'VulnerabilityLocationResponse',
    'VulnerabilityTypeResponse',
]

@pulumi.output_type
class AnalysisCompletedResponse(dict):
    """
    Indicates which analysis completed successfully. Multiple types of analysis can be performed on a single resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisType":
            suggest = "analysis_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalysisCompletedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalysisCompletedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalysisCompletedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_type: Sequence[str]):
        """
        Indicates which analysis completed successfully. Multiple types of analysis can be performed on a single resource.
        :param Sequence[str] analysis_type: type of analysis that were completed on a resource.
        """
        pulumi.set(__self__, "analysis_type", analysis_type)

    @property
    @pulumi.getter(name="analysisType")
    def analysis_type(self) -> Sequence[str]:
        """
        type of analysis that were completed on a resource.
        """
        return pulumi.get(self, "analysis_type")


@pulumi.output_type
class ArtifactResponse(dict):
    """
    Artifact describes a build product.
    """
    def __init__(__self__, *,
                 checksum: str,
                 name: str,
                 names: Sequence[str]):
        """
        Artifact describes a build product.
        :param str checksum: Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        :param str name: Name of the artifact. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. This field is deprecated in favor of the plural `names` field; it continues to exist here to allow existing BuildProvenance serialized to json in google.devtools.containeranalysis.v1alpha1.BuildDetails.provenance_bytes to deserialize back into proto.
        :param Sequence[str] names: Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the artifact. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. This field is deprecated in favor of the plural `names` field; it continues to exist here to allow existing BuildProvenance serialized to json in google.devtools.containeranalysis.v1alpha1.BuildDetails.provenance_bytes to deserialize back into proto.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class AttestationAuthorityHintResponse(dict):
    """
    This submessage provides human-readable hints about the purpose of the AttestationAuthority. Because the name of a Note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should NOT be used to look up AttestationAuthorities in security sensitive contexts, such as when looking up Attestations to verify.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "humanReadableName":
            suggest = "human_readable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttestationAuthorityHintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttestationAuthorityHintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttestationAuthorityHintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 human_readable_name: str):
        """
        This submessage provides human-readable hints about the purpose of the AttestationAuthority. Because the name of a Note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should NOT be used to look up AttestationAuthorities in security sensitive contexts, such as when looking up Attestations to verify.
        :param str human_readable_name: The human readable name of this Attestation Authority, for example "qa".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> str:
        """
        The human readable name of this Attestation Authority, for example "qa".
        """
        return pulumi.get(self, "human_readable_name")


@pulumi.output_type
class AttestationAuthorityResponse(dict):
    """
    Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `AttestationAuthority` for "QA" and one for "build". This Note is intended to act strictly as a grouping mechanism for the attached Occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an Occurrence to a given Note. It also provides a single point of lookup to find all attached Attestation Occurrences, even if they don't all live in the same project.
    """
    def __init__(__self__, *,
                 hint: 'outputs.AttestationAuthorityHintResponse'):
        """
        Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `AttestationAuthority` for "QA" and one for "build". This Note is intended to act strictly as a grouping mechanism for the attached Occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an Occurrence to a given Note. It also provides a single point of lookup to find all attached Attestation Occurrences, even if they don't all live in the same project.
        """
        pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> 'outputs.AttestationAuthorityHintResponse':
        return pulumi.get(self, "hint")


@pulumi.output_type
class AttestationResponse(dict):
    """
    Occurrence that represents a single "attestation". The authenticity of an Attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the AttestationAuthority to which this Attestation is attached is primarily useful for look-up (how to find this Attestation if you already know the Authority and artifact to be verified) and intent (which authority was this attestation intended to sign for).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pgpSignedAttestation":
            suggest = "pgp_signed_attestation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttestationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttestationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttestationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pgp_signed_attestation: 'outputs.PgpSignedAttestationResponse'):
        """
        Occurrence that represents a single "attestation". The authenticity of an Attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the AttestationAuthority to which this Attestation is attached is primarily useful for look-up (how to find this Attestation if you already know the Authority and artifact to be verified) and intent (which authority was this attestation intended to sign for).
        """
        pulumi.set(__self__, "pgp_signed_attestation", pgp_signed_attestation)

    @property
    @pulumi.getter(name="pgpSignedAttestation")
    def pgp_signed_attestation(self) -> 'outputs.PgpSignedAttestationResponse':
        return pulumi.get(self, "pgp_signed_attestation")


@pulumi.output_type
class BasisResponse(dict):
    """
    Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g. a tag of the resource_url.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUrl":
            suggest = "resource_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasisResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasisResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasisResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fingerprint: 'outputs.FingerprintResponse',
                 resource_url: str):
        """
        Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g. a tag of the resource_url.
        :param 'FingerprintResponse' fingerprint: The fingerprint of the base image.
        :param str resource_url: The resource_url for the resource representing the basis of associated occurrence images.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter
    def fingerprint(self) -> 'outputs.FingerprintResponse':
        """
        The fingerprint of the base image.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> str:
        """
        The resource_url for the resource representing the basis of associated occurrence images.
        """
        return pulumi.get(self, "resource_url")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class BuildDetailsResponse(dict):
    """
    Message encapsulating build provenance details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intotoProvenance":
            suggest = "intoto_provenance"
        elif key == "intotoStatement":
            suggest = "intoto_statement"
        elif key == "provenanceBytes":
            suggest = "provenance_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intoto_provenance: 'outputs.InTotoProvenanceResponse',
                 intoto_statement: 'outputs.InTotoStatementResponse',
                 provenance: 'outputs.BuildProvenanceResponse',
                 provenance_bytes: str):
        """
        Message encapsulating build provenance details.
        :param 'InTotoProvenanceResponse' intoto_provenance: Deprecated. See InTotoStatement for the replacement. In-toto Provenance representation as defined in spec.
        :param 'InTotoStatementResponse' intoto_statement: In-toto Statement representation as defined in spec. The intoto_statement can contain any type of provenance. The serialized payload of the statement can be stored and signed in the Occurrence's envelope.
        :param 'BuildProvenanceResponse' provenance: The actual provenance
        :param str provenance_bytes: Serialized JSON representation of the provenance, used in generating the `BuildSignature` in the corresponding Result. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        pulumi.set(__self__, "intoto_provenance", intoto_provenance)
        pulumi.set(__self__, "intoto_statement", intoto_statement)
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "provenance_bytes", provenance_bytes)

    @property
    @pulumi.getter(name="intotoProvenance")
    def intoto_provenance(self) -> 'outputs.InTotoProvenanceResponse':
        """
        Deprecated. See InTotoStatement for the replacement. In-toto Provenance representation as defined in spec.
        """
        return pulumi.get(self, "intoto_provenance")

    @property
    @pulumi.getter(name="intotoStatement")
    def intoto_statement(self) -> 'outputs.InTotoStatementResponse':
        """
        In-toto Statement representation as defined in spec. The intoto_statement can contain any type of provenance. The serialized payload of the statement can be stored and signed in the Occurrence's envelope.
        """
        return pulumi.get(self, "intoto_statement")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.BuildProvenanceResponse':
        """
        The actual provenance
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter(name="provenanceBytes")
    def provenance_bytes(self) -> str:
        """
        Serialized JSON representation of the provenance, used in generating the `BuildSignature` in the corresponding Result. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        return pulumi.get(self, "provenance_bytes")


@pulumi.output_type
class BuildProvenanceResponse(dict):
    """
    Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildOptions":
            suggest = "build_options"
        elif key == "builderVersion":
            suggest = "builder_version"
        elif key == "builtArtifacts":
            suggest = "built_artifacts"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "finishTime":
            suggest = "finish_time"
        elif key == "logsBucket":
            suggest = "logs_bucket"
        elif key == "sourceProvenance":
            suggest = "source_provenance"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "triggerId":
            suggest = "trigger_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildProvenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildProvenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildProvenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_options: Mapping[str, str],
                 builder_version: str,
                 built_artifacts: Sequence['outputs.ArtifactResponse'],
                 commands: Sequence['outputs.CommandResponse'],
                 create_time: str,
                 creator: str,
                 finish_time: str,
                 logs_bucket: str,
                 project: str,
                 source_provenance: 'outputs.SourceResponse',
                 start_time: str,
                 trigger_id: str):
        """
        Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
        :param Mapping[str, str] build_options: Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        :param str builder_version: Version string of the builder at the time this build was executed.
        :param Sequence['ArtifactResponse'] built_artifacts: Output of the build.
        :param Sequence['CommandResponse'] commands: Commands requested by the build.
        :param str create_time: Time at which the build was created.
        :param str creator: E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        :param str finish_time: Time at which execution of the build was finished.
        :param str logs_bucket: Google Cloud Storage bucket where logs were written.
        :param str project: ID of the project.
        :param 'SourceResponse' source_provenance: Details of the Source input to the build.
        :param str start_time: Time at which execution of the build was started.
        :param str trigger_id: Trigger identifier if the build was triggered automatically; empty if not.
        """
        pulumi.set(__self__, "build_options", build_options)
        pulumi.set(__self__, "builder_version", builder_version)
        pulumi.set(__self__, "built_artifacts", built_artifacts)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator", creator)
        pulumi.set(__self__, "finish_time", finish_time)
        pulumi.set(__self__, "logs_bucket", logs_bucket)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "source_provenance", source_provenance)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter(name="buildOptions")
    def build_options(self) -> Mapping[str, str]:
        """
        Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        """
        return pulumi.get(self, "build_options")

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> str:
        """
        Version string of the builder at the time this build was executed.
        """
        return pulumi.get(self, "builder_version")

    @property
    @pulumi.getter(name="builtArtifacts")
    def built_artifacts(self) -> Sequence['outputs.ArtifactResponse']:
        """
        Output of the build.
        """
        return pulumi.get(self, "built_artifacts")

    @property
    @pulumi.getter
    def commands(self) -> Sequence['outputs.CommandResponse']:
        """
        Commands requested by the build.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> str:
        """
        Time at which execution of the build was finished.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> str:
        """
        Google Cloud Storage bucket where logs were written.
        """
        return pulumi.get(self, "logs_bucket")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> 'outputs.SourceResponse':
        """
        Details of the Source input to the build.
        """
        return pulumi.get(self, "source_provenance")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> str:
        """
        Trigger identifier if the build was triggered automatically; empty if not.
        """
        return pulumi.get(self, "trigger_id")


@pulumi.output_type
class BuildSignatureResponse(dict):
    """
    Message encapsulating the signature of the verified build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "keyType":
            suggest = "key_type"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildSignatureResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildSignatureResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildSignatureResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str,
                 key_type: str,
                 public_key: str,
                 signature: str):
        """
        Message encapsulating the signature of the verified build.
        :param str key_id: An Id for the key used to sign. This could be either an Id for the key stored in `public_key` (such as the Id or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        :param str key_type: The type of the key, either stored in `public_key` or referenced in `key_id`
        :param str public_key: Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        :param str signature: Signature of the related `BuildProvenance`, encoded in a base64 string.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_type", key_type)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        An Id for the key used to sign. This could be either an Id for the key stored in `public_key` (such as the Id or fingerprint for a PGP key, or the CN for a cert), or a reference to an external key (such as a reference to a key in Cloud Key Management Service).
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        The type of the key, either stored in `public_key` or referenced in `key_id`
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        Public key of the builder which can be used to verify that the related findings are valid and unchanged. If `key_type` is empty, this defaults to PEM encoded public keys. This field may be empty if `key_id` references an external key. For Cloud Build based signatures, this is a PEM encoded public key. To verify the Cloud Build signature, place the contents of this field into a file (public.pem). The signature field is base64-decoded into its binary representation in signature.bin, and the provenance bytes from `BuildDetails` are base64-decoded into a binary representation in signed.bin. OpenSSL can then verify the signature: `openssl sha256 -verify public.pem -signature signature.bin signed.bin`
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        Signature of the related `BuildProvenance`, encoded in a base64 string.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class BuildTypeResponse(dict):
    """
    Note holding the version of the provider's builder and the signature of the provenance message in linked BuildDetails.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builderVersion":
            suggest = "builder_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 builder_version: str,
                 signature: 'outputs.BuildSignatureResponse'):
        """
        Note holding the version of the provider's builder and the signature of the provenance message in linked BuildDetails.
        :param str builder_version: Version of the builder which produced this Note.
        :param 'BuildSignatureResponse' signature: Signature of the build in Occurrences pointing to the Note containing this `BuilderDetails`.
        """
        pulumi.set(__self__, "builder_version", builder_version)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> str:
        """
        Version of the builder which produced this Note.
        """
        return pulumi.get(self, "builder_version")

    @property
    @pulumi.getter
    def signature(self) -> 'outputs.BuildSignatureResponse':
        """
        Signature of the build in Occurrences pointing to the Note containing this `BuilderDetails`.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class BuilderConfigResponse(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class CVSSResponse(dict):
    """
    Common Vulnerability Scoring System. This message is compatible with CVSS v2 and v3. For CVSS v2 details, see https://www.first.org/cvss/v2/guide CVSS v2 calculator: https://nvd.nist.gov/vuln-metrics/cvss/v2-calculator For CVSS v3 details, see https://www.first.org/cvss/specification-document CVSS v3 calculator: https://nvd.nist.gov/vuln-metrics/cvss/v3-calculator
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attackComplexity":
            suggest = "attack_complexity"
        elif key == "attackVector":
            suggest = "attack_vector"
        elif key == "availabilityImpact":
            suggest = "availability_impact"
        elif key == "baseScore":
            suggest = "base_score"
        elif key == "confidentialityImpact":
            suggest = "confidentiality_impact"
        elif key == "exploitabilityScore":
            suggest = "exploitability_score"
        elif key == "impactScore":
            suggest = "impact_score"
        elif key == "integrityImpact":
            suggest = "integrity_impact"
        elif key == "privilegesRequired":
            suggest = "privileges_required"
        elif key == "userInteraction":
            suggest = "user_interaction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CVSSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CVSSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CVSSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attack_complexity: str,
                 attack_vector: str,
                 authentication: str,
                 availability_impact: str,
                 base_score: float,
                 confidentiality_impact: str,
                 exploitability_score: float,
                 impact_score: float,
                 integrity_impact: str,
                 privileges_required: str,
                 scope: str,
                 user_interaction: str):
        """
        Common Vulnerability Scoring System. This message is compatible with CVSS v2 and v3. For CVSS v2 details, see https://www.first.org/cvss/v2/guide CVSS v2 calculator: https://nvd.nist.gov/vuln-metrics/cvss/v2-calculator For CVSS v3 details, see https://www.first.org/cvss/specification-document CVSS v3 calculator: https://nvd.nist.gov/vuln-metrics/cvss/v3-calculator
        :param str attack_complexity: Defined in CVSS v3, CVSS v2
        :param str attack_vector: Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments. Defined in CVSS v3, CVSS v2
        :param str authentication: Defined in CVSS v2
        :param str availability_impact: Defined in CVSS v3, CVSS v2
        :param float base_score: The base score is a function of the base metric scores.
        :param str confidentiality_impact: Defined in CVSS v3, CVSS v2
        :param str integrity_impact: Defined in CVSS v3, CVSS v2
        :param str privileges_required: Defined in CVSS v3
        :param str scope: Defined in CVSS v3
        :param str user_interaction: Defined in CVSS v3
        """
        pulumi.set(__self__, "attack_complexity", attack_complexity)
        pulumi.set(__self__, "attack_vector", attack_vector)
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "availability_impact", availability_impact)
        pulumi.set(__self__, "base_score", base_score)
        pulumi.set(__self__, "confidentiality_impact", confidentiality_impact)
        pulumi.set(__self__, "exploitability_score", exploitability_score)
        pulumi.set(__self__, "impact_score", impact_score)
        pulumi.set(__self__, "integrity_impact", integrity_impact)
        pulumi.set(__self__, "privileges_required", privileges_required)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "user_interaction", user_interaction)

    @property
    @pulumi.getter(name="attackComplexity")
    def attack_complexity(self) -> str:
        """
        Defined in CVSS v3, CVSS v2
        """
        return pulumi.get(self, "attack_complexity")

    @property
    @pulumi.getter(name="attackVector")
    def attack_vector(self) -> str:
        """
        Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments. Defined in CVSS v3, CVSS v2
        """
        return pulumi.get(self, "attack_vector")

    @property
    @pulumi.getter
    def authentication(self) -> str:
        """
        Defined in CVSS v2
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="availabilityImpact")
    def availability_impact(self) -> str:
        """
        Defined in CVSS v3, CVSS v2
        """
        return pulumi.get(self, "availability_impact")

    @property
    @pulumi.getter(name="baseScore")
    def base_score(self) -> float:
        """
        The base score is a function of the base metric scores.
        """
        return pulumi.get(self, "base_score")

    @property
    @pulumi.getter(name="confidentialityImpact")
    def confidentiality_impact(self) -> str:
        """
        Defined in CVSS v3, CVSS v2
        """
        return pulumi.get(self, "confidentiality_impact")

    @property
    @pulumi.getter(name="exploitabilityScore")
    def exploitability_score(self) -> float:
        return pulumi.get(self, "exploitability_score")

    @property
    @pulumi.getter(name="impactScore")
    def impact_score(self) -> float:
        return pulumi.get(self, "impact_score")

    @property
    @pulumi.getter(name="integrityImpact")
    def integrity_impact(self) -> str:
        """
        Defined in CVSS v3, CVSS v2
        """
        return pulumi.get(self, "integrity_impact")

    @property
    @pulumi.getter(name="privilegesRequired")
    def privileges_required(self) -> str:
        """
        Defined in CVSS v3
        """
        return pulumi.get(self, "privileges_required")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Defined in CVSS v3
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="userInteraction")
    def user_interaction(self) -> str:
        """
        Defined in CVSS v3
        """
        return pulumi.get(self, "user_interaction")


@pulumi.output_type
class CisBenchmarkResponse(dict):
    """
    A compliance check that is a CIS benchmark.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "profileLevel":
            suggest = "profile_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CisBenchmarkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CisBenchmarkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CisBenchmarkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 profile_level: int,
                 severity: str):
        """
        A compliance check that is a CIS benchmark.
        :param int profile_level: The profile level of this CIS benchmark check.
        :param str severity: The severity level of this CIS benchmark check.
        """
        pulumi.set(__self__, "profile_level", profile_level)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="profileLevel")
    def profile_level(self) -> int:
        """
        The profile level of this CIS benchmark check.
        """
        return pulumi.get(self, "profile_level")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity level of this CIS benchmark check.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class CommandResponse(dict):
    """
    Command describes a step performed as part of the build pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "waitFor":
            suggest = "wait_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommandResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommandResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommandResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 dir: str,
                 env: Sequence[str],
                 name: str,
                 wait_for: Sequence[str]):
        """
        Command describes a step performed as part of the build pipeline.
        :param Sequence[str] args: Command-line arguments used when executing this Command.
        :param str dir: Working directory (relative to project source root) used when running this Command.
        :param Sequence[str] env: Environment variables set before running this Command.
        :param str name: Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        :param Sequence[str] wait_for: The ID(s) of the Command(s) that this Command depends on.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Command-line arguments used when executing this Command.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        Working directory (relative to project source root) used when running this Command.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter
    def env(self) -> Sequence[str]:
        """
        Environment variables set before running this Command.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Sequence[str]:
        """
        The ID(s) of the Command(s) that this Command depends on.
        """
        return pulumi.get(self, "wait_for")


@pulumi.output_type
class CompletenessResponse(dict):
    """
    Indicates that the builder claims certain fields in this message to be complete.
    """
    def __init__(__self__, *,
                 arguments: bool,
                 environment: bool,
                 materials: bool):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param bool arguments: If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        :param bool environment: If true, the builder claims that recipe.environment is claimed to be complete.
        :param bool materials: If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "materials", materials)

    @property
    @pulumi.getter
    def arguments(self) -> bool:
        """
        If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def environment(self) -> bool:
        """
        If true, the builder claims that recipe.environment is claimed to be complete.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def materials(self) -> bool:
        """
        If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        return pulumi.get(self, "materials")


@pulumi.output_type
class ComplianceNoteResponse(dict):
    """
    ComplianceNote encapsulates all information about a specific compliance check.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cisBenchmark":
            suggest = "cis_benchmark"
        elif key == "scanInstructions":
            suggest = "scan_instructions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComplianceNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComplianceNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComplianceNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cis_benchmark: 'outputs.CisBenchmarkResponse',
                 description: str,
                 rationale: str,
                 remediation: str,
                 scan_instructions: str,
                 title: str,
                 version: Sequence['outputs.ComplianceVersionResponse']):
        """
        ComplianceNote encapsulates all information about a specific compliance check.
        :param 'CisBenchmarkResponse' cis_benchmark: Right now we only have one compliance type, but we may add additional types in the future.
        :param str description: A description about this compliance check.
        :param str rationale: A rationale for the existence of this compliance check.
        :param str remediation: A description of remediation steps if the compliance check fails.
        :param str scan_instructions: Serialized scan instructions with a predefined format.
        :param str title: The title that identifies this compliance check.
        :param Sequence['ComplianceVersionResponse'] version: The OS and config versions the benchmark applies to.
        """
        pulumi.set(__self__, "cis_benchmark", cis_benchmark)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "rationale", rationale)
        pulumi.set(__self__, "remediation", remediation)
        pulumi.set(__self__, "scan_instructions", scan_instructions)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cisBenchmark")
    def cis_benchmark(self) -> 'outputs.CisBenchmarkResponse':
        """
        Right now we only have one compliance type, but we may add additional types in the future.
        """
        return pulumi.get(self, "cis_benchmark")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description about this compliance check.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def rationale(self) -> str:
        """
        A rationale for the existence of this compliance check.
        """
        return pulumi.get(self, "rationale")

    @property
    @pulumi.getter
    def remediation(self) -> str:
        """
        A description of remediation steps if the compliance check fails.
        """
        return pulumi.get(self, "remediation")

    @property
    @pulumi.getter(name="scanInstructions")
    def scan_instructions(self) -> str:
        """
        Serialized scan instructions with a predefined format.
        """
        return pulumi.get(self, "scan_instructions")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The title that identifies this compliance check.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def version(self) -> Sequence['outputs.ComplianceVersionResponse']:
        """
        The OS and config versions the benchmark applies to.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComplianceOccurrenceResponse(dict):
    """
    An indication that the compliance checks in the associated ComplianceNote were not satisfied for particular resources or a specified reason.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonComplianceReason":
            suggest = "non_compliance_reason"
        elif key == "nonCompliantFiles":
            suggest = "non_compliant_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComplianceOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComplianceOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComplianceOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 non_compliance_reason: str,
                 non_compliant_files: Sequence['outputs.NonCompliantFileResponse']):
        """
        An indication that the compliance checks in the associated ComplianceNote were not satisfied for particular resources or a specified reason.
        :param str non_compliance_reason: The reason for non compliance of these files.
        :param Sequence['NonCompliantFileResponse'] non_compliant_files: A list of files which are violating compliance checks.
        """
        pulumi.set(__self__, "non_compliance_reason", non_compliance_reason)
        pulumi.set(__self__, "non_compliant_files", non_compliant_files)

    @property
    @pulumi.getter(name="nonComplianceReason")
    def non_compliance_reason(self) -> str:
        """
        The reason for non compliance of these files.
        """
        return pulumi.get(self, "non_compliance_reason")

    @property
    @pulumi.getter(name="nonCompliantFiles")
    def non_compliant_files(self) -> Sequence['outputs.NonCompliantFileResponse']:
        """
        A list of files which are violating compliance checks.
        """
        return pulumi.get(self, "non_compliant_files")


@pulumi.output_type
class ComplianceVersionResponse(dict):
    """
    Describes the CIS benchmark version that is applicable to a given OS and os version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "benchmarkDocument":
            suggest = "benchmark_document"
        elif key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComplianceVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComplianceVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComplianceVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 benchmark_document: str,
                 cpe_uri: str,
                 version: str):
        """
        Describes the CIS benchmark version that is applicable to a given OS and os version.
        :param str benchmark_document: The name of the document that defines this benchmark, e.g. "CIS Container-Optimized OS".
        :param str cpe_uri: The CPE URI (https://cpe.mitre.org/specification/) this benchmark is applicable to.
        :param str version: The version of the benchmark. This is set to the version of the OS-specific CIS document the benchmark is defined in.
        """
        pulumi.set(__self__, "benchmark_document", benchmark_document)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="benchmarkDocument")
    def benchmark_document(self) -> str:
        """
        The name of the document that defines this benchmark, e.g. "CIS Container-Optimized OS".
        """
        return pulumi.get(self, "benchmark_document")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The CPE URI (https://cpe.mitre.org/specification/) this benchmark is applicable to.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the benchmark. This is set to the version of the OS-specific CIS document the benchmark is defined in.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DSSEAttestationNoteResponse(dict):
    """
    A note describing an attestation
    """
    def __init__(__self__, *,
                 hint: 'outputs.DSSEHintResponse'):
        """
        A note describing an attestation
        :param 'DSSEHintResponse' hint: DSSEHint hints at the purpose of the attestation authority.
        """
        pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> 'outputs.DSSEHintResponse':
        """
        DSSEHint hints at the purpose of the attestation authority.
        """
        return pulumi.get(self, "hint")


@pulumi.output_type
class DSSEAttestationOccurrenceResponse(dict):
    """
    An occurrence describing an attestation on a resource
    """
    def __init__(__self__, *,
                 envelope: 'outputs.EnvelopeResponse',
                 statement: 'outputs.InTotoStatementResponse'):
        """
        An occurrence describing an attestation on a resource
        :param 'EnvelopeResponse' envelope: If doing something security critical, make sure to verify the signatures in this metadata.
        """
        pulumi.set(__self__, "envelope", envelope)
        pulumi.set(__self__, "statement", statement)

    @property
    @pulumi.getter
    def envelope(self) -> 'outputs.EnvelopeResponse':
        """
        If doing something security critical, make sure to verify the signatures in this metadata.
        """
        return pulumi.get(self, "envelope")

    @property
    @pulumi.getter
    def statement(self) -> 'outputs.InTotoStatementResponse':
        return pulumi.get(self, "statement")


@pulumi.output_type
class DSSEHintResponse(dict):
    """
    This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "humanReadableName":
            suggest = "human_readable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DSSEHintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DSSEHintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DSSEHintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 human_readable_name: str):
        """
        This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
        :param str human_readable_name: The human readable name of this attestation authority, for example "cloudbuild-prod".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> str:
        """
        The human readable name of this attestation authority, for example "cloudbuild-prod".
        """
        return pulumi.get(self, "human_readable_name")


@pulumi.output_type
class DeployableResponse(dict):
    """
    An artifact that can be deployed in some runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeployableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeployableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeployableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_uri: Sequence[str]):
        """
        An artifact that can be deployed in some runtime.
        :param Sequence[str] resource_uri: Resource URI for the artifact being deployed.
        """
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Sequence[str]:
        """
        Resource URI for the artifact being deployed.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class DeploymentResponse(dict):
    """
    The period during which some deployable was active in a runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployTime":
            suggest = "deploy_time"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "undeployTime":
            suggest = "undeploy_time"
        elif key == "userEmail":
            suggest = "user_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 config: str,
                 deploy_time: str,
                 platform: str,
                 resource_uri: Sequence[str],
                 undeploy_time: str,
                 user_email: str):
        """
        The period during which some deployable was active in a runtime.
        :param str address: Address of the runtime element hosting this deployment.
        :param str config: Configuration used to create this deployment.
        :param str deploy_time: Beginning of the lifetime of this deployment.
        :param str platform: Platform hosting this deployment.
        :param Sequence[str] resource_uri: Resource URI for the artifact being deployed taken from the deployable field with the same name.
        :param str undeploy_time: End of the lifetime of this deployment.
        :param str user_email: Identity of the user that triggered this deployment.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "deploy_time", deploy_time)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "resource_uri", resource_uri)
        pulumi.set(__self__, "undeploy_time", undeploy_time)
        pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address of the runtime element hosting this deployment.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def config(self) -> str:
        """
        Configuration used to create this deployment.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="deployTime")
    def deploy_time(self) -> str:
        """
        Beginning of the lifetime of this deployment.
        """
        return pulumi.get(self, "deploy_time")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        Platform hosting this deployment.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Sequence[str]:
        """
        Resource URI for the artifact being deployed taken from the deployable field with the same name.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="undeployTime")
    def undeploy_time(self) -> str:
        """
        End of the lifetime of this deployment.
        """
        return pulumi.get(self, "undeploy_time")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> str:
        """
        Identity of the user that triggered this deployment.
        """
        return pulumi.get(self, "user_email")


@pulumi.output_type
class DerivedResponse(dict):
    """
    Derived describes the derived image portion (Occurrence) of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseResourceUrl":
            suggest = "base_resource_url"
        elif key == "layerInfo":
            suggest = "layer_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DerivedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DerivedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DerivedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_resource_url: str,
                 distance: int,
                 fingerprint: 'outputs.FingerprintResponse',
                 layer_info: Sequence['outputs.LayerResponse']):
        """
        Derived describes the derived image portion (Occurrence) of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
        :param str base_resource_url: This contains the base image URL for the derived image occurrence.
        :param int distance: The number of layers by which this image differs from the associated image basis.
        :param 'FingerprintResponse' fingerprint: The fingerprint of the derived image.
        :param Sequence['LayerResponse'] layer_info: This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        pulumi.set(__self__, "base_resource_url", base_resource_url)
        pulumi.set(__self__, "distance", distance)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "layer_info", layer_info)

    @property
    @pulumi.getter(name="baseResourceUrl")
    def base_resource_url(self) -> str:
        """
        This contains the base image URL for the derived image occurrence.
        """
        return pulumi.get(self, "base_resource_url")

    @property
    @pulumi.getter
    def distance(self) -> int:
        """
        The number of layers by which this image differs from the associated image basis.
        """
        return pulumi.get(self, "distance")

    @property
    @pulumi.getter
    def fingerprint(self) -> 'outputs.FingerprintResponse':
        """
        The fingerprint of the derived image.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="layerInfo")
    def layer_info(self) -> Sequence['outputs.LayerResponse']:
        """
        This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        return pulumi.get(self, "layer_info")


@pulumi.output_type
class DetailResponse(dict):
    """
    Identifies all occurrences of this vulnerability in the package for a specific distro/location For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "fixedLocation":
            suggest = "fixed_location"
        elif key == "isObsolete":
            suggest = "is_obsolete"
        elif key == "maxAffectedVersion":
            suggest = "max_affected_version"
        elif key == "minAffectedVersion":
            suggest = "min_affected_version"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "severityName":
            suggest = "severity_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 description: str,
                 fixed_location: 'outputs.VulnerabilityLocationResponse',
                 is_obsolete: bool,
                 max_affected_version: 'outputs.VersionResponse',
                 min_affected_version: 'outputs.VersionResponse',
                 package: str,
                 package_type: str,
                 severity_name: str,
                 source: str,
                 vendor: str):
        """
        Identifies all occurrences of this vulnerability in the package for a specific distro/location For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
        :param str cpe_uri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        :param str description: A vendor-specific description of this note.
        :param 'VulnerabilityLocationResponse' fixed_location: The fix for this specific package version.
        :param bool is_obsolete: Whether this Detail is obsolete. Occurrences are expected not to point to obsolete details.
        :param 'VersionResponse' max_affected_version: The max version of the package in which the vulnerability exists.
        :param 'VersionResponse' min_affected_version: The min version of the package in which the vulnerability exists.
        :param str package: The name of the package where the vulnerability was found. This field can be used as a filter in list requests.
        :param str package_type: The type of package; whether native or non native(ruby gems, node.js packages etc)
        :param str severity_name: The severity (eg: distro assigned severity) for this vulnerability.
        :param str source: The source from which the information in this Detail was obtained.
        :param str vendor: The vendor of the product. e.g. "google"
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fixed_location", fixed_location)
        pulumi.set(__self__, "is_obsolete", is_obsolete)
        pulumi.set(__self__, "max_affected_version", max_affected_version)
        pulumi.set(__self__, "min_affected_version", min_affected_version)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "severity_name", severity_name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) in which the vulnerability manifests. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A vendor-specific description of this note.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The fix for this specific package version.
        """
        return pulumi.get(self, "fixed_location")

    @property
    @pulumi.getter(name="isObsolete")
    def is_obsolete(self) -> bool:
        """
        Whether this Detail is obsolete. Occurrences are expected not to point to obsolete details.
        """
        return pulumi.get(self, "is_obsolete")

    @property
    @pulumi.getter(name="maxAffectedVersion")
    def max_affected_version(self) -> 'outputs.VersionResponse':
        """
        The max version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "max_affected_version")

    @property
    @pulumi.getter(name="minAffectedVersion")
    def min_affected_version(self) -> 'outputs.VersionResponse':
        """
        The min version of the package in which the vulnerability exists.
        """
        return pulumi.get(self, "min_affected_version")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        The name of the package where the vulnerability was found. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc)
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> str:
        """
        The severity (eg: distro assigned severity) for this vulnerability.
        """
        return pulumi.get(self, "severity_name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source from which the information in this Detail was obtained.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        The vendor of the product. e.g. "google"
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class DigestResponse(dict):
    """
    Digest information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "digestBytes":
            suggest = "digest_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DigestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DigestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DigestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algo: str,
                 digest_bytes: str):
        """
        Digest information.
        :param str algo: `SHA1`, `SHA512` etc.
        :param str digest_bytes: Value of the digest.
        """
        pulumi.set(__self__, "algo", algo)
        pulumi.set(__self__, "digest_bytes", digest_bytes)

    @property
    @pulumi.getter
    def algo(self) -> str:
        """
        `SHA1`, `SHA512` etc.
        """
        return pulumi.get(self, "algo")

    @property
    @pulumi.getter(name="digestBytes")
    def digest_bytes(self) -> str:
        """
        Value of the digest.
        """
        return pulumi.get(self, "digest_bytes")


@pulumi.output_type
class DiscoveredResponse(dict):
    """
    Provides information about the scan status of a discovered resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisCompleted":
            suggest = "analysis_completed"
        elif key == "analysisError":
            suggest = "analysis_error"
        elif key == "analysisStatus":
            suggest = "analysis_status"
        elif key == "analysisStatusError":
            suggest = "analysis_status_error"
        elif key == "archiveTime":
            suggest = "archive_time"
        elif key == "continuousAnalysis":
            suggest = "continuous_analysis"
        elif key == "lastScanTime":
            suggest = "last_scan_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveredResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveredResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveredResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_completed: 'outputs.AnalysisCompletedResponse',
                 analysis_error: Sequence['outputs.StatusResponse'],
                 analysis_status: str,
                 analysis_status_error: 'outputs.StatusResponse',
                 archive_time: str,
                 continuous_analysis: str,
                 cpe: str,
                 last_scan_time: str,
                 operation: 'outputs.OperationResponse'):
        """
        Provides information about the scan status of a discovered resource.
        :param 'AnalysisCompletedResponse' analysis_completed: The list of analysis that were completed for a resource.
        :param Sequence['StatusResponse'] analysis_error: Indicates any errors encountered during analysis of a resource. There could be 0 or more of these errors.
        :param str analysis_status: The status of discovery for the resource.
        :param 'StatusResponse' analysis_status_error: When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage output only and populated by the API.
        :param str archive_time: The time occurrences related to this discovery occurrence were archived.
        :param str continuous_analysis: Whether the resource is continuously analyzed.
        :param str cpe: The CPE of the resource being scanned.
        :param str last_scan_time: The last time this resource was scanned.
        :param 'OperationResponse' operation: An operation that indicates the status of the current scan. This field is deprecated, do not use.
        """
        pulumi.set(__self__, "analysis_completed", analysis_completed)
        pulumi.set(__self__, "analysis_error", analysis_error)
        pulumi.set(__self__, "analysis_status", analysis_status)
        pulumi.set(__self__, "analysis_status_error", analysis_status_error)
        pulumi.set(__self__, "archive_time", archive_time)
        pulumi.set(__self__, "continuous_analysis", continuous_analysis)
        pulumi.set(__self__, "cpe", cpe)
        pulumi.set(__self__, "last_scan_time", last_scan_time)
        pulumi.set(__self__, "operation", operation)

    @property
    @pulumi.getter(name="analysisCompleted")
    def analysis_completed(self) -> 'outputs.AnalysisCompletedResponse':
        """
        The list of analysis that were completed for a resource.
        """
        return pulumi.get(self, "analysis_completed")

    @property
    @pulumi.getter(name="analysisError")
    def analysis_error(self) -> Sequence['outputs.StatusResponse']:
        """
        Indicates any errors encountered during analysis of a resource. There could be 0 or more of these errors.
        """
        return pulumi.get(self, "analysis_error")

    @property
    @pulumi.getter(name="analysisStatus")
    def analysis_status(self) -> str:
        """
        The status of discovery for the resource.
        """
        return pulumi.get(self, "analysis_status")

    @property
    @pulumi.getter(name="analysisStatusError")
    def analysis_status_error(self) -> 'outputs.StatusResponse':
        """
        When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage output only and populated by the API.
        """
        return pulumi.get(self, "analysis_status_error")

    @property
    @pulumi.getter(name="archiveTime")
    def archive_time(self) -> str:
        """
        The time occurrences related to this discovery occurrence were archived.
        """
        return pulumi.get(self, "archive_time")

    @property
    @pulumi.getter(name="continuousAnalysis")
    def continuous_analysis(self) -> str:
        """
        Whether the resource is continuously analyzed.
        """
        return pulumi.get(self, "continuous_analysis")

    @property
    @pulumi.getter
    def cpe(self) -> str:
        """
        The CPE of the resource being scanned.
        """
        return pulumi.get(self, "cpe")

    @property
    @pulumi.getter(name="lastScanTime")
    def last_scan_time(self) -> str:
        """
        The last time this resource was scanned.
        """
        return pulumi.get(self, "last_scan_time")

    @property
    @pulumi.getter
    def operation(self) -> 'outputs.OperationResponse':
        """
        An operation that indicates the status of the current scan. This field is deprecated, do not use.
        """
        return pulumi.get(self, "operation")


@pulumi.output_type
class DiscoveryResponse(dict):
    """
    A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis. The occurrence's operation will indicate the status of the analysis. Absence of an occurrence linked to this note for a resource indicates that analysis hasn't started.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisKind":
            suggest = "analysis_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_kind: str):
        """
        A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis. The occurrence's operation will indicate the status of the analysis. Absence of an occurrence linked to this note for a resource indicates that analysis hasn't started.
        :param str analysis_kind: The kind of analysis that is handled by this discovery.
        """
        pulumi.set(__self__, "analysis_kind", analysis_kind)

    @property
    @pulumi.getter(name="analysisKind")
    def analysis_kind(self) -> str:
        """
        The kind of analysis that is handled by this discovery.
        """
        return pulumi.get(self, "analysis_kind")


@pulumi.output_type
class DistributionResponse(dict):
    """
    This represents a particular channel of distribution for a given package. e.g. Debian's jessie-backports dpkg mirror
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "latestVersion":
            suggest = "latest_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: str,
                 cpe_uri: str,
                 description: str,
                 latest_version: 'outputs.VersionResponse',
                 maintainer: str,
                 url: str):
        """
        This represents a particular channel of distribution for a given package. e.g. Debian's jessie-backports dpkg mirror
        :param str architecture: The CPU architecture for which packages in this distribution channel were built
        :param str cpe_uri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param str description: The distribution channel-specific description of this package.
        :param 'VersionResponse' latest_version: The latest available version of this package in this distribution channel.
        :param str maintainer: A freeform string denoting the maintainer of this package.
        :param str url: The distribution channel-specific homepage for this package.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "maintainer", maintainer)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        """
        The CPU architecture for which packages in this distribution channel were built
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The distribution channel-specific description of this package.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> 'outputs.VersionResponse':
        """
        The latest available version of this package in this distribution channel.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def maintainer(self) -> str:
        """
        A freeform string denoting the maintainer of this package.
        """
        return pulumi.get(self, "maintainer")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The distribution channel-specific homepage for this package.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DocumentNoteResponse(dict):
    """
    DocumentNote represents an SPDX Document Creation Infromation section: https://spdx.github.io/spdx-spec/2-document-creation-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLicence":
            suggest = "data_licence"
        elif key == "spdxVersion":
            suggest = "spdx_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_licence: str,
                 spdx_version: str):
        """
        DocumentNote represents an SPDX Document Creation Infromation section: https://spdx.github.io/spdx-spec/2-document-creation-information/
        :param str data_licence: Compliance with the SPDX specification includes populating the SPDX fields therein with data related to such fields ("SPDX-Metadata")
        :param str spdx_version: Provide a reference number that can be used to understand how to parse and interpret the rest of the file
        """
        pulumi.set(__self__, "data_licence", data_licence)
        pulumi.set(__self__, "spdx_version", spdx_version)

    @property
    @pulumi.getter(name="dataLicence")
    def data_licence(self) -> str:
        """
        Compliance with the SPDX specification includes populating the SPDX fields therein with data related to such fields ("SPDX-Metadata")
        """
        return pulumi.get(self, "data_licence")

    @property
    @pulumi.getter(name="spdxVersion")
    def spdx_version(self) -> str:
        """
        Provide a reference number that can be used to understand how to parse and interpret the rest of the file
        """
        return pulumi.get(self, "spdx_version")


@pulumi.output_type
class DocumentOccurrenceResponse(dict):
    """
    DocumentOccurrence represents an SPDX Document Creation Information section: https://spdx.github.io/spdx-spec/2-document-creation-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "creatorComment":
            suggest = "creator_comment"
        elif key == "documentComment":
            suggest = "document_comment"
        elif key == "externalDocumentRefs":
            suggest = "external_document_refs"
        elif key == "licenseListVersion":
            suggest = "license_list_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: str,
                 creator_comment: str,
                 creators: Sequence[str],
                 document_comment: str,
                 external_document_refs: Sequence[str],
                 license_list_version: str,
                 namespace: str,
                 title: str):
        """
        DocumentOccurrence represents an SPDX Document Creation Information section: https://spdx.github.io/spdx-spec/2-document-creation-information/
        :param str create_time: Identify when the SPDX file was originally created. The date is to be specified according to combined date and time in UTC format as specified in ISO 8601 standard
        :param str creator_comment: A field for creators of the SPDX file to provide general comments about the creation of the SPDX file or any other relevant comment not included in the other fields
        :param Sequence[str] creators: Identify who (or what, in the case of a tool) created the SPDX file. If the SPDX file was created by an individual, indicate the person's name
        :param str document_comment: A field for creators of the SPDX file content to provide comments to the consumers of the SPDX document
        :param Sequence[str] external_document_refs: Identify any external SPDX documents referenced within this SPDX document
        :param str license_list_version: A field for creators of the SPDX file to provide the version of the SPDX License List used when the SPDX file was created
        :param str namespace: Provide an SPDX document specific namespace as a unique absolute Uniform Resource Identifier (URI) as specified in RFC-3986, with the exception of the ‘#’ delimiter
        :param str title: Identify name of this document as designated by creator
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator_comment", creator_comment)
        pulumi.set(__self__, "creators", creators)
        pulumi.set(__self__, "document_comment", document_comment)
        pulumi.set(__self__, "external_document_refs", external_document_refs)
        pulumi.set(__self__, "license_list_version", license_list_version)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Identify when the SPDX file was originally created. The date is to be specified according to combined date and time in UTC format as specified in ISO 8601 standard
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="creatorComment")
    def creator_comment(self) -> str:
        """
        A field for creators of the SPDX file to provide general comments about the creation of the SPDX file or any other relevant comment not included in the other fields
        """
        return pulumi.get(self, "creator_comment")

    @property
    @pulumi.getter
    def creators(self) -> Sequence[str]:
        """
        Identify who (or what, in the case of a tool) created the SPDX file. If the SPDX file was created by an individual, indicate the person's name
        """
        return pulumi.get(self, "creators")

    @property
    @pulumi.getter(name="documentComment")
    def document_comment(self) -> str:
        """
        A field for creators of the SPDX file content to provide comments to the consumers of the SPDX document
        """
        return pulumi.get(self, "document_comment")

    @property
    @pulumi.getter(name="externalDocumentRefs")
    def external_document_refs(self) -> Sequence[str]:
        """
        Identify any external SPDX documents referenced within this SPDX document
        """
        return pulumi.get(self, "external_document_refs")

    @property
    @pulumi.getter(name="licenseListVersion")
    def license_list_version(self) -> str:
        """
        A field for creators of the SPDX file to provide the version of the SPDX License List used when the SPDX file was created
        """
        return pulumi.get(self, "license_list_version")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Provide an SPDX document specific namespace as a unique absolute Uniform Resource Identifier (URI) as specified in RFC-3986, with the exception of the ‘#’ delimiter
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Identify name of this document as designated by creator
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class EnvelopeResponse(dict):
    """
    MUST match https://github.com/secure-systems-lab/dsse/blob/master/envelope.proto. An authenticated message of arbitrary type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "payloadType":
            suggest = "payload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvelopeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvelopeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvelopeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payload: str,
                 payload_type: str,
                 signatures: Sequence['outputs.EnvelopeSignatureResponse']):
        """
        MUST match https://github.com/secure-systems-lab/dsse/blob/master/envelope.proto. An authenticated message of arbitrary type.
        :param str payload: The bytes being signed
        :param str payload_type: The type of payload being signed
        :param Sequence['EnvelopeSignatureResponse'] signatures: The signatures over the payload
        """
        pulumi.set(__self__, "payload", payload)
        pulumi.set(__self__, "payload_type", payload_type)
        pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter
    def payload(self) -> str:
        """
        The bytes being signed
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> str:
        """
        The type of payload being signed
        """
        return pulumi.get(self, "payload_type")

    @property
    @pulumi.getter
    def signatures(self) -> Sequence['outputs.EnvelopeSignatureResponse']:
        """
        The signatures over the payload
        """
        return pulumi.get(self, "signatures")


@pulumi.output_type
class EnvelopeSignatureResponse(dict):
    """
    A DSSE signature
    """
    def __init__(__self__, *,
                 keyid: str,
                 sig: str):
        """
        A DSSE signature
        :param str keyid: A reference id to the key being used for signing
        :param str sig: The signature itself
        """
        pulumi.set(__self__, "keyid", keyid)
        pulumi.set(__self__, "sig", sig)

    @property
    @pulumi.getter
    def keyid(self) -> str:
        """
        A reference id to the key being used for signing
        """
        return pulumi.get(self, "keyid")

    @property
    @pulumi.getter
    def sig(self) -> str:
        """
        The signature itself
        """
        return pulumi.get(self, "sig")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class ExternalRefResponse(dict):
    """
    An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
    """
    def __init__(__self__, *,
                 category: str,
                 comment: str,
                 locator: str,
                 type: str):
        """
        An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        :param str category: An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        :param str comment: Human-readable information about the purpose and target of the reference
        :param str locator: The unique string with no spaces necessary to access the package-specific information, metadata, or content within the target location
        :param str type: Type of category (e.g. 'npm' for the PACKAGE_MANAGER category)
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "locator", locator)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        An External Reference allows a Package to reference an external source of additional information, metadata, enumerations, asset identifiers, or downloadable content believed to be relevant to the Package
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        Human-readable information about the purpose and target of the reference
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def locator(self) -> str:
        """
        The unique string with no spaces necessary to access the package-specific information, metadata, or content within the target location
        """
        return pulumi.get(self, "locator")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of category (e.g. 'npm' for the PACKAGE_MANAGER category)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FileLocationResponse(dict):
    """
    Indicates the location at which a package was found.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: str):
        """
        Indicates the location at which a package was found.
        :param str file_path: For jars that are contained inside .war files, this filepath can indicate the path to war file combined with the path to jar file.
        """
        pulumi.set(__self__, "file_path", file_path)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> str:
        """
        For jars that are contained inside .war files, this filepath can indicate the path to war file combined with the path to jar file.
        """
        return pulumi.get(self, "file_path")


@pulumi.output_type
class FileNoteResponse(dict):
    """
    FileNote represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileType":
            suggest = "file_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 checksum: Sequence[str],
                 file_type: str,
                 title: str):
        """
        FileNote represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
        :param Sequence[str] checksum: Provide a unique identifier to match analysis information on each specific file in a package
        :param str file_type: This field provides information about the type of file identified
        :param str title: Identify the full path and filename that corresponds to the file information in this section
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "file_type", file_type)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def checksum(self) -> Sequence[str]:
        """
        Provide a unique identifier to match analysis information on each specific file in a package
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="fileType")
    def file_type(self) -> str:
        """
        This field provides information about the type of file identified
        """
        return pulumi.get(self, "file_type")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Identify the full path and filename that corresponds to the file information in this section
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FileOccurrenceResponse(dict):
    """
    FileOccurrence represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesLicenseInfo":
            suggest = "files_license_info"
        elif key == "licenseConcluded":
            suggest = "license_concluded"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attributions: Sequence[str],
                 comment: str,
                 contributors: Sequence[str],
                 copyright: str,
                 files_license_info: Sequence[str],
                 license_concluded: 'outputs.LicenseResponse',
                 notice: str):
        """
        FileOccurrence represents an SPDX File Information section: https://spdx.github.io/spdx-spec/4-file-information/
        :param Sequence[str] attributions: This field provides a place for the SPDX data creator to record, at the file level, acknowledgements that may be needed to be communicated in some contexts
        :param str comment: This field provides a place for the SPDX file creator to record any general comments about the file
        :param Sequence[str] contributors: This field provides a place for the SPDX file creator to record file contributors
        :param str copyright: Identify the copyright holder of the file, as well as any dates present
        :param Sequence[str] files_license_info: This field contains the license information actually found in the file, if any
        :param 'LicenseResponse' license_concluded: This field contains the license the SPDX file creator has concluded as governing the file or alternative values if the governing license cannot be determined
        :param str notice: This field provides a place for the SPDX file creator to record license notices or other such related notices found in the file
        """
        pulumi.set(__self__, "attributions", attributions)
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "contributors", contributors)
        pulumi.set(__self__, "copyright", copyright)
        pulumi.set(__self__, "files_license_info", files_license_info)
        pulumi.set(__self__, "license_concluded", license_concluded)
        pulumi.set(__self__, "notice", notice)

    @property
    @pulumi.getter
    def attributions(self) -> Sequence[str]:
        """
        This field provides a place for the SPDX data creator to record, at the file level, acknowledgements that may be needed to be communicated in some contexts
        """
        return pulumi.get(self, "attributions")

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        This field provides a place for the SPDX file creator to record any general comments about the file
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def contributors(self) -> Sequence[str]:
        """
        This field provides a place for the SPDX file creator to record file contributors
        """
        return pulumi.get(self, "contributors")

    @property
    @pulumi.getter
    def copyright(self) -> str:
        """
        Identify the copyright holder of the file, as well as any dates present
        """
        return pulumi.get(self, "copyright")

    @property
    @pulumi.getter(name="filesLicenseInfo")
    def files_license_info(self) -> Sequence[str]:
        """
        This field contains the license information actually found in the file, if any
        """
        return pulumi.get(self, "files_license_info")

    @property
    @pulumi.getter(name="licenseConcluded")
    def license_concluded(self) -> 'outputs.LicenseResponse':
        """
        This field contains the license the SPDX file creator has concluded as governing the file or alternative values if the governing license cannot be determined
        """
        return pulumi.get(self, "license_concluded")

    @property
    @pulumi.getter
    def notice(self) -> str:
        """
        This field provides a place for the SPDX file creator to record license notices or other such related notices found in the file
        """
        return pulumi.get(self, "notice")


@pulumi.output_type
class FingerprintResponse(dict):
    """
    A set of properties that uniquely identify a given Docker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "v1Name":
            suggest = "v1_name"
        elif key == "v2Blob":
            suggest = "v2_blob"
        elif key == "v2Name":
            suggest = "v2_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FingerprintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FingerprintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FingerprintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 v1_name: str,
                 v2_blob: Sequence[str],
                 v2_name: str):
        """
        A set of properties that uniquely identify a given Docker image.
        :param str v1_name: The layer-id of the final layer in the Docker image's v1 representation. This field can be used as a filter in list requests.
        :param Sequence[str] v2_blob: The ordered list of v2 blobs that represent a given image.
        :param str v2_name: The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept. This field can be used as a filter in list requests.
        """
        pulumi.set(__self__, "v1_name", v1_name)
        pulumi.set(__self__, "v2_blob", v2_blob)
        pulumi.set(__self__, "v2_name", v2_name)

    @property
    @pulumi.getter(name="v1Name")
    def v1_name(self) -> str:
        """
        The layer-id of the final layer in the Docker image's v1 representation. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "v1_name")

    @property
    @pulumi.getter(name="v2Blob")
    def v2_blob(self) -> Sequence[str]:
        """
        The ordered list of v2 blobs that represent a given image.
        """
        return pulumi.get(self, "v2_blob")

    @property
    @pulumi.getter(name="v2Name")
    def v2_name(self) -> str:
        """
        The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "v2_name")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse(dict):
    """
    An alias to a repo revision.
    """
    def __init__(__self__, *,
                 kind: str,
                 name: str):
        """
        An alias to a repo revision.
        :param str kind: The alias kind.
        :param str name: The alias name.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The alias kind.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The alias name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse(dict):
    """
    A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasContext":
            suggest = "alias_context"
        elif key == "repoId":
            suggest = "repo_id"
        elif key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_context: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse',
                 repo_id: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse',
                 revision_id: str):
        """
        A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse' alias_context: An alias, which may be a branch or tag.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse' repo_id: The ID of the repo.
        :param str revision_id: A revision ID.
        """
        pulumi.set(__self__, "alias_context", alias_context)
        pulumi.set(__self__, "repo_id", repo_id)
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse':
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse':
        """
        The ID of the repo.
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        A revision ID.
        """
        return pulumi.get(self, "revision_id")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse(dict):
    """
    A SourceContext referring to a Gerrit project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasContext":
            suggest = "alias_context"
        elif key == "gerritProject":
            suggest = "gerrit_project"
        elif key == "hostUri":
            suggest = "host_uri"
        elif key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_context: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse',
                 gerrit_project: str,
                 host_uri: str,
                 revision_id: str):
        """
        A SourceContext referring to a Gerrit project.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse' alias_context: An alias, which may be a branch or tag.
        :param str gerrit_project: The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        :param str host_uri: The URI of a running Gerrit instance.
        :param str revision_id: A revision (commit) ID.
        """
        pulumi.set(__self__, "alias_context", alias_context)
        pulumi.set(__self__, "gerrit_project", gerrit_project)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1AliasContextResponse':
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @property
    @pulumi.getter(name="gerritProject")
    def gerrit_project(self) -> str:
        """
        The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        """
        return pulumi.get(self, "gerrit_project")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> str:
        """
        The URI of a running Gerrit instance.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        A revision (commit) ID.
        """
        return pulumi.get(self, "revision_id")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse(dict):
    """
    A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision_id: str,
                 url: str):
        """
        A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
        :param str revision_id: Git commit hash.
        :param str url: Git repository URL.
        """
        pulumi.set(__self__, "revision_id", revision_id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        Git commit hash.
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Git repository URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse(dict):
    """
    Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoName":
            suggest = "repo_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project: str,
                 repo_name: str):
        """
        Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
        :param str project: The ID of the project.
        :param str repo_name: The name of the repo. Leave empty for the default repo.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repo_name", repo_name)

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        The name of the repo. Leave empty for the default repo.
        """
        return pulumi.get(self, "repo_name")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse(dict):
    """
    A unique identifier for a Cloud Repo.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectRepoId":
            suggest = "project_repo_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1RepoIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_repo_id: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse',
                 uid: str):
        """
        A unique identifier for a Cloud Repo.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse' project_repo_id: A combination of a project ID and a repo name.
        :param str uid: A server-assigned, globally unique identifier.
        """
        pulumi.set(__self__, "project_repo_id", project_repo_id)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="projectRepoId")
    def project_repo_id(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1ProjectRepoIdResponse':
        """
        A combination of a project ID and a repo name.
        """
        return pulumi.get(self, "project_repo_id")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A server-assigned, globally unique identifier.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaBuilderResponse(dict):
    """
    Identifies the entity that executed the recipe, which is trusted to have correctly performed the operation and populated this provenance.
    """
    def __init__(__self__):
        """
        Identifies the entity that executed the recipe, which is trusted to have correctly performed the operation and populated this provenance.
        """
        pass


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaCompletenessResponse(dict):
    """
    Indicates that the builder claims certain fields in this message to be complete.
    """
    def __init__(__self__, *,
                 environment: bool,
                 materials: bool,
                 parameters: bool):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param bool environment: If true, the builder claims that invocation.environment is complete.
        :param bool materials: If true, the builder claims that materials is complete.
        :param bool parameters: If true, the builder claims that invocation.parameters is complete.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def environment(self) -> bool:
        """
        If true, the builder claims that invocation.environment is complete.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def materials(self) -> bool:
        """
        If true, the builder claims that materials is complete.
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def parameters(self) -> bool:
        """
        If true, the builder claims that invocation.parameters is complete.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaConfigSourceResponse(dict):
    """
    Describes where the config file that kicked off the build came from. This is effectively a pointer to the source where buildConfig came from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryPoint":
            suggest = "entry_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaConfigSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaConfigSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaConfigSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 digest: Mapping[str, str],
                 entry_point: str,
                 uri: str):
        """
        Describes where the config file that kicked off the build came from. This is effectively a pointer to the source where buildConfig came from.
        :param Mapping[str, str] digest: Collection of cryptographic digests for the contents of the artifact specified by invocation.configSource.uri.
        :param str entry_point: String identifying the entry point into the build.
        :param str uri: URI indicating the identity of the source of the config.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "entry_point", entry_point)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def digest(self) -> Mapping[str, str]:
        """
        Collection of cryptographic digests for the contents of the artifact specified by invocation.configSource.uri.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> str:
        """
        String identifying the entry point into the build.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI indicating the identity of the source of the config.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaInvocationResponse(dict):
    """
    Identifies the event that kicked off the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configSource":
            suggest = "config_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaInvocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaInvocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaInvocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_source: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaConfigSourceResponse',
                 environment: Mapping[str, str],
                 parameters: Mapping[str, str]):
        """
        Identifies the event that kicked off the build.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaConfigSourceResponse' config_source: Describes where the config file that kicked off the build came from.
        :param Mapping[str, str] environment: Any other builder-controlled inputs necessary for correctly evaluating the build.
        :param Mapping[str, str] parameters: Collection of all external inputs that influenced the build on top of invocation.configSource.
        """
        pulumi.set(__self__, "config_source", config_source)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="configSource")
    def config_source(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaConfigSourceResponse':
        """
        Describes where the config file that kicked off the build came from.
        """
        return pulumi.get(self, "config_source")

    @property
    @pulumi.getter
    def environment(self) -> Mapping[str, str]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the build.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, str]:
        """
        Collection of all external inputs that influenced the build on top of invocation.configSource.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMaterialResponse(dict):
    """
    The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on.
    """
    def __init__(__self__, *,
                 digest: Mapping[str, str],
                 uri: str):
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on.
        :param Mapping[str, str] digest: Collection of cryptographic digests for the contents of this artifact.
        :param str uri: The method by which this artifact was referenced during the build.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def digest(self) -> Mapping[str, str]:
        """
        Collection of cryptographic digests for the contents of this artifact.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The method by which this artifact was referenced during the build.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMetadataResponse(dict):
    """
    Other properties of the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildFinishedOn":
            suggest = "build_finished_on"
        elif key == "buildInvocationId":
            suggest = "build_invocation_id"
        elif key == "buildStartedOn":
            suggest = "build_started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_finished_on: str,
                 build_invocation_id: str,
                 build_started_on: str,
                 completeness: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaCompletenessResponse',
                 reproducible: bool):
        """
        Other properties of the build.
        :param str build_finished_on: The timestamp of when the build completed.
        :param str build_invocation_id: Identifies this particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis.
        :param str build_started_on: The timestamp of when the build started.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaCompletenessResponse' completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param bool reproducible: If true, the builder claims that running invocation on materials will produce bit-for-bit identical output.
        """
        pulumi.set(__self__, "build_finished_on", build_finished_on)
        pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        pulumi.set(__self__, "build_started_on", build_started_on)
        pulumi.set(__self__, "completeness", completeness)
        pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> str:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> str:
        """
        Identifies this particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis.
        """
        return pulumi.get(self, "build_invocation_id")

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> str:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @property
    @pulumi.getter
    def completeness(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaCompletenessResponse':
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @property
    @pulumi.getter
    def reproducible(self) -> bool:
        """
        If true, the builder claims that running invocation on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")


@pulumi.output_type
class GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse(dict):
    """
    A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRepo":
            suggest = "cloud_repo"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_repo: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse',
                 gerrit: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse',
                 git: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse',
                 labels: Mapping[str, str]):
        """
        A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse' cloud_repo: A SourceContext referring to a revision in a Google Cloud Source Repo.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse' gerrit: A SourceContext referring to a Gerrit project.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse' git: A SourceContext referring to any third party Git repo (e.g., GitHub).
        :param Mapping[str, str] labels: Labels with user defined metadata.
        """
        pulumi.set(__self__, "cloud_repo", cloud_repo)
        pulumi.set(__self__, "gerrit", gerrit)
        pulumi.set(__self__, "git", git)
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="cloudRepo")
    def cloud_repo(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1CloudRepoSourceContextResponse':
        """
        A SourceContext referring to a revision in a Google Cloud Source Repo.
        """
        return pulumi.get(self, "cloud_repo")

    @property
    @pulumi.getter
    def gerrit(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1GerritSourceContextResponse':
        """
        A SourceContext referring to a Gerrit project.
        """
        return pulumi.get(self, "gerrit")

    @property
    @pulumi.getter
    def git(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1GitSourceContextResponse':
        """
        A SourceContext referring to any third party Git repo (e.g., GitHub).
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels with user defined metadata.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class HashResponse(dict):
    """
    Container message for hash values.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        Container message for hash values.
        :param str type: The type of hash that was performed.
        :param str value: The hash value.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of hash that was performed.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The hash value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InTotoProvenanceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builderConfig":
            suggest = "builder_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InTotoProvenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InTotoProvenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InTotoProvenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 builder_config: 'outputs.BuilderConfigResponse',
                 materials: Sequence[str],
                 metadata: 'outputs.MetadataResponse',
                 recipe: 'outputs.RecipeResponse'):
        """
        :param 'BuilderConfigResponse' builder_config: required
        :param Sequence[str] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        :param 'RecipeResponse' recipe: Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        pulumi.set(__self__, "builder_config", builder_config)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "recipe", recipe)

    @property
    @pulumi.getter(name="builderConfig")
    def builder_config(self) -> 'outputs.BuilderConfigResponse':
        """
        required
        """
        return pulumi.get(self, "builder_config")

    @property
    @pulumi.getter
    def materials(self) -> Sequence[str]:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.MetadataResponse':
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def recipe(self) -> 'outputs.RecipeResponse':
        """
        Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        return pulumi.get(self, "recipe")


@pulumi.output_type
class InTotoStatementResponse(dict):
    """
    Spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement The serialized InTotoStatement will be stored as Envelope.payload. Envelope.payloadType is always "application/vnd.in-toto+json".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predicateType":
            suggest = "predicate_type"
        elif key == "slsaProvenance":
            suggest = "slsa_provenance"
        elif key == "slsaProvenanceZeroTwo":
            suggest = "slsa_provenance_zero_two"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InTotoStatementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InTotoStatementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InTotoStatementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predicate_type: str,
                 provenance: 'outputs.InTotoProvenanceResponse',
                 slsa_provenance: 'outputs.SlsaProvenanceResponse',
                 slsa_provenance_zero_two: 'outputs.SlsaProvenanceZeroTwoResponse',
                 subject: Sequence['outputs.SubjectResponse'],
                 type: str):
        """
        Spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement The serialized InTotoStatement will be stored as Envelope.payload. Envelope.payloadType is always "application/vnd.in-toto+json".
        :param str predicate_type: "https://slsa.dev/provenance/v0.1" for SlsaProvenance.
        :param 'InTotoProvenanceResponse' provenance: Generic Grafeas provenance.
        :param 'SlsaProvenanceResponse' slsa_provenance: SLSA 0.1 provenance.
        :param 'SlsaProvenanceZeroTwoResponse' slsa_provenance_zero_two: SLSA 0.2 provenance.
        :param Sequence['SubjectResponse'] subject: subject is the subjects of the intoto statement
        :param str type: Always "https://in-toto.io/Statement/v0.1".
        """
        pulumi.set(__self__, "predicate_type", predicate_type)
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "slsa_provenance", slsa_provenance)
        pulumi.set(__self__, "slsa_provenance_zero_two", slsa_provenance_zero_two)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="predicateType")
    def predicate_type(self) -> str:
        """
        "https://slsa.dev/provenance/v0.1" for SlsaProvenance.
        """
        return pulumi.get(self, "predicate_type")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.InTotoProvenanceResponse':
        """
        Generic Grafeas provenance.
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter(name="slsaProvenance")
    def slsa_provenance(self) -> 'outputs.SlsaProvenanceResponse':
        """
        SLSA 0.1 provenance.
        """
        return pulumi.get(self, "slsa_provenance")

    @property
    @pulumi.getter(name="slsaProvenanceZeroTwo")
    def slsa_provenance_zero_two(self) -> 'outputs.SlsaProvenanceZeroTwoResponse':
        """
        SLSA 0.2 provenance.
        """
        return pulumi.get(self, "slsa_provenance_zero_two")

    @property
    @pulumi.getter
    def subject(self) -> Sequence['outputs.SubjectResponse']:
        """
        subject is the subjects of the intoto statement
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Always "https://in-toto.io/Statement/v0.1".
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstallationResponse(dict):
    """
    This represents how a particular software package may be installed on a system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "packageType":
            suggest = "package_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstallationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstallationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstallationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: str,
                 cpe_uri: str,
                 license: 'outputs.LicenseResponse',
                 location: Sequence['outputs.LocationResponse'],
                 name: str,
                 package_type: str,
                 version: 'outputs.VersionResponse'):
        """
        This represents how a particular software package may be installed on a system.
        :param str architecture: The CPU architecture for which packages in this distribution channel were built. Architecture will be blank for language packages.
        :param str cpe_uri: The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package. The cpe_uri will be blank for language packages.
        :param 'LicenseResponse' license: Licenses that have been declared by the authors of the package.
        :param Sequence['LocationResponse'] location: All of the places within the filesystem versions of this package have been found.
        :param str name: The name of the installed package.
        :param str package_type: The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        :param 'VersionResponse' version: The version of the package.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "license", license)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        """
        The CPU architecture for which packages in this distribution channel were built. Architecture will be blank for language packages.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package. The cpe_uri will be blank for language packages.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def license(self) -> 'outputs.LicenseResponse':
        """
        Licenses that have been declared by the authors of the package.
        """
        return pulumi.get(self, "license")

    @property
    @pulumi.getter
    def location(self) -> Sequence['outputs.LocationResponse']:
        """
        All of the places within the filesystem versions of this package have been found.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the installed package.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The version of the package.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LayerResponse(dict):
    """
    Layer holds metadata specific to a layer of a Docker image.
    """
    def __init__(__self__, *,
                 arguments: str,
                 directive: str):
        """
        Layer holds metadata specific to a layer of a Docker image.
        :param str arguments: The recovered arguments to the Dockerfile directive.
        :param str directive: The recovered Dockerfile directive used to construct this layer.
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "directive", directive)

    @property
    @pulumi.getter
    def arguments(self) -> str:
        """
        The recovered arguments to the Dockerfile directive.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def directive(self) -> str:
        """
        The recovered Dockerfile directive used to construct this layer.
        """
        return pulumi.get(self, "directive")


@pulumi.output_type
class LicenseResponse(dict):
    """
    License information.
    """
    def __init__(__self__, *,
                 comments: str,
                 expression: str):
        """
        License information.
        :param str comments: Comments
        :param str expression: Often a single license can be used to represent the licensing terms. Sometimes it is necessary to include a choice of one or more licenses or some combination of license identifiers. Examples: "LGPL-2.1-only OR MIT", "LGPL-2.1-only AND MIT", "GPL-2.0-or-later WITH Bison-exception-2.2".
        """
        pulumi.set(__self__, "comments", comments)
        pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def comments(self) -> str:
        """
        Comments
        """
        return pulumi.get(self, "comments")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Often a single license can be used to represent the licensing terms. Sometimes it is necessary to include a choice of one or more licenses or some combination of license identifiers. Examples: "LGPL-2.1-only OR MIT", "LGPL-2.1-only AND MIT", "GPL-2.0-or-later WITH Bison-exception-2.2".
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class LocationResponse(dict):
    """
    An occurrence of a particular package installation found within a system's filesystem. e.g. glibc was found in /var/lib/dpkg/status
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 path: str,
                 version: 'outputs.VersionResponse'):
        """
        An occurrence of a particular package installation found within a system's filesystem. e.g. glibc was found in /var/lib/dpkg/status
        :param str cpe_uri: Deprecated. The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param str path: The path from which we gathered that this package/version is installed.
        :param 'VersionResponse' version: Deprecated. The version installed at this location.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        Deprecated. The cpe_uri in [cpe format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path from which we gathered that this package/version is installed.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        Deprecated. The version installed at this location.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MaterialResponse(dict):
    """
    Material is a material used in the generation of the provenance
    """
    def __init__(__self__, *,
                 digest: Mapping[str, str],
                 uri: str):
        """
        Material is a material used in the generation of the provenance
        :param Mapping[str, str] digest: digest is a map from a hash algorithm (e.g. sha256) to the value in the material
        :param str uri: uri is the uri of the material
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def digest(self) -> Mapping[str, str]:
        """
        digest is a map from a hash algorithm (e.g. sha256) to the value in the material
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        uri is the uri of the material
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class MetadataResponse(dict):
    """
    Other properties of the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildFinishedOn":
            suggest = "build_finished_on"
        elif key == "buildInvocationId":
            suggest = "build_invocation_id"
        elif key == "buildStartedOn":
            suggest = "build_started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_finished_on: str,
                 build_invocation_id: str,
                 build_started_on: str,
                 completeness: 'outputs.CompletenessResponse',
                 reproducible: bool):
        """
        Other properties of the build.
        :param str build_finished_on: The timestamp of when the build completed.
        :param str build_invocation_id: Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        :param str build_started_on: The timestamp of when the build started.
        :param 'CompletenessResponse' completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param bool reproducible: If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        pulumi.set(__self__, "build_finished_on", build_finished_on)
        pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        pulumi.set(__self__, "build_started_on", build_started_on)
        pulumi.set(__self__, "completeness", completeness)
        pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> str:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> str:
        """
        Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        """
        return pulumi.get(self, "build_invocation_id")

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> str:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @property
    @pulumi.getter
    def completeness(self) -> 'outputs.CompletenessResponse':
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @property
    @pulumi.getter
    def reproducible(self) -> bool:
        """
        If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")


@pulumi.output_type
class NonCompliantFileResponse(dict):
    """
    Details about files that caused a compliance check to fail.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayCommand":
            suggest = "display_command"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NonCompliantFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NonCompliantFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NonCompliantFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_command: str,
                 path: str,
                 reason: str):
        """
        Details about files that caused a compliance check to fail.
        :param str display_command: Command to display the non-compliant files.
        :param str path: display_command is a single command that can be used to display a list of non compliant files. When there is no such command, we can also iterate a list of non compliant file using 'path'. Empty if `display_command` is set.
        :param str reason: Explains why a file is non compliant for a CIS check.
        """
        pulumi.set(__self__, "display_command", display_command)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter(name="displayCommand")
    def display_command(self) -> str:
        """
        Command to display the non-compliant files.
        """
        return pulumi.get(self, "display_command")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        display_command is a single command that can be used to display a list of non compliant files. When there is no such command, we can also iterate a list of non compliant file using 'path'. Empty if `display_command` is set.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Explains why a file is non compliant for a CIS check.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class OperationResponse(dict):
    """
    This resource represents a long-running operation that is the result of a network API call.
    """
    def __init__(__self__, *,
                 done: bool,
                 error: 'outputs.StatusResponse',
                 metadata: Mapping[str, str],
                 name: str,
                 response: Mapping[str, str]):
        """
        This resource represents a long-running operation that is the result of a network API call.
        :param bool done: If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
        :param 'StatusResponse' error: The error result of the operation in case of failure or cancellation.
        :param Mapping[str, str] metadata: Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.
        :param str name: The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id}`.
        :param Mapping[str, str] response: The normal response of the operation in case of success. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
        """
        pulumi.set(__self__, "done", done)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "response", response)

    @property
    @pulumi.getter
    def done(self) -> bool:
        """
        If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
        """
        return pulumi.get(self, "done")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.StatusResponse':
        """
        The error result of the operation in case of failure or cancellation.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def response(self) -> Mapping[str, str]:
        """
        The normal response of the operation in case of success. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
        """
        return pulumi.get(self, "response")


@pulumi.output_type
class PackageInfoNoteResponse(dict):
    """
    PackageInfoNote represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detailedDescription":
            suggest = "detailed_description"
        elif key == "downloadLocation":
            suggest = "download_location"
        elif key == "externalRefs":
            suggest = "external_refs"
        elif key == "filesLicenseInfo":
            suggest = "files_license_info"
        elif key == "homePage":
            suggest = "home_page"
        elif key == "licenseDeclared":
            suggest = "license_declared"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "summaryDescription":
            suggest = "summary_description"
        elif key == "verificationCode":
            suggest = "verification_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageInfoNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageInfoNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageInfoNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analyzed: bool,
                 attribution: str,
                 checksum: str,
                 copyright: str,
                 detailed_description: str,
                 download_location: str,
                 external_refs: Sequence['outputs.ExternalRefResponse'],
                 files_license_info: Sequence[str],
                 home_page: str,
                 license_declared: 'outputs.LicenseResponse',
                 originator: str,
                 package_type: str,
                 summary_description: str,
                 supplier: str,
                 title: str,
                 verification_code: str,
                 version: str):
        """
        PackageInfoNote represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
        :param bool analyzed: Indicates whether the file content of this package has been available for or subjected to analysis when creating the SPDX document
        :param str attribution: A place for the SPDX data creator to record, at the package level, acknowledgements that may be needed to be communicated in some contexts
        :param str checksum: Provide an independently reproducible mechanism that permits unique identification of a specific package that correlates to the data in this SPDX file
        :param str copyright: Identify the copyright holders of the package, as well as any dates present
        :param str detailed_description: A more detailed description of the package
        :param str download_location: This section identifies the download Universal Resource Locator (URL), or a specific location within a version control system (VCS) for the package at the time that the SPDX file was created
        :param Sequence['ExternalRefResponse'] external_refs: ExternalRef
        :param Sequence[str] files_license_info: Contain the license the SPDX file creator has concluded as governing the This field is to contain a list of all licenses found in the package. The relationship between licenses (i.e., conjunctive, disjunctive) is not specified in this field – it is simply a listing of all licenses found
        :param str home_page: Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        :param 'LicenseResponse' license_declared: List the licenses that have been declared by the authors of the package
        :param str originator: If the package identified in the SPDX file originated from a different person or organization than identified as Package Supplier, this field identifies from where or whom the package originally came
        :param str package_type: The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        :param str summary_description: A short description of the package
        :param str supplier: Identify the actual distribution source for the package/directory identified in the SPDX file
        :param str title: Identify the full name of the package as given by the Package Originator
        :param str verification_code: This field provides an independently reproducible mechanism identifying specific contents of a package based on the actual files (except the SPDX file itself, if it is included in the package) that make up each package and that correlates to the data in this SPDX file
        :param str version: Identify the version of the package
        """
        pulumi.set(__self__, "analyzed", analyzed)
        pulumi.set(__self__, "attribution", attribution)
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "copyright", copyright)
        pulumi.set(__self__, "detailed_description", detailed_description)
        pulumi.set(__self__, "download_location", download_location)
        pulumi.set(__self__, "external_refs", external_refs)
        pulumi.set(__self__, "files_license_info", files_license_info)
        pulumi.set(__self__, "home_page", home_page)
        pulumi.set(__self__, "license_declared", license_declared)
        pulumi.set(__self__, "originator", originator)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "summary_description", summary_description)
        pulumi.set(__self__, "supplier", supplier)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "verification_code", verification_code)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def analyzed(self) -> bool:
        """
        Indicates whether the file content of this package has been available for or subjected to analysis when creating the SPDX document
        """
        return pulumi.get(self, "analyzed")

    @property
    @pulumi.getter
    def attribution(self) -> str:
        """
        A place for the SPDX data creator to record, at the package level, acknowledgements that may be needed to be communicated in some contexts
        """
        return pulumi.get(self, "attribution")

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Provide an independently reproducible mechanism that permits unique identification of a specific package that correlates to the data in this SPDX file
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def copyright(self) -> str:
        """
        Identify the copyright holders of the package, as well as any dates present
        """
        return pulumi.get(self, "copyright")

    @property
    @pulumi.getter(name="detailedDescription")
    def detailed_description(self) -> str:
        """
        A more detailed description of the package
        """
        return pulumi.get(self, "detailed_description")

    @property
    @pulumi.getter(name="downloadLocation")
    def download_location(self) -> str:
        """
        This section identifies the download Universal Resource Locator (URL), or a specific location within a version control system (VCS) for the package at the time that the SPDX file was created
        """
        return pulumi.get(self, "download_location")

    @property
    @pulumi.getter(name="externalRefs")
    def external_refs(self) -> Sequence['outputs.ExternalRefResponse']:
        """
        ExternalRef
        """
        return pulumi.get(self, "external_refs")

    @property
    @pulumi.getter(name="filesLicenseInfo")
    def files_license_info(self) -> Sequence[str]:
        """
        Contain the license the SPDX file creator has concluded as governing the This field is to contain a list of all licenses found in the package. The relationship between licenses (i.e., conjunctive, disjunctive) is not specified in this field – it is simply a listing of all licenses found
        """
        return pulumi.get(self, "files_license_info")

    @property
    @pulumi.getter(name="homePage")
    def home_page(self) -> str:
        """
        Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        """
        return pulumi.get(self, "home_page")

    @property
    @pulumi.getter(name="licenseDeclared")
    def license_declared(self) -> 'outputs.LicenseResponse':
        """
        List the licenses that have been declared by the authors of the package
        """
        return pulumi.get(self, "license_declared")

    @property
    @pulumi.getter
    def originator(self) -> str:
        """
        If the package identified in the SPDX file originated from a different person or organization than identified as Package Supplier, this field identifies from where or whom the package originally came
        """
        return pulumi.get(self, "originator")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="summaryDescription")
    def summary_description(self) -> str:
        """
        A short description of the package
        """
        return pulumi.get(self, "summary_description")

    @property
    @pulumi.getter
    def supplier(self) -> str:
        """
        Identify the actual distribution source for the package/directory identified in the SPDX file
        """
        return pulumi.get(self, "supplier")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Identify the full name of the package as given by the Package Originator
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="verificationCode")
    def verification_code(self) -> str:
        """
        This field provides an independently reproducible mechanism identifying specific contents of a package based on the actual files (except the SPDX file itself, if it is included in the package) that make up each package and that correlates to the data in this SPDX file
        """
        return pulumi.get(self, "verification_code")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Identify the version of the package
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PackageInfoOccurrenceResponse(dict):
    """
    PackageInfoOccurrence represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "homePage":
            suggest = "home_page"
        elif key == "licenseConcluded":
            suggest = "license_concluded"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "sourceInfo":
            suggest = "source_info"
        elif key == "summaryDescription":
            suggest = "summary_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageInfoOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageInfoOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageInfoOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comment: str,
                 filename: str,
                 home_page: str,
                 license_concluded: 'outputs.LicenseResponse',
                 package_type: str,
                 source_info: str,
                 summary_description: str,
                 title: str,
                 version: str):
        """
        PackageInfoOccurrence represents an SPDX Package Information section: https://spdx.github.io/spdx-spec/3-package-information/
        :param str comment: A place for the SPDX file creator to record any general comments about the package being described
        :param str filename: Provide the actual file name of the package, or path of the directory being treated as a package
        :param str home_page: Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        :param 'LicenseResponse' license_concluded: package or alternative values, if the governing license cannot be determined
        :param str package_type: The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        :param str source_info: Provide a place for the SPDX file creator to record any relevant background information or additional comments about the origin of the package
        :param str summary_description: A short description of the package
        :param str title: Identify the full name of the package as given by the Package Originator
        :param str version: Identify the version of the package
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "filename", filename)
        pulumi.set(__self__, "home_page", home_page)
        pulumi.set(__self__, "license_concluded", license_concluded)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "source_info", source_info)
        pulumi.set(__self__, "summary_description", summary_description)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        A place for the SPDX file creator to record any general comments about the package being described
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def filename(self) -> str:
        """
        Provide the actual file name of the package, or path of the directory being treated as a package
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="homePage")
    def home_page(self) -> str:
        """
        Provide a place for the SPDX file creator to record a web site that serves as the package's home page
        """
        return pulumi.get(self, "home_page")

    @property
    @pulumi.getter(name="licenseConcluded")
    def license_concluded(self) -> 'outputs.LicenseResponse':
        """
        package or alternative values, if the governing license cannot be determined
        """
        return pulumi.get(self, "license_concluded")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package: OS, MAVEN, GO, GO_STDLIB, etc.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="sourceInfo")
    def source_info(self) -> str:
        """
        Provide a place for the SPDX file creator to record any relevant background information or additional comments about the origin of the package
        """
        return pulumi.get(self, "source_info")

    @property
    @pulumi.getter(name="summaryDescription")
    def summary_description(self) -> str:
        """
        A short description of the package
        """
        return pulumi.get(self, "summary_description")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Identify the full name of the package as given by the Package Originator
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Identify the version of the package
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PackageIssueResponse(dict):
    """
    This message wraps a location affected by a vulnerability and its associated fix (if one is available).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affectedLocation":
            suggest = "affected_location"
        elif key == "effectiveSeverity":
            suggest = "effective_severity"
        elif key == "fixedLocation":
            suggest = "fixed_location"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "severityName":
            suggest = "severity_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageIssueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageIssueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageIssueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affected_location: 'outputs.VulnerabilityLocationResponse',
                 effective_severity: str,
                 fixed_location: 'outputs.VulnerabilityLocationResponse',
                 package_type: str,
                 severity_name: str):
        """
        This message wraps a location affected by a vulnerability and its associated fix (if one is available).
        :param 'VulnerabilityLocationResponse' affected_location: The location of the vulnerability.
        :param str effective_severity: The distro or language system assigned severity for this vulnerability when that is available and note provider assigned severity when distro or language system has not yet assigned a severity for this vulnerability.
        :param 'VulnerabilityLocationResponse' fixed_location: The location of the available fix for vulnerability.
        :param str package_type: The type of package (e.g. OS, MAVEN, GO).
        """
        pulumi.set(__self__, "affected_location", affected_location)
        pulumi.set(__self__, "effective_severity", effective_severity)
        pulumi.set(__self__, "fixed_location", fixed_location)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "severity_name", severity_name)

    @property
    @pulumi.getter(name="affectedLocation")
    def affected_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The location of the vulnerability.
        """
        return pulumi.get(self, "affected_location")

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> str:
        """
        The distro or language system assigned severity for this vulnerability when that is available and note provider assigned severity when distro or language system has not yet assigned a severity for this vulnerability.
        """
        return pulumi.get(self, "effective_severity")

    @property
    @pulumi.getter(name="fixedLocation")
    def fixed_location(self) -> 'outputs.VulnerabilityLocationResponse':
        """
        The location of the available fix for vulnerability.
        """
        return pulumi.get(self, "fixed_location")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package (e.g. OS, MAVEN, GO).
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> str:
        return pulumi.get(self, "severity_name")


@pulumi.output_type
class PackageResponse(dict):
    """
    This represents a particular package that is distributed over various channels. e.g. glibc (aka libc6) is distributed by many, at various versions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "packageType":
            suggest = "package_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: str,
                 cpe_uri: str,
                 description: str,
                 digest: Sequence['outputs.DigestResponse'],
                 distribution: Sequence['outputs.DistributionResponse'],
                 license: 'outputs.LicenseResponse',
                 maintainer: str,
                 name: str,
                 package_type: str,
                 url: str,
                 version: 'outputs.VersionResponse'):
        """
        This represents a particular package that is distributed over various channels. e.g. glibc (aka libc6) is distributed by many, at various versions.
        :param str architecture: The CPU architecture for which packages in this distribution channel were built. Architecture will be blank for language packages.
        :param str cpe_uri: The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package. The cpe_uri will be blank for language packages.
        :param str description: The description of this package.
        :param Sequence['DigestResponse'] digest: Hash value, typically a file digest, that allows unique identification a specific package.
        :param Sequence['DistributionResponse'] distribution: The various channels by which a package is distributed.
        :param 'LicenseResponse' license: Licenses that have been declared by the authors of the package.
        :param str maintainer: A freeform text denoting the maintainer of this package.
        :param str name: The name of the package.
        :param str package_type: The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        :param str url: The homepage for this package.
        :param 'VersionResponse' version: The version of the package.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "license", license)
        pulumi.set(__self__, "maintainer", maintainer)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        """
        The CPU architecture for which packages in this distribution channel were built. Architecture will be blank for language packages.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package. The cpe_uri will be blank for language packages.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of this package.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def digest(self) -> Sequence['outputs.DigestResponse']:
        """
        Hash value, typically a file digest, that allows unique identification a specific package.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def distribution(self) -> Sequence['outputs.DistributionResponse']:
        """
        The various channels by which a package is distributed.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def license(self) -> 'outputs.LicenseResponse':
        """
        Licenses that have been declared by the authors of the package.
        """
        return pulumi.get(self, "license")

    @property
    @pulumi.getter
    def maintainer(self) -> str:
        """
        A freeform text denoting the maintainer of this package.
        """
        return pulumi.get(self, "maintainer")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the package.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The homepage for this package.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The version of the package.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PgpSignedAttestationResponse(dict):
    """
    An attestation wrapper with a PGP-compatible signature. This message only supports `ATTACHED` signatures, where the payload that is signed is included alongside the signature itself in the same file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "pgpKeyId":
            suggest = "pgp_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PgpSignedAttestationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PgpSignedAttestationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PgpSignedAttestationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: str,
                 pgp_key_id: str,
                 signature: str):
        """
        An attestation wrapper with a PGP-compatible signature. This message only supports `ATTACHED` signatures, where the payload that is signed is included alongside the signature itself in the same file.
        :param str content_type: Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        :param str pgp_key_id: The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexadecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \\ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        :param str signature: The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "pgp_key_id", pgp_key_id)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        Type (for example schema) of the attestation payload that was signed. The verifier must ensure that the provided type is one that the verifier supports, and that the attestation payload is a valid instantiation of that type (for example by validating a JSON schema).
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="pgpKeyId")
    def pgp_key_id(self) -> str:
        """
        The cryptographic fingerprint of the key used to generate the signature, as output by, e.g. `gpg --list-keys`. This should be the version 4, full 160-bit fingerprint, expressed as a 40 character hexadecimal string. See https://tools.ietf.org/html/rfc4880#section-12.2 for details. Implementations may choose to acknowledge "LONG", "SHORT", or other abbreviated key IDs, but only the full fingerprint is guaranteed to work. In gpg, the full fingerprint can be retrieved from the `fpr` field returned when calling --list-keys with --with-colons. For example: ``` gpg --with-colons --with-fingerprint --force-v4-certs \\ --list-keys attester@example.com tru::1:1513631572:0:3:1:5 pub:...... fpr:::::::::24FF6481B76AC91E66A00AC657A93A81EF3AE6FB: ``` Above, the fingerprint is `24FF6481B76AC91E66A00AC657A93A81EF3AE6FB`.
        """
        return pulumi.get(self, "pgp_key_id")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        The raw content of the signature, as output by GNU Privacy Guard (GPG) or equivalent. Since this message only supports attached signatures, the payload that was signed must be attached. While the signature format supported is dependent on the verification implementation, currently only ASCII-armored (`--armor` to gpg), non-clearsigned (`--sign` rather than `--clearsign` to gpg) are supported. Concretely, `gpg --sign --armor --output=signature.gpg payload.json` will create the signature content expected in this field in `signature.gpg` for the `payload.json` attestation payload.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class RecipeResponse(dict):
    """
    Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedInMaterial":
            suggest = "defined_in_material"
        elif key == "entryPoint":
            suggest = "entry_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecipeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecipeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecipeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Sequence[Mapping[str, str]],
                 defined_in_material: str,
                 entry_point: str,
                 environment: Sequence[Mapping[str, str]],
                 type: str):
        """
        Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
        :param Sequence[Mapping[str, str]] arguments: Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint.
        :param str defined_in_material: Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        :param str entry_point: String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        :param Sequence[Mapping[str, str]] environment: Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy.
        :param str type: URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "defined_in_material", defined_in_material)
        pulumi.set(__self__, "entry_point", entry_point)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arguments(self) -> Sequence[Mapping[str, str]]:
        """
        Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="definedInMaterial")
    def defined_in_material(self) -> str:
        """
        Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        """
        return pulumi.get(self, "defined_in_material")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> str:
        """
        String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter
    def environment(self) -> Sequence[Mapping[str, str]]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RelatedUrlResponse(dict):
    """
    Metadata for any related URL information
    """
    def __init__(__self__, *,
                 label: str,
                 url: str):
        """
        Metadata for any related URL information
        :param str label: Label to describe usage of the URL
        :param str url: Specific URL to associate with the note
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label to describe usage of the URL
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Specific URL to associate with the note
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class RelationshipNoteResponse(dict):
    """
    RelationshipNote represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
    """
    def __init__(__self__, *,
                 type: str):
        """
        RelationshipNote represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
        :param str type: The type of relationship between the source and target SPDX elements
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of relationship between the source and target SPDX elements
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RelationshipOccurrenceResponse(dict):
    """
    RelationshipOccurrence represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
    """
    def __init__(__self__, *,
                 comment: str,
                 source: str,
                 target: str,
                 type: str):
        """
        RelationshipOccurrence represents an SPDX Relationship section: https://spdx.github.io/spdx-spec/7-relationships-between-SPDX-elements/
        :param str comment: A place for the SPDX file creator to record any general comments about the relationship
        :param str source: Also referred to as SPDXRef-A The source SPDX element (file, package, etc)
        :param str target: Also referred to as SPDXRef-B The target SPDC element (file, package, etc) In cases where there are "known unknowns", the use of the keyword NOASSERTION can be used The keywords NONE can be used to indicate that an SPDX element (package/file/snippet) has no other elements connected by some relationship to it
        :param str type: The type of relationship between the source and target SPDX elements
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        A place for the SPDX file creator to record any general comments about the relationship
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Also referred to as SPDXRef-A The source SPDX element (file, package, etc)
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Also referred to as SPDXRef-B The target SPDC element (file, package, etc) In cases where there are "known unknowns", the use of the keyword NOASSERTION can be used The keywords NONE can be used to indicate that an SPDX element (package/file/snippet) has no other elements connected by some relationship to it
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of relationship between the source and target SPDX elements
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RepoSourceResponse(dict):
    """
    RepoSource describes the location of the source in a Google Cloud Source Repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "repoName":
            suggest = "repo_name"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: str,
                 commit_sha: str,
                 project: str,
                 repo_name: str,
                 tag_name: str):
        """
        RepoSource describes the location of the source in a Google Cloud Source Repository.
        :param str branch_name: Name of the branch to build.
        :param str commit_sha: Explicit commit SHA to build.
        :param str project: ID of the project that owns the repo.
        :param str repo_name: Name of the repo.
        :param str tag_name: Name of the tag to build.
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "commit_sha", commit_sha)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> str:
        """
        Name of the branch to build.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> str:
        """
        Explicit commit SHA to build.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        ID of the project that owns the repo.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        Name of the repo.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> str:
        """
        Name of the tag to build.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class ResourceResponse(dict):
    """
     Resource is an entity that can have metadata. E.g., a Docker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentHash":
            suggest = "content_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_hash: 'outputs.HashResponse',
                 name: str,
                 uri: str):
        """
         Resource is an entity that can have metadata. E.g., a Docker image.
        :param 'HashResponse' content_hash: The hash of the resource content. E.g., the Docker digest.
        :param str name: The name of the resource. E.g., the name of a Docker image - "Debian".
        :param str uri: The unique URI of the resource. E.g., "https://gcr.io/project/image@sha256:foo" for a Docker image.
        """
        pulumi.set(__self__, "content_hash", content_hash)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="contentHash")
    def content_hash(self) -> 'outputs.HashResponse':
        """
        The hash of the resource content. E.g., the Docker digest.
        """
        return pulumi.get(self, "content_hash")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource. E.g., the name of a Docker image - "Debian".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The unique URI of the resource. E.g., "https://gcr.io/project/image@sha256:foo" for a Docker image.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class SlsaBuilderResponse(dict):
    """
    SlsaBuilder encapsulates the identity of the builder of this provenance.
    """
    def __init__(__self__):
        """
        SlsaBuilder encapsulates the identity of the builder of this provenance.
        """
        pass


@pulumi.output_type
class SlsaCompletenessResponse(dict):
    """
    Indicates that the builder claims certain fields in this message to be complete.
    """
    def __init__(__self__, *,
                 arguments: bool,
                 environment: bool,
                 materials: bool):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param bool arguments: If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        :param bool environment: If true, the builder claims that recipe.environment is claimed to be complete.
        :param bool materials: If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "materials", materials)

    @property
    @pulumi.getter
    def arguments(self) -> bool:
        """
        If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def environment(self) -> bool:
        """
        If true, the builder claims that recipe.environment is claimed to be complete.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def materials(self) -> bool:
        """
        If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        return pulumi.get(self, "materials")


@pulumi.output_type
class SlsaMetadataResponse(dict):
    """
    Other properties of the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildFinishedOn":
            suggest = "build_finished_on"
        elif key == "buildInvocationId":
            suggest = "build_invocation_id"
        elif key == "buildStartedOn":
            suggest = "build_started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlsaMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlsaMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlsaMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_finished_on: str,
                 build_invocation_id: str,
                 build_started_on: str,
                 completeness: 'outputs.SlsaCompletenessResponse',
                 reproducible: bool):
        """
        Other properties of the build.
        :param str build_finished_on: The timestamp of when the build completed.
        :param str build_invocation_id: Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        :param str build_started_on: The timestamp of when the build started.
        :param 'SlsaCompletenessResponse' completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param bool reproducible: If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        pulumi.set(__self__, "build_finished_on", build_finished_on)
        pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        pulumi.set(__self__, "build_started_on", build_started_on)
        pulumi.set(__self__, "completeness", completeness)
        pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> str:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> str:
        """
        Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        """
        return pulumi.get(self, "build_invocation_id")

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> str:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @property
    @pulumi.getter
    def completeness(self) -> 'outputs.SlsaCompletenessResponse':
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @property
    @pulumi.getter
    def reproducible(self) -> bool:
        """
        If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")


@pulumi.output_type
class SlsaProvenanceResponse(dict):
    """
    SlsaProvenance is the slsa provenance as defined by the slsa spec.
    """
    def __init__(__self__, *,
                 builder: 'outputs.SlsaBuilderResponse',
                 materials: Sequence['outputs.MaterialResponse'],
                 metadata: 'outputs.SlsaMetadataResponse',
                 recipe: 'outputs.SlsaRecipeResponse'):
        """
        SlsaProvenance is the slsa provenance as defined by the slsa spec.
        :param 'SlsaBuilderResponse' builder: builder is the builder of this provenance
        :param Sequence['MaterialResponse'] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        :param 'SlsaMetadataResponse' metadata: metadata is the metadata of the provenance
        :param 'SlsaRecipeResponse' recipe: Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible).
        """
        pulumi.set(__self__, "builder", builder)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "recipe", recipe)

    @property
    @pulumi.getter
    def builder(self) -> 'outputs.SlsaBuilderResponse':
        """
        builder is the builder of this provenance
        """
        return pulumi.get(self, "builder")

    @property
    @pulumi.getter
    def materials(self) -> Sequence['outputs.MaterialResponse']:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.SlsaMetadataResponse':
        """
        metadata is the metadata of the provenance
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def recipe(self) -> 'outputs.SlsaRecipeResponse':
        """
        Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible).
        """
        return pulumi.get(self, "recipe")


@pulumi.output_type
class SlsaProvenanceZeroTwoResponse(dict):
    """
    SlsaProvenanceZeroTwo is the slsa provenance as defined by the slsa spec. See full explanation of fields at slsa.dev/provenance/v0.2.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildConfig":
            suggest = "build_config"
        elif key == "buildType":
            suggest = "build_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlsaProvenanceZeroTwoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlsaProvenanceZeroTwoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlsaProvenanceZeroTwoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_config: Mapping[str, str],
                 build_type: str,
                 builder: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaBuilderResponse',
                 invocation: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaInvocationResponse',
                 materials: Sequence['outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMaterialResponse'],
                 metadata: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMetadataResponse'):
        """
        SlsaProvenanceZeroTwo is the slsa provenance as defined by the slsa spec. See full explanation of fields at slsa.dev/provenance/v0.2.
        :param Mapping[str, str] build_config: Lists the steps in the build.
        :param str build_type: URI indicating what type of build was performed.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaBuilderResponse' builder: Identifies the entity that executed the recipe, which is trusted to have correctly performed the operation and populated this provenance.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaInvocationResponse' invocation: Identifies the event that kicked off the build.
        :param Sequence['GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMaterialResponse'] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMetadataResponse' metadata: Other properties of the build.
        """
        pulumi.set(__self__, "build_config", build_config)
        pulumi.set(__self__, "build_type", build_type)
        pulumi.set(__self__, "builder", builder)
        pulumi.set(__self__, "invocation", invocation)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> Mapping[str, str]:
        """
        Lists the steps in the build.
        """
        return pulumi.get(self, "build_config")

    @property
    @pulumi.getter(name="buildType")
    def build_type(self) -> str:
        """
        URI indicating what type of build was performed.
        """
        return pulumi.get(self, "build_type")

    @property
    @pulumi.getter
    def builder(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaBuilderResponse':
        """
        Identifies the entity that executed the recipe, which is trusted to have correctly performed the operation and populated this provenance.
        """
        return pulumi.get(self, "builder")

    @property
    @pulumi.getter
    def invocation(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaInvocationResponse':
        """
        Identifies the event that kicked off the build.
        """
        return pulumi.get(self, "invocation")

    @property
    @pulumi.getter
    def materials(self) -> Sequence['outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMaterialResponse']:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on.
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SlsaProvenanceZeroTwoSlsaMetadataResponse':
        """
        Other properties of the build.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class SlsaRecipeResponse(dict):
    """
    Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedInMaterial":
            suggest = "defined_in_material"
        elif key == "entryPoint":
            suggest = "entry_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlsaRecipeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlsaRecipeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlsaRecipeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Mapping[str, str],
                 defined_in_material: str,
                 entry_point: str,
                 environment: Mapping[str, str],
                 type: str):
        """
        Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
        :param Mapping[str, str] arguments: Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Depending on the recipe Type, the structure may be different.
        :param str defined_in_material: Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        :param str entry_point: String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        :param Mapping[str, str] environment: Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Depending on the recipe Type, the structure may be different.
        :param str type: URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "defined_in_material", defined_in_material)
        pulumi.set(__self__, "entry_point", entry_point)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arguments(self) -> Mapping[str, str]:
        """
        Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Depending on the recipe Type, the structure may be different.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="definedInMaterial")
    def defined_in_material(self) -> str:
        """
        Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        """
        return pulumi.get(self, "defined_in_material")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> str:
        """
        String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter
    def environment(self) -> Mapping[str, str]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Depending on the recipe Type, the structure may be different.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SourceResponse(dict):
    """
    Source describes the location of the source used for the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalContexts":
            suggest = "additional_contexts"
        elif key == "artifactStorageSource":
            suggest = "artifact_storage_source"
        elif key == "fileHashes":
            suggest = "file_hashes"
        elif key == "repoSource":
            suggest = "repo_source"
        elif key == "storageSource":
            suggest = "storage_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_contexts: Sequence['outputs.GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse'],
                 artifact_storage_source: 'outputs.StorageSourceResponse',
                 context: 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse',
                 file_hashes: Mapping[str, str],
                 repo_source: 'outputs.RepoSourceResponse',
                 storage_source: 'outputs.StorageSourceResponse'):
        """
        Source describes the location of the source used for the build.
        :param Sequence['GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse'] additional_contexts: If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        :param 'StorageSourceResponse' artifact_storage_source: If provided, the input binary artifacts for the build came from this location.
        :param 'GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse' context: If provided, the source code used for the build came from this location.
        :param Mapping[str, str] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        :param 'RepoSourceResponse' repo_source: If provided, get source from this location in a Cloud Repo.
        :param 'StorageSourceResponse' storage_source: If provided, get the source from this location in in Google Cloud Storage.
        """
        pulumi.set(__self__, "additional_contexts", additional_contexts)
        pulumi.set(__self__, "artifact_storage_source", artifact_storage_source)
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "file_hashes", file_hashes)
        pulumi.set(__self__, "repo_source", repo_source)
        pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Sequence['outputs.GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse']:
        """
        If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        """
        return pulumi.get(self, "additional_contexts")

    @property
    @pulumi.getter(name="artifactStorageSource")
    def artifact_storage_source(self) -> 'outputs.StorageSourceResponse':
        """
        If provided, the input binary artifacts for the build came from this location.
        """
        return pulumi.get(self, "artifact_storage_source")

    @property
    @pulumi.getter
    def context(self) -> 'outputs.GoogleDevtoolsContaineranalysisV1alpha1SourceContextResponse':
        """
        If provided, the source code used for the build came from this location.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Mapping[str, str]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> 'outputs.RepoSourceResponse':
        """
        If provided, get source from this location in a Cloud Repo.
        """
        return pulumi.get(self, "repo_source")

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> 'outputs.StorageSourceResponse':
        """
        If provided, get the source from this location in in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_source")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class StorageSourceResponse(dict):
    """
    StorageSource describes the location of the source in an archive file in Google Cloud Storage.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        StorageSource describes the location of the source in an archive file in Google Cloud Storage.
        :param str bucket: Google Cloud Storage bucket containing source (see [Bucket Name Requirements] (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param str generation: Google Cloud Storage generation for the object.
        :param str object: Google Cloud Storage object containing source.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Google Cloud Storage bucket containing source (see [Bucket Name Requirements] (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Google Cloud Storage generation for the object.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Google Cloud Storage object containing source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class SubjectResponse(dict):
    """
    Subject refers to the subject of the intoto statement
    """
    def __init__(__self__, *,
                 digest: Mapping[str, str],
                 name: str):
        """
        Subject refers to the subject of the intoto statement
        :param Mapping[str, str] digest: "": "" Algorithms can be e.g. sha256, sha512 See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
        :param str name: name is the name of the Subject used here
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def digest(self) -> Mapping[str, str]:
        """
        "": "" Algorithms can be e.g. sha256, sha512 See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name is the name of the Subject used here
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class UpgradeDistributionResponse(dict):
    """
    The Upgrade Distribution represents metadata about the Upgrade for each operating system (CPE). Some distributions have additional metadata around updates, classifying them into various categories and severities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeDistributionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeDistributionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeDistributionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification: str,
                 cpe_uri: str,
                 cve: Sequence[str],
                 severity: str):
        """
        The Upgrade Distribution represents metadata about the Upgrade for each operating system (CPE). Some distributions have additional metadata around updates, classifying them into various categories and severities.
        :param str classification: The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed.
        :param str cpe_uri: Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        :param Sequence[str] cve: The cve that would be resolved by this upgrade.
        :param str severity: The severity as specified by the upstream operating system.
        """
        pulumi.set(__self__, "classification", classification)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "cve", cve)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def classification(self) -> str:
        """
        The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed.
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def cve(self) -> Sequence[str]:
        """
        The cve that would be resolved by this upgrade.
        """
        return pulumi.get(self, "cve")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity as specified by the upstream operating system.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class UpgradeNoteResponse(dict):
    """
    An Upgrade Note represents a potential upgrade of a package to a given version. For each package version combination (i.e. bash 4.0, bash 4.1, bash 4.1.2), there will be a Upgrade Note.
    """
    def __init__(__self__, *,
                 distributions: Sequence['outputs.UpgradeDistributionResponse'],
                 package: str,
                 version: 'outputs.VersionResponse'):
        """
        An Upgrade Note represents a potential upgrade of a package to a given version. For each package version combination (i.e. bash 4.0, bash 4.1, bash 4.1.2), there will be a Upgrade Note.
        :param Sequence['UpgradeDistributionResponse'] distributions: Metadata about the upgrade for each specific operating system.
        :param str package: Required - The package this Upgrade is for.
        :param 'VersionResponse' version: Required - The version of the package in machine + human readable form.
        """
        pulumi.set(__self__, "distributions", distributions)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def distributions(self) -> Sequence['outputs.UpgradeDistributionResponse']:
        """
        Metadata about the upgrade for each specific operating system.
        """
        return pulumi.get(self, "distributions")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        Required - The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        Required - The version of the package in machine + human readable form.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class UpgradeOccurrenceResponse(dict):
    """
    An Upgrade Occurrence represents that a specific resource_url could install a specific upgrade. This presence is supplied via local sources (i.e. it is present in the mirror and the running system has noticed its availability).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parsedVersion":
            suggest = "parsed_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution: 'outputs.UpgradeDistributionResponse',
                 package: str,
                 parsed_version: 'outputs.VersionResponse'):
        """
        An Upgrade Occurrence represents that a specific resource_url could install a specific upgrade. This presence is supplied via local sources (i.e. it is present in the mirror and the running system has noticed its availability).
        :param 'UpgradeDistributionResponse' distribution: Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        :param str package: Required - The package this Upgrade is for.
        :param 'VersionResponse' parsed_version: Required - The version of the package in a machine + human readable form.
        """
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "parsed_version", parsed_version)

    @property
    @pulumi.getter
    def distribution(self) -> 'outputs.UpgradeDistributionResponse':
        """
        Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        Required - The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter(name="parsedVersion")
    def parsed_version(self) -> 'outputs.VersionResponse':
        """
        Required - The version of the package in a machine + human readable form.
        """
        return pulumi.get(self, "parsed_version")


@pulumi.output_type
class VersionResponse(dict):
    """
    Version contains structured information about the version of the package. For a discussion of this in Debian/Ubuntu: http://serverfault.com/questions/604541/debian-packages-version-convention For a discussion of this in Redhat/Fedora/Centos: http://blog.jasonantman.com/2014/07/how-yum-and-rpm-compare-versions/
    """
    def __init__(__self__, *,
                 epoch: int,
                 inclusive: bool,
                 kind: str,
                 name: str,
                 revision: str):
        """
        Version contains structured information about the version of the package. For a discussion of this in Debian/Ubuntu: http://serverfault.com/questions/604541/debian-packages-version-convention For a discussion of this in Redhat/Fedora/Centos: http://blog.jasonantman.com/2014/07/how-yum-and-rpm-compare-versions/
        :param int epoch: Used to correct mistakes in the version numbering scheme.
        :param bool inclusive: Whether this version is vulnerable, when defining the version bounds. For example, if the minimum version is 2.0, inclusive=true would say 2.0 is vulnerable, while inclusive=false would say it's not
        :param str kind: Distinguish between sentinel MIN/MAX versions and normal versions. If kind is not NORMAL, then the other fields are ignored.
        :param str name: The main part of the version name.
        :param str revision: The iteration of the package build from the above version.
        """
        pulumi.set(__self__, "epoch", epoch)
        pulumi.set(__self__, "inclusive", inclusive)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def epoch(self) -> int:
        """
        Used to correct mistakes in the version numbering scheme.
        """
        return pulumi.get(self, "epoch")

    @property
    @pulumi.getter
    def inclusive(self) -> bool:
        """
        Whether this version is vulnerable, when defining the version bounds. For example, if the minimum version is 2.0, inclusive=true would say 2.0 is vulnerable, while inclusive=false would say it's not
        """
        return pulumi.get(self, "inclusive")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Distinguish between sentinel MIN/MAX versions and normal versions. If kind is not NORMAL, then the other fields are ignored.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The main part of the version name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The iteration of the package build from the above version.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class VulnerabilityDetailsResponse(dict):
    """
    Used by Occurrence to point to where the vulnerability exists and how to fix it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssScore":
            suggest = "cvss_score"
        elif key == "cvssV3":
            suggest = "cvss_v3"
        elif key == "effectiveSeverity":
            suggest = "effective_severity"
        elif key == "packageIssue":
            suggest = "package_issue"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_score: float,
                 cvss_v3: 'outputs.CVSSResponse',
                 effective_severity: str,
                 package_issue: Sequence['outputs.PackageIssueResponse'],
                 severity: str,
                 type: str):
        """
        Used by Occurrence to point to where the vulnerability exists and how to fix it.
        :param float cvss_score: The CVSS score of this vulnerability. CVSS score is on a scale of 0-10 where 0 indicates low severity and 10 indicates high severity.
        :param 'CVSSResponse' cvss_v3: The CVSS v3 score of this vulnerability.
        :param str effective_severity: The distro assigned severity for this vulnerability when that is available and note provider assigned severity when distro has not yet assigned a severity for this vulnerability. When there are multiple package issues for this vulnerability, they can have different effective severities because some might come from the distro and some might come from installed language packs (e.g. Maven JARs or Go binaries). For this reason, it is advised to use the effective severity on the PackageIssue level, as this field may eventually be deprecated. In the case where multiple PackageIssues have different effective severities, the one set here will be the highest severity of any of the PackageIssues.
        :param Sequence['PackageIssueResponse'] package_issue: The set of affected locations and their fixes (if available) within the associated resource.
        :param str severity: The note provider assigned Severity of the vulnerability.
        :param str type: The type of package; whether native or non native(ruby gems, node.js packages etc). This may be deprecated in the future because we can have multiple PackageIssues with different package types.
        """
        pulumi.set(__self__, "cvss_score", cvss_score)
        pulumi.set(__self__, "cvss_v3", cvss_v3)
        pulumi.set(__self__, "effective_severity", effective_severity)
        pulumi.set(__self__, "package_issue", package_issue)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> float:
        """
        The CVSS score of this vulnerability. CVSS score is on a scale of 0-10 where 0 indicates low severity and 10 indicates high severity.
        """
        return pulumi.get(self, "cvss_score")

    @property
    @pulumi.getter(name="cvssV3")
    def cvss_v3(self) -> 'outputs.CVSSResponse':
        """
        The CVSS v3 score of this vulnerability.
        """
        return pulumi.get(self, "cvss_v3")

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> str:
        """
        The distro assigned severity for this vulnerability when that is available and note provider assigned severity when distro has not yet assigned a severity for this vulnerability. When there are multiple package issues for this vulnerability, they can have different effective severities because some might come from the distro and some might come from installed language packs (e.g. Maven JARs or Go binaries). For this reason, it is advised to use the effective severity on the PackageIssue level, as this field may eventually be deprecated. In the case where multiple PackageIssues have different effective severities, the one set here will be the highest severity of any of the PackageIssues.
        """
        return pulumi.get(self, "effective_severity")

    @property
    @pulumi.getter(name="packageIssue")
    def package_issue(self) -> Sequence['outputs.PackageIssueResponse']:
        """
        The set of affected locations and their fixes (if available) within the associated resource.
        """
        return pulumi.get(self, "package_issue")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The note provider assigned Severity of the vulnerability.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of package; whether native or non native(ruby gems, node.js packages etc). This may be deprecated in the future because we can have multiple PackageIssues with different package types.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VulnerabilityLocationResponse(dict):
    """
    The location of the vulnerability
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "fileLocation":
            suggest = "file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityLocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityLocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityLocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 file_location: Sequence['outputs.FileLocationResponse'],
                 package: str,
                 version: 'outputs.VersionResponse'):
        """
        The location of the vulnerability
        :param str cpe_uri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        :param Sequence['FileLocationResponse'] file_location: The file location at which this package was found.
        :param str package: The package being described.
        :param 'VersionResponse' version: The version of the package being described. This field can be used as a filter in list requests.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "file_location", file_location)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) format. Examples include distro or storage location for vulnerable jar. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter(name="fileLocation")
    def file_location(self) -> Sequence['outputs.FileLocationResponse']:
        """
        The file location at which this package was found.
        """
        return pulumi.get(self, "file_location")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        The package being described.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The version of the package being described. This field can be used as a filter in list requests.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class VulnerabilityTypeResponse(dict):
    """
    VulnerabilityType provides metadata about a security vulnerability.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssScore":
            suggest = "cvss_score"
        elif key == "cvssV2":
            suggest = "cvss_v2"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_score: float,
                 cvss_v2: 'outputs.CVSSResponse',
                 cwe: Sequence[str],
                 details: Sequence['outputs.DetailResponse'],
                 severity: str):
        """
        VulnerabilityType provides metadata about a security vulnerability.
        :param float cvss_score: The CVSS score for this Vulnerability.
        :param 'CVSSResponse' cvss_v2: The full description of the CVSS for version 2.
        :param Sequence[str] cwe: A list of CWE for this vulnerability. For details, see: https://cwe.mitre.org/index.html
        :param Sequence['DetailResponse'] details: All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        :param str severity: Note provider assigned impact of the vulnerability
        """
        pulumi.set(__self__, "cvss_score", cvss_score)
        pulumi.set(__self__, "cvss_v2", cvss_v2)
        pulumi.set(__self__, "cwe", cwe)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> float:
        """
        The CVSS score for this Vulnerability.
        """
        return pulumi.get(self, "cvss_score")

    @property
    @pulumi.getter(name="cvssV2")
    def cvss_v2(self) -> 'outputs.CVSSResponse':
        """
        The full description of the CVSS for version 2.
        """
        return pulumi.get(self, "cvss_v2")

    @property
    @pulumi.getter
    def cwe(self) -> Sequence[str]:
        """
        A list of CWE for this vulnerability. For details, see: https://cwe.mitre.org/index.html
        """
        return pulumi.get(self, "cwe")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.DetailResponse']:
        """
        All information about the package to specifically identify this vulnerability. One entry per (version range and cpe_uri) the package vulnerability has manifested in.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Note provider assigned impact of the vulnerability
        """
        return pulumi.get(self, "severity")


