# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['NfsShareArgs', 'NfsShare']

@pulumi.input_type
class NfsShareArgs:
    def __init__(__self__, *,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input['AllowedClientArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 requested_size_gib: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input['NfsShareStorageType']] = None):
        """
        The set of arguments for constructing a NfsShare resource.
        :param pulumi.Input[Sequence[pulumi.Input['AllowedClientArgs']]] allowed_clients: List of allowed access points.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs.
        :param pulumi.Input[str] name: Immutable. The name of the NFS share.
        :param pulumi.Input[str] requested_size_gib: The requested size, in GiB.
        :param pulumi.Input['NfsShareStorageType'] storage_type: Immutable. The storage type of the underlying volume.
        """
        if allowed_clients is not None:
            pulumi.set(__self__, "allowed_clients", allowed_clients)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if requested_size_gib is not None:
            pulumi.set(__self__, "requested_size_gib", requested_size_gib)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AllowedClientArgs']]]]:
        """
        List of allowed access points.
        """
        return pulumi.get(self, "allowed_clients")

    @allowed_clients.setter
    def allowed_clients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AllowedClientArgs']]]]):
        pulumi.set(self, "allowed_clients", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the NFS share.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestedSizeGib")
    def requested_size_gib(self) -> Optional[pulumi.Input[str]]:
        """
        The requested size, in GiB.
        """
        return pulumi.get(self, "requested_size_gib")

    @requested_size_gib.setter
    def requested_size_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requested_size_gib", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input['NfsShareStorageType']]:
        """
        Immutable. The storage type of the underlying volume.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input['NfsShareStorageType']]):
        pulumi.set(self, "storage_type", value)


class NfsShare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AllowedClientArgs']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 requested_size_gib: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input['NfsShareStorageType']] = None,
                 __props__=None):
        """
        Create an NFS share.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AllowedClientArgs']]]] allowed_clients: List of allowed access points.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs.
        :param pulumi.Input[str] name: Immutable. The name of the NFS share.
        :param pulumi.Input[str] requested_size_gib: The requested size, in GiB.
        :param pulumi.Input['NfsShareStorageType'] storage_type: Immutable. The storage type of the underlying volume.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NfsShareArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create an NFS share.

        :param str resource_name: The name of the resource.
        :param NfsShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NfsShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_clients: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AllowedClientArgs']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 requested_size_gib: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input['NfsShareStorageType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NfsShareArgs.__new__(NfsShareArgs)

            __props__.__dict__["allowed_clients"] = allowed_clients
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["requested_size_gib"] = requested_size_gib
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["nfs_share_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["volume"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(NfsShare, __self__).__init__(
            'google-native:baremetalsolution/v2:NfsShare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NfsShare':
        """
        Get an existing NfsShare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NfsShareArgs.__new__(NfsShareArgs)

        __props__.__dict__["allowed_clients"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["nfs_share_id"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["requested_size_gib"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["storage_type"] = None
        __props__.__dict__["volume"] = None
        return NfsShare(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> pulumi.Output[Sequence['outputs.AllowedClientResponse']]:
        """
        List of allowed access points.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The name of the NFS share.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nfsShareId")
    def nfs_share_id(self) -> pulumi.Output[str]:
        """
        An identifier for the NFS share, generated by the backend. This field will be deprecated in the future, use `id` instead.
        """
        return pulumi.get(self, "nfs_share_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestedSizeGib")
    def requested_size_gib(self) -> pulumi.Output[str]:
        """
        The requested size, in GiB.
        """
        return pulumi.get(self, "requested_size_gib")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the NFS share.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        Immutable. The storage type of the underlying volume.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Output[str]:
        """
        The underlying volume of the share. Created automatically during provisioning.
        """
        return pulumi.get(self, "volume")

