# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AllowedClientArgs',
    'GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs',
    'InstanceConfigArgs',
    'IntakeVlanAttachmentArgs',
    'LogicalNetworkInterfaceArgs',
    'LunRangeArgs',
    'LunArgs',
    'NetworkAddressArgs',
    'NetworkConfigArgs',
    'NfsExportArgs',
    'SnapshotReservationDetailArgs',
    'VolumeConfigArgs',
    'VolumeArgs',
]

@pulumi.input_type
class AllowedClientArgs:
    def __init__(__self__, *,
                 allow_dev: Optional[pulumi.Input[bool]] = None,
                 allow_suid: Optional[pulumi.Input[bool]] = None,
                 allowed_clients_cidr: Optional[pulumi.Input[str]] = None,
                 mount_permissions: Optional[pulumi.Input['AllowedClientMountPermissions']] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_root_squash: Optional[pulumi.Input[bool]] = None):
        """
        Represents an 'access point' for the share.
        :param pulumi.Input[bool] allow_dev: Allow dev flag. Which controls whether to allow creation of devices.
        :param pulumi.Input[bool] allow_suid: Allow the setuid flag.
        :param pulumi.Input[str] allowed_clients_cidr: The subnet of IP addresses permitted to access the share.
        :param pulumi.Input['AllowedClientMountPermissions'] mount_permissions: Mount permissions.
        :param pulumi.Input[str] network: The network the access point sits on.
        :param pulumi.Input[bool] no_root_squash: Disable root squashing, which is a feature of NFS. Root squash is a special mapping of the remote superuser (root) identity when using identity authentication.
        """
        if allow_dev is not None:
            pulumi.set(__self__, "allow_dev", allow_dev)
        if allow_suid is not None:
            pulumi.set(__self__, "allow_suid", allow_suid)
        if allowed_clients_cidr is not None:
            pulumi.set(__self__, "allowed_clients_cidr", allowed_clients_cidr)
        if mount_permissions is not None:
            pulumi.set(__self__, "mount_permissions", mount_permissions)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if no_root_squash is not None:
            pulumi.set(__self__, "no_root_squash", no_root_squash)

    @property
    @pulumi.getter(name="allowDev")
    def allow_dev(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow dev flag. Which controls whether to allow creation of devices.
        """
        return pulumi.get(self, "allow_dev")

    @allow_dev.setter
    def allow_dev(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_dev", value)

    @property
    @pulumi.getter(name="allowSuid")
    def allow_suid(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow the setuid flag.
        """
        return pulumi.get(self, "allow_suid")

    @allow_suid.setter
    def allow_suid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_suid", value)

    @property
    @pulumi.getter(name="allowedClientsCidr")
    def allowed_clients_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet of IP addresses permitted to access the share.
        """
        return pulumi.get(self, "allowed_clients_cidr")

    @allowed_clients_cidr.setter
    def allowed_clients_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_clients_cidr", value)

    @property
    @pulumi.getter(name="mountPermissions")
    def mount_permissions(self) -> Optional[pulumi.Input['AllowedClientMountPermissions']]:
        """
        Mount permissions.
        """
        return pulumi.get(self, "mount_permissions")

    @mount_permissions.setter
    def mount_permissions(self, value: Optional[pulumi.Input['AllowedClientMountPermissions']]):
        pulumi.set(self, "mount_permissions", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The network the access point sits on.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="noRootSquash")
    def no_root_squash(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable root squashing, which is a feature of NFS. Root squash is a special mapping of the remote superuser (root) identity when using identity authentication.
        """
        return pulumi.get(self, "no_root_squash")

    @no_root_squash.setter
    def no_root_squash(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_root_squash", value)


@pulumi.input_type
class GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs:
    def __init__(__self__, *,
                 interface_index: Optional[pulumi.Input[int]] = None,
                 logical_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['LogicalNetworkInterfaceArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Each logical interface represents a logical abstraction of the underlying physical interface (for eg. bond, nic) of the instance. Each logical interface can effectively map to multiple network-IP pairs and still be mapped to one underlying physical interface.
        :param pulumi.Input[int] interface_index: The index of the logical interface mapping to the index of the hardware bond or nic on the chosen network template. This field is deprecated.
        :param pulumi.Input[Sequence[pulumi.Input['LogicalNetworkInterfaceArgs']]] logical_network_interfaces: List of logical network interfaces within a logical interface.
        :param pulumi.Input[str] name: Interface name. This is of syntax or and forms part of the network template name.
        """
        if interface_index is not None:
            warnings.warn("""The index of the logical interface mapping to the index of the hardware bond or nic on the chosen network template. This field is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""interface_index is deprecated: The index of the logical interface mapping to the index of the hardware bond or nic on the chosen network template. This field is deprecated.""")
        if interface_index is not None:
            pulumi.set(__self__, "interface_index", interface_index)
        if logical_network_interfaces is not None:
            pulumi.set(__self__, "logical_network_interfaces", logical_network_interfaces)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="interfaceIndex")
    def interface_index(self) -> Optional[pulumi.Input[int]]:
        """
        The index of the logical interface mapping to the index of the hardware bond or nic on the chosen network template. This field is deprecated.
        """
        return pulumi.get(self, "interface_index")

    @interface_index.setter
    def interface_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interface_index", value)

    @property
    @pulumi.getter(name="logicalNetworkInterfaces")
    def logical_network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogicalNetworkInterfaceArgs']]]]:
        """
        List of logical network interfaces within a logical interface.
        """
        return pulumi.get(self, "logical_network_interfaces")

    @logical_network_interfaces.setter
    def logical_network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogicalNetworkInterfaceArgs']]]]):
        pulumi.set(self, "logical_network_interfaces", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Interface name. This is of syntax or and forms part of the network template name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class InstanceConfigArgs:
    def __init__(__self__, *,
                 account_networks_enabled: Optional[pulumi.Input[bool]] = None,
                 client_network: Optional[pulumi.Input['NetworkAddressArgs']] = None,
                 hyperthreading: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 logical_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]] = None,
                 network_config: Optional[pulumi.Input['InstanceConfigNetworkConfig']] = None,
                 network_template: Optional[pulumi.Input[str]] = None,
                 os_image: Optional[pulumi.Input[str]] = None,
                 private_network: Optional[pulumi.Input['NetworkAddressArgs']] = None,
                 user_note: Optional[pulumi.Input[str]] = None):
        """
        Configuration parameters for a new instance.
        :param pulumi.Input[bool] account_networks_enabled: If true networks can be from different projects of the same vendor account.
        :param pulumi.Input['NetworkAddressArgs'] client_network: Client network address. Filled if InstanceConfig.multivlan_config is false.
        :param pulumi.Input[bool] hyperthreading: Whether the instance should be provisioned with Hyperthreading enabled.
        :param pulumi.Input[str] id: A transient unique identifier to idenfity an instance within an ProvisioningConfig request.
        :param pulumi.Input[str] instance_type: Instance type. [Available types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]] logical_interfaces: List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. Filled if InstanceConfig.multivlan_config is true.
        :param pulumi.Input['InstanceConfigNetworkConfig'] network_config: The type of network configuration on the instance.
        :param pulumi.Input[str] network_template: Server network template name. Filled if InstanceConfig.multivlan_config is true.
        :param pulumi.Input[str] os_image: OS image to initialize the instance. [Available images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        :param pulumi.Input['NetworkAddressArgs'] private_network: Private network address, if any. Filled if InstanceConfig.multivlan_config is false.
        :param pulumi.Input[str] user_note: User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        if account_networks_enabled is not None:
            pulumi.set(__self__, "account_networks_enabled", account_networks_enabled)
        if client_network is not None:
            pulumi.set(__self__, "client_network", client_network)
        if hyperthreading is not None:
            pulumi.set(__self__, "hyperthreading", hyperthreading)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if logical_interfaces is not None:
            pulumi.set(__self__, "logical_interfaces", logical_interfaces)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if network_template is not None:
            pulumi.set(__self__, "network_template", network_template)
        if os_image is not None:
            pulumi.set(__self__, "os_image", os_image)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if user_note is not None:
            pulumi.set(__self__, "user_note", user_note)

    @property
    @pulumi.getter(name="accountNetworksEnabled")
    def account_networks_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true networks can be from different projects of the same vendor account.
        """
        return pulumi.get(self, "account_networks_enabled")

    @account_networks_enabled.setter
    def account_networks_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "account_networks_enabled", value)

    @property
    @pulumi.getter(name="clientNetwork")
    def client_network(self) -> Optional[pulumi.Input['NetworkAddressArgs']]:
        """
        Client network address. Filled if InstanceConfig.multivlan_config is false.
        """
        return pulumi.get(self, "client_network")

    @client_network.setter
    def client_network(self, value: Optional[pulumi.Input['NetworkAddressArgs']]):
        pulumi.set(self, "client_network", value)

    @property
    @pulumi.getter
    def hyperthreading(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance should be provisioned with Hyperthreading enabled.
        """
        return pulumi.get(self, "hyperthreading")

    @hyperthreading.setter
    def hyperthreading(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hyperthreading", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A transient unique identifier to idenfity an instance within an ProvisioningConfig request.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. [Available types](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="logicalInterfaces")
    def logical_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]]:
        """
        List of logical interfaces for the instance. The number of logical interfaces will be the same as number of hardware bond/nic on the chosen network template. Filled if InstanceConfig.multivlan_config is true.
        """
        return pulumi.get(self, "logical_interfaces")

    @logical_interfaces.setter
    def logical_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudBaremetalsolutionV2LogicalInterfaceArgs']]]]):
        pulumi.set(self, "logical_interfaces", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['InstanceConfigNetworkConfig']]:
        """
        The type of network configuration on the instance.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['InstanceConfigNetworkConfig']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="networkTemplate")
    def network_template(self) -> Optional[pulumi.Input[str]]:
        """
        Server network template name. Filled if InstanceConfig.multivlan_config is true.
        """
        return pulumi.get(self, "network_template")

    @network_template.setter
    def network_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_template", value)

    @property
    @pulumi.getter(name="osImage")
    def os_image(self) -> Optional[pulumi.Input[str]]:
        """
        OS image to initialize the instance. [Available images](https://cloud.google.com/bare-metal/docs/bms-planning#server_configurations)
        """
        return pulumi.get(self, "os_image")

    @os_image.setter
    def os_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_image", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input['NetworkAddressArgs']]:
        """
        Private network address, if any. Filled if InstanceConfig.multivlan_config is false.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input['NetworkAddressArgs']]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="userNote")
    def user_note(self) -> Optional[pulumi.Input[str]]:
        """
        User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        return pulumi.get(self, "user_note")

    @user_note.setter
    def user_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_note", value)


@pulumi.input_type
class IntakeVlanAttachmentArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 pairing_key: Optional[pulumi.Input[str]] = None):
        """
        A GCP vlan attachment.
        :param pulumi.Input[str] id: Identifier of the VLAN attachment.
        :param pulumi.Input[str] pairing_key: Attachment pairing key.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if pairing_key is not None:
            pulumi.set(__self__, "pairing_key", pairing_key)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VLAN attachment.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> Optional[pulumi.Input[str]]:
        """
        Attachment pairing key.
        """
        return pulumi.get(self, "pairing_key")

    @pairing_key.setter
    def pairing_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pairing_key", value)


@pulumi.input_type
class LogicalNetworkInterfaceArgs:
    def __init__(__self__, *,
                 default_gateway: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_type: Optional[pulumi.Input['LogicalNetworkInterfaceNetworkType']] = None):
        """
        Each logical network interface is effectively a network and IP pair.
        :param pulumi.Input[bool] default_gateway: Whether this interface is the default gateway for the instance. Only one interface can be the default gateway for the instance.
        :param pulumi.Input[str] id: An identifier for the `Network`, generated by the backend.
        :param pulumi.Input[str] ip_address: IP address in the network
        :param pulumi.Input[str] network: Name of the network
        :param pulumi.Input['LogicalNetworkInterfaceNetworkType'] network_type: Type of network.
        """
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this interface is the default gateway for the instance. Only one interface can be the default gateway for the instance.
        """
        return pulumi.get(self, "default_gateway")

    @default_gateway.setter
    def default_gateway(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_gateway", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the `Network`, generated by the backend.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address in the network
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the network
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input['LogicalNetworkInterfaceNetworkType']]:
        """
        Type of network.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input['LogicalNetworkInterfaceNetworkType']]):
        pulumi.set(self, "network_type", value)


@pulumi.input_type
class LunRangeArgs:
    def __init__(__self__, *,
                 quantity: Optional[pulumi.Input[int]] = None,
                 size_gb: Optional[pulumi.Input[int]] = None):
        """
        A LUN(Logical Unit Number) range.
        :param pulumi.Input[int] quantity: Number of LUNs to create.
        :param pulumi.Input[int] size_gb: The requested size of each LUN, in GB.
        """
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of LUNs to create.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quantity", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The requested size of each LUN, in GB.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_gb", value)


@pulumi.input_type
class LunArgs:
    def __init__(__self__, *,
                 boot_lun: Optional[pulumi.Input[bool]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 multiprotocol_type: Optional[pulumi.Input['LunMultiprotocolType']] = None,
                 shareable: Optional[pulumi.Input[bool]] = None,
                 size_gb: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['LunState']] = None,
                 storage_type: Optional[pulumi.Input['LunStorageType']] = None,
                 storage_volume: Optional[pulumi.Input[str]] = None,
                 wwid: Optional[pulumi.Input[str]] = None):
        """
        A storage volume logical unit number (LUN).
        :param pulumi.Input[bool] boot_lun: Display if this LUN is a boot LUN.
        :param pulumi.Input[str] id: An identifier for the LUN, generated by the backend.
        :param pulumi.Input['LunMultiprotocolType'] multiprotocol_type: The LUN multiprotocol type ensures the characteristics of the LUN are optimized for each operating system.
        :param pulumi.Input[bool] shareable: Display if this LUN can be shared between multiple physical servers.
        :param pulumi.Input[str] size_gb: The size of this LUN, in gigabytes.
        :param pulumi.Input['LunState'] state: The state of this storage volume.
        :param pulumi.Input['LunStorageType'] storage_type: The storage type for this LUN.
        :param pulumi.Input[str] storage_volume: Display the storage volume for this LUN.
        :param pulumi.Input[str] wwid: The WWID for this LUN.
        """
        if boot_lun is not None:
            pulumi.set(__self__, "boot_lun", boot_lun)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if multiprotocol_type is not None:
            pulumi.set(__self__, "multiprotocol_type", multiprotocol_type)
        if shareable is not None:
            pulumi.set(__self__, "shareable", shareable)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if storage_volume is not None:
            pulumi.set(__self__, "storage_volume", storage_volume)
        if wwid is not None:
            pulumi.set(__self__, "wwid", wwid)

    @property
    @pulumi.getter(name="bootLun")
    def boot_lun(self) -> Optional[pulumi.Input[bool]]:
        """
        Display if this LUN is a boot LUN.
        """
        return pulumi.get(self, "boot_lun")

    @boot_lun.setter
    def boot_lun(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "boot_lun", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the LUN, generated by the backend.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="multiprotocolType")
    def multiprotocol_type(self) -> Optional[pulumi.Input['LunMultiprotocolType']]:
        """
        The LUN multiprotocol type ensures the characteristics of the LUN are optimized for each operating system.
        """
        return pulumi.get(self, "multiprotocol_type")

    @multiprotocol_type.setter
    def multiprotocol_type(self, value: Optional[pulumi.Input['LunMultiprotocolType']]):
        pulumi.set(self, "multiprotocol_type", value)

    @property
    @pulumi.getter
    def shareable(self) -> Optional[pulumi.Input[bool]]:
        """
        Display if this LUN can be shared between multiple physical servers.
        """
        return pulumi.get(self, "shareable")

    @shareable.setter
    def shareable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shareable", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        The size of this LUN, in gigabytes.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_gb", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['LunState']]:
        """
        The state of this storage volume.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['LunState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input['LunStorageType']]:
        """
        The storage type for this LUN.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input['LunStorageType']]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="storageVolume")
    def storage_volume(self) -> Optional[pulumi.Input[str]]:
        """
        Display the storage volume for this LUN.
        """
        return pulumi.get(self, "storage_volume")

    @storage_volume.setter
    def storage_volume(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_volume", value)

    @property
    @pulumi.getter
    def wwid(self) -> Optional[pulumi.Input[str]]:
        """
        The WWID for this LUN.
        """
        return pulumi.get(self, "wwid")

    @wwid.setter
    def wwid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wwid", value)


@pulumi.input_type
class NetworkAddressArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 existing_network_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None):
        """
        A network.
        :param pulumi.Input[str] address: IPv4 address to be assigned to the server.
        :param pulumi.Input[str] existing_network_id: Name of the existing network to use.
        :param pulumi.Input[str] network_id: Id of the network to use, within the same ProvisioningConfig request.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if existing_network_id is not None:
            pulumi.set(__self__, "existing_network_id", existing_network_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address to be assigned to the server.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="existingNetworkId")
    def existing_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the existing network to use.
        """
        return pulumi.get(self, "existing_network_id")

    @existing_network_id.setter
    def existing_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_network_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the network to use, within the same ProvisioningConfig request.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)


@pulumi.input_type
class NetworkConfigArgs:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input['NetworkConfigBandwidth']] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 gcp_service: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 jumbo_frames_enabled: Optional[pulumi.Input[bool]] = None,
                 service_cidr: Optional[pulumi.Input['NetworkConfigServiceCidr']] = None,
                 type: Optional[pulumi.Input['NetworkConfigType']] = None,
                 user_note: Optional[pulumi.Input[str]] = None,
                 vlan_attachments: Optional[pulumi.Input[Sequence[pulumi.Input['IntakeVlanAttachmentArgs']]]] = None,
                 vlan_same_project: Optional[pulumi.Input[bool]] = None):
        """
        Configuration parameters for a new network.
        :param pulumi.Input['NetworkConfigBandwidth'] bandwidth: Interconnect bandwidth. Set only when type is CLIENT.
        :param pulumi.Input[str] cidr: CIDR range of the network.
        :param pulumi.Input[str] gcp_service: The GCP service of the network. Available gcp_service are in https://cloud.google.com/bare-metal/docs/bms-planning.
        :param pulumi.Input[str] id: A transient unique identifier to identify a volume within an ProvisioningConfig request.
        :param pulumi.Input[bool] jumbo_frames_enabled: The JumboFramesEnabled option for customer to set.
        :param pulumi.Input['NetworkConfigServiceCidr'] service_cidr: Service CIDR, if any.
        :param pulumi.Input['NetworkConfigType'] type: The type of this network, either Client or Private.
        :param pulumi.Input[str] user_note: User note field, it can be used by customers to add additional information for the BMS Ops team .
        :param pulumi.Input[Sequence[pulumi.Input['IntakeVlanAttachmentArgs']]] vlan_attachments: List of VLAN attachments. As of now there are always 2 attachments, but it is going to change in the future (multi vlan).
        :param pulumi.Input[bool] vlan_same_project: Whether the VLAN attachment pair is located in the same project.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if gcp_service is not None:
            pulumi.set(__self__, "gcp_service", gcp_service)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if jumbo_frames_enabled is not None:
            pulumi.set(__self__, "jumbo_frames_enabled", jumbo_frames_enabled)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_note is not None:
            pulumi.set(__self__, "user_note", user_note)
        if vlan_attachments is not None:
            pulumi.set(__self__, "vlan_attachments", vlan_attachments)
        if vlan_same_project is not None:
            pulumi.set(__self__, "vlan_same_project", vlan_same_project)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input['NetworkConfigBandwidth']]:
        """
        Interconnect bandwidth. Set only when type is CLIENT.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input['NetworkConfigBandwidth']]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR range of the network.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="gcpService")
    def gcp_service(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP service of the network. Available gcp_service are in https://cloud.google.com/bare-metal/docs/bms-planning.
        """
        return pulumi.get(self, "gcp_service")

    @gcp_service.setter
    def gcp_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcp_service", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A transient unique identifier to identify a volume within an ProvisioningConfig request.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="jumboFramesEnabled")
    def jumbo_frames_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The JumboFramesEnabled option for customer to set.
        """
        return pulumi.get(self, "jumbo_frames_enabled")

    @jumbo_frames_enabled.setter
    def jumbo_frames_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jumbo_frames_enabled", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input['NetworkConfigServiceCidr']]:
        """
        Service CIDR, if any.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input['NetworkConfigServiceCidr']]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['NetworkConfigType']]:
        """
        The type of this network, either Client or Private.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['NetworkConfigType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userNote")
    def user_note(self) -> Optional[pulumi.Input[str]]:
        """
        User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        return pulumi.get(self, "user_note")

    @user_note.setter
    def user_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_note", value)

    @property
    @pulumi.getter(name="vlanAttachments")
    def vlan_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntakeVlanAttachmentArgs']]]]:
        """
        List of VLAN attachments. As of now there are always 2 attachments, but it is going to change in the future (multi vlan).
        """
        return pulumi.get(self, "vlan_attachments")

    @vlan_attachments.setter
    def vlan_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntakeVlanAttachmentArgs']]]]):
        pulumi.set(self, "vlan_attachments", value)

    @property
    @pulumi.getter(name="vlanSameProject")
    def vlan_same_project(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the VLAN attachment pair is located in the same project.
        """
        return pulumi.get(self, "vlan_same_project")

    @vlan_same_project.setter
    def vlan_same_project(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "vlan_same_project", value)


@pulumi.input_type
class NfsExportArgs:
    def __init__(__self__, *,
                 allow_dev: Optional[pulumi.Input[bool]] = None,
                 allow_suid: Optional[pulumi.Input[bool]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 machine_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 no_root_squash: Optional[pulumi.Input[bool]] = None,
                 permissions: Optional[pulumi.Input['NfsExportPermissions']] = None):
        """
        A NFS export entry.
        :param pulumi.Input[bool] allow_dev: Allow dev flag in NfsShare AllowedClientsRequest.
        :param pulumi.Input[bool] allow_suid: Allow the setuid flag.
        :param pulumi.Input[str] cidr: A CIDR range.
        :param pulumi.Input[str] machine_id: Either a single machine, identified by an ID, or a comma-separated list of machine IDs.
        :param pulumi.Input[str] network_id: Network to use to publish the export.
        :param pulumi.Input[bool] no_root_squash: Disable root squashing, which is a feature of NFS. Root squash is a special mapping of the remote superuser (root) identity when using identity authentication.
        :param pulumi.Input['NfsExportPermissions'] permissions: Export permissions.
        """
        if allow_dev is not None:
            pulumi.set(__self__, "allow_dev", allow_dev)
        if allow_suid is not None:
            pulumi.set(__self__, "allow_suid", allow_suid)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if machine_id is not None:
            pulumi.set(__self__, "machine_id", machine_id)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if no_root_squash is not None:
            pulumi.set(__self__, "no_root_squash", no_root_squash)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="allowDev")
    def allow_dev(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow dev flag in NfsShare AllowedClientsRequest.
        """
        return pulumi.get(self, "allow_dev")

    @allow_dev.setter
    def allow_dev(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_dev", value)

    @property
    @pulumi.getter(name="allowSuid")
    def allow_suid(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow the setuid flag.
        """
        return pulumi.get(self, "allow_suid")

    @allow_suid.setter
    def allow_suid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_suid", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR range.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="machineId")
    def machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Either a single machine, identified by an ID, or a comma-separated list of machine IDs.
        """
        return pulumi.get(self, "machine_id")

    @machine_id.setter
    def machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Network to use to publish the export.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="noRootSquash")
    def no_root_squash(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable root squashing, which is a feature of NFS. Root squash is a special mapping of the remote superuser (root) identity when using identity authentication.
        """
        return pulumi.get(self, "no_root_squash")

    @no_root_squash.setter
    def no_root_squash(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_root_squash", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input['NfsExportPermissions']]:
        """
        Export permissions.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input['NfsExportPermissions']]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class SnapshotReservationDetailArgs:
    def __init__(__self__, *,
                 reserved_space_gib: Optional[pulumi.Input[str]] = None,
                 reserved_space_percent: Optional[pulumi.Input[int]] = None,
                 reserved_space_remaining_gib: Optional[pulumi.Input[str]] = None,
                 reserved_space_used_percent: Optional[pulumi.Input[int]] = None):
        """
        Details about snapshot space reservation and usage on the storage volume.
        :param pulumi.Input[str] reserved_space_gib: The space on this storage volume reserved for snapshots, shown in GiB.
        :param pulumi.Input[int] reserved_space_percent: Percent of the total Volume size reserved for snapshot copies. Enabling snapshots requires reserving 20% or more of the storage volume space for snapshots. Maximum reserved space for snapshots is 40%. Setting this field will effectively set snapshot_enabled to true.
        :param pulumi.Input[str] reserved_space_remaining_gib: The amount, in GiB, of available space in this storage volume's reserved snapshot space.
        :param pulumi.Input[int] reserved_space_used_percent: The percent of snapshot space on this storage volume actually being used by the snapshot copies. This value might be higher than 100% if the snapshot copies have overflowed into the data portion of the storage volume.
        """
        if reserved_space_gib is not None:
            pulumi.set(__self__, "reserved_space_gib", reserved_space_gib)
        if reserved_space_percent is not None:
            pulumi.set(__self__, "reserved_space_percent", reserved_space_percent)
        if reserved_space_remaining_gib is not None:
            pulumi.set(__self__, "reserved_space_remaining_gib", reserved_space_remaining_gib)
        if reserved_space_used_percent is not None:
            pulumi.set(__self__, "reserved_space_used_percent", reserved_space_used_percent)

    @property
    @pulumi.getter(name="reservedSpaceGib")
    def reserved_space_gib(self) -> Optional[pulumi.Input[str]]:
        """
        The space on this storage volume reserved for snapshots, shown in GiB.
        """
        return pulumi.get(self, "reserved_space_gib")

    @reserved_space_gib.setter
    def reserved_space_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_space_gib", value)

    @property
    @pulumi.getter(name="reservedSpacePercent")
    def reserved_space_percent(self) -> Optional[pulumi.Input[int]]:
        """
        Percent of the total Volume size reserved for snapshot copies. Enabling snapshots requires reserving 20% or more of the storage volume space for snapshots. Maximum reserved space for snapshots is 40%. Setting this field will effectively set snapshot_enabled to true.
        """
        return pulumi.get(self, "reserved_space_percent")

    @reserved_space_percent.setter
    def reserved_space_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reserved_space_percent", value)

    @property
    @pulumi.getter(name="reservedSpaceRemainingGib")
    def reserved_space_remaining_gib(self) -> Optional[pulumi.Input[str]]:
        """
        The amount, in GiB, of available space in this storage volume's reserved snapshot space.
        """
        return pulumi.get(self, "reserved_space_remaining_gib")

    @reserved_space_remaining_gib.setter
    def reserved_space_remaining_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_space_remaining_gib", value)

    @property
    @pulumi.getter(name="reservedSpaceUsedPercent")
    def reserved_space_used_percent(self) -> Optional[pulumi.Input[int]]:
        """
        The percent of snapshot space on this storage volume actually being used by the snapshot copies. This value might be higher than 100% if the snapshot copies have overflowed into the data portion of the storage volume.
        """
        return pulumi.get(self, "reserved_space_used_percent")

    @reserved_space_used_percent.setter
    def reserved_space_used_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reserved_space_used_percent", value)


@pulumi.input_type
class VolumeConfigArgs:
    def __init__(__self__, *,
                 gcp_service: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 lun_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['LunRangeArgs']]]] = None,
                 machine_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 nfs_exports: Optional[pulumi.Input[Sequence[pulumi.Input['NfsExportArgs']]]] = None,
                 performance_tier: Optional[pulumi.Input['VolumeConfigPerformanceTier']] = None,
                 protocol: Optional[pulumi.Input['VolumeConfigProtocol']] = None,
                 size_gb: Optional[pulumi.Input[int]] = None,
                 snapshots_enabled: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input['VolumeConfigType']] = None,
                 user_note: Optional[pulumi.Input[str]] = None):
        """
        Configuration parameters for a new volume.
        :param pulumi.Input[str] gcp_service: The GCP service of the storage volume. Available gcp_service are in https://cloud.google.com/bare-metal/docs/bms-planning.
        :param pulumi.Input[str] id: A transient unique identifier to identify a volume within an ProvisioningConfig request.
        :param pulumi.Input[Sequence[pulumi.Input['LunRangeArgs']]] lun_ranges: LUN ranges to be configured. Set only when protocol is PROTOCOL_FC.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] machine_ids: Machine ids connected to this volume. Set only when protocol is PROTOCOL_FC.
        :param pulumi.Input[Sequence[pulumi.Input['NfsExportArgs']]] nfs_exports: NFS exports. Set only when protocol is PROTOCOL_NFS.
        :param pulumi.Input['VolumeConfigPerformanceTier'] performance_tier: Performance tier of the Volume. Default is SHARED.
        :param pulumi.Input['VolumeConfigProtocol'] protocol: Volume protocol.
        :param pulumi.Input[int] size_gb: The requested size of this volume, in GB.
        :param pulumi.Input[bool] snapshots_enabled: Whether snapshots should be enabled.
        :param pulumi.Input['VolumeConfigType'] type: The type of this Volume.
        :param pulumi.Input[str] user_note: User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        if gcp_service is not None:
            pulumi.set(__self__, "gcp_service", gcp_service)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if lun_ranges is not None:
            pulumi.set(__self__, "lun_ranges", lun_ranges)
        if machine_ids is not None:
            pulumi.set(__self__, "machine_ids", machine_ids)
        if nfs_exports is not None:
            pulumi.set(__self__, "nfs_exports", nfs_exports)
        if performance_tier is not None:
            pulumi.set(__self__, "performance_tier", performance_tier)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if snapshots_enabled is not None:
            pulumi.set(__self__, "snapshots_enabled", snapshots_enabled)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_note is not None:
            pulumi.set(__self__, "user_note", user_note)

    @property
    @pulumi.getter(name="gcpService")
    def gcp_service(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP service of the storage volume. Available gcp_service are in https://cloud.google.com/bare-metal/docs/bms-planning.
        """
        return pulumi.get(self, "gcp_service")

    @gcp_service.setter
    def gcp_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcp_service", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A transient unique identifier to identify a volume within an ProvisioningConfig request.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="lunRanges")
    def lun_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LunRangeArgs']]]]:
        """
        LUN ranges to be configured. Set only when protocol is PROTOCOL_FC.
        """
        return pulumi.get(self, "lun_ranges")

    @lun_ranges.setter
    def lun_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LunRangeArgs']]]]):
        pulumi.set(self, "lun_ranges", value)

    @property
    @pulumi.getter(name="machineIds")
    def machine_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Machine ids connected to this volume. Set only when protocol is PROTOCOL_FC.
        """
        return pulumi.get(self, "machine_ids")

    @machine_ids.setter
    def machine_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "machine_ids", value)

    @property
    @pulumi.getter(name="nfsExports")
    def nfs_exports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NfsExportArgs']]]]:
        """
        NFS exports. Set only when protocol is PROTOCOL_NFS.
        """
        return pulumi.get(self, "nfs_exports")

    @nfs_exports.setter
    def nfs_exports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NfsExportArgs']]]]):
        pulumi.set(self, "nfs_exports", value)

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> Optional[pulumi.Input['VolumeConfigPerformanceTier']]:
        """
        Performance tier of the Volume. Default is SHARED.
        """
        return pulumi.get(self, "performance_tier")

    @performance_tier.setter
    def performance_tier(self, value: Optional[pulumi.Input['VolumeConfigPerformanceTier']]):
        pulumi.set(self, "performance_tier", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['VolumeConfigProtocol']]:
        """
        Volume protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['VolumeConfigProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The requested size of this volume, in GB.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_gb", value)

    @property
    @pulumi.getter(name="snapshotsEnabled")
    def snapshots_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether snapshots should be enabled.
        """
        return pulumi.get(self, "snapshots_enabled")

    @snapshots_enabled.setter
    def snapshots_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snapshots_enabled", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['VolumeConfigType']]:
        """
        The type of this Volume.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['VolumeConfigType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userNote")
    def user_note(self) -> Optional[pulumi.Input[str]]:
        """
        User note field, it can be used by customers to add additional information for the BMS Ops team .
        """
        return pulumi.get(self, "user_note")

    @user_note.setter
    def user_note(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_note", value)


@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 auto_grown_size_gib: Optional[pulumi.Input[str]] = None,
                 current_size_gib: Optional[pulumi.Input[str]] = None,
                 emergency_size_gib: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size_gib: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 originally_requested_size_gib: Optional[pulumi.Input[str]] = None,
                 performance_tier: Optional[pulumi.Input['VolumePerformanceTier']] = None,
                 pod: Optional[pulumi.Input[str]] = None,
                 remaining_space_gib: Optional[pulumi.Input[str]] = None,
                 requested_size_gib: Optional[pulumi.Input[str]] = None,
                 snapshot_auto_delete_behavior: Optional[pulumi.Input['VolumeSnapshotAutoDeleteBehavior']] = None,
                 snapshot_enabled: Optional[pulumi.Input[bool]] = None,
                 snapshot_reservation_detail: Optional[pulumi.Input['SnapshotReservationDetailArgs']] = None,
                 snapshot_schedule_policy: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['VolumeState']] = None,
                 storage_type: Optional[pulumi.Input['VolumeStorageType']] = None):
        """
        A storage volume.
        :param pulumi.Input[str] auto_grown_size_gib: The size, in GiB, that this storage volume has expanded as a result of an auto grow policy. In the absence of auto-grow, the value is 0.
        :param pulumi.Input[str] current_size_gib: The current size of this storage volume, in GiB, including space reserved for snapshots. This size might be different than the requested size if the storage volume has been configured with auto grow or auto shrink.
        :param pulumi.Input[str] emergency_size_gib: Additional emergency size that was requested for this Volume, in GiB. current_size_gib includes this value.
        :param pulumi.Input[str] id: An identifier for the `Volume`, generated by the backend.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs.
        :param pulumi.Input[str] max_size_gib: Maximum size volume can be expanded to in case of evergency, in GiB.
        :param pulumi.Input[str] notes: Input only. User-specified notes for new Volume. Used to provision Volumes that require manual intervention.
        :param pulumi.Input[str] originally_requested_size_gib: Originally requested size, in GiB.
        :param pulumi.Input['VolumePerformanceTier'] performance_tier: Immutable. Performance tier of the Volume. Default is SHARED.
        :param pulumi.Input[str] pod: Immutable. Pod name.
        :param pulumi.Input[str] remaining_space_gib: The space remaining in the storage volume for new LUNs, in GiB, excluding space reserved for snapshots.
        :param pulumi.Input[str] requested_size_gib: The requested size of this storage volume, in GiB.
        :param pulumi.Input['VolumeSnapshotAutoDeleteBehavior'] snapshot_auto_delete_behavior: The behavior to use when snapshot reserved space is full.
        :param pulumi.Input[bool] snapshot_enabled: Whether snapshots are enabled.
        :param pulumi.Input['SnapshotReservationDetailArgs'] snapshot_reservation_detail: Details about snapshot space reservation and usage on the storage volume.
        :param pulumi.Input[str] snapshot_schedule_policy: The name of the snapshot schedule policy in use for this volume, if any.
        :param pulumi.Input['VolumeState'] state: The state of this storage volume.
        :param pulumi.Input['VolumeStorageType'] storage_type: The storage type for this volume.
        """
        if auto_grown_size_gib is not None:
            pulumi.set(__self__, "auto_grown_size_gib", auto_grown_size_gib)
        if current_size_gib is not None:
            pulumi.set(__self__, "current_size_gib", current_size_gib)
        if emergency_size_gib is not None:
            pulumi.set(__self__, "emergency_size_gib", emergency_size_gib)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size_gib is not None:
            pulumi.set(__self__, "max_size_gib", max_size_gib)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if originally_requested_size_gib is not None:
            pulumi.set(__self__, "originally_requested_size_gib", originally_requested_size_gib)
        if performance_tier is not None:
            pulumi.set(__self__, "performance_tier", performance_tier)
        if pod is not None:
            pulumi.set(__self__, "pod", pod)
        if remaining_space_gib is not None:
            pulumi.set(__self__, "remaining_space_gib", remaining_space_gib)
        if requested_size_gib is not None:
            pulumi.set(__self__, "requested_size_gib", requested_size_gib)
        if snapshot_auto_delete_behavior is not None:
            pulumi.set(__self__, "snapshot_auto_delete_behavior", snapshot_auto_delete_behavior)
        if snapshot_enabled is not None:
            pulumi.set(__self__, "snapshot_enabled", snapshot_enabled)
        if snapshot_reservation_detail is not None:
            pulumi.set(__self__, "snapshot_reservation_detail", snapshot_reservation_detail)
        if snapshot_schedule_policy is not None:
            pulumi.set(__self__, "snapshot_schedule_policy", snapshot_schedule_policy)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter(name="autoGrownSizeGib")
    def auto_grown_size_gib(self) -> Optional[pulumi.Input[str]]:
        """
        The size, in GiB, that this storage volume has expanded as a result of an auto grow policy. In the absence of auto-grow, the value is 0.
        """
        return pulumi.get(self, "auto_grown_size_gib")

    @auto_grown_size_gib.setter
    def auto_grown_size_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_grown_size_gib", value)

    @property
    @pulumi.getter(name="currentSizeGib")
    def current_size_gib(self) -> Optional[pulumi.Input[str]]:
        """
        The current size of this storage volume, in GiB, including space reserved for snapshots. This size might be different than the requested size if the storage volume has been configured with auto grow or auto shrink.
        """
        return pulumi.get(self, "current_size_gib")

    @current_size_gib.setter
    def current_size_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_size_gib", value)

    @property
    @pulumi.getter(name="emergencySizeGib")
    def emergency_size_gib(self) -> Optional[pulumi.Input[str]]:
        """
        Additional emergency size that was requested for this Volume, in GiB. current_size_gib includes this value.
        """
        return pulumi.get(self, "emergency_size_gib")

    @emergency_size_gib.setter
    def emergency_size_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "emergency_size_gib", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the `Volume`, generated by the backend.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxSizeGib")
    def max_size_gib(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size volume can be expanded to in case of evergency, in GiB.
        """
        return pulumi.get(self, "max_size_gib")

    @max_size_gib.setter
    def max_size_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size_gib", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. User-specified notes for new Volume. Used to provision Volumes that require manual intervention.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)

    @property
    @pulumi.getter(name="originallyRequestedSizeGib")
    def originally_requested_size_gib(self) -> Optional[pulumi.Input[str]]:
        """
        Originally requested size, in GiB.
        """
        return pulumi.get(self, "originally_requested_size_gib")

    @originally_requested_size_gib.setter
    def originally_requested_size_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "originally_requested_size_gib", value)

    @property
    @pulumi.getter(name="performanceTier")
    def performance_tier(self) -> Optional[pulumi.Input['VolumePerformanceTier']]:
        """
        Immutable. Performance tier of the Volume. Default is SHARED.
        """
        return pulumi.get(self, "performance_tier")

    @performance_tier.setter
    def performance_tier(self, value: Optional[pulumi.Input['VolumePerformanceTier']]):
        pulumi.set(self, "performance_tier", value)

    @property
    @pulumi.getter
    def pod(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Pod name.
        """
        return pulumi.get(self, "pod")

    @pod.setter
    def pod(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod", value)

    @property
    @pulumi.getter(name="remainingSpaceGib")
    def remaining_space_gib(self) -> Optional[pulumi.Input[str]]:
        """
        The space remaining in the storage volume for new LUNs, in GiB, excluding space reserved for snapshots.
        """
        return pulumi.get(self, "remaining_space_gib")

    @remaining_space_gib.setter
    def remaining_space_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remaining_space_gib", value)

    @property
    @pulumi.getter(name="requestedSizeGib")
    def requested_size_gib(self) -> Optional[pulumi.Input[str]]:
        """
        The requested size of this storage volume, in GiB.
        """
        return pulumi.get(self, "requested_size_gib")

    @requested_size_gib.setter
    def requested_size_gib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requested_size_gib", value)

    @property
    @pulumi.getter(name="snapshotAutoDeleteBehavior")
    def snapshot_auto_delete_behavior(self) -> Optional[pulumi.Input['VolumeSnapshotAutoDeleteBehavior']]:
        """
        The behavior to use when snapshot reserved space is full.
        """
        return pulumi.get(self, "snapshot_auto_delete_behavior")

    @snapshot_auto_delete_behavior.setter
    def snapshot_auto_delete_behavior(self, value: Optional[pulumi.Input['VolumeSnapshotAutoDeleteBehavior']]):
        pulumi.set(self, "snapshot_auto_delete_behavior", value)

    @property
    @pulumi.getter(name="snapshotEnabled")
    def snapshot_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether snapshots are enabled.
        """
        return pulumi.get(self, "snapshot_enabled")

    @snapshot_enabled.setter
    def snapshot_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snapshot_enabled", value)

    @property
    @pulumi.getter(name="snapshotReservationDetail")
    def snapshot_reservation_detail(self) -> Optional[pulumi.Input['SnapshotReservationDetailArgs']]:
        """
        Details about snapshot space reservation and usage on the storage volume.
        """
        return pulumi.get(self, "snapshot_reservation_detail")

    @snapshot_reservation_detail.setter
    def snapshot_reservation_detail(self, value: Optional[pulumi.Input['SnapshotReservationDetailArgs']]):
        pulumi.set(self, "snapshot_reservation_detail", value)

    @property
    @pulumi.getter(name="snapshotSchedulePolicy")
    def snapshot_schedule_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the snapshot schedule policy in use for this volume, if any.
        """
        return pulumi.get(self, "snapshot_schedule_policy")

    @snapshot_schedule_policy.setter
    def snapshot_schedule_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_schedule_policy", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['VolumeState']]:
        """
        The state of this storage volume.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['VolumeState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input['VolumeStorageType']]:
        """
        The storage type for this volume.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input['VolumeStorageType']]):
        pulumi.set(self, "storage_type", value)


