# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiConfigHandlerResponse',
    'ApiEndpointHandlerResponse',
    'AutomaticScalingResponse',
    'BasicScalingResponse',
    'CertificateRawDataResponse',
    'CloudBuildOptionsResponse',
    'ContainerInfoResponse',
    'CpuUtilizationResponse',
    'DeploymentResponse',
    'DiskUtilizationResponse',
    'EndpointsApiServiceResponse',
    'EntrypointResponse',
    'ErrorHandlerResponse',
    'FeatureSettingsResponse',
    'HealthCheckResponse',
    'IdentityAwareProxyResponse',
    'LibraryResponse',
    'LivenessCheckResponse',
    'ManagedCertificateResponse',
    'ManualScalingResponse',
    'NetworkResponse',
    'NetworkUtilizationResponse',
    'ReadinessCheckResponse',
    'RequestUtilizationResponse',
    'ResourceRecordResponse',
    'ResourcesResponse',
    'ScriptHandlerResponse',
    'SslSettingsResponse',
    'StandardSchedulerSettingsResponse',
    'StaticFilesHandlerResponse',
    'UrlDispatchRuleResponse',
    'UrlMapResponse',
    'VolumeResponse',
    'VpcAccessConnectorResponse',
    'ZipInfoResponse',
]

@pulumi.output_type
class ApiConfigHandlerResponse(dict):
    """
    Google Cloud Endpoints (https://cloud.google.com/endpoints) configuration for API handlers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authFailAction":
            suggest = "auth_fail_action"
        elif key == "securityLevel":
            suggest = "security_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiConfigHandlerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiConfigHandlerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiConfigHandlerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_fail_action: str,
                 login: str,
                 script: str,
                 security_level: str,
                 url: str):
        """
        Google Cloud Endpoints (https://cloud.google.com/endpoints) configuration for API handlers.
        :param str auth_fail_action: Action to take when users access resources that require authentication. Defaults to redirect.
        :param str login: Level of login required to access this resource. Defaults to optional.
        :param str script: Path to the script from the application root directory.
        :param str security_level: Security (HTTPS) enforcement for this URL.
        :param str url: URL to serve the endpoint at.
        """
        pulumi.set(__self__, "auth_fail_action", auth_fail_action)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "security_level", security_level)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="authFailAction")
    def auth_fail_action(self) -> str:
        """
        Action to take when users access resources that require authentication. Defaults to redirect.
        """
        return pulumi.get(self, "auth_fail_action")

    @property
    @pulumi.getter
    def login(self) -> str:
        """
        Level of login required to access this resource. Defaults to optional.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> str:
        """
        Security (HTTPS) enforcement for this URL.
        """
        return pulumi.get(self, "security_level")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL to serve the endpoint at.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ApiEndpointHandlerResponse(dict):
    """
    Uses Google Cloud Endpoints to handle requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEndpointHandlerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEndpointHandlerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEndpointHandlerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script_path: str):
        """
        Uses Google Cloud Endpoints to handle requests.
        :param str script_path: Path to the script from the application root directory.
        """
        pulumi.set(__self__, "script_path", script_path)

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> str:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class AutomaticScalingResponse(dict):
    """
    Automatic scaling is based on request rate, response latencies, and other application metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coolDownPeriod":
            suggest = "cool_down_period"
        elif key == "cpuUtilization":
            suggest = "cpu_utilization"
        elif key == "diskUtilization":
            suggest = "disk_utilization"
        elif key == "maxConcurrentRequests":
            suggest = "max_concurrent_requests"
        elif key == "maxIdleInstances":
            suggest = "max_idle_instances"
        elif key == "maxPendingLatency":
            suggest = "max_pending_latency"
        elif key == "maxTotalInstances":
            suggest = "max_total_instances"
        elif key == "minIdleInstances":
            suggest = "min_idle_instances"
        elif key == "minPendingLatency":
            suggest = "min_pending_latency"
        elif key == "minTotalInstances":
            suggest = "min_total_instances"
        elif key == "networkUtilization":
            suggest = "network_utilization"
        elif key == "requestUtilization":
            suggest = "request_utilization"
        elif key == "standardSchedulerSettings":
            suggest = "standard_scheduler_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomaticScalingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomaticScalingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomaticScalingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cool_down_period: str,
                 cpu_utilization: 'outputs.CpuUtilizationResponse',
                 disk_utilization: 'outputs.DiskUtilizationResponse',
                 max_concurrent_requests: int,
                 max_idle_instances: int,
                 max_pending_latency: str,
                 max_total_instances: int,
                 min_idle_instances: int,
                 min_pending_latency: str,
                 min_total_instances: int,
                 network_utilization: 'outputs.NetworkUtilizationResponse',
                 request_utilization: 'outputs.RequestUtilizationResponse',
                 standard_scheduler_settings: 'outputs.StandardSchedulerSettingsResponse'):
        """
        Automatic scaling is based on request rate, response latencies, and other application metrics.
        :param str cool_down_period: The time period that the Autoscaler (https://cloud.google.com/compute/docs/autoscaler/) should wait before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. Only applicable in the App Engine flexible environment.
        :param 'CpuUtilizationResponse' cpu_utilization: Target scaling by CPU usage.
        :param 'DiskUtilizationResponse' disk_utilization: Target scaling by disk usage.
        :param int max_concurrent_requests: Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.Defaults to a runtime-specific value.
        :param int max_idle_instances: Maximum number of idle instances that should be maintained for this version.
        :param str max_pending_latency: Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
        :param int max_total_instances: Maximum number of instances that should be started to handle requests for this version.
        :param int min_idle_instances: Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        :param str min_pending_latency: Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
        :param int min_total_instances: Minimum number of running instances that should be maintained for this version.
        :param 'NetworkUtilizationResponse' network_utilization: Target scaling by network usage.
        :param 'RequestUtilizationResponse' request_utilization: Target scaling by request utilization.
        :param 'StandardSchedulerSettingsResponse' standard_scheduler_settings: Scheduler settings for standard environment.
        """
        pulumi.set(__self__, "cool_down_period", cool_down_period)
        pulumi.set(__self__, "cpu_utilization", cpu_utilization)
        pulumi.set(__self__, "disk_utilization", disk_utilization)
        pulumi.set(__self__, "max_concurrent_requests", max_concurrent_requests)
        pulumi.set(__self__, "max_idle_instances", max_idle_instances)
        pulumi.set(__self__, "max_pending_latency", max_pending_latency)
        pulumi.set(__self__, "max_total_instances", max_total_instances)
        pulumi.set(__self__, "min_idle_instances", min_idle_instances)
        pulumi.set(__self__, "min_pending_latency", min_pending_latency)
        pulumi.set(__self__, "min_total_instances", min_total_instances)
        pulumi.set(__self__, "network_utilization", network_utilization)
        pulumi.set(__self__, "request_utilization", request_utilization)
        pulumi.set(__self__, "standard_scheduler_settings", standard_scheduler_settings)

    @property
    @pulumi.getter(name="coolDownPeriod")
    def cool_down_period(self) -> str:
        """
        The time period that the Autoscaler (https://cloud.google.com/compute/docs/autoscaler/) should wait before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "cool_down_period")

    @property
    @pulumi.getter(name="cpuUtilization")
    def cpu_utilization(self) -> 'outputs.CpuUtilizationResponse':
        """
        Target scaling by CPU usage.
        """
        return pulumi.get(self, "cpu_utilization")

    @property
    @pulumi.getter(name="diskUtilization")
    def disk_utilization(self) -> 'outputs.DiskUtilizationResponse':
        """
        Target scaling by disk usage.
        """
        return pulumi.get(self, "disk_utilization")

    @property
    @pulumi.getter(name="maxConcurrentRequests")
    def max_concurrent_requests(self) -> int:
        """
        Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.Defaults to a runtime-specific value.
        """
        return pulumi.get(self, "max_concurrent_requests")

    @property
    @pulumi.getter(name="maxIdleInstances")
    def max_idle_instances(self) -> int:
        """
        Maximum number of idle instances that should be maintained for this version.
        """
        return pulumi.get(self, "max_idle_instances")

    @property
    @pulumi.getter(name="maxPendingLatency")
    def max_pending_latency(self) -> str:
        """
        Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
        """
        return pulumi.get(self, "max_pending_latency")

    @property
    @pulumi.getter(name="maxTotalInstances")
    def max_total_instances(self) -> int:
        """
        Maximum number of instances that should be started to handle requests for this version.
        """
        return pulumi.get(self, "max_total_instances")

    @property
    @pulumi.getter(name="minIdleInstances")
    def min_idle_instances(self) -> int:
        """
        Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        """
        return pulumi.get(self, "min_idle_instances")

    @property
    @pulumi.getter(name="minPendingLatency")
    def min_pending_latency(self) -> str:
        """
        Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
        """
        return pulumi.get(self, "min_pending_latency")

    @property
    @pulumi.getter(name="minTotalInstances")
    def min_total_instances(self) -> int:
        """
        Minimum number of running instances that should be maintained for this version.
        """
        return pulumi.get(self, "min_total_instances")

    @property
    @pulumi.getter(name="networkUtilization")
    def network_utilization(self) -> 'outputs.NetworkUtilizationResponse':
        """
        Target scaling by network usage.
        """
        return pulumi.get(self, "network_utilization")

    @property
    @pulumi.getter(name="requestUtilization")
    def request_utilization(self) -> 'outputs.RequestUtilizationResponse':
        """
        Target scaling by request utilization.
        """
        return pulumi.get(self, "request_utilization")

    @property
    @pulumi.getter(name="standardSchedulerSettings")
    def standard_scheduler_settings(self) -> 'outputs.StandardSchedulerSettingsResponse':
        """
        Scheduler settings for standard environment.
        """
        return pulumi.get(self, "standard_scheduler_settings")


@pulumi.output_type
class BasicScalingResponse(dict):
    """
    A service with basic scaling will create an instance when the application receives a request. The instance will be turned down when the app becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeout":
            suggest = "idle_timeout"
        elif key == "maxInstances":
            suggest = "max_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasicScalingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasicScalingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasicScalingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_timeout: str,
                 max_instances: int):
        """
        A service with basic scaling will create an instance when the application receives a request. The instance will be turned down when the app becomes idle. Basic scaling is ideal for work that is intermittent or driven by user activity.
        :param str idle_timeout: Duration of time after the last request that an instance must wait before the instance is shut down.
        :param int max_instances: Maximum number of instances to create for this version.
        """
        pulumi.set(__self__, "idle_timeout", idle_timeout)
        pulumi.set(__self__, "max_instances", max_instances)

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> str:
        """
        Duration of time after the last request that an instance must wait before the instance is shut down.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> int:
        """
        Maximum number of instances to create for this version.
        """
        return pulumi.get(self, "max_instances")


@pulumi.output_type
class CertificateRawDataResponse(dict):
    """
    An SSL certificate obtained from a certificate authority.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "publicCertificate":
            suggest = "public_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateRawDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateRawDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateRawDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_key: str,
                 public_certificate: str):
        """
        An SSL certificate obtained from a certificate authority.
        :param str private_key: Unencrypted PEM encoded RSA private key. This field is set once on certificate creation and then encrypted. The key size must be 2048 bits or fewer. Must include the header and footer. Example: -----BEGIN RSA PRIVATE KEY----- -----END RSA PRIVATE KEY----- @InputOnly
        :param str public_certificate: PEM encoded x.509 public key certificate. This field is set once on certificate creation. Must include the header and footer. Example: -----BEGIN CERTIFICATE----- -----END CERTIFICATE----- 
        """
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "public_certificate", public_certificate)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        Unencrypted PEM encoded RSA private key. This field is set once on certificate creation and then encrypted. The key size must be 2048 bits or fewer. Must include the header and footer. Example: -----BEGIN RSA PRIVATE KEY----- -----END RSA PRIVATE KEY----- @InputOnly
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> str:
        """
        PEM encoded x.509 public key certificate. This field is set once on certificate creation. Must include the header and footer. Example: -----BEGIN CERTIFICATE----- -----END CERTIFICATE----- 
        """
        return pulumi.get(self, "public_certificate")


@pulumi.output_type
class CloudBuildOptionsResponse(dict):
    """
    Options for the build operations performed as a part of the version deployment. Only applicable for App Engine flexible environment when creating a version using source code directly.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appYamlPath":
            suggest = "app_yaml_path"
        elif key == "cloudBuildTimeout":
            suggest = "cloud_build_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudBuildOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudBuildOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudBuildOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_yaml_path: str,
                 cloud_build_timeout: str):
        """
        Options for the build operations performed as a part of the version deployment. Only applicable for App Engine flexible environment when creating a version using source code directly.
        :param str app_yaml_path: Path to the yaml file used in deployment, used to determine runtime configuration details.Required for flexible environment builds.See https://cloud.google.com/appengine/docs/standard/python/config/appref for more details.
        :param str cloud_build_timeout: The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
        """
        pulumi.set(__self__, "app_yaml_path", app_yaml_path)
        pulumi.set(__self__, "cloud_build_timeout", cloud_build_timeout)

    @property
    @pulumi.getter(name="appYamlPath")
    def app_yaml_path(self) -> str:
        """
        Path to the yaml file used in deployment, used to determine runtime configuration details.Required for flexible environment builds.See https://cloud.google.com/appengine/docs/standard/python/config/appref for more details.
        """
        return pulumi.get(self, "app_yaml_path")

    @property
    @pulumi.getter(name="cloudBuildTimeout")
    def cloud_build_timeout(self) -> str:
        """
        The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
        """
        return pulumi.get(self, "cloud_build_timeout")


@pulumi.output_type
class ContainerInfoResponse(dict):
    """
    Docker image that is used to create a container and start a VM instance for the version that you deploy. Only applicable for instances running in the App Engine flexible environment.
    """
    def __init__(__self__, *,
                 image: str):
        """
        Docker image that is used to create a container and start a VM instance for the version that you deploy. Only applicable for instances running in the App Engine flexible environment.
        :param str image: URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest. Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        """
        pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest. Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class CpuUtilizationResponse(dict):
    """
    Target scaling by CPU usage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregationWindowLength":
            suggest = "aggregation_window_length"
        elif key == "targetUtilization":
            suggest = "target_utilization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CpuUtilizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CpuUtilizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CpuUtilizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregation_window_length: str,
                 target_utilization: float):
        """
        Target scaling by CPU usage.
        :param str aggregation_window_length: Period of time over which CPU utilization is calculated.
        :param float target_utilization: Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
        """
        pulumi.set(__self__, "aggregation_window_length", aggregation_window_length)
        pulumi.set(__self__, "target_utilization", target_utilization)

    @property
    @pulumi.getter(name="aggregationWindowLength")
    def aggregation_window_length(self) -> str:
        """
        Period of time over which CPU utilization is calculated.
        """
        return pulumi.get(self, "aggregation_window_length")

    @property
    @pulumi.getter(name="targetUtilization")
    def target_utilization(self) -> float:
        """
        Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
        """
        return pulumi.get(self, "target_utilization")


@pulumi.output_type
class DeploymentResponse(dict):
    """
    Code and application artifacts used to deploy a version to App Engine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudBuildOptions":
            suggest = "cloud_build_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_build_options: 'outputs.CloudBuildOptionsResponse',
                 container: 'outputs.ContainerInfoResponse',
                 files: Mapping[str, str],
                 zip: 'outputs.ZipInfoResponse'):
        """
        Code and application artifacts used to deploy a version to App Engine.
        :param 'CloudBuildOptionsResponse' cloud_build_options: Options for any Google Cloud Build builds created as a part of this deployment.These options will only be used if a new build is created, such as when deploying to the App Engine flexible environment using files or zip.
        :param 'ContainerInfoResponse' container: The Docker image for the container that runs the version. Only applicable for instances running in the App Engine flexible environment.
        :param Mapping[str, str] files: Manifest of the files stored in Google Cloud Storage that are included as part of this version. All files must be readable using the credentials supplied with this call.
        :param 'ZipInfoResponse' zip: The zip file for this deployment, if this is a zip deployment.
        """
        pulumi.set(__self__, "cloud_build_options", cloud_build_options)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "files", files)
        pulumi.set(__self__, "zip", zip)

    @property
    @pulumi.getter(name="cloudBuildOptions")
    def cloud_build_options(self) -> 'outputs.CloudBuildOptionsResponse':
        """
        Options for any Google Cloud Build builds created as a part of this deployment.These options will only be used if a new build is created, such as when deploying to the App Engine flexible environment using files or zip.
        """
        return pulumi.get(self, "cloud_build_options")

    @property
    @pulumi.getter
    def container(self) -> 'outputs.ContainerInfoResponse':
        """
        The Docker image for the container that runs the version. Only applicable for instances running in the App Engine flexible environment.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def files(self) -> Mapping[str, str]:
        """
        Manifest of the files stored in Google Cloud Storage that are included as part of this version. All files must be readable using the credentials supplied with this call.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter
    def zip(self) -> 'outputs.ZipInfoResponse':
        """
        The zip file for this deployment, if this is a zip deployment.
        """
        return pulumi.get(self, "zip")


@pulumi.output_type
class DiskUtilizationResponse(dict):
    """
    Target scaling by disk usage. Only applicable in the App Engine flexible environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetReadBytesPerSecond":
            suggest = "target_read_bytes_per_second"
        elif key == "targetReadOpsPerSecond":
            suggest = "target_read_ops_per_second"
        elif key == "targetWriteBytesPerSecond":
            suggest = "target_write_bytes_per_second"
        elif key == "targetWriteOpsPerSecond":
            suggest = "target_write_ops_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskUtilizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskUtilizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskUtilizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_read_bytes_per_second: int,
                 target_read_ops_per_second: int,
                 target_write_bytes_per_second: int,
                 target_write_ops_per_second: int):
        """
        Target scaling by disk usage. Only applicable in the App Engine flexible environment.
        :param int target_read_bytes_per_second: Target bytes read per second.
        :param int target_read_ops_per_second: Target ops read per seconds.
        :param int target_write_bytes_per_second: Target bytes written per second.
        :param int target_write_ops_per_second: Target ops written per second.
        """
        pulumi.set(__self__, "target_read_bytes_per_second", target_read_bytes_per_second)
        pulumi.set(__self__, "target_read_ops_per_second", target_read_ops_per_second)
        pulumi.set(__self__, "target_write_bytes_per_second", target_write_bytes_per_second)
        pulumi.set(__self__, "target_write_ops_per_second", target_write_ops_per_second)

    @property
    @pulumi.getter(name="targetReadBytesPerSecond")
    def target_read_bytes_per_second(self) -> int:
        """
        Target bytes read per second.
        """
        return pulumi.get(self, "target_read_bytes_per_second")

    @property
    @pulumi.getter(name="targetReadOpsPerSecond")
    def target_read_ops_per_second(self) -> int:
        """
        Target ops read per seconds.
        """
        return pulumi.get(self, "target_read_ops_per_second")

    @property
    @pulumi.getter(name="targetWriteBytesPerSecond")
    def target_write_bytes_per_second(self) -> int:
        """
        Target bytes written per second.
        """
        return pulumi.get(self, "target_write_bytes_per_second")

    @property
    @pulumi.getter(name="targetWriteOpsPerSecond")
    def target_write_ops_per_second(self) -> int:
        """
        Target ops written per second.
        """
        return pulumi.get(self, "target_write_ops_per_second")


@pulumi.output_type
class EndpointsApiServiceResponse(dict):
    """
    Google Cloud Endpoints (https://cloud.google.com/endpoints) configuration. The Endpoints API Service provides tooling for serving Open API and gRPC endpoints via an NGINX proxy. Only valid for App Engine Flexible environment deployments.The fields here refer to the name and configuration ID of a "service" resource in the Service Management API (https://cloud.google.com/service-management/overview).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configId":
            suggest = "config_id"
        elif key == "disableTraceSampling":
            suggest = "disable_trace_sampling"
        elif key == "rolloutStrategy":
            suggest = "rollout_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointsApiServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointsApiServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointsApiServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_id: str,
                 disable_trace_sampling: bool,
                 name: str,
                 rollout_strategy: str):
        """
        Google Cloud Endpoints (https://cloud.google.com/endpoints) configuration. The Endpoints API Service provides tooling for serving Open API and gRPC endpoints via an NGINX proxy. Only valid for App Engine Flexible environment deployments.The fields here refer to the name and configuration ID of a "service" resource in the Service Management API (https://cloud.google.com/service-management/overview).
        :param str config_id: Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".By default, the rollout strategy for Endpoints is RolloutStrategy.FIXED. This means that Endpoints starts up with a particular configuration ID. When a new configuration is rolled out, Endpoints must be given the new configuration ID. The config_id field is used to give the configuration ID and is required in this case.Endpoints also has a rollout strategy called RolloutStrategy.MANAGED. When using this, Endpoints fetches the latest configuration and does not need the configuration ID. In this case, config_id must be omitted.
        :param bool disable_trace_sampling: Enable or disable trace sampling. By default, this is set to false for enabled.
        :param str name: Endpoints service name which is the name of the "service" resource in the Service Management API. For example "myapi.endpoints.myproject.cloud.goog"
        :param str rollout_strategy: Endpoints rollout strategy. If FIXED, config_id must be specified. If MANAGED, config_id must be omitted.
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "disable_trace_sampling", disable_trace_sampling)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rollout_strategy", rollout_strategy)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> str:
        """
        Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".By default, the rollout strategy for Endpoints is RolloutStrategy.FIXED. This means that Endpoints starts up with a particular configuration ID. When a new configuration is rolled out, Endpoints must be given the new configuration ID. The config_id field is used to give the configuration ID and is required in this case.Endpoints also has a rollout strategy called RolloutStrategy.MANAGED. When using this, Endpoints fetches the latest configuration and does not need the configuration ID. In this case, config_id must be omitted.
        """
        return pulumi.get(self, "config_id")

    @property
    @pulumi.getter(name="disableTraceSampling")
    def disable_trace_sampling(self) -> bool:
        """
        Enable or disable trace sampling. By default, this is set to false for enabled.
        """
        return pulumi.get(self, "disable_trace_sampling")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Endpoints service name which is the name of the "service" resource in the Service Management API. For example "myapi.endpoints.myproject.cloud.goog"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="rolloutStrategy")
    def rollout_strategy(self) -> str:
        """
        Endpoints rollout strategy. If FIXED, config_id must be specified. If MANAGED, config_id must be omitted.
        """
        return pulumi.get(self, "rollout_strategy")


@pulumi.output_type
class EntrypointResponse(dict):
    """
    The entrypoint for the application.
    """
    def __init__(__self__, *,
                 shell: str):
        """
        The entrypoint for the application.
        :param str shell: The format should be a shell command that can be fed to bash -c.
        """
        pulumi.set(__self__, "shell", shell)

    @property
    @pulumi.getter
    def shell(self) -> str:
        """
        The format should be a shell command that can be fed to bash -c.
        """
        return pulumi.get(self, "shell")


@pulumi.output_type
class ErrorHandlerResponse(dict):
    """
    Custom static error page to be served when an error occurs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "mimeType":
            suggest = "mime_type"
        elif key == "staticFile":
            suggest = "static_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorHandlerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorHandlerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorHandlerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: str,
                 mime_type: str,
                 static_file: str):
        """
        Custom static error page to be served when an error occurs.
        :param str error_code: Error condition this handler applies to.
        :param str mime_type: MIME type of file. Defaults to text/html.
        :param str static_file: Static file content to be served for this error.
        """
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "static_file", static_file)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        Error condition this handler applies to.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        MIME type of file. Defaults to text/html.
        """
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter(name="staticFile")
    def static_file(self) -> str:
        """
        Static file content to be served for this error.
        """
        return pulumi.get(self, "static_file")


@pulumi.output_type
class FeatureSettingsResponse(dict):
    """
    The feature specific settings to be used in the application. These define behaviors that are user configurable.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "splitHealthChecks":
            suggest = "split_health_checks"
        elif key == "useContainerOptimizedOs":
            suggest = "use_container_optimized_os"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 split_health_checks: bool,
                 use_container_optimized_os: bool):
        """
        The feature specific settings to be used in the application. These define behaviors that are user configurable.
        :param bool split_health_checks: Boolean value indicating if split health checks should be used instead of the legacy health checks. At an app.yaml level, this means defaulting to 'readiness_check' and 'liveness_check' values instead of 'health_check' ones. Once the legacy 'health_check' behavior is deprecated, and this value is always true, this setting can be removed.
        :param bool use_container_optimized_os: If true, use Container-Optimized OS (https://cloud.google.com/container-optimized-os/) base image for VMs, rather than a base Debian image.
        """
        pulumi.set(__self__, "split_health_checks", split_health_checks)
        pulumi.set(__self__, "use_container_optimized_os", use_container_optimized_os)

    @property
    @pulumi.getter(name="splitHealthChecks")
    def split_health_checks(self) -> bool:
        """
        Boolean value indicating if split health checks should be used instead of the legacy health checks. At an app.yaml level, this means defaulting to 'readiness_check' and 'liveness_check' values instead of 'health_check' ones. Once the legacy 'health_check' behavior is deprecated, and this value is always true, this setting can be removed.
        """
        return pulumi.get(self, "split_health_checks")

    @property
    @pulumi.getter(name="useContainerOptimizedOs")
    def use_container_optimized_os(self) -> bool:
        """
        If true, use Container-Optimized OS (https://cloud.google.com/container-optimized-os/) base image for VMs, rather than a base Debian image.
        """
        return pulumi.get(self, "use_container_optimized_os")


@pulumi.output_type
class HealthCheckResponse(dict):
    """
    Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances. Only applicable for instances in App Engine flexible environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "disableHealthCheck":
            suggest = "disable_health_check"
        elif key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "restartThreshold":
            suggest = "restart_threshold"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_interval: str,
                 disable_health_check: bool,
                 healthy_threshold: int,
                 host: str,
                 restart_threshold: int,
                 timeout: str,
                 unhealthy_threshold: int):
        """
        Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances. Only applicable for instances in App Engine flexible environment.
        :param str check_interval: Interval between health checks.
        :param bool disable_health_check: Whether to explicitly disable health checks for this instance.
        :param int healthy_threshold: Number of consecutive successful health checks required before receiving traffic.
        :param str host: Host header to send when performing an HTTP health check. Example: "myapp.appspot.com"
        :param int restart_threshold: Number of consecutive failed health checks required before an instance is restarted.
        :param str timeout: Time before the health check is considered failed.
        :param int unhealthy_threshold: Number of consecutive failed health checks required before removing traffic.
        """
        pulumi.set(__self__, "check_interval", check_interval)
        pulumi.set(__self__, "disable_health_check", disable_health_check)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "restart_threshold", restart_threshold)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> str:
        """
        Interval between health checks.
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="disableHealthCheck")
    def disable_health_check(self) -> bool:
        """
        Whether to explicitly disable health checks for this instance.
        """
        return pulumi.get(self, "disable_health_check")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> int:
        """
        Number of consecutive successful health checks required before receiving traffic.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host header to send when performing an HTTP health check. Example: "myapp.appspot.com"
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="restartThreshold")
    def restart_threshold(self) -> int:
        """
        Number of consecutive failed health checks required before an instance is restarted.
        """
        return pulumi.get(self, "restart_threshold")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Time before the health check is considered failed.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> int:
        """
        Number of consecutive failed health checks required before removing traffic.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class IdentityAwareProxyResponse(dict):
    """
    Identity-Aware Proxy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oauth2ClientId":
            suggest = "oauth2_client_id"
        elif key == "oauth2ClientSecret":
            suggest = "oauth2_client_secret"
        elif key == "oauth2ClientSecretSha256":
            suggest = "oauth2_client_secret_sha256"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityAwareProxyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityAwareProxyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityAwareProxyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 oauth2_client_id: str,
                 oauth2_client_secret: str,
                 oauth2_client_secret_sha256: str):
        """
        Identity-Aware Proxy
        :param bool enabled: Whether the serving infrastructure will authenticate and authorize all incoming requests.If true, the oauth2_client_id and oauth2_client_secret fields must be non-empty.
        :param str oauth2_client_id: OAuth2 client ID to use for the authentication flow.
        :param str oauth2_client_secret: OAuth2 client secret to use for the authentication flow.For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2_client_secret_sha256 field.@InputOnly
        :param str oauth2_client_secret_sha256: Hex-encoded SHA-256 hash of the client secret.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "oauth2_client_id", oauth2_client_id)
        pulumi.set(__self__, "oauth2_client_secret", oauth2_client_secret)
        pulumi.set(__self__, "oauth2_client_secret_sha256", oauth2_client_secret_sha256)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the serving infrastructure will authenticate and authorize all incoming requests.If true, the oauth2_client_id and oauth2_client_secret fields must be non-empty.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> str:
        """
        OAuth2 client ID to use for the authentication flow.
        """
        return pulumi.get(self, "oauth2_client_id")

    @property
    @pulumi.getter(name="oauth2ClientSecret")
    def oauth2_client_secret(self) -> str:
        """
        OAuth2 client secret to use for the authentication flow.For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2_client_secret_sha256 field.@InputOnly
        """
        return pulumi.get(self, "oauth2_client_secret")

    @property
    @pulumi.getter(name="oauth2ClientSecretSha256")
    def oauth2_client_secret_sha256(self) -> str:
        """
        Hex-encoded SHA-256 hash of the client secret.
        """
        return pulumi.get(self, "oauth2_client_secret_sha256")


@pulumi.output_type
class LibraryResponse(dict):
    """
    Third-party Python runtime library that is required by the application.
    """
    def __init__(__self__, *,
                 name: str,
                 version: str):
        """
        Third-party Python runtime library that is required by the application.
        :param str name: Name of the library. Example: "django".
        :param str version: Version of the library to select, or "latest".
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the library. Example: "django".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the library to select, or "latest".
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LivenessCheckResponse(dict):
    """
    Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "successThreshold":
            suggest = "success_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LivenessCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LivenessCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LivenessCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 check_interval: str,
                 failure_threshold: int,
                 host: str,
                 initial_delay: str,
                 path: str,
                 success_threshold: int,
                 timeout: str):
        """
        Health checking configuration for VM instances. Unhealthy instances are killed and replaced with new instances.
        :param str check_interval: Interval between health checks.
        :param int failure_threshold: Number of consecutive failed checks required before considering the VM unhealthy.
        :param str host: Host header to send when performing a HTTP Liveness check. Example: "myapp.appspot.com"
        :param str initial_delay: The initial delay before starting to execute the checks.
        :param str path: The request path.
        :param int success_threshold: Number of consecutive successful checks required before considering the VM healthy.
        :param str timeout: Time before the check is considered failed.
        """
        pulumi.set(__self__, "check_interval", check_interval)
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "initial_delay", initial_delay)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "success_threshold", success_threshold)
        pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> str:
        """
        Interval between health checks.
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> int:
        """
        Number of consecutive failed checks required before considering the VM unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host header to send when performing a HTTP Liveness check. Example: "myapp.appspot.com"
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> str:
        """
        The initial delay before starting to execute the checks.
        """
        return pulumi.get(self, "initial_delay")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The request path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> int:
        """
        Number of consecutive successful checks required before considering the VM healthy.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Time before the check is considered failed.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ManagedCertificateResponse(dict):
    """
    A certificate managed by App Engine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastRenewalTime":
            suggest = "last_renewal_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_renewal_time: str,
                 status: str):
        """
        A certificate managed by App Engine.
        :param str last_renewal_time: Time at which the certificate was last renewed. The renewal process is fully managed. Certificate renewal will automatically occur before the certificate expires. Renewal errors can be tracked via ManagementStatus.
        :param str status: Status of certificate management. Refers to the most recent certificate acquisition or renewal attempt.
        """
        pulumi.set(__self__, "last_renewal_time", last_renewal_time)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="lastRenewalTime")
    def last_renewal_time(self) -> str:
        """
        Time at which the certificate was last renewed. The renewal process is fully managed. Certificate renewal will automatically occur before the certificate expires. Renewal errors can be tracked via ManagementStatus.
        """
        return pulumi.get(self, "last_renewal_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of certificate management. Refers to the most recent certificate acquisition or renewal attempt.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ManualScalingResponse(dict):
    """
    A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
    """
    def __init__(__self__, *,
                 instances: int):
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        :param int instances: Number of instances to assign to the service at the start. This number can later be altered by using the Modules API (https://cloud.google.com/appengine/docs/python/modules/functions) set_num_instances() function.
        """
        pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> int:
        """
        Number of instances to assign to the service at the start. This number can later be altered by using the Modules API (https://cloud.google.com/appengine/docs/python/modules/functions) set_num_instances() function.
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class NetworkResponse(dict):
    """
    Extra network settings. Only applicable in the App Engine flexible environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardedPorts":
            suggest = "forwarded_ports"
        elif key == "instanceIpMode":
            suggest = "instance_ip_mode"
        elif key == "instanceTag":
            suggest = "instance_tag"
        elif key == "sessionAffinity":
            suggest = "session_affinity"
        elif key == "subnetworkName":
            suggest = "subnetwork_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 forwarded_ports: Sequence[str],
                 instance_ip_mode: str,
                 instance_tag: str,
                 name: str,
                 session_affinity: bool,
                 subnetwork_name: str):
        """
        Extra network settings. Only applicable in the App Engine flexible environment.
        :param Sequence[str] forwarded_ports: List of ports, or port pairs, to forward from the virtual machine to the application container. Only applicable in the App Engine flexible environment.
        :param str instance_ip_mode: The IP mode for instances. Only applicable in the App Engine flexible environment.
        :param str instance_tag: Tag to apply to the instance during creation. Only applicable in the App Engine flexible environment.
        :param str name: Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.Defaults to default.
        :param bool session_affinity: Enable session affinity. Only applicable in the App Engine flexible environment.
        :param str subnetwork_name: Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.If a subnetwork name is specified, a network name will also be required unless it is for the default network. If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range. If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetwork_name) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network. If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetwork_name must be specified and the IP address is created from the IPCidrRange of the subnetwork.If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
        """
        pulumi.set(__self__, "forwarded_ports", forwarded_ports)
        pulumi.set(__self__, "instance_ip_mode", instance_ip_mode)
        pulumi.set(__self__, "instance_tag", instance_tag)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "session_affinity", session_affinity)
        pulumi.set(__self__, "subnetwork_name", subnetwork_name)

    @property
    @pulumi.getter(name="forwardedPorts")
    def forwarded_ports(self) -> Sequence[str]:
        """
        List of ports, or port pairs, to forward from the virtual machine to the application container. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "forwarded_ports")

    @property
    @pulumi.getter(name="instanceIpMode")
    def instance_ip_mode(self) -> str:
        """
        The IP mode for instances. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "instance_ip_mode")

    @property
    @pulumi.getter(name="instanceTag")
    def instance_tag(self) -> str:
        """
        Tag to apply to the instance during creation. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "instance_tag")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.Defaults to default.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> bool:
        """
        Enable session affinity. Only applicable in the App Engine flexible environment.
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter(name="subnetworkName")
    def subnetwork_name(self) -> str:
        """
        Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.If a subnetwork name is specified, a network name will also be required unless it is for the default network. If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range. If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetwork_name) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network. If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetwork_name must be specified and the IP address is created from the IPCidrRange of the subnetwork.If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
        """
        return pulumi.get(self, "subnetwork_name")


@pulumi.output_type
class NetworkUtilizationResponse(dict):
    """
    Target scaling by network usage. Only applicable in the App Engine flexible environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetReceivedBytesPerSecond":
            suggest = "target_received_bytes_per_second"
        elif key == "targetReceivedPacketsPerSecond":
            suggest = "target_received_packets_per_second"
        elif key == "targetSentBytesPerSecond":
            suggest = "target_sent_bytes_per_second"
        elif key == "targetSentPacketsPerSecond":
            suggest = "target_sent_packets_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkUtilizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkUtilizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkUtilizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_received_bytes_per_second: int,
                 target_received_packets_per_second: int,
                 target_sent_bytes_per_second: int,
                 target_sent_packets_per_second: int):
        """
        Target scaling by network usage. Only applicable in the App Engine flexible environment.
        :param int target_received_bytes_per_second: Target bytes received per second.
        :param int target_received_packets_per_second: Target packets received per second.
        :param int target_sent_bytes_per_second: Target bytes sent per second.
        :param int target_sent_packets_per_second: Target packets sent per second.
        """
        pulumi.set(__self__, "target_received_bytes_per_second", target_received_bytes_per_second)
        pulumi.set(__self__, "target_received_packets_per_second", target_received_packets_per_second)
        pulumi.set(__self__, "target_sent_bytes_per_second", target_sent_bytes_per_second)
        pulumi.set(__self__, "target_sent_packets_per_second", target_sent_packets_per_second)

    @property
    @pulumi.getter(name="targetReceivedBytesPerSecond")
    def target_received_bytes_per_second(self) -> int:
        """
        Target bytes received per second.
        """
        return pulumi.get(self, "target_received_bytes_per_second")

    @property
    @pulumi.getter(name="targetReceivedPacketsPerSecond")
    def target_received_packets_per_second(self) -> int:
        """
        Target packets received per second.
        """
        return pulumi.get(self, "target_received_packets_per_second")

    @property
    @pulumi.getter(name="targetSentBytesPerSecond")
    def target_sent_bytes_per_second(self) -> int:
        """
        Target bytes sent per second.
        """
        return pulumi.get(self, "target_sent_bytes_per_second")

    @property
    @pulumi.getter(name="targetSentPacketsPerSecond")
    def target_sent_packets_per_second(self) -> int:
        """
        Target packets sent per second.
        """
        return pulumi.get(self, "target_sent_packets_per_second")


@pulumi.output_type
class ReadinessCheckResponse(dict):
    """
    Readiness checking configuration for VM instances. Unhealthy instances are removed from traffic rotation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appStartTimeout":
            suggest = "app_start_timeout"
        elif key == "checkInterval":
            suggest = "check_interval"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "successThreshold":
            suggest = "success_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadinessCheckResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadinessCheckResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadinessCheckResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_start_timeout: str,
                 check_interval: str,
                 failure_threshold: int,
                 host: str,
                 path: str,
                 success_threshold: int,
                 timeout: str):
        """
        Readiness checking configuration for VM instances. Unhealthy instances are removed from traffic rotation.
        :param str app_start_timeout: A maximum time limit on application initialization, measured from moment the application successfully replies to a healthcheck until it is ready to serve traffic.
        :param str check_interval: Interval between health checks.
        :param int failure_threshold: Number of consecutive failed checks required before removing traffic.
        :param str host: Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        :param str path: The request path.
        :param int success_threshold: Number of consecutive successful checks required before receiving traffic.
        :param str timeout: Time before the check is considered failed.
        """
        pulumi.set(__self__, "app_start_timeout", app_start_timeout)
        pulumi.set(__self__, "check_interval", check_interval)
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "success_threshold", success_threshold)
        pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="appStartTimeout")
    def app_start_timeout(self) -> str:
        """
        A maximum time limit on application initialization, measured from moment the application successfully replies to a healthcheck until it is ready to serve traffic.
        """
        return pulumi.get(self, "app_start_timeout")

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> str:
        """
        Interval between health checks.
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> int:
        """
        Number of consecutive failed checks required before removing traffic.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The request path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> int:
        """
        Number of consecutive successful checks required before receiving traffic.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Time before the check is considered failed.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class RequestUtilizationResponse(dict):
    """
    Target scaling by request utilization. Only applicable in the App Engine flexible environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetConcurrentRequests":
            suggest = "target_concurrent_requests"
        elif key == "targetRequestCountPerSecond":
            suggest = "target_request_count_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestUtilizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestUtilizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestUtilizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_concurrent_requests: int,
                 target_request_count_per_second: int):
        """
        Target scaling by request utilization. Only applicable in the App Engine flexible environment.
        :param int target_concurrent_requests: Target number of concurrent requests.
        :param int target_request_count_per_second: Target requests per second.
        """
        pulumi.set(__self__, "target_concurrent_requests", target_concurrent_requests)
        pulumi.set(__self__, "target_request_count_per_second", target_request_count_per_second)

    @property
    @pulumi.getter(name="targetConcurrentRequests")
    def target_concurrent_requests(self) -> int:
        """
        Target number of concurrent requests.
        """
        return pulumi.get(self, "target_concurrent_requests")

    @property
    @pulumi.getter(name="targetRequestCountPerSecond")
    def target_request_count_per_second(self) -> int:
        """
        Target requests per second.
        """
        return pulumi.get(self, "target_request_count_per_second")


@pulumi.output_type
class ResourceRecordResponse(dict):
    """
    A DNS resource record.
    """
    def __init__(__self__, *,
                 name: str,
                 rrdata: str,
                 type: str):
        """
        A DNS resource record.
        :param str name: Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        :param str rrdata: Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        :param str type: Resource record type. Example: AAAA.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rrdata", rrdata)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rrdata(self) -> str:
        """
        Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        """
        return pulumi.get(self, "rrdata")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource record type. Example: AAAA.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ResourcesResponse(dict):
    """
    Machine resources for a version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskGb":
            suggest = "disk_gb"
        elif key == "kmsKeyReference":
            suggest = "kms_key_reference"
        elif key == "memoryGb":
            suggest = "memory_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourcesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourcesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourcesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: float,
                 disk_gb: float,
                 kms_key_reference: str,
                 memory_gb: float,
                 volumes: Sequence['outputs.VolumeResponse']):
        """
        Machine resources for a version.
        :param float cpu: Number of CPU cores needed.
        :param float disk_gb: Disk size (GB) needed.
        :param str kms_key_reference: The name of the encryption key that is stored in Google Cloud KMS. Only should be used by Cloud Composer to encrypt the vm disk
        :param float memory_gb: Memory (GB) needed.
        :param Sequence['VolumeResponse'] volumes: User specified volumes.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "disk_gb", disk_gb)
        pulumi.set(__self__, "kms_key_reference", kms_key_reference)
        pulumi.set(__self__, "memory_gb", memory_gb)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def cpu(self) -> float:
        """
        Number of CPU cores needed.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="diskGb")
    def disk_gb(self) -> float:
        """
        Disk size (GB) needed.
        """
        return pulumi.get(self, "disk_gb")

    @property
    @pulumi.getter(name="kmsKeyReference")
    def kms_key_reference(self) -> str:
        """
        The name of the encryption key that is stored in Google Cloud KMS. Only should be used by Cloud Composer to encrypt the vm disk
        """
        return pulumi.get(self, "kms_key_reference")

    @property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> float:
        """
        Memory (GB) needed.
        """
        return pulumi.get(self, "memory_gb")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        User specified volumes.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class ScriptHandlerResponse(dict):
    """
    Executes a script to handle the request that matches the URL pattern.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptHandlerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptHandlerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptHandlerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script_path: str):
        """
        Executes a script to handle the request that matches the URL pattern.
        :param str script_path: Path to the script from the application root directory.
        """
        pulumi.set(__self__, "script_path", script_path)

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> str:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class SslSettingsResponse(dict):
    """
    SSL configuration for a DomainMapping resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateId":
            suggest = "certificate_id"
        elif key == "pendingManagedCertificateId":
            suggest = "pending_managed_certificate_id"
        elif key == "sslManagementType":
            suggest = "ssl_management_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SslSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SslSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SslSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_id: str,
                 pending_managed_certificate_id: str,
                 ssl_management_type: str):
        """
        SSL configuration for a DomainMapping resource.
        :param str certificate_id: ID of the AuthorizedCertificate resource configuring SSL for the application. Clearing this field will remove SSL support.By default, a managed certificate is automatically created for every domain mapping. To omit SSL support or to configure SSL manually, specify SslManagementType.MANUAL on a CREATE or UPDATE request. You must be authorized to administer the AuthorizedCertificate resource to manually map it to a DomainMapping resource. Example: 12345.
        :param str pending_managed_certificate_id: ID of the managed AuthorizedCertificate resource currently being provisioned, if applicable. Until the new managed certificate has been successfully provisioned, the previous SSL state will be preserved. Once the provisioning process completes, the certificate_id field will reflect the new managed certificate and this field will be left empty. To remove SSL support while there is still a pending managed certificate, clear the certificate_id field with an UpdateDomainMappingRequest.
        :param str ssl_management_type: SSL management type for this domain. If AUTOMATIC, a managed certificate is automatically provisioned. If MANUAL, certificate_id must be manually specified in order to configure SSL for this domain.
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "pending_managed_certificate_id", pending_managed_certificate_id)
        pulumi.set(__self__, "ssl_management_type", ssl_management_type)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        """
        ID of the AuthorizedCertificate resource configuring SSL for the application. Clearing this field will remove SSL support.By default, a managed certificate is automatically created for every domain mapping. To omit SSL support or to configure SSL manually, specify SslManagementType.MANUAL on a CREATE or UPDATE request. You must be authorized to administer the AuthorizedCertificate resource to manually map it to a DomainMapping resource. Example: 12345.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="pendingManagedCertificateId")
    def pending_managed_certificate_id(self) -> str:
        """
        ID of the managed AuthorizedCertificate resource currently being provisioned, if applicable. Until the new managed certificate has been successfully provisioned, the previous SSL state will be preserved. Once the provisioning process completes, the certificate_id field will reflect the new managed certificate and this field will be left empty. To remove SSL support while there is still a pending managed certificate, clear the certificate_id field with an UpdateDomainMappingRequest.
        """
        return pulumi.get(self, "pending_managed_certificate_id")

    @property
    @pulumi.getter(name="sslManagementType")
    def ssl_management_type(self) -> str:
        """
        SSL management type for this domain. If AUTOMATIC, a managed certificate is automatically provisioned. If MANUAL, certificate_id must be manually specified in order to configure SSL for this domain.
        """
        return pulumi.get(self, "ssl_management_type")


@pulumi.output_type
class StandardSchedulerSettingsResponse(dict):
    """
    Scheduler settings for standard environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"
        elif key == "targetCpuUtilization":
            suggest = "target_cpu_utilization"
        elif key == "targetThroughputUtilization":
            suggest = "target_throughput_utilization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardSchedulerSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardSchedulerSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardSchedulerSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instances: int,
                 min_instances: int,
                 target_cpu_utilization: float,
                 target_throughput_utilization: float):
        """
        Scheduler settings for standard environment.
        :param int max_instances: Maximum number of instances to run for this version. Set to zero to disable max_instances configuration.
        :param int min_instances: Minimum number of instances to run for this version. Set to zero to disable min_instances configuration.
        :param float target_cpu_utilization: Target CPU utilization ratio to maintain when scaling.
        :param float target_throughput_utilization: Target throughput utilization ratio to maintain when scaling
        """
        pulumi.set(__self__, "max_instances", max_instances)
        pulumi.set(__self__, "min_instances", min_instances)
        pulumi.set(__self__, "target_cpu_utilization", target_cpu_utilization)
        pulumi.set(__self__, "target_throughput_utilization", target_throughput_utilization)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> int:
        """
        Maximum number of instances to run for this version. Set to zero to disable max_instances configuration.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> int:
        """
        Minimum number of instances to run for this version. Set to zero to disable min_instances configuration.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter(name="targetCpuUtilization")
    def target_cpu_utilization(self) -> float:
        """
        Target CPU utilization ratio to maintain when scaling.
        """
        return pulumi.get(self, "target_cpu_utilization")

    @property
    @pulumi.getter(name="targetThroughputUtilization")
    def target_throughput_utilization(self) -> float:
        """
        Target throughput utilization ratio to maintain when scaling
        """
        return pulumi.get(self, "target_throughput_utilization")


@pulumi.output_type
class StaticFilesHandlerResponse(dict):
    """
    Files served directly to the user for a given URL, such as images, CSS stylesheets, or JavaScript source files. Static file handlers describe which files in the application directory are static files, and which URLs serve them.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationReadable":
            suggest = "application_readable"
        elif key == "httpHeaders":
            suggest = "http_headers"
        elif key == "mimeType":
            suggest = "mime_type"
        elif key == "requireMatchingFile":
            suggest = "require_matching_file"
        elif key == "uploadPathRegex":
            suggest = "upload_path_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticFilesHandlerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticFilesHandlerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticFilesHandlerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_readable: bool,
                 expiration: str,
                 http_headers: Mapping[str, str],
                 mime_type: str,
                 path: str,
                 require_matching_file: bool,
                 upload_path_regex: str):
        """
        Files served directly to the user for a given URL, such as images, CSS stylesheets, or JavaScript source files. Static file handlers describe which files in the application directory are static files, and which URLs serve them.
        :param bool application_readable: Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged against both your code and static data storage resource quotas.
        :param str expiration: Time a static file served by this handler should be cached by web proxies and browsers.
        :param Mapping[str, str] http_headers: HTTP headers to use for all responses from these URLs.
        :param str mime_type: MIME type used to serve all files served by this handler.Defaults to file-specific MIME types, which are derived from each file's filename extension.
        :param str path: Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
        :param bool require_matching_file: Whether this handler should match the request if the file referenced by the handler does not exist.
        :param str upload_path_regex: Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        pulumi.set(__self__, "application_readable", application_readable)
        pulumi.set(__self__, "expiration", expiration)
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "require_matching_file", require_matching_file)
        pulumi.set(__self__, "upload_path_regex", upload_path_regex)

    @property
    @pulumi.getter(name="applicationReadable")
    def application_readable(self) -> bool:
        """
        Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged against both your code and static data storage resource quotas.
        """
        return pulumi.get(self, "application_readable")

    @property
    @pulumi.getter
    def expiration(self) -> str:
        """
        Time a static file served by this handler should be cached by web proxies and browsers.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Mapping[str, str]:
        """
        HTTP headers to use for all responses from these URLs.
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        MIME type used to serve all files served by this handler.Defaults to file-specific MIME types, which are derived from each file's filename extension.
        """
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="requireMatchingFile")
    def require_matching_file(self) -> bool:
        """
        Whether this handler should match the request if the file referenced by the handler does not exist.
        """
        return pulumi.get(self, "require_matching_file")

    @property
    @pulumi.getter(name="uploadPathRegex")
    def upload_path_regex(self) -> str:
        """
        Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        return pulumi.get(self, "upload_path_regex")


@pulumi.output_type
class UrlDispatchRuleResponse(dict):
    """
    Rules to match an HTTP request and dispatch that request to a service.
    """
    def __init__(__self__, *,
                 domain: str,
                 path: str,
                 service: str):
        """
        Rules to match an HTTP request and dispatch that request to a service.
        :param str domain: Domain name to match against. The wildcard "*" is supported if specified before a period: "*.".Defaults to matching all domains: "*".
        :param str path: Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.The sum of the lengths of the domain and path may not exceed 100 characters.
        :param str service: Resource ID of a service in this application that should serve the matched request. The service must already exist. Example: default.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Domain name to match against. The wildcard "*" is supported if specified before a period: "*.".Defaults to matching all domains: "*".
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.The sum of the lengths of the domain and path may not exceed 100 characters.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Resource ID of a service in this application that should serve the matched request. The service must already exist. Example: default.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class UrlMapResponse(dict):
    """
    URL pattern and description of how the URL should be handled. App Engine can handle URLs by executing application code or by serving static files uploaded with the version, such as images, CSS, or JavaScript.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiEndpoint":
            suggest = "api_endpoint"
        elif key == "authFailAction":
            suggest = "auth_fail_action"
        elif key == "redirectHttpResponseCode":
            suggest = "redirect_http_response_code"
        elif key == "securityLevel":
            suggest = "security_level"
        elif key == "staticFiles":
            suggest = "static_files"
        elif key == "urlRegex":
            suggest = "url_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UrlMapResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UrlMapResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UrlMapResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_endpoint: 'outputs.ApiEndpointHandlerResponse',
                 auth_fail_action: str,
                 login: str,
                 redirect_http_response_code: str,
                 script: 'outputs.ScriptHandlerResponse',
                 security_level: str,
                 static_files: 'outputs.StaticFilesHandlerResponse',
                 url_regex: str):
        """
        URL pattern and description of how the URL should be handled. App Engine can handle URLs by executing application code or by serving static files uploaded with the version, such as images, CSS, or JavaScript.
        :param 'ApiEndpointHandlerResponse' api_endpoint: Uses API Endpoints to handle requests.
        :param str auth_fail_action: Action to take when users access resources that require authentication. Defaults to redirect.
        :param str login: Level of login required to access this resource. Not supported for Node.js in the App Engine standard environment.
        :param str redirect_http_response_code: 30x code to use when performing redirects for the secure field. Defaults to 302.
        :param 'ScriptHandlerResponse' script: Executes a script to handle the requests that match this URL pattern. Only the auto value is supported for Node.js in the App Engine standard environment, for example "script": "auto".
        :param str security_level: Security (HTTPS) enforcement for this URL.
        :param 'StaticFilesHandlerResponse' static_files: Returns the contents of a file, such as an image, as the response.
        :param str url_regex: URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings. All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        pulumi.set(__self__, "api_endpoint", api_endpoint)
        pulumi.set(__self__, "auth_fail_action", auth_fail_action)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "redirect_http_response_code", redirect_http_response_code)
        pulumi.set(__self__, "script", script)
        pulumi.set(__self__, "security_level", security_level)
        pulumi.set(__self__, "static_files", static_files)
        pulumi.set(__self__, "url_regex", url_regex)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> 'outputs.ApiEndpointHandlerResponse':
        """
        Uses API Endpoints to handle requests.
        """
        return pulumi.get(self, "api_endpoint")

    @property
    @pulumi.getter(name="authFailAction")
    def auth_fail_action(self) -> str:
        """
        Action to take when users access resources that require authentication. Defaults to redirect.
        """
        return pulumi.get(self, "auth_fail_action")

    @property
    @pulumi.getter
    def login(self) -> str:
        """
        Level of login required to access this resource. Not supported for Node.js in the App Engine standard environment.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter(name="redirectHttpResponseCode")
    def redirect_http_response_code(self) -> str:
        """
        30x code to use when performing redirects for the secure field. Defaults to 302.
        """
        return pulumi.get(self, "redirect_http_response_code")

    @property
    @pulumi.getter
    def script(self) -> 'outputs.ScriptHandlerResponse':
        """
        Executes a script to handle the requests that match this URL pattern. Only the auto value is supported for Node.js in the App Engine standard environment, for example "script": "auto".
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> str:
        """
        Security (HTTPS) enforcement for this URL.
        """
        return pulumi.get(self, "security_level")

    @property
    @pulumi.getter(name="staticFiles")
    def static_files(self) -> 'outputs.StaticFilesHandlerResponse':
        """
        Returns the contents of a file, such as an image, as the response.
        """
        return pulumi.get(self, "static_files")

    @property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> str:
        """
        URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings. All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        return pulumi.get(self, "url_regex")


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volumes mounted within the app container. Only applicable in the App Engine flexible environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeGb":
            suggest = "size_gb"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 size_gb: float,
                 volume_type: str):
        """
        Volumes mounted within the app container. Only applicable in the App Engine flexible environment.
        :param str name: Unique name for the volume.
        :param float size_gb: Volume size in gigabytes.
        :param str volume_type: Underlying volume type, e.g. 'tmpfs'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size_gb", size_gb)
        pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique name for the volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> float:
        """
        Volume size in gigabytes.
        """
        return pulumi.get(self, "size_gb")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        """
        Underlying volume type, e.g. 'tmpfs'.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class VpcAccessConnectorResponse(dict):
    """
    VPC access connector specification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressSetting":
            suggest = "egress_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcAccessConnectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcAccessConnectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcAccessConnectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress_setting: str,
                 name: str):
        """
        VPC access connector specification.
        :param str egress_setting: The egress setting for the connector, controlling what traffic is diverted through it.
        :param str name: Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        pulumi.set(__self__, "egress_setting", egress_setting)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="egressSetting")
    def egress_setting(self) -> str:
        """
        The egress setting for the connector, controlling what traffic is diverted through it.
        """
        return pulumi.get(self, "egress_setting")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ZipInfoResponse(dict):
    """
    The zip file information for a zip deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesCount":
            suggest = "files_count"
        elif key == "sourceUrl":
            suggest = "source_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZipInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZipInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZipInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 files_count: int,
                 source_url: str):
        """
        The zip file information for a zip deployment.
        :param int files_count: An estimate of the number of files in a zip for a zip deployment. If set, must be greater than or equal to the actual number of files. Used for optimizing performance; if not provided, deployment may be slow.
        :param str source_url: URL of the zip file to deploy from. Must be a URL to a resource in Google Cloud Storage in the form 'http(s)://storage.googleapis.com//'.
        """
        pulumi.set(__self__, "files_count", files_count)
        pulumi.set(__self__, "source_url", source_url)

    @property
    @pulumi.getter(name="filesCount")
    def files_count(self) -> int:
        """
        An estimate of the number of files in a zip for a zip deployment. If set, must be greater than or equal to the actual number of files. Used for optimizing performance; if not provided, deployment may be slow.
        """
        return pulumi.get(self, "files_count")

    @property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> str:
        """
        URL of the zip file to deploy from. Must be a URL to a resource in Google Cloud Storage in the form 'http(s)://storage.googleapis.com//'.
        """
        return pulumi.get(self, "source_url")


