# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetExportResult',
    'AwaitableGetExportResult',
    'get_export',
    'get_export_output',
]

@pulumi.output_type
class GetExportResult:
    def __init__(__self__, created=None, datastore_name=None, description=None, error=None, execution_time=None, name=None, self=None, state=None, updated=None):
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if datastore_name and not isinstance(datastore_name, str):
            raise TypeError("Expected argument 'datastore_name' to be a str")
        pulumi.set(__self__, "datastore_name", datastore_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if error and not isinstance(error, str):
            raise TypeError("Expected argument 'error' to be a str")
        pulumi.set(__self__, "error", error)
        if execution_time and not isinstance(execution_time, str):
            raise TypeError("Expected argument 'execution_time' to be a str")
        pulumi.set(__self__, "execution_time", execution_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if self and not isinstance(self, str):
            raise TypeError("Expected argument 'self' to be a str")
        pulumi.set(__self__, "self", self)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        Time the export job was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="datastoreName")
    def datastore_name(self) -> str:
        """
        Name of the datastore that is the destination of the export job [datastore]
        """
        return pulumi.get(self, "datastore_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the export job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def error(self) -> str:
        """
        Error is set when export fails
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="executionTime")
    def execution_time(self) -> str:
        """
        Execution time for this export job. If the job is still in progress, it will be set to the amount of time that has elapsed since`created`, in seconds. Else, it will set to (`updated` - `created`), in seconds.
        """
        return pulumi.get(self, "execution_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Display name of the export job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        Self link of the export job. A URI that can be used to retrieve the status of an export job. Example: `/organizations/myorg/environments/myenv/analytics/exports/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd`
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Status of the export job. Valid values include `enqueued`, `running`, `completed`, and `failed`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def updated(self) -> str:
        """
        Time the export job was last updated.
        """
        return pulumi.get(self, "updated")


class AwaitableGetExportResult(GetExportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExportResult(
            created=self.created,
            datastore_name=self.datastore_name,
            description=self.description,
            error=self.error,
            execution_time=self.execution_time,
            name=self.name,
            self=self.self,
            state=self.state,
            updated=self.updated)


def get_export(environment_id: Optional[str] = None,
               export_id: Optional[str] = None,
               organization_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExportResult:
    """
    Gets the details and status of an analytics export job. If the export job is still in progress, its `state` is set to "running". After the export job has completed successfully, its `state` is set to "completed". If the export job fails, its `state` is set to `failed`.
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['exportId'] = export_id
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getExport', __args__, opts=opts, typ=GetExportResult).value

    return AwaitableGetExportResult(
        created=__ret__.created,
        datastore_name=__ret__.datastore_name,
        description=__ret__.description,
        error=__ret__.error,
        execution_time=__ret__.execution_time,
        name=__ret__.name,
        self=__ret__.self,
        state=__ret__.state,
        updated=__ret__.updated)


@_utilities.lift_output_func(get_export)
def get_export_output(environment_id: Optional[pulumi.Input[str]] = None,
                      export_id: Optional[pulumi.Input[str]] = None,
                      organization_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExportResult]:
    """
    Gets the details and status of an analytics export job. If the export job is still in progress, its `state` is set to "running". After the export job has completed successfully, its `state` is set to "completed". If the export job fails, its `state` is set to `failed`.
    """
    ...
