"""This module defines the function signatures of the DWF C shared library functions.

Warning:
    This code was generated by the 'GeneratePythonFunctionSignaturesFromDwfHeaderFile.py' script, do not edit by hand!

This code was generated from the Digilent Waveforms C header file::

    file ......... : dwf.h
    size ......... : 48191 bytes
    md5sum ....... : c77ad106f85cbad3aef5d61872351754
    version ...... : 3.16.3
"""

from typing import List, Tuple, Any

dwf_version = "3.16.3"
"""The version of the DWF library from which the function signatures were extracted."""

def dwf_function_signatures(typespec: Any) -> List[Tuple[str, Any, List[Tuple[str, Any]], bool]]:
    """Return type information for the 415 functions in the DWF C library API.

    Parameters:
        typespec: a class-like object whose attributes denote the types of the return values and parameters of the
            C library function prototypes.

            The most obvious use of this parameter is to map the types as represented by the attributes onto types
            as defined in the *ctypes* module.

    Returns:
        A list consists of 4-element tuples, each containing the following –

        - The name of the function in the C library;
        - The return type of the function;
        - A list of parameter specifications, each consisting of a (name, type) tuple;
        - A bool indicating if the function is designated as *obsolete*.
    """

    # pylint: disable=line-too-long

    return [
        ('FDwfGetLastError', typespec.c_int, [ ('pdwferc', typespec.DWFERC_ptr) ], False),
        ('FDwfGetLastErrorMsg', typespec.c_int, [ ('szError', typespec.c_char_array_512) ], False),
        ('FDwfGetVersion', typespec.c_int, [ ('szVersion', typespec.c_char_array_32) ], False),
        ('FDwfParamSet', typespec.c_int, [ ('param', typespec.DwfParam), ('value', typespec.c_int) ], False),
        ('FDwfParamGet', typespec.c_int, [ ('param', typespec.DwfParam), ('pvalue', typespec.c_int_ptr) ], False),
        ('FDwfEnum', typespec.c_int, [ ('enumfilter', typespec.ENUMFILTER), ('pcDevice', typespec.c_int_ptr) ], False),
        ('FDwfEnumDeviceType', typespec.c_int, [ ('idxDevice', typespec.c_int), ('pDeviceId', typespec.DEVID_ptr), ('pDeviceRevision', typespec.DEVVER_ptr) ], False),
        ('FDwfEnumDeviceIsOpened', typespec.c_int, [ ('idxDevice', typespec.c_int), ('pfIsUsed', typespec.c_int_ptr) ], False),
        ('FDwfEnumUserName', typespec.c_int, [ ('idxDevice', typespec.c_int), ('szUserName', typespec.c_char_array_32) ], False),
        ('FDwfEnumDeviceName', typespec.c_int, [ ('idxDevice', typespec.c_int), ('szDeviceName', typespec.c_char_array_32) ], False),
        ('FDwfEnumSN', typespec.c_int, [ ('idxDevice', typespec.c_int), ('szSN', typespec.c_char_array_32) ], False),
        ('FDwfEnumConfig', typespec.c_int, [ ('idxDevice', typespec.c_int), ('pcConfig', typespec.c_int_ptr) ], False),
        ('FDwfEnumConfigInfo', typespec.c_int, [ ('idxConfig', typespec.c_int), ('info', typespec.DwfEnumConfigInfo), ('pv', typespec.c_int_ptr) ], False),
        ('FDwfDeviceOpen', typespec.c_int, [ ('idxDevice', typespec.c_int), ('phdwf', typespec.HDWF_ptr) ], False),
        ('FDwfDeviceConfigOpen', typespec.c_int, [ ('idxDev', typespec.c_int), ('idxCfg', typespec.c_int), ('phdwf', typespec.HDWF_ptr) ], False),
        ('FDwfDeviceClose', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDeviceCloseAll', typespec.c_int, [  ], False),
        ('FDwfDeviceAutoConfigureSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fAutoConfigure', typespec.c_int) ], False),
        ('FDwfDeviceAutoConfigureGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfAutoConfigure', typespec.c_int_ptr) ], False),
        ('FDwfDeviceReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDeviceEnableSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fEnable', typespec.c_int) ], False),
        ('FDwfDeviceTriggerInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfstrigsrc', typespec.c_int_ptr) ], False),
        ('FDwfDeviceTriggerSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxPin', typespec.c_int), ('trigsrc', typespec.TRIGSRC) ], False),
        ('FDwfDeviceTriggerGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxPin', typespec.c_int), ('ptrigsrc', typespec.TRIGSRC_ptr) ], False),
        ('FDwfDeviceTriggerPC', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDeviceTriggerSlopeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsslope', typespec.c_int_ptr) ], False),
        ('FDwfDeviceParamSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('param', typespec.DwfParam), ('value', typespec.c_int) ], False),
        ('FDwfDeviceParamGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('param', typespec.DwfParam), ('pvalue', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfAnalogInConfigure', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fReconfigure', typespec.c_int), ('fStart', typespec.c_int) ], False),
        ('FDwfAnalogInTriggerForce', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfAnalogInStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fReadData', typespec.c_int), ('psts', typespec.DwfState_ptr) ], False),
        ('FDwfAnalogInStatusSamplesLeft', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcSamplesLeft', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInStatusSamplesValid', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcSamplesValid', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInStatusIndexWrite', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pidxWrite', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInStatusAutoTriggered', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfAuto', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInStatusData', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('rgdVoltData', typespec.c_double_ptr), ('cdData', typespec.c_int) ], False),
        ('FDwfAnalogInStatusData2', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('rgdVoltData', typespec.c_double_ptr), ('idxData', typespec.c_int), ('cdData', typespec.c_int) ], False),
        ('FDwfAnalogInStatusData16', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('rgu16Data', typespec.c_short_ptr), ('idxData', typespec.c_int), ('cdData', typespec.c_int) ], False),
        ('FDwfAnalogInStatusNoise', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('rgdMin', typespec.c_double_ptr), ('rgdMax', typespec.c_double_ptr), ('cdData', typespec.c_int) ], False),
        ('FDwfAnalogInStatusNoise2', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('rgdMin', typespec.c_double_ptr), ('rgdMax', typespec.c_double_ptr), ('idxData', typespec.c_int), ('cdData', typespec.c_int) ], False),
        ('FDwfAnalogInStatusSample', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pdVoltSample', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInStatusTime', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecUtc', typespec.c_unsigned_int_ptr), ('ptick', typespec.c_unsigned_int_ptr), ('pticksPerSecond', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfAnalogInStatusRecord', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcdDataAvailable', typespec.c_int_ptr), ('pcdDataLost', typespec.c_int_ptr), ('pcdDataCorrupt', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInRecordLengthSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('sLength', typespec.c_double) ], False),
        ('FDwfAnalogInRecordLengthGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psLength', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInFrequencyInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('phzMin', typespec.c_double_ptr), ('phzMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInFrequencySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('hzFrequency', typespec.c_double) ], False),
        ('FDwfAnalogInFrequencyGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('phzFrequency', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInBitsInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnBits', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInBufferSizeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnSizeMin', typespec.c_int_ptr), ('pnSizeMax', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInBufferSizeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('nSize', typespec.c_int) ], False),
        ('FDwfAnalogInBufferSizeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnSize', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInNoiseSizeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnSizeMax', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInNoiseSizeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('nSize', typespec.c_int) ], False),
        ('FDwfAnalogInNoiseSizeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnSize', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInAcquisitionModeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsacqmode', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInAcquisitionModeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('acqmode', typespec.ACQMODE) ], False),
        ('FDwfAnalogInAcquisitionModeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pacqmode', typespec.ACQMODE_ptr) ], False),
        ('FDwfAnalogInChannelCount', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcChannel', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInChannelEnableSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('fEnable', typespec.c_int) ], False),
        ('FDwfAnalogInChannelEnableGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfEnable', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInChannelFilterInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsfilter', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInChannelFilterSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('filter', typespec.FILTER) ], False),
        ('FDwfAnalogInChannelFilterGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfilter', typespec.FILTER_ptr) ], False),
        ('FDwfAnalogInChannelRangeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvoltsMin', typespec.c_double_ptr), ('pvoltsMax', typespec.c_double_ptr), ('pnSteps', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInChannelRangeSteps', typespec.c_int, [ ('hdwf', typespec.HDWF), ('rgVoltsStep', typespec.c_double_array_32), ('pnSteps', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInChannelRangeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('voltsRange', typespec.c_double) ], False),
        ('FDwfAnalogInChannelRangeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pvoltsRange', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInChannelOffsetInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvoltsMin', typespec.c_double_ptr), ('pvoltsMax', typespec.c_double_ptr), ('pnSteps', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInChannelOffsetSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('voltOffset', typespec.c_double) ], False),
        ('FDwfAnalogInChannelOffsetGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pvoltOffset', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInChannelAttenuationSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('xAttenuation', typespec.c_double) ], False),
        ('FDwfAnalogInChannelAttenuationGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pxAttenuation', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInChannelBandwidthSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('hz', typespec.c_double) ], False),
        ('FDwfAnalogInChannelBandwidthGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('hzMin', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInChannelImpedanceSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('hz', typespec.c_double) ], False),
        ('FDwfAnalogInChannelImpedanceGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('hzMin', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerSourceSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('trigsrc', typespec.TRIGSRC) ], False),
        ('FDwfAnalogInTriggerSourceGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ptrigsrc', typespec.TRIGSRC_ptr) ], False),
        ('FDwfAnalogInTriggerPositionInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr), ('pnSteps', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerPositionSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('secPosition', typespec.c_double) ], False),
        ('FDwfAnalogInTriggerPositionGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecPosition', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerPositionStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecPosition', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerAutoTimeoutInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr), ('pnSteps', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerAutoTimeoutSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('secTimeout', typespec.c_double) ], False),
        ('FDwfAnalogInTriggerAutoTimeoutGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecTimeout', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerHoldOffInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr), ('pnStep', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerHoldOffSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('secHoldOff', typespec.c_double) ], False),
        ('FDwfAnalogInTriggerHoldOffGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecHoldOff', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerTypeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfstrigtype', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInTriggerTypeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('trigtype', typespec.TRIGTYPE) ], False),
        ('FDwfAnalogInTriggerTypeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ptrigtype', typespec.TRIGTYPE_ptr) ], False),
        ('FDwfAnalogInTriggerChannelInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pidxMin', typespec.c_int_ptr), ('pidxMax', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInTriggerChannelSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfAnalogInTriggerChannelGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pidxChannel', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInTriggerFilterInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsfilter', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInTriggerFilterSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('filter', typespec.FILTER) ], False),
        ('FDwfAnalogInTriggerFilterGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfilter', typespec.FILTER_ptr) ], False),
        ('FDwfAnalogInTriggerLevelInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvoltsMin', typespec.c_double_ptr), ('pvoltsMax', typespec.c_double_ptr), ('pnSteps', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerLevelSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('voltsLevel', typespec.c_double) ], False),
        ('FDwfAnalogInTriggerLevelGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvoltsLevel', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerHysteresisInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvoltsMin', typespec.c_double_ptr), ('pvoltsMax', typespec.c_double_ptr), ('pnSteps', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerHysteresisSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('voltsLevel', typespec.c_double) ], False),
        ('FDwfAnalogInTriggerHysteresisGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvoltsHysteresis', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerConditionInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfstrigcond', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInTriggerConditionSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('trigcond', typespec.DwfTriggerSlope) ], False),
        ('FDwfAnalogInTriggerConditionGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ptrigcond', typespec.DwfTriggerSlope_ptr) ], False),
        ('FDwfAnalogInTriggerLengthInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr), ('pnSteps', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerLengthSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('secLength', typespec.c_double) ], False),
        ('FDwfAnalogInTriggerLengthGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecLength', typespec.c_double_ptr) ], False),
        ('FDwfAnalogInTriggerLengthConditionInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfstriglen', typespec.c_int_ptr) ], False),
        ('FDwfAnalogInTriggerLengthConditionSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('triglen', typespec.TRIGLEN) ], False),
        ('FDwfAnalogInTriggerLengthConditionGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ptriglen', typespec.TRIGLEN_ptr) ], False),
        ('FDwfAnalogInSamplingSourceSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('trigsrc', typespec.TRIGSRC) ], False),
        ('FDwfAnalogInSamplingSourceGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ptrigsrc', typespec.TRIGSRC_ptr) ], False),
        ('FDwfAnalogInSamplingSlopeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('slope', typespec.DwfTriggerSlope) ], False),
        ('FDwfAnalogInSamplingSlopeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pslope', typespec.DwfTriggerSlope_ptr) ], False),
        ('FDwfAnalogInSamplingDelaySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('sec', typespec.c_double) ], False),
        ('FDwfAnalogInSamplingDelayGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psec', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutCount', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcChannel', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutMasterSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idxMaster', typespec.c_int) ], False),
        ('FDwfAnalogOutMasterGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pidxMaster', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutTriggerSourceSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('trigsrc', typespec.TRIGSRC) ], False),
        ('FDwfAnalogOutTriggerSourceGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('ptrigsrc', typespec.TRIGSRC_ptr) ], False),
        ('FDwfAnalogOutTriggerSlopeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('slope', typespec.DwfTriggerSlope) ], False),
        ('FDwfAnalogOutTriggerSlopeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pslope', typespec.DwfTriggerSlope_ptr) ], False),
        ('FDwfAnalogOutRunInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutRunSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('secRun', typespec.c_double) ], False),
        ('FDwfAnalogOutRunGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('psecRun', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutRunStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('psecRun', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutWaitInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutWaitSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('secWait', typespec.c_double) ], False),
        ('FDwfAnalogOutWaitGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('psecWait', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutRepeatInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pnMin', typespec.c_int_ptr), ('pnMax', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutRepeatSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('cRepeat', typespec.c_int) ], False),
        ('FDwfAnalogOutRepeatGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pcRepeat', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutRepeatStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pcRepeat', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutRepeatTriggerSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('fRepeatTrigger', typespec.c_int) ], False),
        ('FDwfAnalogOutRepeatTriggerGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfRepeatTrigger', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutLimitationInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pMin', typespec.c_double_ptr), ('pMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutLimitationSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('limit', typespec.c_double) ], False),
        ('FDwfAnalogOutLimitationGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('plimit', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutModeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('mode', typespec.DwfAnalogOutMode) ], False),
        ('FDwfAnalogOutModeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pmode', typespec.DwfAnalogOutMode_ptr) ], False),
        ('FDwfAnalogOutIdleInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfsidle', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutIdleSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idle', typespec.DwfAnalogOutIdle) ], False),
        ('FDwfAnalogOutIdleGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pidle', typespec.DwfAnalogOutIdle_ptr) ], False),
        ('FDwfAnalogOutNodeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfsnode', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutNodeEnableSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('fEnable', typespec.c_int) ], False),
        ('FDwfAnalogOutNodeEnableGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pfEnable', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutNodeFunctionInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pfsfunc', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfAnalogOutNodeFunctionSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('func', typespec.FUNC) ], False),
        ('FDwfAnalogOutNodeFunctionGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pfunc', typespec.FUNC_ptr) ], False),
        ('FDwfAnalogOutNodeFrequencyInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('phzMin', typespec.c_double_ptr), ('phzMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodeFrequencySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('hzFrequency', typespec.c_double) ], False),
        ('FDwfAnalogOutNodeFrequencyGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('phzFrequency', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodeAmplitudeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pMin', typespec.c_double_ptr), ('pMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodeAmplitudeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('vAmplitude', typespec.c_double) ], False),
        ('FDwfAnalogOutNodeAmplitudeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pvAmplitude', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodeOffsetInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pMin', typespec.c_double_ptr), ('pMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodeOffsetSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('vOffset', typespec.c_double) ], False),
        ('FDwfAnalogOutNodeOffsetGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pvOffset', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodeSymmetryInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('ppercentageMin', typespec.c_double_ptr), ('ppercentageMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodeSymmetrySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('percentageSymmetry', typespec.c_double) ], False),
        ('FDwfAnalogOutNodeSymmetryGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('ppercentageSymmetry', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodePhaseInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pdegreeMin', typespec.c_double_ptr), ('pdegreeMax', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodePhaseSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('degreePhase', typespec.c_double) ], False),
        ('FDwfAnalogOutNodePhaseGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pdegreePhase', typespec.c_double_ptr) ], False),
        ('FDwfAnalogOutNodeDataInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('pnSamplesMin', typespec.c_int_ptr), ('pnSamplesMax', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutNodeDataSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('rgdData', typespec.c_double_ptr), ('cdData', typespec.c_int) ], False),
        ('FDwfAnalogOutCustomAMFMEnableSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('fEnable', typespec.c_int) ], False),
        ('FDwfAnalogOutCustomAMFMEnableGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfEnable', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutReset', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfAnalogOutConfigure', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('fStart', typespec.c_int) ], False),
        ('FDwfAnalogOutStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('psts', typespec.DwfState_ptr) ], False),
        ('FDwfAnalogOutNodePlayStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('cdDataFree', typespec.c_int_ptr), ('cdDataLost', typespec.c_int_ptr), ('cdDataCorrupted', typespec.c_int_ptr) ], False),
        ('FDwfAnalogOutNodePlayData', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('node', typespec.AnalogOutNode), ('rgdData', typespec.c_double_ptr), ('cdData', typespec.c_int) ], False),
        ('FDwfAnalogIOReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfAnalogIOConfigure', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfAnalogIOStatus', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfAnalogIOEnableInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfSet', typespec.c_int_ptr), ('pfStatus', typespec.c_int_ptr) ], False),
        ('FDwfAnalogIOEnableSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fMasterEnable', typespec.c_int) ], False),
        ('FDwfAnalogIOEnableGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfMasterEnable', typespec.c_int_ptr) ], False),
        ('FDwfAnalogIOEnableStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfMasterEnable', typespec.c_int_ptr) ], False),
        ('FDwfAnalogIOChannelCount', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnChannel', typespec.c_int_ptr) ], False),
        ('FDwfAnalogIOChannelName', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('szName', typespec.c_char_array_32), ('szLabel', typespec.c_char_array_16) ], False),
        ('FDwfAnalogIOChannelInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pnNodes', typespec.c_int_ptr) ], False),
        ('FDwfAnalogIOChannelNodeName', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idxNode', typespec.c_int), ('szNodeName', typespec.c_char_array_32), ('szNodeUnits', typespec.c_char_array_16) ], False),
        ('FDwfAnalogIOChannelNodeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idxNode', typespec.c_int), ('panalogio', typespec.ANALOGIO_ptr) ], False),
        ('FDwfAnalogIOChannelNodeSetInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idxNode', typespec.c_int), ('pmin', typespec.c_double_ptr), ('pmax', typespec.c_double_ptr), ('pnSteps', typespec.c_int_ptr) ], False),
        ('FDwfAnalogIOChannelNodeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idxNode', typespec.c_int), ('value', typespec.c_double) ], False),
        ('FDwfAnalogIOChannelNodeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idxNode', typespec.c_int), ('pvalue', typespec.c_double_ptr) ], False),
        ('FDwfAnalogIOChannelNodeStatusInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idxNode', typespec.c_int), ('pmin', typespec.c_double_ptr), ('pmax', typespec.c_double_ptr), ('pnSteps', typespec.c_int_ptr) ], False),
        ('FDwfAnalogIOChannelNodeStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('idxNode', typespec.c_int), ('pvalue', typespec.c_double_ptr) ], False),
        ('FDwfDigitalIOReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalIOConfigure', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalIOStatus', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalIOOutputEnableInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsOutputEnableMask', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalIOOutputEnableSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fsOutputEnable', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalIOOutputEnableGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsOutputEnable', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalIOOutputInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsOutputMask', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalIOOutputSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fsOutput', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalIOOutputGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsOutput', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalIOInputInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsInputMask', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalIOInputStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsInput', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalIOOutputEnableInfo64', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsOutputEnableMask', typespec.c_unsigned_long_long_ptr) ], False),
        ('FDwfDigitalIOOutputEnableSet64', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fsOutputEnable', typespec.c_unsigned_long_long) ], False),
        ('FDwfDigitalIOOutputEnableGet64', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsOutputEnable', typespec.c_unsigned_long_long_ptr) ], False),
        ('FDwfDigitalIOOutputInfo64', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsOutputMask', typespec.c_unsigned_long_long_ptr) ], False),
        ('FDwfDigitalIOOutputSet64', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fsOutput', typespec.c_unsigned_long_long) ], False),
        ('FDwfDigitalIOOutputGet64', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsOutput', typespec.c_unsigned_long_long_ptr) ], False),
        ('FDwfDigitalIOInputInfo64', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsInputMask', typespec.c_unsigned_long_long_ptr) ], False),
        ('FDwfDigitalIOInputStatus64', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsInput', typespec.c_unsigned_long_long_ptr) ], False),
        ('FDwfDigitalInReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalInConfigure', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fReconfigure', typespec.c_int), ('fStart', typespec.c_int) ], False),
        ('FDwfDigitalInStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fReadData', typespec.c_int), ('psts', typespec.DwfState_ptr) ], False),
        ('FDwfDigitalInStatusSamplesLeft', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcSamplesLeft', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInStatusSamplesValid', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcSamplesValid', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInStatusIndexWrite', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pidxWrite', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInStatusAutoTriggered', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfAuto', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInStatusData', typespec.c_int, [ ('hdwf', typespec.HDWF), ('rgData', typespec.c_void_ptr), ('countOfDataBytes', typespec.c_int) ], False),
        ('FDwfDigitalInStatusData2', typespec.c_int, [ ('hdwf', typespec.HDWF), ('rgData', typespec.c_void_ptr), ('idxSample', typespec.c_int), ('countOfDataBytes', typespec.c_int) ], False),
        ('FDwfDigitalInStatusNoise2', typespec.c_int, [ ('hdwf', typespec.HDWF), ('rgData', typespec.c_void_ptr), ('idxSample', typespec.c_int), ('countOfDataBytes', typespec.c_int) ], False),
        ('FDwfDigitalInStatusRecord', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcdDataAvailable', typespec.c_int_ptr), ('pcdDataLost', typespec.c_int_ptr), ('pcdDataCorrupt', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInStatusTime', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecUtc', typespec.c_unsigned_int_ptr), ('ptick', typespec.c_unsigned_int_ptr), ('pticksPerSecond', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInInternalClockInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('phzFreq', typespec.c_double_ptr) ], False),
        ('FDwfDigitalInClockSourceInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsDwfDigitalInClockSource', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInClockSourceSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('v', typespec.DwfDigitalInClockSource) ], False),
        ('FDwfDigitalInClockSourceGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pv', typespec.DwfDigitalInClockSource_ptr) ], False),
        ('FDwfDigitalInDividerInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pdivMax', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInDividerSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('div', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalInDividerGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pdiv', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInBitsInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnBits', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInSampleFormatSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('nBits', typespec.c_int) ], False),
        ('FDwfDigitalInSampleFormatGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnBits', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInInputOrderSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fDioFirst', typespec.c_bool) ], False),
        ('FDwfDigitalInBufferSizeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnSizeMax', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInBufferSizeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('nSize', typespec.c_int) ], False),
        ('FDwfDigitalInBufferSizeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnSize', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInSampleModeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsDwfDigitalInSampleMode', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInSampleModeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('v', typespec.DwfDigitalInSampleMode) ], False),
        ('FDwfDigitalInSampleModeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pv', typespec.DwfDigitalInSampleMode_ptr) ], False),
        ('FDwfDigitalInSampleSensibleSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fs', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalInSampleSensibleGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfs', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInAcquisitionModeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsacqmode', typespec.c_int_ptr) ], False),
        ('FDwfDigitalInAcquisitionModeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('acqmode', typespec.ACQMODE) ], False),
        ('FDwfDigitalInAcquisitionModeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pacqmode', typespec.ACQMODE_ptr) ], False),
        ('FDwfDigitalInTriggerSourceSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('trigsrc', typespec.TRIGSRC) ], False),
        ('FDwfDigitalInTriggerSourceGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ptrigsrc', typespec.TRIGSRC_ptr) ], False),
        ('FDwfDigitalInTriggerSlopeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('slope', typespec.DwfTriggerSlope) ], False),
        ('FDwfDigitalInTriggerSlopeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pslope', typespec.DwfTriggerSlope_ptr) ], False),
        ('FDwfDigitalInTriggerPositionInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnSamplesAfterTriggerMax', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInTriggerPositionSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cSamplesAfterTrigger', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalInTriggerPositionGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcSamplesAfterTrigger', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInTriggerPrefillSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cSamplesBeforeTrigger', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalInTriggerPrefillGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcSamplesBeforeTrigger', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInTriggerAutoTimeoutInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr), ('pnSteps', typespec.c_double_ptr) ], False),
        ('FDwfDigitalInTriggerAutoTimeoutSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('secTimeout', typespec.c_double) ], False),
        ('FDwfDigitalInTriggerAutoTimeoutGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecTimeout', typespec.c_double_ptr) ], False),
        ('FDwfDigitalInTriggerInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsLevelLow', typespec.c_unsigned_int_ptr), ('pfsLevelHigh', typespec.c_unsigned_int_ptr), ('pfsEdgeRise', typespec.c_unsigned_int_ptr), ('pfsEdgeFall', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInTriggerSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fsLevelLow', typespec.c_unsigned_int), ('fsLevelHigh', typespec.c_unsigned_int), ('fsEdgeRise', typespec.c_unsigned_int), ('fsEdgeFall', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalInTriggerGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfsLevelLow', typespec.c_unsigned_int_ptr), ('pfsLevelHigh', typespec.c_unsigned_int_ptr), ('pfsEdgeRise', typespec.c_unsigned_int_ptr), ('pfsEdgeFall', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalInTriggerResetSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fsLevelLow', typespec.c_unsigned_int), ('fsLevelHigh', typespec.c_unsigned_int), ('fsEdgeRise', typespec.c_unsigned_int), ('fsEdgeFall', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalInTriggerCountSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cCount', typespec.c_int), ('fRestart', typespec.c_int) ], False),
        ('FDwfDigitalInTriggerLengthSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('secMin', typespec.c_double), ('secMax', typespec.c_double), ('idxSync', typespec.c_int) ], False),
        ('FDwfDigitalInTriggerMatchSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('iPin', typespec.c_int), ('fsMask', typespec.c_unsigned_int), ('fsValue', typespec.c_unsigned_int), ('cBitStuffing', typespec.c_int) ], False),
        ('FDwfDigitalOutReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalOutConfigure', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fStart', typespec.c_int) ], False),
        ('FDwfDigitalOutStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psts', typespec.DwfState_ptr) ], False),
        ('FDwfDigitalOutInternalClockInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('phzFreq', typespec.c_double_ptr) ], False),
        ('FDwfDigitalOutTriggerSourceSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('trigsrc', typespec.TRIGSRC) ], False),
        ('FDwfDigitalOutTriggerSourceGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ptrigsrc', typespec.TRIGSRC_ptr) ], False),
        ('FDwfDigitalOutRunInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr) ], False),
        ('FDwfDigitalOutRunSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('secRun', typespec.c_double) ], False),
        ('FDwfDigitalOutRunGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecRun', typespec.c_double_ptr) ], False),
        ('FDwfDigitalOutRunStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecRun', typespec.c_double_ptr) ], False),
        ('FDwfDigitalOutWaitInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecMin', typespec.c_double_ptr), ('psecMax', typespec.c_double_ptr) ], False),
        ('FDwfDigitalOutWaitSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('secWait', typespec.c_double) ], False),
        ('FDwfDigitalOutWaitGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psecWait', typespec.c_double_ptr) ], False),
        ('FDwfDigitalOutRepeatInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pnMin', typespec.c_unsigned_int_ptr), ('pnMax', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutRepeatSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cRepeat', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalOutRepeatGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcRepeat', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutRepeatStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcRepeat', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutTriggerSlopeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('slope', typespec.DwfTriggerSlope) ], False),
        ('FDwfDigitalOutTriggerSlopeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pslope', typespec.DwfTriggerSlope_ptr) ], False),
        ('FDwfDigitalOutRepeatTriggerSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fRepeatTrigger', typespec.c_int) ], False),
        ('FDwfDigitalOutRepeatTriggerGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfRepeatTrigger', typespec.c_int_ptr) ], False),
        ('FDwfDigitalOutCount', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pcChannel', typespec.c_int_ptr) ], False),
        ('FDwfDigitalOutEnableSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('fEnable', typespec.c_int) ], False),
        ('FDwfDigitalOutEnableGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfEnable', typespec.c_int_ptr) ], False),
        ('FDwfDigitalOutOutputInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfsDwfDigitalOutOutput', typespec.c_int_ptr) ], False),
        ('FDwfDigitalOutOutputSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('v', typespec.DwfDigitalOutOutput) ], False),
        ('FDwfDigitalOutOutputGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pv', typespec.DwfDigitalOutOutput_ptr) ], False),
        ('FDwfDigitalOutTypeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfsDwfDigitalOutType', typespec.c_int_ptr) ], False),
        ('FDwfDigitalOutTypeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('v', typespec.DwfDigitalOutType) ], False),
        ('FDwfDigitalOutTypeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pv', typespec.DwfDigitalOutType_ptr) ], False),
        ('FDwfDigitalOutIdleInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfsDwfDigitalOutIdle', typespec.c_int_ptr) ], False),
        ('FDwfDigitalOutIdleSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('v', typespec.DwfDigitalOutIdle) ], False),
        ('FDwfDigitalOutIdleGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pv', typespec.DwfDigitalOutIdle_ptr) ], False),
        ('FDwfDigitalOutDividerInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('vMin', typespec.c_unsigned_int_ptr), ('vMax', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutDividerInitSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('v', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalOutDividerInitGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pv', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutDividerSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('v', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalOutDividerGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pv', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutCounterInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('vMin', typespec.c_unsigned_int_ptr), ('vMax', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutCounterInitSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('fHigh', typespec.c_int), ('v', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalOutCounterInitGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfHigh', typespec.c_int_ptr), ('pv', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutCounterSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('vLow', typespec.c_unsigned_int), ('vHigh', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalOutCounterGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pvLow', typespec.c_unsigned_int_ptr), ('pvHigh', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutDataInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pcountOfBitsMax', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalOutDataSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('rgBits', typespec.c_void_ptr), ('countOfBits', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalOutPlayDataSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('rgBits', typespec.c_unsigned_char_ptr), ('bitPerSample', typespec.c_unsigned_int), ('countOfSamples', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalOutPlayRateSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('hzRate', typespec.c_double) ], False),
        ('FDwfDigitalUartReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalUartRateSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('hz', typespec.c_double) ], False),
        ('FDwfDigitalUartBitsSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cBits', typespec.c_int) ], False),
        ('FDwfDigitalUartParitySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('parity', typespec.c_int) ], False),
        ('FDwfDigitalUartStopSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cBit', typespec.c_double) ], False),
        ('FDwfDigitalUartTxSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfDigitalUartRxSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfDigitalUartTx', typespec.c_int, [ ('hdwf', typespec.HDWF), ('szTx', typespec.c_char_ptr), ('cTx', typespec.c_int) ], False),
        ('FDwfDigitalUartRx', typespec.c_int, [ ('hdwf', typespec.HDWF), ('szRx', typespec.c_char_ptr), ('cRx', typespec.c_int), ('pcRx', typespec.c_int_ptr), ('pParity', typespec.c_int_ptr) ], False),
        ('FDwfDigitalSpiReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalSpiFrequencySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('hz', typespec.c_double) ], False),
        ('FDwfDigitalSpiClockSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfDigitalSpiDataSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxDQ', typespec.c_int), ('idxChannel', typespec.c_int) ], False),
        ('FDwfDigitalSpiIdleSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxDQ', typespec.c_int), ('idle', typespec.DwfDigitalOutIdle) ], False),
        ('FDwfDigitalSpiModeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('iMode', typespec.c_int) ], False),
        ('FDwfDigitalSpiOrderSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fMSBFirst', typespec.c_int) ], False),
        ('FDwfDigitalSpiSelect', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('level', typespec.c_int) ], False),
        ('FDwfDigitalSpiWriteRead', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgTX', typespec.c_unsigned_char_ptr), ('cTX', typespec.c_int), ('rgRX', typespec.c_unsigned_char_ptr), ('cRX', typespec.c_int) ], False),
        ('FDwfDigitalSpiWriteRead16', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgTX', typespec.c_unsigned_short_ptr), ('cTX', typespec.c_int), ('rgRX', typespec.c_unsigned_short_ptr), ('cRX', typespec.c_int) ], False),
        ('FDwfDigitalSpiWriteRead32', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgTX', typespec.c_unsigned_int_ptr), ('cTX', typespec.c_int), ('rgRX', typespec.c_unsigned_int_ptr), ('cRX', typespec.c_int) ], False),
        ('FDwfDigitalSpiRead', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgRX', typespec.c_unsigned_char_ptr), ('cRX', typespec.c_int) ], False),
        ('FDwfDigitalSpiReadOne', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('pRX', typespec.c_unsigned_int_ptr) ], False),
        ('FDwfDigitalSpiRead16', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgRX', typespec.c_unsigned_short_ptr), ('cRX', typespec.c_int) ], False),
        ('FDwfDigitalSpiRead32', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgRX', typespec.c_unsigned_int_ptr), ('cRX', typespec.c_int) ], False),
        ('FDwfDigitalSpiWrite', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgTX', typespec.c_unsigned_char_ptr), ('cTX', typespec.c_int) ], False),
        ('FDwfDigitalSpiWriteOne', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBits', typespec.c_int), ('vTX', typespec.c_unsigned_int) ], False),
        ('FDwfDigitalSpiWrite16', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgTX', typespec.c_unsigned_short_ptr), ('cTX', typespec.c_int) ], False),
        ('FDwfDigitalSpiWrite32', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cDQ', typespec.c_int), ('cBitPerWord', typespec.c_int), ('rgTX', typespec.c_unsigned_int_ptr), ('cTX', typespec.c_int) ], False),
        ('FDwfDigitalI2cReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalI2cClear', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfFree', typespec.c_int_ptr) ], False),
        ('FDwfDigitalI2cStretchSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fEnable', typespec.c_int) ], False),
        ('FDwfDigitalI2cRateSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('hz', typespec.c_double) ], False),
        ('FDwfDigitalI2cReadNakSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fNakLastReadByte', typespec.c_int) ], False),
        ('FDwfDigitalI2cSclSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfDigitalI2cSdaSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfDigitalI2cWriteRead', typespec.c_int, [ ('hdwf', typespec.HDWF), ('adr8bits', typespec.c_unsigned_char), ('rgbTx', typespec.c_unsigned_char_ptr), ('cTx', typespec.c_int), ('rgRx', typespec.c_unsigned_char_ptr), ('cRx', typespec.c_int), ('pNak', typespec.c_int_ptr) ], False),
        ('FDwfDigitalI2cRead', typespec.c_int, [ ('hdwf', typespec.HDWF), ('adr8bits', typespec.c_unsigned_char), ('rgbRx', typespec.c_unsigned_char_ptr), ('cRx', typespec.c_int), ('pNak', typespec.c_int_ptr) ], False),
        ('FDwfDigitalI2cWrite', typespec.c_int, [ ('hdwf', typespec.HDWF), ('adr8bits', typespec.c_unsigned_char), ('rgbTx', typespec.c_unsigned_char_ptr), ('cTx', typespec.c_int), ('pNak', typespec.c_int_ptr) ], False),
        ('FDwfDigitalI2cWriteOne', typespec.c_int, [ ('hdwf', typespec.HDWF), ('adr8bits', typespec.c_unsigned_char), ('bTx', typespec.c_unsigned_char), ('pNak', typespec.c_int_ptr) ], False),
        ('FDwfDigitalCanReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfDigitalCanRateSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('hz', typespec.c_double) ], False),
        ('FDwfDigitalCanPolaritySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fHigh', typespec.c_int) ], False),
        ('FDwfDigitalCanTxSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfDigitalCanRxSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int) ], False),
        ('FDwfDigitalCanTx', typespec.c_int, [ ('hdwf', typespec.HDWF), ('vID', typespec.c_int), ('fExtended', typespec.c_int), ('fRemote', typespec.c_int), ('cDLC', typespec.c_int), ('rgTX', typespec.c_unsigned_char_ptr) ], False),
        ('FDwfDigitalCanRx', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvID', typespec.c_int_ptr), ('pfExtended', typespec.c_int_ptr), ('pfRemote', typespec.c_int_ptr), ('pcDLC', typespec.c_int_ptr), ('rgRX', typespec.c_unsigned_char_ptr), ('cRX', typespec.c_int), ('pvStatus', typespec.c_int_ptr) ], False),
        ('FDwfAnalogImpedanceReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfAnalogImpedanceModeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('mode', typespec.c_int) ], False),
        ('FDwfAnalogImpedanceModeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('mode', typespec.c_int_ptr) ], False),
        ('FDwfAnalogImpedanceReferenceSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ohms', typespec.c_double) ], False),
        ('FDwfAnalogImpedanceReferenceGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pohms', typespec.c_double_ptr) ], False),
        ('FDwfAnalogImpedanceFrequencySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('hz', typespec.c_double) ], False),
        ('FDwfAnalogImpedanceFrequencyGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('phz', typespec.c_double_ptr) ], False),
        ('FDwfAnalogImpedanceAmplitudeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('volts', typespec.c_double) ], False),
        ('FDwfAnalogImpedanceAmplitudeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvolts', typespec.c_double_ptr) ], False),
        ('FDwfAnalogImpedanceOffsetSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('volts', typespec.c_double) ], False),
        ('FDwfAnalogImpedanceOffsetGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pvolts', typespec.c_double_ptr) ], False),
        ('FDwfAnalogImpedanceProbeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ohmRes', typespec.c_double), ('faradCap', typespec.c_double) ], False),
        ('FDwfAnalogImpedanceProbeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pohmRes', typespec.c_double_ptr), ('pfaradCap', typespec.c_double_ptr) ], False),
        ('FDwfAnalogImpedancePeriodSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cMinPeriods', typespec.c_int) ], False),
        ('FDwfAnalogImpedancePeriodGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('cMinPeriods', typespec.c_int_ptr) ], False),
        ('FDwfAnalogImpedanceCompReset', typespec.c_int, [ ('hdwf', typespec.HDWF) ], False),
        ('FDwfAnalogImpedanceCompSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('ohmOpenResistance', typespec.c_double), ('ohmOpenReactance', typespec.c_double), ('ohmShortResistance', typespec.c_double), ('ohmShortReactance', typespec.c_double) ], False),
        ('FDwfAnalogImpedanceCompGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pohmOpenResistance', typespec.c_double_ptr), ('pohmOpenReactance', typespec.c_double_ptr), ('pohmShortResistance', typespec.c_double_ptr), ('pohmShortReactance', typespec.c_double_ptr) ], False),
        ('FDwfAnalogImpedanceConfigure', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fStart', typespec.c_int) ], False),
        ('FDwfAnalogImpedanceStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('psts', typespec.DwfState_ptr) ], False),
        ('FDwfAnalogImpedanceStatusInput', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pgain', typespec.c_double_ptr), ('pradian', typespec.c_double_ptr) ], False),
        ('FDwfAnalogImpedanceStatusMeasure', typespec.c_int, [ ('hdwf', typespec.HDWF), ('measure', typespec.DwfAnalogImpedance), ('pvalue', typespec.c_double_ptr) ], False),
        ('FDwfDigitalInMixedSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('fEnable', typespec.c_int) ], True),
        ('FDwfAnalogInTriggerSourceInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfstrigsrc', typespec.c_int_ptr) ], True),
        ('FDwfAnalogOutTriggerSourceInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfstrigsrc', typespec.c_int_ptr) ], True),
        ('FDwfDigitalInTriggerSourceInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfstrigsrc', typespec.c_int_ptr) ], True),
        ('FDwfDigitalOutTriggerSourceInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('pfstrigsrc', typespec.c_int_ptr) ], True),
        ('FDwfAnalogOutEnableSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('fEnable', typespec.c_int) ], True),
        ('FDwfAnalogOutEnableGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfEnable', typespec.c_int_ptr) ], True),
        ('FDwfAnalogOutFunctionInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfsfunc', typespec.c_unsigned_int_ptr) ], True),
        ('FDwfAnalogOutFunctionSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('func', typespec.FUNC) ], True),
        ('FDwfAnalogOutFunctionGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pfunc', typespec.FUNC_ptr) ], True),
        ('FDwfAnalogOutFrequencyInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('phzMin', typespec.c_double_ptr), ('phzMax', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutFrequencySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('hzFrequency', typespec.c_double) ], True),
        ('FDwfAnalogOutFrequencyGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('phzFrequency', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutAmplitudeInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pvoltsMin', typespec.c_double_ptr), ('pvoltsMax', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutAmplitudeSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('voltsAmplitude', typespec.c_double) ], True),
        ('FDwfAnalogOutAmplitudeGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pvoltsAmplitude', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutOffsetInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pvoltsMin', typespec.c_double_ptr), ('pvoltsMax', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutOffsetSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('voltsOffset', typespec.c_double) ], True),
        ('FDwfAnalogOutOffsetGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pvoltsOffset', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutSymmetryInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('ppercentageMin', typespec.c_double_ptr), ('ppercentageMax', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutSymmetrySet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('percentageSymmetry', typespec.c_double) ], True),
        ('FDwfAnalogOutSymmetryGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('ppercentageSymmetry', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutPhaseInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pdegreeMin', typespec.c_double_ptr), ('pdegreeMax', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutPhaseSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('degreePhase', typespec.c_double) ], True),
        ('FDwfAnalogOutPhaseGet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pdegreePhase', typespec.c_double_ptr) ], True),
        ('FDwfAnalogOutDataInfo', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('pnSamplesMin', typespec.c_int_ptr), ('pnSamplesMax', typespec.c_int_ptr) ], True),
        ('FDwfAnalogOutDataSet', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('rgdData', typespec.c_double_ptr), ('cdData', typespec.c_int) ], True),
        ('FDwfAnalogOutPlayStatus', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('cdDataFree', typespec.c_int_ptr), ('cdDataLost', typespec.c_int_ptr), ('cdDataCorrupted', typespec.c_int_ptr) ], True),
        ('FDwfAnalogOutPlayData', typespec.c_int, [ ('hdwf', typespec.HDWF), ('idxChannel', typespec.c_int), ('rgdData', typespec.c_double_ptr), ('cdData', typespec.c_int) ], True),
        ('FDwfEnumAnalogInChannels', typespec.c_int, [ ('idxDevice', typespec.c_int), ('pnChannels', typespec.c_int_ptr) ], True),
        ('FDwfEnumAnalogInBufferSize', typespec.c_int, [ ('idxDevice', typespec.c_int), ('pnBufferSize', typespec.c_int_ptr) ], True),
        ('FDwfEnumAnalogInBits', typespec.c_int, [ ('idxDevice', typespec.c_int), ('pnBits', typespec.c_int_ptr) ], True),
        ('FDwfEnumAnalogInFrequency', typespec.c_int, [ ('idxDevice', typespec.c_int), ('phzFrequency', typespec.c_double_ptr) ], True)
    ]
