# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cyc_next_app',
 'cyc_next_app.lib.@jupyter-widgets.schema',
 'cyc_next_app.server',
 'cyc_next_app.server.python',
 'cyc_next_app.server.python.cassist',
 'cyc_next_app.server.python.code_editor',
 'cyc_next_app.server.python.dataframe_manager',
 'cyc_next_app.server.python.experiment_manager',
 'cyc_next_app.server.python.file_explorer',
 'cyc_next_app.server.python.file_manager',
 'cyc_next_app.server.python.libs',
 'cyc_next_app.server.python.project_manager',
 'cyc_next_app.server.python.user_space',
 'cyc_next_app.server.python.user_space.ipython',
 'cyc_next_app.server.tests',
 'cyc_next_app.server.tests.test_servers']

package_data = \
{'': ['*'],
 'cyc_next_app': ['lib/@jupyter-widgets/base/*',
                  'lib/@jupyter-widgets/base/css/*',
                  'lib/@jupyter-widgets/base/lib/*',
                  'lib/@jupyter-widgets/controls/*',
                  'lib/@jupyter-widgets/controls/css/*',
                  'lib/@jupyter-widgets/controls/lib/*',
                  'lib/@jupyter-widgets/controls/lib/phosphor/*',
                  'lib/@jupyter-widgets/html-manager/*',
                  'lib/@jupyter-widgets/html-manager/css/*',
                  'lib/@jupyter-widgets/html-manager/lib/*',
                  'lib/@jupyter-widgets/jupyterlab-manager/*',
                  'lib/@jupyter-widgets/jupyterlab-manager/lib/*',
                  'lib/@jupyter-widgets/jupyterlab-manager/schema/*',
                  'lib/@jupyter-widgets/output/*',
                  'lib/@jupyter-widgets/output/lib/*',
                  'lib/cassist/*',
                  'lib/codemirror/autocomplete-lsp/*',
                  'lib/codemirror/autocomplete-lsp/autocomplete/*',
                  'lib/codemirror/basic-setup/*',
                  'lib/codemirror/grammar/*',
                  'lib/components/*',
                  'lib/components/code-panel/*',
                  'lib/components/dataframe-manager/*',
                  'lib/components/error-boundary/*',
                  'lib/components/file-manager/*',
                  'lib/components/libs/*',
                  'lib/components/richoutput-panel/*',
                  'lib/components/richoutput-panel/data-panel/*',
                  'lib/components/richoutput-panel/experiment-panel/*',
                  'lib/components/richoutput-panel/model-panel/*',
                  'lib/components/richoutput-panel/result-panel/*',
                  'lib/components/richoutput-panel/summary-panel/*',
                  'lib/components/sidebar/*',
                  'lib/components/tests/*',
                  'lib/interfaces/*',
                  'pages/*',
                  'public/*',
                  'public/icons/*',
                  'redux/*',
                  'redux/actions/*',
                  'redux/reducers/*',
                  'redux/store/*',
                  'styles/*',
                  'theme/*'],
 'cyc_next_app.lib.@jupyter-widgets.schema': ['v1/*', 'v2/*'],
 'cyc_next_app.server': ['build/*', 'ls/*', 'routes/*']}

install_requires = \
['cnext-libs>=0.1.0,<0.2.0',
 'jupyter-client==7.2.2',
 'jupyterlab==3.3.4',
 'matplotlib==3.5.1',
 'mlflow==1.25.1',
 'multipledispatch==0.6.0',
 'pandas==1.3.5',
 'plotly==5.7.0',
 'python-language-server==0.36.2',
 'requests==2.27.1',
 'send2trash==1.8.0',
 'simplejson==3.17.6',
 'tensorflow==2.8.0',
 'zmq==0.0.0']

entry_points = \
{'console_scripts': ['cnext-init = cyc_next_app.__main__:main',
                     'cnext-path = cyc_next_app.__main__:path',
                     'cnext-run = cyc_next_app.__main__:start']}

setup_kwargs = {
    'name': 'cnext',
    'version': '0.3.0',
    'description': 'improve your AI work follow',
    'long_description': '# Cycai/CNext Instruction\n\n## Setup and run CNext web application\n\nCyc AI is an application focusing on improve the AI development life cycle\n\n-   Convinient code editor like coding normal\n-   Combine smart UI to control the infomation\n-   Simple but power full\n-   Setup easily\n\n## Features\n\n-   Create and get your coding easily\n-   Visualize your data infomation in machine learning\n-   Behavior follow easily\n-   Console output\n-   Customize\n\nMore about CycAI.\n[Website] - [Docker Image] - [Overview Video]\n\n## Installation via Docker\n\nStep 1: `Download` [cnext] folder and `extract`\n\nStep 2: `setup` [Docker] on your computer\n\nStep 3: Run `docker login` login with your docker account\n\nStep 4: Point destination command to `cnext` directory\n\nStep 5: Run command `docker-compose up -d`\n\n-   Web application will launch at : `http://localhost:CLIENT_PORT` or `http://127.0.0.1:CLIENT_PORT/`\n-   Stop application: `docker-compose down`\n-   Note: Pay attention at `CLIENT_PORT`, and `SERVER_PORT` in `.env` file (you will have to change these ports if you already use them on your machine)\n\n## Installation via Pip\n\nStep 1: `Download` [cnext] folder and `extract`\n\nStep 2: Make sure `Nodejs` is available in your computer (try `npm --version` and make sure it work)\n\nStep 3: `run` command `pip install cycai-cnext`\n\nStep 4: `run` command `cnext-init`\n\nStep 5: `run` command `cnext-path`\n\n-   Input `Skywalker folder directory path` and hit `Enter` (Example `C:/Skywalker`)\n\nStep 5 `run` command `cnext-run`\n\n-   Web application will launch at : `http://localhost:CLIENT_PORT` or `http://127.0.0.1:CLIENT_PORT/`\n-   Stop application: `Ctrl + c | Command + c`\n-   Note: Pay attention at `CLIENT_PORT`, and `SERVER_PORT` in `.env` file (you will have to change these ports if you already use them on your machine)\n\n<!-- ## Comments\n\nQuoc Tran - Principal Data Scientist - Walmart Lab\n\n> Save the deployment time: our sientist usually develop the model on python\n> notebook, then transfer the final model to software engineers to make the code\n> ready for deployment. This step is time-comuming and sometimes a bottleneck\n> when the engineers are to busy or can not replicate the same results as in the notebook.\n> Cnext helps eliminate this step since the code is deployment-ready.\n> We have an internal team to try to automate this step but so far the results are limited.\n\n> CNext also has helped speed up the data discovery step since we can conveniently\n> see all the data with different formats in the same place together with just the same\n> common slice and dice techniques that our scientists are very famiilar with.\n\n> Save time in parameter tuning and model output evaluation: for classification tasks,\n> most of our training time is used at parameter tuning and evaluating the model\n> output in underperformed classes. CNext has heled save a lot of time here since\n> we can visualize the result fast after running and can reduce the time in between runs.\n\nXian Fang - Sr.Data Scientist - Roofstock\n\n> Realy like normal coding interface and the intergration with data and models as\n> the firs class citizen. Window layout make it very easy to see data while working on\n> transformation and building model\n\nKarim Filali - Principal Applied Scientist - Microsoft\n\n> CNext addresses a crucial and, in many ways, overlooked aspect of ML development\n> that requires good understanding of the data and detection of any anomalies or patterns\n> indicative of biased collection or insufficient coverage of important phenomena.\n\n> CNext integrated approach helps automate and guide many of the routine operations in\n> a Data Scient pipeline, similar in how modern software engineering tools help with\n> writing code via completion, search functionality, static analysis, common bug detection, profilling, ...\n> Reducing Scientists\' cognitive load in areas involving data preparation, standardized trainning/testing\n> patterns, and hyperparameter search helps them focus on what is truly unique to their ML application.\n\nAnh Dinh - Sr. Manager machine Learning - Zendesk\n\n> CNext is particulary useful fordata scientist on my team to iterate quikly ontheir experiments.\n> Without CNext, the bottleneck in their research workflow is the ability to switch from the data\n> exploration phase to model research phase and back to data exploration seamlessly. By having these two phases fully integrated into a single view, it helps scientists to keep the context and make changes more effectively. If there is\n> VSCode for software engineer, CNext yield potentital for a much needed development environment for data scientists. -->\n\n## License\n\nCYCAI\n\n**Great Software, Hell Yeah!**\n\n[//]: # "These are reference links used in the body of this note and get stripped out when the markdown processor does its job. There is no need to format nicely because it shouldn\'t be seen. Thanks SO - http://stackoverflow.com/questions/4823468/store-comments-in-markdown-syntax"\n[website]: https://cyc-ai.com/\n[docker image]: https://hub.docker.com/r/cycai/cnext\n[overview video]: https://youtu.be/5eWPkQIUfZw\n[cnext]: https://drive.google.com/file/d/1aK0bq5sFVQufth3y66iP1by-gyIwH6t3\n[docker]: https://www.docker.com/products/docker-desktop/\n\n<!--\n# Build a image and update version\ndocker tag [image-name:tag] [new-image-name:new-tag-version]\ndocker login -u [user] -p [password]\ndocker push [new-image-name:new-tag-version] -->\n',
    'author': 'cycai company',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://cyc-ai.com/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '==3.9.7',
}


setup(**setup_kwargs)
