import { JsonMap } from "@iarna/toml";
import { AutoscalingConfiguration } from "./autoscaling-configuration";
import { CacheConfiguration } from "./cache-configuration";
import { DockerConfiguration } from "./docker-configuration";
import { GlobalConfiguration } from "./global-configuration";
import { MachineConfiguration } from "./machine-configuration";
import { RunnerConfiguration } from "./runner-configuration";
/**
 * @stability stable
 */
export interface ConfigurationMapperProps {
    /**
     * @stability stable
     */
    readonly globalConfiguration: GlobalConfiguration;
    /**
     * @stability stable
     */
    readonly runnerConfiguration: RunnerConfiguration;
    /**
     * @stability stable
     */
    readonly dockerConfiguration: DockerConfiguration;
    /**
     * @stability stable
     */
    readonly machineConfiguration: MachineConfiguration;
    /**
     * @stability stable
     */
    readonly autoscalingConfigurations: AutoscalingConfiguration[];
    /**
     * @stability stable
     */
    readonly cacheConfiguration: CacheConfiguration;
}
/**
 * @stability stable
 */
export declare class ConfigurationMapper {
    readonly props: ConfigurationMapperProps;
    /**
     * @stability stable
     */
    static withDefaults(props: ConfigurationMapperProps): ConfigurationMapper;
    /**
     * @stability stable
     */
    static fromProps(props: ConfigurationMapperProps): ConfigurationMapper;
    private constructor();
    /**
     * @stability stable
     */
    toToml(): string;
    /**
     * @internal
     */
    _toJsonMap(): JsonMap;
}
