"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const events = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const targets = require("../../lib");
const path = require("path");
const app = new cdk.App();
class EventStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'Vpc', { maxAzs: 1 });
        const cluster = new ecs.Cluster(this, 'EcsCluster', { vpc });
        cluster.addCapacity('DefaultAutoScalingGroup', {
            instanceType: new ec2.InstanceType('t2.micro')
        });
        /// !show
        // Create a Task Definition for the container to start
        const taskDefinition = new ecs.Ec2TaskDefinition(this, 'TaskDef');
        taskDefinition.addContainer('TheContainer', {
            image: ecs.ContainerImage.fromAsset(path.resolve(__dirname, 'eventhandler-image')),
            memoryLimitMiB: 256,
            logging: new ecs.AwsLogDriver({ streamPrefix: 'EventDemo' })
        });
        // An Rule that describes the event trigger (in this case a scheduled run)
        const rule = new events.Rule(this, 'Rule', {
            schedule: events.Schedule.rate(cdk.Duration.minutes(1)),
        });
        // Use EcsTask as the target of the Rule
        rule.addTarget(new targets.EcsTask({
            cluster,
            taskDefinition,
            taskCount: 1,
            containerOverrides: [{
                    containerName: 'TheContainer',
                    environment: [
                        { name: 'I_WAS_TRIGGERED', value: 'From CloudWatch Events' }
                    ]
                }]
        }));
        /// !hide
    }
}
new EventStack(app, 'aws-ecs-integ-ecs');
app.synth();
//# sourceMappingURL=data:application/json;base64,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