"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codecommit = require("@aws-cdk/aws-codecommit");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const events = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const targets = require("../../lib");
class MockAction {
    constructor(props) {
        this.actionProperties = props;
        this.configuration = props.configuration;
    }
    bind(_scope, _stage, _options) {
        return {
            configuration: this.configuration,
        };
    }
    onStateChange(_name, _target, _options) {
        throw new Error('onStateChange() is not available on MockAction');
    }
}
const app = new cdk.App();
const stack = new cdk.Stack(app, 'pipeline-events');
const repo = new codecommit.Repository(stack, 'Repo', {
    repositoryName: 'TestRepository',
});
const pipeline = new codepipeline.Pipeline(stack, 'pipelinePipeline22F2A91D');
const srcArtifact = new codepipeline.Artifact('Src');
pipeline.addStage({
    stageName: 'Source',
    actions: [new MockAction({
            actionName: 'CodeCommit',
            category: codepipeline.ActionCategory.SOURCE,
            provider: 'CodeCommit',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 1, maxOutputs: 1, },
            configuration: {
                RepositoryName: repo.repositoryName,
                BranchName: 'master',
            },
            outputs: [srcArtifact]
        })]
});
pipeline.addStage({
    stageName: 'Build',
    actions: [new MockAction({
            actionName: 'Hello',
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0, }
        })]
});
new events.Rule(stack, 'rule', {
    schedule: events.Schedule.expression('rate(1 minute)'),
    targets: [new targets.CodePipeline(pipeline)]
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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