"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const batch = require("@aws-cdk/aws-batch");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
const targets = require("../../lib");
test('use aws batch job as an eventrule target', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const jobQueue = new batch.JobQueue(stack, 'MyQueue', {
        computeEnvironments: [
            {
                computeEnvironment: new batch.ComputeEnvironment(stack, 'ComputeEnvironment', {
                    managed: false
                }),
                order: 1
            }
        ]
    });
    const jobDefinition = new batch.JobDefinition(stack, 'MyJob', {
        container: {
            image: aws_ecs_1.ContainerImage.fromRegistry('test-repo')
        }
    });
    const rule = new events.Rule(stack, 'Rule', {
        schedule: events.Schedule.expression('rate(1 min)')
    });
    // WHEN
    rule.addTarget(new targets.BatchJob(jobQueue, jobDefinition));
    // THEN
    assert_1.expect(stack).to(assert_1.haveResource('AWS::Events::Rule', {
        ScheduleExpression: 'rate(1 min)',
        State: 'ENABLED',
        Targets: [
            {
                Arn: {
                    Ref: 'MyQueueE6CA6235'
                },
                Id: 'Target0',
                RoleArn: {
                    'Fn::GetAtt': [
                        'MyJobEventsRoleCF43C336',
                        'Arn'
                    ]
                },
                BatchParameters: {
                    JobDefinition: { Ref: 'MyJob8719E923' },
                    JobName: 'Rule'
                },
            }
        ]
    }));
    assert_1.expect(stack).to(assert_1.haveResource('AWS::IAM::Policy', {
        PolicyDocument: {
            Statement: [
                {
                    Action: 'batch:SubmitJob',
                    Effect: 'Allow',
                    Resource: [
                        { Ref: 'MyJob8719E923' },
                        { Ref: 'MyQueueE6CA6235' }
                    ],
                }
            ],
            Version: '2012-10-17'
        },
        Roles: [
            { Ref: 'MyJobEventsRoleCF43C336' }
        ]
    }));
});
//# sourceMappingURL=data:application/json;base64,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