"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const AWS = require("aws-sdk-mock");
const aws_api_handler_1 = require("../../lib/aws-api-handler");
AWS.setSDK(require.resolve('aws-sdk'));
console.log = jest.fn();
const event = {
    service: 'ECS',
    action: 'updateService',
    parameters: {
        service: 'cool-service',
        forceNewDeployment: true,
    },
};
beforeEach(() => {
    AWS.restore();
});
test('calls the SDK with the right parameters', async () => {
    const updateServiceMock = jest.fn().mockResolvedValue({ success: true });
    AWS.mock('ECS', 'updateService', updateServiceMock);
    await aws_api_handler_1.handler(event);
    expect(updateServiceMock).toHaveBeenCalledWith({
        service: 'cool-service',
        forceNewDeployment: true
    }, expect.any(Function));
    expect(console.log).toHaveBeenLastCalledWith('Response: %j', {
        success: true
    });
});
test('throws and logs in case of error', async () => {
    const updateServiceMock = jest.fn().mockRejectedValue({ code: 'Error' });
    AWS.mock('ECS', 'updateService', updateServiceMock);
    await expect(aws_api_handler_1.handler(event)).rejects.toEqual({ code: 'Error' });
    expect(console.log).toHaveBeenLastCalledWith({ code: 'Error' });
});
test('catches and logs error', async () => {
    const catchEvent = {
        ...event,
        catchErrorPattern: 'Invalid'
    };
    const updateServiceMock = jest.fn().mockRejectedValue({ code: 'Invalid' });
    AWS.mock('ECS', 'updateService', updateServiceMock);
    await aws_api_handler_1.handler(catchEvent);
    expect(console.log).toHaveBeenLastCalledWith({ code: 'Invalid' });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzLWFwaS1oYW5kbGVyLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhd3MtYXBpLWhhbmRsZXIudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUVBLG9DQUFvQztBQUVwQywrREFBb0Q7QUFFcEQsR0FBRyxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7QUFFdkMsT0FBTyxDQUFDLEdBQUcsR0FBRyxJQUFJLENBQUMsRUFBRSxFQUFFLENBQUM7QUFFeEIsTUFBTSxLQUFLLEdBQWdCO0lBQ3pCLE9BQU8sRUFBRSxLQUFLO0lBQ2QsTUFBTSxFQUFFLGVBQWU7SUFDdkIsVUFBVSxFQUFFO1FBQ1YsT0FBTyxFQUFFLGNBQWM7UUFDdkIsa0JBQWtCLEVBQUUsSUFBSTtLQUNPO0NBQ2xDLENBQUM7QUFFRixVQUFVLENBQUMsR0FBRyxFQUFFO0lBQ2QsR0FBRyxDQUFDLE9BQU8sRUFBRSxDQUFDO0FBQ2hCLENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLHlDQUF5QyxFQUFFLEtBQUssSUFBSSxFQUFFO0lBQ3pELE1BQU0saUJBQWlCLEdBQUcsSUFBSSxDQUFDLEVBQUUsRUFBRSxDQUFDLGlCQUFpQixDQUFDLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7SUFFekUsR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsZUFBZSxFQUFFLGlCQUFpQixDQUFDLENBQUM7SUFFcEQsTUFBTSx5QkFBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBRXJCLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLG9CQUFvQixDQUFDO1FBQzdDLE9BQU8sRUFBRSxjQUFjO1FBQ3ZCLGtCQUFrQixFQUFFLElBQUk7S0FDekIsRUFBRSxNQUFNLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFFekIsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyx3QkFBd0IsQ0FBQyxjQUFjLEVBQUU7UUFDM0QsT0FBTyxFQUFFLElBQUk7S0FDZCxDQUFDLENBQUM7QUFDTCxDQUFDLENBQUMsQ0FBQztBQUVILElBQUksQ0FBQyxrQ0FBa0MsRUFBRSxLQUFLLElBQUksRUFBRTtJQUNsRCxNQUFNLGlCQUFpQixHQUFHLElBQUksQ0FBQyxFQUFFLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUUsQ0FBQyxDQUFDO0lBRXpFLEdBQUcsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLGVBQWUsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0lBRXBELE1BQU0sTUFBTSxDQUFDLHlCQUFPLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUM7SUFFaEUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyx3QkFBd0IsQ0FBQyxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUMsQ0FBQyxDQUFDO0FBQ2pFLENBQUMsQ0FBQyxDQUFDO0FBRUgsSUFBSSxDQUFDLHdCQUF3QixFQUFFLEtBQUssSUFBSSxFQUFFO0lBQ3hDLE1BQU0sVUFBVSxHQUFnQjtRQUM5QixHQUFHLEtBQUs7UUFDUixpQkFBaUIsRUFBRSxTQUFTO0tBQzdCLENBQUM7SUFFRixNQUFNLGlCQUFpQixHQUFHLElBQUksQ0FBQyxFQUFFLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDO0lBRTNFLEdBQUcsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLGVBQWUsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO0lBRXBELE1BQU0seUJBQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUUxQixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLHdCQUF3QixDQUFDLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBQyxDQUFDLENBQUM7QUFDbkUsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyB0c2xpbnQ6ZGlzYWJsZTpuby1jb25zb2xlXG5pbXBvcnQgKiBhcyBTREsgZnJvbSAnYXdzLXNkayc7XG5pbXBvcnQgKiBhcyBBV1MgZnJvbSAnYXdzLXNkay1tb2NrJztcbmltcG9ydCB7IEF3c0FwaVByb3BzIH0gZnJvbSAnLi4vLi4vbGliJztcbmltcG9ydCB7IGhhbmRsZXIgfSBmcm9tICcuLi8uLi9saWIvYXdzLWFwaS1oYW5kbGVyJztcblxuQVdTLnNldFNESyhyZXF1aXJlLnJlc29sdmUoJ2F3cy1zZGsnKSk7XG5cbmNvbnNvbGUubG9nID0gamVzdC5mbigpO1xuXG5jb25zdCBldmVudDogQXdzQXBpUHJvcHMgPSB7XG4gIHNlcnZpY2U6ICdFQ1MnLFxuICBhY3Rpb246ICd1cGRhdGVTZXJ2aWNlJyxcbiAgcGFyYW1ldGVyczoge1xuICAgIHNlcnZpY2U6ICdjb29sLXNlcnZpY2UnLFxuICAgIGZvcmNlTmV3RGVwbG95bWVudDogdHJ1ZSxcbiAgfSBhcyBTREsuRUNTLlVwZGF0ZVNlcnZpY2VSZXF1ZXN0LFxufTtcblxuYmVmb3JlRWFjaCgoKSA9PiB7XG4gIEFXUy5yZXN0b3JlKCk7XG59KTtcblxudGVzdCgnY2FsbHMgdGhlIFNESyB3aXRoIHRoZSByaWdodCBwYXJhbWV0ZXJzJywgYXN5bmMgKCkgPT4ge1xuICBjb25zdCB1cGRhdGVTZXJ2aWNlTW9jayA9IGplc3QuZm4oKS5tb2NrUmVzb2x2ZWRWYWx1ZSh7IHN1Y2Nlc3M6IHRydWUgfSk7XG5cbiAgQVdTLm1vY2soJ0VDUycsICd1cGRhdGVTZXJ2aWNlJywgdXBkYXRlU2VydmljZU1vY2spO1xuXG4gIGF3YWl0IGhhbmRsZXIoZXZlbnQpO1xuXG4gIGV4cGVjdCh1cGRhdGVTZXJ2aWNlTW9jaykudG9IYXZlQmVlbkNhbGxlZFdpdGgoe1xuICAgIHNlcnZpY2U6ICdjb29sLXNlcnZpY2UnLFxuICAgIGZvcmNlTmV3RGVwbG95bWVudDogdHJ1ZVxuICB9LCBleHBlY3QuYW55KEZ1bmN0aW9uKSk7XG5cbiAgZXhwZWN0KGNvbnNvbGUubG9nKS50b0hhdmVCZWVuTGFzdENhbGxlZFdpdGgoJ1Jlc3BvbnNlOiAlaicsIHtcbiAgICBzdWNjZXNzOiB0cnVlXG4gIH0pO1xufSk7XG5cbnRlc3QoJ3Rocm93cyBhbmQgbG9ncyBpbiBjYXNlIG9mIGVycm9yJywgYXN5bmMgKCkgPT4ge1xuICBjb25zdCB1cGRhdGVTZXJ2aWNlTW9jayA9IGplc3QuZm4oKS5tb2NrUmVqZWN0ZWRWYWx1ZSh7IGNvZGU6ICdFcnJvcicgfSk7XG5cbiAgQVdTLm1vY2soJ0VDUycsICd1cGRhdGVTZXJ2aWNlJywgdXBkYXRlU2VydmljZU1vY2spO1xuXG4gIGF3YWl0IGV4cGVjdChoYW5kbGVyKGV2ZW50KSkucmVqZWN0cy50b0VxdWFsKHsgY29kZTogJ0Vycm9yJyB9KTtcblxuICBleHBlY3QoY29uc29sZS5sb2cpLnRvSGF2ZUJlZW5MYXN0Q2FsbGVkV2l0aCh7IGNvZGU6ICdFcnJvcid9KTtcbn0pO1xuXG50ZXN0KCdjYXRjaGVzIGFuZCBsb2dzIGVycm9yJywgYXN5bmMgKCkgPT4ge1xuICBjb25zdCBjYXRjaEV2ZW50OiBBd3NBcGlQcm9wcyA9IHtcbiAgICAuLi5ldmVudCxcbiAgICBjYXRjaEVycm9yUGF0dGVybjogJ0ludmFsaWQnXG4gIH07XG5cbiAgY29uc3QgdXBkYXRlU2VydmljZU1vY2sgPSBqZXN0LmZuKCkubW9ja1JlamVjdGVkVmFsdWUoeyBjb2RlOiAnSW52YWxpZCcgfSk7XG5cbiAgQVdTLm1vY2soJ0VDUycsICd1cGRhdGVTZXJ2aWNlJywgdXBkYXRlU2VydmljZU1vY2spO1xuXG4gIGF3YWl0IGhhbmRsZXIoY2F0Y2hFdmVudCk7XG5cbiAgZXhwZWN0KGNvbnNvbGUubG9nKS50b0hhdmVCZWVuTGFzdENhbGxlZFdpdGgoeyBjb2RlOiAnSW52YWxpZCd9KTtcbn0pO1xuIl19