import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as events from '@aws-cdk/aws-events';
import { ContainerOverride } from './ecs-task-properties';
/**
 * Properties to define an ECS Event Task
 */
export interface EcsTaskProps {
    /**
     * Cluster where service will be deployed
     */
    readonly cluster: ecs.ICluster;
    /**
     * Task Definition of the task that should be started
     */
    readonly taskDefinition: ecs.TaskDefinition;
    /**
     * How many tasks should be started when this event is triggered
     *
     * @default 1
     */
    readonly taskCount?: number;
    /**
     * Container setting overrides
     *
     * Key is the name of the container to override, value is the
     * values you want to override.
     */
    readonly containerOverrides?: ContainerOverride[];
    /**
     * In what subnets to place the task's ENIs
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default Private subnets
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Existing security group to use for the task's ENIs
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default A new security group is created
     */
    readonly securityGroup?: ec2.ISecurityGroup;
}
/**
 * Start a task on an ECS cluster
 */
export declare class EcsTask implements events.IRuleTarget {
    private readonly props;
    readonly securityGroup?: ec2.ISecurityGroup;
    private readonly cluster;
    private readonly taskDefinition;
    private readonly taskCount;
    constructor(props: EcsTaskProps);
    /**
     * Allows using tasks as target of CloudWatch events
     */
    bind(_rule: events.IRule, _id?: string): events.RuleTargetConfig;
}
