"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Allows the pipeline to be used as a CloudWatch event rule target.
 */
class CodePipeline {
    constructor(pipeline, options = {}) {
        this.pipeline = pipeline;
        this.options = options;
    }
    bind(_rule, _id) {
        return {
            id: '',
            arn: this.pipeline.pipelineArn,
            role: this.options.eventRole || util_1.singletonEventRole(this.pipeline, [new iam.PolicyStatement({
                    resources: [this.pipeline.pipelineArn],
                    actions: ['codepipeline:StartPipelineExecution'],
                })]),
            targetResource: this.pipeline,
        };
    }
}
exports.CodePipeline = CodePipeline;
//# sourceMappingURL=data:application/json;base64,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