"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const util_1 = require("./util");
/**
 * Use an AWS Batch Job / Queue as an event rule target.
 * @experimental
 */
class BatchJob {
    constructor(jobQueue, jobDefinition, props = {}) {
        this.jobQueue = jobQueue;
        this.jobDefinition = jobDefinition;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a
     * result from a CloudWatch event.
     */
    bind(rule, _id) {
        var _a;
        const batchParameters = {
            jobDefinition: this.jobDefinition.jobDefinitionArn,
            jobName: (_a = this.props.jobName) !== null && _a !== void 0 ? _a : rule.node.uniqueId,
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            id: '',
            arn: this.jobQueue.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinition, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinition.jobDefinitionArn,
                        this.jobQueue.jobQueueArn,
                    ]
                })
            ]),
            input: this.props.event,
            targetResource: this.jobQueue,
            batchParameters
        };
    }
}
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,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