from typing import Any, Dict, List, Optional, Union

import httpx

from ...client import Client
from ...models.maybe_create_projects_and_import_models_from_archive_multipart_data import (
    MaybeCreateProjectsAndImportModelsFromArchiveMultipartData,
)
from ...models.project_status import ProjectStatus
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    client: Client,
    multipart_data: MaybeCreateProjectsAndImportModelsFromArchiveMultipartData,
    group_name: Union[Unset, None, str] = UNSET,
    reuse_project_name: Union[Unset, None, bool] = False,
    project_name: Union[Unset, None, str] = UNSET,
    project_label: Union[Unset, None, str] = UNSET,
) -> Dict[str, Any]:
    url = "{}/projects/_import_models".format(client.base_url)

    headers: Dict[str, Any] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    params: Dict[str, Any] = {
        "groupName": group_name,
        "reuseProjectName": reuse_project_name,
        "projectName": project_name,
        "projectLabel": project_label,
    }
    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    multipart_multipart_data = multipart_data.to_multipart()

    return {
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "files": multipart_multipart_data,
        "params": params,
    }


def _parse_response(*, response: httpx.Response) -> Optional[List[ProjectStatus]]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for componentsschemas_project_status_array_item_data in _response_200:
            componentsschemas_project_status_array_item = ProjectStatus.from_dict(
                componentsschemas_project_status_array_item_data
            )

            response_200.append(componentsschemas_project_status_array_item)

        return response_200
    return None


def _build_response(*, response: httpx.Response) -> Response[List[ProjectStatus]]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    client: Client,
    multipart_data: MaybeCreateProjectsAndImportModelsFromArchiveMultipartData,
    group_name: Union[Unset, None, str] = UNSET,
    reuse_project_name: Union[Unset, None, bool] = False,
    project_name: Union[Unset, None, str] = UNSET,
    project_label: Union[Unset, None, str] = UNSET,
) -> Response[List[ProjectStatus]]:
    kwargs = _get_kwargs(
        client=client,
        multipart_data=multipart_data,
        group_name=group_name,
        reuse_project_name=reuse_project_name,
        project_name=project_name,
        project_label=project_label,
    )

    response = httpx.post(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(response=response)


def sync(
    *,
    client: Client,
    multipart_data: MaybeCreateProjectsAndImportModelsFromArchiveMultipartData,
    group_name: Union[Unset, None, str] = UNSET,
    reuse_project_name: Union[Unset, None, bool] = False,
    project_name: Union[Unset, None, str] = UNSET,
    project_label: Union[Unset, None, str] = UNSET,
) -> Optional[List[ProjectStatus]]:
    """ """

    return sync_detailed(
        client=client,
        multipart_data=multipart_data,
        group_name=group_name,
        reuse_project_name=reuse_project_name,
        project_name=project_name,
        project_label=project_label,
    ).parsed


async def asyncio_detailed(
    *,
    client: Client,
    multipart_data: MaybeCreateProjectsAndImportModelsFromArchiveMultipartData,
    group_name: Union[Unset, None, str] = UNSET,
    reuse_project_name: Union[Unset, None, bool] = False,
    project_name: Union[Unset, None, str] = UNSET,
    project_label: Union[Unset, None, str] = UNSET,
) -> Response[List[ProjectStatus]]:
    kwargs = _get_kwargs(
        client=client,
        multipart_data=multipart_data,
        group_name=group_name,
        reuse_project_name=reuse_project_name,
        project_name=project_name,
        project_label=project_label,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.post(**kwargs)

    return _build_response(response=response)


async def asyncio(
    *,
    client: Client,
    multipart_data: MaybeCreateProjectsAndImportModelsFromArchiveMultipartData,
    group_name: Union[Unset, None, str] = UNSET,
    reuse_project_name: Union[Unset, None, bool] = False,
    project_name: Union[Unset, None, str] = UNSET,
    project_label: Union[Unset, None, str] = UNSET,
) -> Optional[List[ProjectStatus]]:
    """ """

    return (
        await asyncio_detailed(
            client=client,
            multipart_data=multipart_data,
            group_name=group_name,
            reuse_project_name=reuse_project_name,
            project_name=project_name,
            project_label=project_label,
        )
    ).parsed
