"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QXmlItem(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlitem.html

    **Detailed Description**

    In **XQuery** , all expressions evaluate to a sequence of items, where each
    item is either an XML node or an atomic value. The query in the following
    snippet evaluates to sequence of five items.

    <aNode/>,
        xs:base64Binary("FFFF"),
        current-date(),
        3e3, (: A
    floating point value :)
        attribute {"name"} {()}

    The five items are: An element, an atomic value (binary data encoded in
    base64), a date, a float, and an attribute.

    QXmlItem is the class that represents these **XQuery**  items in the Qt XML
    Patterns API. A non-null instance of QXmlItem is either a node or an atomic
    value. Calling **isNode** () or **isAtomicValue** () tells you which it is.
    Atomic values are represented elsewhere in the Qt API as instances of
    **QVariant** , and an instance of QXmlItem that represents an atomic value
    can be converted to a **QVariant**  by calling **toAtomicValue** (). A
    QXmlItem that wraps a node is represented elsewhere as an instance of
    **QXmlNodeModelIndex** . A node QXmlItem can be converted to a
    **QXmlNodeModelIndex**  by calling **toNodeModelIndex** ().

    A default constructed QXmlItem instance is neither a node nor an atomic
    value. It is considered null, in which case **isNull** () returns true.

    An instance of QXmlItem will be left dangling if the **XML node model**  it
    refers to is deleted, if it is a **QXmlNodeModelIndex** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#QXmlItem

        **QXmlItem::QXmlItem()**

        Constructs a null QXmlItem that is neither a node nor an atomic value.
        **isNull** () returns true for a default constructed instance.
        """
        ...

    @typing.overload
    def __init__(self, other: "QXmlItem") -> None:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#QXmlItem-1

        **QXmlItem::QXmlItem(const QXmlItem & other )**

        The copy constructor constructs a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, node: QXmlNodeModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#QXmlItem-2

        **QXmlItem::QXmlItem(const QXmlNodeModelIndex & node )**

        Constructs a node QXmlItem that is a copy of **node**.

        **See also** **isNode** ().
        """
        ...

    @typing.overload
    def __init__(self, atomicValue: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#QXmlItem-3

        **QXmlItem::QXmlItem(const QVariant & atomicValue )**

        Constructs an atomic value QXmlItem with **atomicValue**.

        **See also** **isAtomicValue** ().
        """
        ...

    def toNodeModelIndex(self) -> QXmlNodeModelIndex:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#toNodeModelIndex

        **QXmlNodeModelIndex QXmlItem::toNodeModelIndex() const**

        If this **QXmlItem**  represents a node, it returns the item as a
        **QXmlNodeModelIndex** . If this **QXmlItem**  is not a node, the return
        value is undefined. You can call **isNode** () to test whether the item
        is a node.

        **See also** **isNode** ().
        """
        ...

    def toAtomicValue(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#toAtomicValue

        **QVariant QXmlItem::toAtomicValue() const**

        If this **QXmlItem**  represents an atomic value, it is converted to an
        appropriate **QVariant**  and returned. If this **QXmlItem**  is not an
        atomic value, the return value is a default constructed **QVariant** .
        You can call **isAtomicValue** () to test whether the item is an atomic
        value.

        **See also** **isAtomicValue** ().
        """
        ...

    def isAtomicValue(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#isAtomicValue

        **bool QXmlItem::isAtomicValue() const**

        Returns true if this item is an atomic value. Returns false if it is a
        node or null.

        **See also** **isNull** () and **isNode** ().
        """
        ...

    def isNode(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#isNode

        **bool QXmlItem::isNode() const**

        Returns true if this item is a Node. Returns false if it is an atomic
        value or null.

        **See also** **isNull** () and **isAtomicValue** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlitem.html#isNull

        **bool QXmlItem::isNull() const**

        Returns true if this **QXmlItem**  is neither a node nor an atomic
        value. Default constructed instances of **QXmlItem**  are null.
        """
        ...
