"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtXml import *


class QXmlSimpleReader(QXmlReader):
    """
    https://doc.qt.io/qt-5/qxmlsimplereader.html

    **Detailed Description**

    This XML reader is suitable for a wide range of applications. It is able to
    parse well-formed XML and can report the namespaces of elements to a content
    handler; however, it does not parse any external entities. For historical
    reasons, Attribute Value Normalization and End-of-Line Handling as described
    in the XML 1.0 specification is not performed.

    The easiest pattern of use for this class is to create a reader instance,
    define an input source, specify the handlers to be used by the reader, and
    parse the data.

    For example, we could use a **QFile**  to supply the input. Here, we create
    a reader, and define an input source to be used by the reader:

    **QXmlSimpleReader**  xmlReader;
            **QXmlInputSource**  *source = new
    **QXmlInputSource** (file);

    A handler lets us perform actions when the reader encounters certain types
    of content, or if errors in the input are found. The reader must be told
    which handler to use for each type of event. For many common applications,
    we can create a custom handler by subclassing **QXmlDefaultHandler** , and
    use this to handle both error and content events:

    Handler *handler = new Handler;
    xmlReader.setContentHandler(handler);
    xmlReader.setErrorHandler(handler);

    If you don't set at least the content and error handlers, the parser will
    fall back on its default behavior---and will do nothing.

    The most convenient way to handle the input is to read it in a single pass
    using the **parse** () function with an argument that specifies the input
    source:

    bool ok = xmlReader.parse(source);

            if (!ok)
    std::cout << "Parsing failed." << std::endl;

    If you can't parse the entire input in one go (for example, it is huge, or
    is being delivered over a network connection), data can be fed to the parser
    in pieces. This is achieved by telling **parse** () to work incrementally,
    and making subsequent calls to the **parseContinue** () function, until all
    the data has been processed.

    A common way to perform incremental parsing is to connect the `readyRead()`
    signal of a **network reply**  a slot, and handle the incoming data there.
    See **QNetworkAccessManager** .

    Aspects of the parsing behavior can be adapted using **setFeature** () and
    **setProperty** ().

    xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes",
    true);

    QXmlSimpleReader is not reentrant. If you want to use the class in threaded
    code, lock the code using QXmlSimpleReader with a locking mechanism, such as
    a **QMutex** .

    Note that this class is now deprecated, please use **QXmlStreamReader**  or
    **QDomDocument**  for reading XML files.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#QXmlSimpleReader

        **QXmlSimpleReader::QXmlSimpleReader()**

        Constructs a simple XML reader.
        """
        ...

    def parseContinue(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#parseContinue

        **[virtual] bool QXmlSimpleReader::parseContinue()**

        Continues incremental parsing, taking input from the QXmlInputSource
        that was specified with the most recent call to **parse** (). To use
        this function, you **must** have called **parse** () with the
        incremental argument set to true.

        Returns `false` if a parsing error occurs; otherwise returns `true`,
        even if the end of the XML file has not been reached. You can continue
        parsing at a later stage by calling this function again when there is
        more data available to parse.

        Calling this function when there is no data available in the input
        source indicates to the reader that the end of the XML file has been
        reached. If the input supplied up to this point was not well-formed then
        a parsing error occurs, and false is returned. If the input supplied was
        well-formed, true is returned. It is important to end the input in this
        way because it allows you to reuse the reader to parse other XML files.

        Calling this function after the end of file has been reached, but
        without available data will cause false to be returned whether the
        previous input was well-formed or not.

        **See also** **parse** (), **QXmlInputSource::data** (), and
        **QXmlInputSource::next** ().
        """
        ...

    @typing.overload
    def parse(self, input: QXmlInputSource) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#parse

        **[override virtual] bool QXmlSimpleReader::parse(const QXmlInputSource
        & input )**

        Reimplements: **QXmlReader::parse** (const QXmlInputSource &input).
        """
        ...

    @typing.overload
    def parse(self, input: QXmlInputSource, incremental: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#parse-1

        **[override virtual] bool QXmlSimpleReader::parse(const QXmlInputSource
        * input )**

        Reimplements: **QXmlReader::parse** (const QXmlInputSource *input).

        Reads an XML document from **input** and parses it in one pass (non-
        incrementally). Returns `true` if the parsing was successful; otherwise
        returns `false`.
        """
        ...

    def declHandler(self) -> "QXmlDeclHandler":
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#declHandler

        **[override virtual] QXmlDeclHandler *QXmlSimpleReader::declHandler()
        const**

        Reimplements: **QXmlReader::declHandler** () const.

        **See also** **setDeclHandler** ().
        """
        ...

    def setDeclHandler(self, handler: "QXmlDeclHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#setDeclHandler

        **[override virtual] void
        QXmlSimpleReader::setDeclHandler(QXmlDeclHandler * handler )**

        Reimplements: **QXmlReader::setDeclHandler** (QXmlDeclHandler *handler).

        **See also** **declHandler** ().
        """
        ...

    def lexicalHandler(self) -> "QXmlLexicalHandler":
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#lexicalHandler

        **[override virtual] QXmlLexicalHandler
        *QXmlSimpleReader::lexicalHandler() const**

        Reimplements: **QXmlReader::lexicalHandler** () const.

        **See also** **setLexicalHandler** ().
        """
        ...

    def setLexicalHandler(self, handler: "QXmlLexicalHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#setLexicalHandler

        **[override virtual] void
        QXmlSimpleReader::setLexicalHandler(QXmlLexicalHandler * handler )**

        Reimplements: **QXmlReader::setLexicalHandler** (QXmlLexicalHandler
        *handler).

        **See also** **lexicalHandler** ().
        """
        ...

    def errorHandler(self) -> "QXmlErrorHandler":
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#errorHandler

        **[override virtual] QXmlErrorHandler *QXmlSimpleReader::errorHandler()
        const**

        Reimplements: **QXmlReader::errorHandler** () const.

        **See also** **setErrorHandler** ().
        """
        ...

    def setErrorHandler(self, handler: "QXmlErrorHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#setErrorHandler

        **[override virtual] void
        QXmlSimpleReader::setErrorHandler(QXmlErrorHandler * handler )**

        Reimplements: **QXmlReader::setErrorHandler** (QXmlErrorHandler
        *handler).

        **See also** **errorHandler** ().
        """
        ...

    def contentHandler(self) -> "QXmlContentHandler":
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#contentHandler

        **[override virtual] QXmlContentHandler
        *QXmlSimpleReader::contentHandler() const**

        Reimplements: **QXmlReader::contentHandler** () const.

        **See also** **setContentHandler** ().
        """
        ...

    def setContentHandler(self, handler: "QXmlContentHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#setContentHandler

        **[override virtual] void
        QXmlSimpleReader::setContentHandler(QXmlContentHandler * handler )**

        Reimplements: **QXmlReader::setContentHandler** (QXmlContentHandler
        *handler).

        **See also** **contentHandler** ().
        """
        ...

    def DTDHandler(self) -> "QXmlDTDHandler":
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#DTDHandler

        **[override virtual] QXmlDTDHandler *QXmlSimpleReader::DTDHandler()
        const**

        Reimplements: **QXmlReader::DTDHandler** () const.

        **See also** **setDTDHandler** ().
        """
        ...

    def setDTDHandler(self, handler: "QXmlDTDHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#setDTDHandler

        **[override virtual] void QXmlSimpleReader::setDTDHandler(QXmlDTDHandler
        * handler )**

        Reimplements: **QXmlReader::setDTDHandler** (QXmlDTDHandler *handler).
        """
        ...

    def entityResolver(self) -> "QXmlEntityResolver":
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#entityResolver

        **[override virtual] QXmlEntityResolver
        *QXmlSimpleReader::entityResolver() const**

        Reimplements: **QXmlReader::entityResolver** () const.

        **See also** **setEntityResolver** ().
        """
        ...

    def setEntityResolver(self, handler: "QXmlEntityResolver") -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#setEntityResolver

        **[override virtual] void
        QXmlSimpleReader::setEntityResolver(QXmlEntityResolver * handler )**

        Reimplements: **QXmlReader::setEntityResolver** (QXmlEntityResolver
        *handler).

        **See also** **entityResolver** ().
        """
        ...

    def hasProperty(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#hasProperty

        **[override virtual] bool QXmlSimpleReader::hasProperty(const QString &
        name ) const**

        Reimplements: **QXmlReader::hasProperty** (const QString &name) const.
        """
        ...

    def setProperty(self, name: str, value: PyQt5.sip.voidptr) -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#setProperty

        **[override virtual] void QXmlSimpleReader::setProperty(const QString &
        name , void * value )**

        Reimplements: **QXmlReader::setProperty** (const QString &name, void
        *value).

        **See also** **property** ().
        """
        ...

    def property(self, name: str) -> typing.Tuple[PyQt5.sip.voidptr, bool]:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#property

        **[override virtual] void *QXmlSimpleReader::property(const QString &
        name , bool * ok = nullptr) const**

        Reimplements: **QXmlReader::property** (const QString &name, bool *ok)
        const.

        **See also** **setProperty** ().
        """
        ...

    def hasFeature(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#hasFeature

        **[override virtual] bool QXmlSimpleReader::hasFeature(const QString &
        name ) const**

        Reimplements: **QXmlReader::hasFeature** (const QString &name) const.
        """
        ...

    def setFeature(self, name: str, value: bool) -> None:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#setFeature

        **[override virtual] void QXmlSimpleReader::setFeature(const QString &
        name , bool enable )**

        Reimplements: **QXmlReader::setFeature** (const QString &name, bool
        value).

        Turns on the feature **name** if **enable** is true; otherwise turns it
        off.

        The **name** parameter must be one of the following strings:

        FeatureDefaultNotes
        **http://xml.org/sax/features/namespaces** trueIf
        enabled, namespaces are reported to the content handler.
        **http://xml.org/sax/features/namespace-prefixes** falseIf enabled, the
        original prefixed names and attributes used for namespace declarations
        are reported.
        **http://qt-project.org/xml/features/report-whitespace-
        only-CharData** trueIf enabled, CharData that consist of only whitespace
        characters are reported using **QXmlContentHandler::characters** (). If
        disabled, whitespace is silently discarded.
        **http://qt-
        project.org/xml/features/report-start-end-entity** falseIf enabled, the
        parser reports QXmlContentHandler::startEntity() and
        QXmlContentHandler::endEntity() events, so character data might be
        reported in chunks. If disabled, the parser does not report these
        events, but silently substitutes the entities, and reports the character
        data in one chunk.

        **See also** **feature** (), **hasFeature** (), and SAX2 Features.
        """
        ...

    def feature(self, name: str) -> typing.Tuple[bool, bool]:
        """
        https://doc.qt.io/qt-5/qxmlsimplereader.html#feature

        **[override virtual] bool QXmlSimpleReader::feature(const QString & name
        , bool * ok = nullptr) const**

        Reimplements: **QXmlReader::feature** (const QString &name, bool *ok)
        const.

        **See also** **setFeature** ().
        """
        ...
