"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtWinExtras import *


class QWinThumbnailToolBar(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html

    **Detailed Description**

    Applications can embed a toolbar in the thumbnail of a window, which is
    shown when hovering over its taskbar icon. A thumbnail toolbar may provide
    quick access to the commands of a window without requiring the user to
    restore or activate the window.

    ![Media player thumbnail toolbar](images/thumbbar.png)

    The following example code illustrates how to use the functions in the
    QWinThumbnailToolBar and **QWinThumbnailToolButton**  class to implement a
    thumbnail toolbar:

    **QWinThumbnailToolBar**  *thumbbar = new **QWinThumbnailToolBar** (widget);
    thumbbar->setWindow(widget->windowHandle());
    **QWinThumbnailToolButton**  *settings = new **QWinThumbnailToolButton**
    (thumbbar);
            settings->setToolTip("Settings");
    settings->setIcon(":/settings.png");
    settings->setDismissOnClick(true);
            connect(settings,
    SIGNAL(clicked()), settingsPage, SLOT(show()));
    **QWinThumbnailToolButton**  *playPause = new **QWinThumbnailToolButton**
    (thumbbar);
            playPause->setToolTip("Play/Pause");
    playPause->setIcon(":/play.png");
            connect(playPause,
    SIGNAL(clicked()), mediaPlayer, SLOT(play()));
    thumbbar->addButton(settings);
            thumbbar->addButton(playPause);

    **See also** **QWinThumbnailToolButton** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#QWinThumbnailToolBar

        **QWinThumbnailToolBar::QWinThumbnailToolBar(QObject * parent =
        nullptr)**

        Constructs a QWinThumbnailToolBar with the specified **parent**.

        If **parent** is an instance of **QWindow** , it is automatically
        assigned as the thumbnail toolbar's **window** .
        """
        ...

    def setIconicLivePreviewPixmap(self, a0: QtGui.QPixmap) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#iconicLivePreviewPixmap
        -prop

        **iconicLivePreviewPixmap : QPixmap**

        This property holds the pixmap for use as a live (peek) preview when
        tabbing into the application

        This property was introduced in Qt 5.4.

        **Access functions:**

        QPixmap **iconicLivePreviewPixmap** () const
        void
        **setIconicLivePreviewPixmap** ( **const QPixmap &**)
        """
        ...

    def setIconicThumbnailPixmap(self, a0: QtGui.QPixmap) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#iconicThumbnailPixmap-
        prop

        **iconicThumbnailPixmap : QPixmap**

        This property holds the pixmap for use as a thumbnail representation

        This property was introduced in Qt 5.4.

        **Access functions:**

        QPixmap **iconicThumbnailPixmap** () const
        void
        **setIconicThumbnailPixmap** ( **const QPixmap &**)

        **See also** **QWinThumbnailToolBar::iconicPixmapNotificationsEnabled**
        .
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#clear

        **[slot] void QWinThumbnailToolBar::clear()**

        Removes all buttons from the thumbnail toolbar.
        """
        ...

    def iconicLivePreviewPixmap(self) -> QtGui.QPixmap:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#iconicLivePreviewPixmap
        -prop

        **iconicLivePreviewPixmap : QPixmap**

        This property holds the pixmap for use as a live (peek) preview when
        tabbing into the application

        This property was introduced in Qt 5.4.

        **Access functions:**

        QPixmap **iconicLivePreviewPixmap** () const
        void
        **setIconicLivePreviewPixmap** ( **const QPixmap &**)
        """
        ...

    def iconicThumbnailPixmap(self) -> QtGui.QPixmap:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#iconicThumbnailPixmap-
        prop

        **iconicThumbnailPixmap : QPixmap**

        This property holds the pixmap for use as a thumbnail representation

        This property was introduced in Qt 5.4.

        **Access functions:**

        QPixmap **iconicThumbnailPixmap** () const
        void
        **setIconicThumbnailPixmap** ( **const QPixmap &**)

        **See also** **QWinThumbnailToolBar::iconicPixmapNotificationsEnabled**
        .
        """
        ...

    def setIconicPixmapNotificationsEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#iconicPixmapNotificatio
        nsEnabled-prop

        **iconicPixmapNotificationsEnabled : bool**

        This property holds whether signals **iconicThumbnailPixmapRequested**
        () and **iconicLivePreviewPixmapRequested** () will be emitted

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **iconicPixmapNotificationsEnabled** () const
        void
        **setIconicPixmapNotificationsEnabled** (bool **enabled** )

        **See also** **QWinThumbnailToolBar::iconicThumbnailPixmap**  and
        **QWinThumbnailToolBar::iconicLivePreviewPixmap** .
        """
        ...

    def iconicPixmapNotificationsEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#iconicPixmapNotificatio
        nsEnabled-prop

        **iconicPixmapNotificationsEnabled : bool**

        This property holds whether signals **iconicThumbnailPixmapRequested**
        () and **iconicLivePreviewPixmapRequested** () will be emitted

        This property was introduced in Qt 5.4.

        **Access functions:**

        bool **iconicPixmapNotificationsEnabled** () const
        void
        **setIconicPixmapNotificationsEnabled** (bool **enabled** )

        **See also** **QWinThumbnailToolBar::iconicThumbnailPixmap**  and
        **QWinThumbnailToolBar::iconicLivePreviewPixmap** .
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#count-prop

        **count : const int**

        This property holds the number of buttons in the thumbnail toolbar

        **Note:** The number of buttons is limited to `7`.

        **Access functions:**

        int **count** () const
        """
        ...

    def buttons(self) -> typing.List["QWinThumbnailToolButton"]:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#buttons

        **QList<QWinThumbnailToolButton *> QWinThumbnailToolBar::buttons()
        const**

        Returns the list of buttons in the thumbnail toolbar.

        **See also** **setButtons** ().
        """
        ...

    def setButtons(self, buttons: typing.Iterable["QWinThumbnailToolButton"]) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#setButtons

        **void QWinThumbnailToolBar::setButtons(const
        QList<QWinThumbnailToolButton *> & buttons )**

        Sets the list of **buttons** in the thumbnail toolbar.

        **Note:** Any existing buttons are replaced.

        **See also** **buttons** ().
        """
        ...

    def removeButton(self, button: "QWinThumbnailToolButton") -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#removeButton

        **void QWinThumbnailToolBar::removeButton(QWinThumbnailToolButton *
        button )**

        Removes the **button** from the thumbnail toolbar.
        """
        ...

    def addButton(self, button: "QWinThumbnailToolButton") -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#addButton

        **void QWinThumbnailToolBar::addButton(QWinThumbnailToolButton * button
        )**

        Adds a **button** to the thumbnail toolbar.

        **Note:** The number of buttons is limited to `7`.
        """
        ...

    def window(self) -> QtGui.QWindow:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#window-prop

        **window : QWindow***

        This property holds the window whose thumbnail toolbar is manipulated

        **Access functions:**

        QWindow * **window** () const
        void **setWindow** (QWindow * **window**
        )

        **Member Function Documentation**
        """
        ...

    def setWindow(self, window: QtGui.QWindow) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#window-prop

        **window : QWindow***

        This property holds the window whose thumbnail toolbar is manipulated

        **Access functions:**

        QWindow * **window** () const
        void **setWindow** (QWindow * **window**
        )

        **Member Function Documentation**
        """
        ...

    @property
    def iconicLivePreviewPixmapRequested(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#iconicLivePreviewPixmap
        Requested

        **[signal] void
        QWinThumbnailToolBar::iconicLivePreviewPixmapRequested()**

        This signal is emitted when the operating system requests a new iconic
        live preview pixmap, typically when the user ALT-tabs to the
        application.

        This function was introduced in Qt 5.4.

        **See also** **iconicLivePreviewPixmap** .
        """
        ...

    @property
    def iconicThumbnailPixmapRequested(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbar.html#iconicThumbnailPixmapRe
        quested

        **[signal] void QWinThumbnailToolBar::iconicThumbnailPixmapRequested()**

        This signal is emitted when the operating system requests a new iconic
        thumbnail pixmap, typically when the thumbnail is shown.

        This function was introduced in Qt 5.4.

        **See also** **iconicThumbnailPixmap** .
        """
        ...
