"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtWinExtras import *


class QWinJumpListCategory(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qwinjumplistcategory.html

    **Detailed Description**
    """

    class Type(int):
        Custom: QWinJumpListCategory = ...
        Recent: QWinJumpListCategory = ...
        Frequent: QWinJumpListCategory = ...
        Tasks: QWinJumpListCategory = ...

    def __init__(self, title: str = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#QWinJumpListCategory

        **QWinJumpListCategory::QWinJumpListCategory(const QString & title =
        QString())**

        Constructs a custom QWinJumpListCategory with the specified **title**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#clear

        **void QWinJumpListCategory::clear()**

        Clears the category.
        """
        ...

    def addSeparator(self) -> "QWinJumpListItem":
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#addSeparator

        **QWinJumpListItem *QWinJumpListCategory::addSeparator()**

        Adds a separator to the category.

        **Note:** Only tasks category supports separators.
        """
        ...

    @typing.overload
    def addLink(
        self, title: str, executablePath: str, arguments: typing.Iterable[str] = ...
    ) -> "QWinJumpListItem":
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#addLink

        **QWinJumpListItem *QWinJumpListCategory::addLink(const QString & title
        , const QString & executablePath , const QStringList & arguments =
        QStringList())**

        Adds a link to the category using **title** , **executablePath** , and
        optionally **arguments**.
        """
        ...

    @typing.overload
    def addLink(
        self,
        icon: QtGui.QIcon,
        title: str,
        executablePath: str,
        arguments: typing.Iterable[str] = ...,
    ) -> "QWinJumpListItem":
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#addLink-1

        **QWinJumpListItem *QWinJumpListCategory::addLink(const QIcon & icon ,
        const QString & title , const QString & executablePath , const
        QStringList & arguments = QStringList())**

        This function overloads addLink().

        Adds a link to the category using **icon** , **title** ,
        **executablePath** , and optionally **arguments**.
        """
        ...

    def addDestination(self, filePath: str) -> "QWinJumpListItem":
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#addDestination

        **QWinJumpListItem *QWinJumpListCategory::addDestination(const QString &
        filePath )**

        Adds a destination to the category pointing to **filePath**.
        """
        ...

    def addItem(self, item: "QWinJumpListItem") -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#addItem

        **void QWinJumpListCategory::addItem(QWinJumpListItem * item )**

        Adds an **item** to the category.
        """
        ...

    def items(self) -> typing.List["QWinJumpListItem"]:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#items

        **QList<QWinJumpListItem *> QWinJumpListCategory::items() const**

        Returns the list of items in the category.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#isEmpty

        **bool QWinJumpListCategory::isEmpty() const**

        Returns whether the category is empty.
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#count

        **int QWinJumpListCategory::count() const**

        Returns the amount of items in the category.
        """
        ...

    def setTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#setTitle

        **void QWinJumpListCategory::setTitle(const QString & title )**

        Sets the category **title**.

        **See also** **title** ().
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#title

        **QString QWinJumpListCategory::title() const**

        Returns the category title.

        **See also** **setTitle** ().
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#setVisible

        **void QWinJumpListCategory::setVisible(bool visible )**

        Sets the category **visible**.

        **See also** **isVisible** ().
        """
        ...

    def isVisible(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#isVisible

        **bool QWinJumpListCategory::isVisible() const**

        Returns whether the category is visible.
        """
        ...

    def type(self) -> "QWinJumpListCategory.Type":
        """
        https://doc.qt.io/qt-5/qwinjumplistcategory.html#type

        **QWinJumpListCategory::Type QWinJumpListCategory::type() const**

        Returns the category type.
        """
        ...
