"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QWhatsThis(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qwhatsthis.html

    **Detailed Description**

    "What's This?" help is part of an application's online help system, and
    provides users with information about the functionality and usage of a
    particular widget. "What's This?" help texts are typically longer and more
    detailed than **tooltips** , but generally provide less information than
    that supplied by separate help windows.

    QWhatsThis provides a single window with an explanatory text that pops up
    when the user asks "What's This?". The default way for users to ask the
    question is to move the focus to the relevant widget and press Shift+F1. The
    help text appears immediately; it goes away as soon as the user does
    something else. (Note that if there is a shortcut for Shift+F1, this
    mechanism will not work.) Some dialogs provide a "?" button that users can
    click to enter "What's This?" mode; they then click the relevant widget to
    pop up the "What's This?" window. It is also possible to provide a a menu
    option or toolbar button to switch into "What's This?" mode.

    To add "What's This?" text to a widget or an action, you simply call
    **QWidget::setWhatsThis** () or **QAction::setWhatsThis** ().

    The text can be either rich text or plain text. If you specify a rich text
    formatted string, it will be rendered using the default stylesheet, making
    it possible to embed images in the displayed text. To be as fast as
    possible, the default stylesheet uses a simple method to determine whether
    the text can be rendered as plain text. See **Qt::mightBeRichText** () for
    details.

    newAct = new **QAction** (tr("&New"), this);
    newAct->setShortcut(tr("Ctrl+N"));
            newAct->setStatusTip(tr("Create a
    new file"));
            newAct->setWhatsThis(tr("Click this option to create a
    new file."));

    An alternative way to enter "What's This?" mode is to call **createAction**
    (), and add the returned **QAction**  to either a menu or a tool bar. By
    invoking this context help action (in the picture below, the button with the
    arrow and question mark icon) the user switches into "What's This?" mode. If
    they now click on a widget the appropriate help text is shown. The mode is
    left when help is given or when the user presses Esc.

    ![](images/whatsthis.png)

    You can enter "What's This?" mode programmatically with
    **enterWhatsThisMode** (), check the mode with **inWhatsThisMode** (), and
    return to normal mode with **leaveWhatsThisMode** ().

    If you want to control the "What's This?" behavior of a widget manually see
    **Qt::WA_CustomWhatsThis** .

    It is also possible to show different help texts for different regions of a
    widget, by using a **QHelpEvent**  of type **QEvent::WhatsThis** . Intercept
    the help event in your widget's **QWidget::event** () function and call
    **QWhatsThis::showText** () with the text you want to display for the
    position specified in **QHelpEvent::pos** (). If the text is rich text and
    the user clicks on a link, the widget also receives a
    **QWhatsThisClickedEvent**  with the link's reference as
    **QWhatsThisClickedEvent::href** (). If a **QWhatsThisClickedEvent**  is
    handled (i.e. **QWidget::event** () returns true), the help window remains
    visible. Call **QWhatsThis::hideText** () to hide it explicitly.

    **See also** **QToolTip** .
    """

    def __init__(self, a0: "QWhatsThis") -> None:
        ...

    @staticmethod
    def createAction(parent: typing.Optional[QtCore.QObject] = ...) -> QAction:
        """
        https://doc.qt.io/qt-5/qwhatsthis.html#createAction

        **[static] QAction *QWhatsThis::createAction(QObject * parent =
        nullptr)**

        Returns a ready-made **QAction** , used to invoke "What's This?" context
        help, with the given **parent**.

        The returned **QAction**  provides a convenient way to let users enter
        "What's This?" mode.
        """
        ...

    @staticmethod
    def hideText() -> None:
        """
        https://doc.qt.io/qt-5/qwhatsthis.html#hideText

        **[static] void QWhatsThis::hideText()**

        If a "What's This?" window is showing, this destroys it.

        **See also** **showText** ().
        """
        ...

    @staticmethod
    def showText(
        pos: QtCore.QPoint, text: str, widget: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwhatsthis.html#showText

        **[static] void QWhatsThis::showText(const QPoint & pos , const QString
        & text , QWidget * w = nullptr)**

        Shows **text** as a "What's This?" window, at global position **pos**.
        The optional widget argument, **w** , is used to determine the
        appropriate screen on multi-head systems.

        **See also** **hideText** ().
        """
        ...

    @staticmethod
    def leaveWhatsThisMode() -> None:
        """
        https://doc.qt.io/qt-5/qwhatsthis.html#leaveWhatsThisMode

        **[static] void QWhatsThis::leaveWhatsThisMode()**

        If the user interface is in "What's This?" mode, this function switches
        back to normal mode; otherwise it does nothing.

        When leaving "What's This?" mode, a **QEvent**  of type
        Qt::LeaveWhatsThisMode is sent to all toplevel widgets.

        **See also** **enterWhatsThisMode** () and **inWhatsThisMode** ().
        """
        ...

    @staticmethod
    def inWhatsThisMode() -> bool:
        """
        https://doc.qt.io/qt-5/qwhatsthis.html#inWhatsThisMode

        **[static] bool QWhatsThis::inWhatsThisMode()**

        Returns `true` if the user interface is in "What's This?" mode;
        otherwise returns `false`.

        **See also** **enterWhatsThisMode** ().
        """
        ...

    @staticmethod
    def enterWhatsThisMode() -> None:
        """
        https://doc.qt.io/qt-5/qwhatsthis.html#enterWhatsThisMode

        **[static] void QWhatsThis::enterWhatsThisMode()**

        This function switches the user interface into "What's This?" mode. The
        user interface can be switched back into normal mode by the user (e.g.
        by them clicking or pressing Esc), or programmatically by calling
        **leaveWhatsThisMode** ().

        When entering "What's This?" mode, a **QEvent**  of type
        Qt::EnterWhatsThisMode is sent to all toplevel widgets.

        **See also** **inWhatsThisMode** () and **leaveWhatsThisMode** ().
        """
        ...
