"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QSplitterHandle(QWidget):
    """
    https://doc.qt.io/qt-5/qsplitterhandle.html

    **Detailed Description**

    QSplitterHandle is typically what people think about when they think about a
    splitter. It is the handle that is used to resize the widgets.

    A typical developer using **QSplitter**  will never have to worry about
    QSplitterHandle. It is provided for developers who want splitter handles
    that provide extra features, such as popup menus.

    The typical way one would create splitter handles is to subclass
    **QSplitter**  and then reimplement **QSplitter::createHandle** () to
    instantiate the custom splitter handle. For example, a minimum **QSplitter**
    subclass might look like this:

    class Splitter : public **QSplitter**
        {
        public:
    Splitter(Qt::Orientation orientation, **QWidget**  *parent = 0);
    protected:
            **QSplitterHandle**  *createHandle() override;
        };

    The **createHandle()**  implementation simply constructs a custom splitter
    handle, called `Splitter` in this example:

    **QSplitterHandle**  *Splitter::createHandle()
        {
            return new
    SplitterHandle(orientation(), this);
        }

    Information about a given handle can be obtained using functions like
    **orientation** () and **opaqueResize** (), and is retrieved from its parent
    splitter. Details like these can be used to give custom handles different
    appearances depending on the splitter's orientation.

    The complexity of a custom handle subclass depends on the tasks that it
    needs to perform. A simple subclass might only provide a **paintEvent** ()
    implementation:

    void SplitterHandle::paintEvent(**QPaintEvent**  *event)
        {
    **QPainter**  painter(this);
            if (orientation() == Qt::Horizontal) {
    gradient.setStart(rect().left(), rect().height()/2);
    gradient.setFinalStop(rect().right(), rect().height()/2);
            } else {
    gradient.setStart(rect().width()/2, rect().top());
    gradient.setFinalStop(rect().width()/2, rect().bottom());
            }
    painter.fillRect(event->rect(), **QBrush** (gradient));
        }

    In this example, a predefined gradient is set up differently depending on
    the orientation of the handle. QSplitterHandle provides a reasonable size
    hint for the handle, so the subclass does not need to provide a
    reimplementation of **sizeHint** () unless the handle has special size
    requirements.

    **See also** **QSplitter** .
    """

    def __init__(self, o: QtCore.Qt.Orientation, parent: QSplitter) -> None:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#QSplitterHandle

        **QSplitterHandle::QSplitterHandle(Qt::Orientation orientation ,
        QSplitter * parent )**

        Creates a **QSplitter**  handle with the given **orientation** and
        **parent**.
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#resizeEvent

        **[override virtual protected] void
        QSplitterHandle::resizeEvent(QResizeEvent * event )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def closestLegalPosition(self, p: int) -> int:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#closestLegalPosition

        **[protected] int QSplitterHandle::closestLegalPosition(int pos )**

        Returns the closest legal position to **pos** of the splitter handle.
        The positions are measured from the left or top edge of the splitter,
        even for right-to-left languages.

        **See also** **QSplitter::closestLegalPosition** () and **moveSplitter**
        ().
        """
        ...

    def moveSplitter(self, p: int) -> None:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#moveSplitter

        **[protected] void QSplitterHandle::moveSplitter(int pos )**

        Tells the splitter to move this handle to position **pos** , which is
        the distance from the left or top edge of the widget.

        Note that **pos** is also measured from the left (or top) for right-to-
        left languages. This function will map **pos** to the appropriate
        position before calling **QSplitter::moveSplitter** ().

        **See also** **QSplitter::moveSplitter** () and **closestLegalPosition**
        ().
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#event

        **[override virtual protected] bool QSplitterHandle::event(QEvent *
        event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#mouseReleaseEvent

        **[override virtual protected] void
        QSplitterHandle::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#mousePressEvent

        **[override virtual protected] void
        QSplitterHandle::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#mouseMoveEvent

        **[override virtual protected] void
        QSplitterHandle::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#paintEvent

        **[override virtual protected] void QSplitterHandle::paintEvent(
        QPaintEvent * )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#sizeHint

        **[override virtual] QSize QSplitterHandle::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def splitter(self) -> QSplitter:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#splitter

        **QSplitter *QSplitterHandle::splitter() const**

        Returns the splitter associated with this splitter handle.

        **See also** **QSplitter::handle** ().
        """
        ...

    def opaqueResize(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#opaqueResize

        **bool QSplitterHandle::opaqueResize() const**

        Returns `true` if widgets are resized dynamically (opaquely) while
        interactively moving the splitter. Otherwise returns `false`. This value
        is controlled by the **QSplitter** .

        **See also** **QSplitter::opaqueResize** ().
        """
        ...

    def orientation(self) -> QtCore.Qt.Orientation:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#orientation

        **Qt::Orientation QSplitterHandle::orientation() const**

        Returns the handle's orientation. This is usually propagated from the
        **QSplitter** .

        **See also** **setOrientation** () and **QSplitter::orientation** ().
        """
        ...

    def setOrientation(self, o: QtCore.Qt.Orientation) -> None:
        """
        https://doc.qt.io/qt-5/qsplitterhandle.html#setOrientation

        **void QSplitterHandle::setOrientation(Qt::Orientation orientation )**

        Sets the orientation of the splitter handle to **orientation**. This is
        usually propagated from the **QSplitter** .

        **See also** **orientation** () and **QSplitter::setOrientation** ().
        """
        ...
