"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QScrollBar(QAbstractSlider):
    """
    https://doc.qt.io/qt-5/qscrollbar.html

    **Detailed Description**

    A scroll bar is a control that enables the user to access parts of a
    document that is larger than the widget used to display it. It provides a
    visual indication of the user's current position within the document and the
    amount of the document that is visible. Scroll bars are usually equipped
    with other controls that enable more accurate navigation. Qt displays scroll
    bars in a way that is appropriate for each platform.

    If you need to provide a scrolling view onto another widget, it may be more
    convenient to use the **QScrollArea**  class because this provides a
    viewport widget and scroll bars. QScrollBar is useful if you need to
    implement similar functionality for specialized widgets using
    **QAbstractScrollArea** ; for example, if you decide to subclass
    **QAbstractItemView** . For most other situations where a slider control is
    used to obtain a value within a given range, the **QSlider**  class may be
    more appropriate for your needs.

    ![](images/qscrollbar-picture.png)

    Scroll bars typically include four
    separate controls: a slider, scroll arrows, and a page control.

      * a. The
    slider provides a way to quickly go to any part of the document, but does
    not support accurate navigation within large documents.
      * b. The scroll
    arrows are push buttons which can be used to accurately navigate to a
    particular place in a document. For a vertical scroll bar connected to a
    text editor, these typically move the current position one "line" up or
    down, and adjust the position of the slider by a small amount. In editors
    and list boxes a "line" might mean one line of text; in an image viewer it
    might mean 20 pixels.
      * c. The page control is the area over which the
    slider is dragged (the scroll bar's background). Clicking here moves the
    scroll bar towards the click by one "page". This value is usually the same
    as the length of the slider.

    Each scroll bar has a value that indicates how far the slider is from the
    start of the scroll bar; this is obtained with **value** () and set with
    **setValue** (). This value always lies within the range of values defined
    for the scroll bar, from **minimum()**  to **maximum()**  inclusive. The
    range of acceptable values can be set with **setMinimum** () and
    **setMaximum** (). At the minimum value, the top edge of the slider (for a
    vertical scroll bar) or left edge (for a horizontal scroll bar) will be at
    the top (or left) end of the scroll bar. At the maximum value, the bottom
    (or right) edge of the slider will be at the bottom (or right) end of the
    scroll bar.

    The length of the slider is usually related to the value of the page step,
    and typically represents the proportion of the document area shown in a
    scrolling view. The page step is the amount that the value changes by when
    the user presses the **Page Up** and **Page Down** keys, and is set with
    **setPageStep** (). Smaller changes to the value defined by the line step
    are made using the cursor keys, and this quantity is set with
    **setSingleStep()** .

    Note that the range of values used is independent of the actual size of the
    scroll bar widget. You do not need to take this into account when you choose
    values for the range and the page step.

    The range of values specified for the scroll bar are often determined
    differently to those for a **QSlider**  because the length of the slider
    needs to be taken into account. If we have a document with 100 lines, and we
    can only show 20 lines in a widget, we may wish to construct a scroll bar
    with a page step of 20, a minimum value of 0, and a maximum value of 80.
    This would give us a scroll bar with five "pages".

    ![](images/qscrollbar-values.png)The relationship between a document length,
    the range of values used in a scroll bar, and the page step is simple in
    many common situations. The scroll bar's range of values is determined by
    subtracting a chosen page step from some value representing the length of
    the document. In such cases, the following equation is useful: **document
    length** = **maximum** () - **minimum** () + **pageStep** ().

    QScrollBar only provides integer ranges. Note that although QScrollBar
    handles very large numbers, scroll bars on current screens cannot usefully
    represent ranges above about 100,000 pixels. Beyond that, it becomes
    difficult for the user to control the slider using either the keyboard or
    the mouse, and the scroll arrows will have limited use.

    ScrollBar inherits a comprehensive set of signals from **QAbstractSlider** :

    * **valueChanged()**  is emitted when the scroll bar's value has changed.
    The tracking() determines whether this signal is emitted during user
    interaction.
      * **rangeChanged()**  is emitted when the scroll bar's range
    of values has changed.
      * **sliderPressed()**  is emitted when the user
    starts to drag the slider.
      * **sliderMoved()**  is emitted when the user
    drags the slider.
      * **sliderReleased()**  is emitted when the user
    releases the slider.
      * **actionTriggered()**  is emitted when the scroll
    bar is changed by user interaction or via the **triggerAction()**  function.

    A scroll bar can be controlled by the keyboard, but it has a default
    **focusPolicy** () of **Qt::NoFocus** . Use **setFocusPolicy** () to enable
    keyboard interaction with the scroll bar:

    * Left/Right move a horizontal scroll bar by one single step.
      * Up/Down
    move a vertical scroll bar by one single step.
      * PageUp moves up one page.
    * PageDown moves down one page.
      * Home moves to the start (mininum).
      *
    End moves to the end (maximum).

    The slider itself can be controlled by using the **triggerAction()**
    function to simulate user interaction with the scroll bar controls. This is
    useful if you have many different widgets that use a common range of values.

    Most GUI styles use the **pageStep** () value to calculate the size of the
    slider.

    **See also** **QScrollArea** , **QSlider** , **QDial** , **QSpinBox** ,
    **GUI Design Handbook: Scroll Bar** , and **Sliders Example** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#QScrollBar

        **QScrollBar::QScrollBar(QWidget * parent = nullptr)**

        Constructs a vertical scroll bar.

        The **parent** argument is sent to the **QWidget**  constructor.

        The **minimum**  defaults to 0, the **maximum**  to 99, with a
        **singleStep**  size of 1 and a **pageStep**  size of 10, and an initial
        **value**  of 0.
        """
        ...

    @typing.overload
    def __init__(
        self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#QScrollBar-1

        **QScrollBar::QScrollBar(Qt::Orientation orientation , QWidget * parent
        = nullptr)**

        Constructs a scroll bar with the given **orientation**.

        The **parent** argument is passed to the **QWidget**  constructor.

        The **minimum**  defaults to 0, the **maximum**  to 99, with a
        **singleStep**  size of 1 and a **pageStep**  size of 10, and an initial
        **value**  of 0.
        """
        ...

    def sliderChange(self, change: QAbstractSlider.SliderChange) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#sliderChange

        **[override virtual protected] void
        QScrollBar::sliderChange(QAbstractSlider::SliderChange change )**

        Reimplements: **QAbstractSlider::sliderChange**
        (QAbstractSlider::SliderChange change).
        """
        ...

    def wheelEvent(self, a0: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#wheelEvent

        **[override virtual protected] void QScrollBar::wheelEvent(QWheelEvent *
        event )**

        Reimplements: **QAbstractSlider::wheelEvent** (QWheelEvent *e).
        """
        ...

    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#contextMenuEvent

        **[override virtual protected] void
        QScrollBar::contextMenuEvent(QContextMenuEvent * event )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).
        """
        ...

    def hideEvent(self, a0: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#hideEvent

        **[override virtual protected] void QScrollBar::hideEvent( QHideEvent *
        )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#mouseMoveEvent

        **[override virtual protected] void
        QScrollBar::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#mouseReleaseEvent

        **[override virtual protected] void
        QScrollBar::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#mousePressEvent

        **[override virtual protected] void
        QScrollBar::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#paintEvent

        **[override virtual protected] void QScrollBar::paintEvent( QPaintEvent
        * )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionSlider") -> None:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#initStyleOption

        **[protected] void QScrollBar::initStyleOption(QStyleOptionSlider *
        option ) const**

        Initialize **option** with the values from this **QScrollBar** . This
        method is useful for subclasses when they need a **QStyleOptionSlider**
        , but don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#event

        **[override virtual] bool QScrollBar::event(QEvent * event )**

        Reimplements: **QAbstractSlider::event** (QEvent *e).
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qscrollbar.html#sizeHint

        **[override virtual] QSize QScrollBar::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...
