"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QGraphicsScene(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qgraphicsscene.html

    **Detailed Description**

    The class serves as a container for QGraphicsItems. It is used together with
    **QGraphicsView**  for visualizing graphical items, such as lines,
    rectangles, text, or even custom items, on a 2D surface. QGraphicsScene is
    part of the **Graphics View Framework** .

    QGraphicsScene also provides functionality that lets you efficiently
    determine both the location of items, and for determining what items are
    visible within an arbitrary area on the scene. With the **QGraphicsView**
    widget, you can either visualize the whole scene, or zoom in and view only
    parts of the scene.

    Example:

    **QGraphicsScene**  scene;
        scene.addText("Hello, world!");
    **QGraphicsView**  view(&scene);
        view.show();

    Note that QGraphicsScene has no visual appearance of its own; it only
    manages the items. You need to create a **QGraphicsView**  widget to
    visualize the scene.

    To add items to a scene, you start off by constructing a QGraphicsScene
    object. Then, you have two options: either add your existing
    **QGraphicsItem**  objects by calling **addItem** (), or you can call one of
    the convenience functions **addEllipse** (), **addLine** (), **addPath** (),
    **addPixmap** (), **addPolygon** (), **addRect** (), or **addText** (),
    which all return a pointer to the newly added item. The dimensions of the
    items added with these functions are relative to the item's coordinate
    system, and the items position is initialized to (0, 0) in the scene.

    You can then visualize the scene using **QGraphicsView** . When the scene
    changes, (e.g., when an item moves or is transformed) QGraphicsScene emits
    the **changed** () signal. To remove an item, call **removeItem** ().

    QGraphicsScene uses an indexing algorithm to manage the location of items
    efficiently. By default, a BSP (Binary Space Partitioning) tree is used; an
    algorithm suitable for large scenes where most items remain static (i.e., do
    not move around). You can choose to disable this index by calling
    **setItemIndexMethod** (). For more information about the available indexing
    algorithms, see the **itemIndexMethod**  property.

    The scene's bounding rect is set by calling **setSceneRect** (). Items can
    be placed at any position on the scene, and the size of the scene is by
    default unlimited. The scene rect is used only for internal bookkeeping,
    maintaining the scene's item index. If the scene rect is unset,
    QGraphicsScene will use the bounding area of all items, as returned by
    **itemsBoundingRect** (), as the scene rect. However, **itemsBoundingRect**
    () is a relatively time consuming function, as it operates by collecting
    positional information for every item on the scene. Because of this, you
    should always set the scene rect when operating on large scenes.

    One of QGraphicsScene's greatest strengths is its ability to efficiently
    determine the location of items. Even with millions of items on the scene,
    the **items** () functions can determine the location of an item within a
    few milliseconds. There are several overloads to **items** (): one that
    finds items at a certain position, one that finds items inside or
    intersecting with a polygon or a rectangle, and more. The list of returned
    items is sorted by stacking order, with the topmost item being the first
    item in the list. For convenience, there is also an **itemAt** () function
    that returns the topmost item at a given position.

    QGraphicsScene maintains selection information for the scene. To select
    items, call **setSelectionArea** (), and to clear the current selection,
    call **clearSelection** (). Call **selectedItems** () to get the list of all
    selected items.

    **Event Handling and Propagation**

    Another responsibility that QGraphicsScene has, is to propagate events from
    **QGraphicsView** . To send an event to a scene, you construct an event that
    inherits **QEvent** , and then send it using, for example,
    **QCoreApplication::sendEvent** (). **event** () is responsible for
    dispatching the event to the individual items. Some common events are
    handled by convenience event handlers. For example, key press events are
    handled by **keyPressEvent** (), and mouse press events are handled by
    **mousePressEvent** ().

    Key events are delivered to the **focus item**. To set the focus item, you
    can either call **setFocusItem** (), passing an item that accepts focus, or
    the item itself can call **QGraphicsItem::setFocus** (). Call **focusItem**
    () to get the current focus item. For compatibility with widgets, the scene
    also maintains its own focus information. By default, the scene does not
    have focus, and all key events are discarded. If **setFocus** () is called,
    or if an item on the scene gains focus, the scene automatically gains focus.
    If the scene has focus, **hasFocus** () will return true, and key events
    will be forwarded to the focus item, if any. If the scene loses focus,
    (i.e., someone calls **clearFocus** ()) while an item has focus, the scene
    will maintain its item focus information, and once the scene regains focus,
    it will make sure the last focus item regains focus.

    For mouse-over effects, QGraphicsScene dispatches **hover events**. If an
    item accepts hover events (see **QGraphicsItem::acceptHoverEvents** ()), it
    will receive a **GraphicsSceneHoverEnter**  event when the mouse enters its
    area. As the mouse continues moving inside the item's area, QGraphicsScene
    will send it **GraphicsSceneHoverMove**  events. When the mouse leaves the
    item's area, the item will receive a **GraphicsSceneHoverLeave**  event.

    All mouse events are delivered to the current **mouse grabber** item. An
    item becomes the scene's mouse grabber if it accepts mouse events (see
    **QGraphicsItem::acceptedMouseButtons** ()) and it receives a mouse press.
    It stays the mouse grabber until it receives a mouse release when no other
    mouse buttons are pressed. You can call **mouseGrabberItem** () to determine
    what item is currently grabbing the mouse.

    **See also** **QGraphicsItem**  and **QGraphicsView** .
    """

    class SceneLayer(int):
        ItemLayer: QGraphicsScene = ...
        BackgroundLayer: QGraphicsScene = ...
        ForegroundLayer: QGraphicsScene = ...
        AllLayers: QGraphicsScene = ...

    class ItemIndexMethod(int):
        BspTreeIndex: QGraphicsScene = ...
        NoIndex: QGraphicsScene = ...

    class SceneLayers(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QGraphicsScene.SceneLayers", "QGraphicsScene.SceneLayer"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGraphicsScene.SceneLayers") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGraphicsScene.SceneLayers":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#QGraphicsScene

        **QGraphicsScene::QGraphicsScene(QObject * parent = nullptr)**

        Constructs a QGraphicsScene object. The **parent** parameter is passed
        to **QObject** 's constructor.
        """
        ...

    @typing.overload
    def __init__(
        self, sceneRect: QtCore.QRectF, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#QGraphicsScene-1

        **QGraphicsScene::QGraphicsScene(const QRectF & sceneRect , QObject *
        parent = nullptr)**

        Constructs a QGraphicsScene object, using **sceneRect** for its scene
        rectangle. The **parent** parameter is passed to **QObject** 's
        constructor.

        **See also** **sceneRect** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        x: float,
        y: float,
        width: float,
        height: float,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#QGraphicsScene-2

        **QGraphicsScene::QGraphicsScene(qreal x , qreal y , qreal width , qreal
        height , QObject * parent = nullptr)**

        Constructs a QGraphicsScene object, using the rectangle specified by (
        **x** , **y** ), and the given **width** and **height** for its scene
        rectangle. The **parent** parameter is passed to **QObject** 's
        constructor.

        **See also** **sceneRect** .
        """
        ...

    def setFocusOnTouch(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#focusOnTouch-prop

        **focusOnTouch : bool**

        This property holds whether items gain focus when receiving a **touch
        begin** event.

        The usual behavior is to transfer focus only when an item is clicked.
        Often a tap on a touchpad is interpreted as equivalent to a mouse click
        by the operating system, generating a synthesized click event in
        response. However, at least on macOS you can configure this behavior.

        By default, **QGraphicsScene**  also transfers focus when you touch on a
        trackpad or similar. If the operating system is configured to not
        generate a synthetic mouse click on tapping the trackpad, this is
        surprising. If the operating system does generate synthetic mouse clicks
        on tapping the trackpad, the focus transfer on starting a touch gesture
        is unnecessary.

        With focusOnTouch switched off, **QGraphicsScene**  behaves as one would
        expect on macOS.

        The default value is `true`, ensuring that the default behavior is just
        as in Qt versions prior to 5.12. Set to `false` to prevent touch events
        from triggering focus changes.

        This property was introduced in Qt 5.12.

        **Access functions:**

        bool **focusOnTouch** () const
        void **setFocusOnTouch** (bool
        **enabled** )
        """
        ...

    def focusOnTouch(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#focusOnTouch-prop

        **focusOnTouch : bool**

        This property holds whether items gain focus when receiving a **touch
        begin** event.

        The usual behavior is to transfer focus only when an item is clicked.
        Often a tap on a touchpad is interpreted as equivalent to a mouse click
        by the operating system, generating a synthesized click event in
        response. However, at least on macOS you can configure this behavior.

        By default, **QGraphicsScene**  also transfers focus when you touch on a
        trackpad or similar. If the operating system is configured to not
        generate a synthetic mouse click on tapping the trackpad, this is
        surprising. If the operating system does generate synthetic mouse clicks
        on tapping the trackpad, the focus transfer on starting a touch gesture
        is unnecessary.

        With focusOnTouch switched off, **QGraphicsScene**  behaves as one would
        expect on macOS.

        The default value is `true`, ensuring that the default behavior is just
        as in Qt versions prior to 5.12. Set to `false` to prevent touch events
        from triggering focus changes.

        This property was introduced in Qt 5.12.

        **Access functions:**

        bool **focusOnTouch** () const
        void **setFocusOnTouch** (bool
        **enabled** )
        """
        ...

    def setMinimumRenderSize(self, minSize: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#minimumRenderSize-prop

        **minimumRenderSize : qreal**

        This property holds the minimal view-transformed size an item must have
        to be drawn

        When the scene is rendered, any item whose width or height, transformed
        to the target view, is smaller that minimumRenderSize(), will not be
        rendered. If an item is not rendered and it clips its children items
        they will also not be rendered. Set this value to speed up rendering of
        scenes with many objects rendered on a zoomed out view.

        The default value is 0. If unset, or if set to 0 or a negative value,
        all items will always be rendered.

        For example, setting this property can be especially useful if a scene
        is rendered by multiple views, one of which serves as an overview which
        always displays all items. In scenes with many items, such a view will
        use a high scaling factor so that all items can be shown. Due to the
        scaling, smaller items will only make an insignificant contribution to
        the final rendered scene. To avoid drawing these items and reduce the
        time necessary to render the scene, you can call setMinimumRenderSize()
        with a non-negative value.

        **Note:** Items that are not drawn as a result of being too small, are
        still returned by methods such as **items** () and **itemAt** (), and
        participate in collision detection and interactions. It is recommended
        that you set minimumRenderSize() to a value less than or equal to 1 in
        order to avoid large unrendered items that are interactive.

        This property was introduced in Qt 5.4.

        **Access functions:**

        qreal **minimumRenderSize** () const
        void **setMinimumRenderSize**
        (qreal **minSize** )

        **See also** **QStyleOptionGraphicsItem::levelOfDetailFromTransform**
        ().
        """
        ...

    def minimumRenderSize(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#minimumRenderSize-prop

        **minimumRenderSize : qreal**

        This property holds the minimal view-transformed size an item must have
        to be drawn

        When the scene is rendered, any item whose width or height, transformed
        to the target view, is smaller that minimumRenderSize(), will not be
        rendered. If an item is not rendered and it clips its children items
        they will also not be rendered. Set this value to speed up rendering of
        scenes with many objects rendered on a zoomed out view.

        The default value is 0. If unset, or if set to 0 or a negative value,
        all items will always be rendered.

        For example, setting this property can be especially useful if a scene
        is rendered by multiple views, one of which serves as an overview which
        always displays all items. In scenes with many items, such a view will
        use a high scaling factor so that all items can be shown. Due to the
        scaling, smaller items will only make an insignificant contribution to
        the final rendered scene. To avoid drawing these items and reduce the
        time necessary to render the scene, you can call setMinimumRenderSize()
        with a non-negative value.

        **Note:** Items that are not drawn as a result of being too small, are
        still returned by methods such as **items** () and **itemAt** (), and
        participate in collision detection and interactions. It is recommended
        that you set minimumRenderSize() to a value less than or equal to 1 in
        order to avoid large unrendered items that are interactive.

        This property was introduced in Qt 5.4.

        **Access functions:**

        qreal **minimumRenderSize** () const
        void **setMinimumRenderSize**
        (qreal **minSize** )

        **See also** **QStyleOptionGraphicsItem::levelOfDetailFromTransform**
        ().
        """
        ...

    def sendEvent(self, item: QGraphicsItem, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#sendEvent

        **bool QGraphicsScene::sendEvent(QGraphicsItem * item , QEvent * event
        )**

        Sends event **event** to item **item** through possible event filters.

        The event is sent only if the item is enabled.

        Returns `false` if the event was filtered or if the item is disabled.
        Otherwise returns the value that was returned from the event handler.

        This function was introduced in Qt 4.6.

        **See also** **QGraphicsItem::sceneEvent** () and
        **QGraphicsItem::sceneEventFilter** ().
        """
        ...

    def setActivePanel(self, item: QGraphicsItem) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#setActivePanel

        **void QGraphicsScene::setActivePanel(QGraphicsItem * item )**

        Activates **item** , which must be an item in this scene. You can also
        pass 0 for **item** , in which case **QGraphicsScene**  will deactivate
        any currently active panel.

        If the scene is currently inactive, **item** remains inactive until the
        scene becomes active (or, ir **item** is `nullptr`, no item will be
        activated).

        This function was introduced in Qt 4.6.

        **See also** **activePanel** (), **isActive** (), and
        **QGraphicsItem::isActive** ().
        """
        ...

    def activePanel(self) -> QGraphicsItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#activePanel

        **QGraphicsItem *QGraphicsScene::activePanel() const**

        Returns the current active panel, or `nullptr` if no panel is currently
        active.

        This function was introduced in Qt 4.6.

        **See also** **QGraphicsScene::setActivePanel** ().
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#isActive

        **bool QGraphicsScene::isActive() const**

        Returns `true` if the scene is active (e.g., it's viewed by at least one
        **QGraphicsView**  that is active); otherwise returns `false`.

        This function was introduced in Qt 4.6.

        **See also** **QGraphicsItem::isActive** () and
        **QWidget::isActiveWindow** ().
        """
        ...

    @typing.overload
    def itemAt(
        self,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        deviceTransform: QtGui.QTransform,
    ) -> QGraphicsItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#itemAt

        **QGraphicsItem *QGraphicsScene::itemAt(const QPointF & position , const
        QTransform & deviceTransform ) const**

        Returns the topmost visible item at the specified **position** , or
        `nullptr` if there are no items at this position.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        Note: See **items** () for a definition of which items are considered
        visible by this function.

        This function was introduced in Qt 4.6.

        **See also** **items** (), **collidingItems** (), and **Sorting** .
        """
        ...

    @typing.overload
    def itemAt(
        self, x: float, y: float, deviceTransform: QtGui.QTransform
    ) -> QGraphicsItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#itemAt-3

        **QGraphicsItem *QGraphicsScene::itemAt(qreal x , qreal y , const
        QTransform & deviceTransform ) const**

        This is an overloaded function.

        Returns the topmost visible item at the position specified by ( **x** ,
        **y** ), or `nullptr` if there are no items at this position.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        This convenience function is equivalent to calling `itemAt(QPointF(x,
        y), deviceTransform)`.

        Note: See **items** () for a definition of which items are considered
        visible by this function.

        This function was introduced in Qt 4.6.
        """
        ...

    def stickyFocus(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#stickyFocus-prop

        **stickyFocus : bool**

        This property holds whether clicking into the scene background will
        clear focus

        In a **QGraphicsScene**  with stickyFocus set to true, focus will remain
        unchanged when the user clicks into the scene background or on an item
        that does not accept focus. Otherwise, focus will be cleared.

        By default, this property is `false`.

        Focus changes in response to a mouse press. You can reimplement
        **mousePressEvent** () in a subclass of **QGraphicsScene**  to toggle
        this property based on where the user has clicked.

        This property was introduced in Qt 4.6.

        **Access functions:**

        bool **stickyFocus** () const
        void **setStickyFocus** (bool
        **enabled** )

        **See also** **clearFocus** () and **setFocusItem** ().

        **Member Function Documentation**
        """
        ...

    def setStickyFocus(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#stickyFocus-prop

        **stickyFocus : bool**

        This property holds whether clicking into the scene background will
        clear focus

        In a **QGraphicsScene**  with stickyFocus set to true, focus will remain
        unchanged when the user clicks into the scene background or on an item
        that does not accept focus. Otherwise, focus will be cleared.

        By default, this property is `false`.

        Focus changes in response to a mouse press. You can reimplement
        **mousePressEvent** () in a subclass of **QGraphicsScene**  to toggle
        this property based on where the user has clicked.

        This property was introduced in Qt 4.6.

        **Access functions:**

        bool **stickyFocus** () const
        void **setStickyFocus** (bool
        **enabled** )

        **See also** **clearFocus** () and **setFocusItem** ().

        **Member Function Documentation**
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#focusNextPrevChild

        **[protected slot] bool QGraphicsScene::focusNextPrevChild(bool next )**

        Finds a new widget to give the keyboard focus to, as appropriate for Tab
        and Shift+Tab, and returns `true` if it can find a new widget, or false
        if it cannot. If **next** is true, this function searches forward; if
        **next** is false, it searches backward.

        You can reimplement this function in a subclass of **QGraphicsScene**
        to provide fine-grained control over how tab focus passes inside your
        scene. The default implementation is based on the tab focus chain
        defined by **QGraphicsWidget::setTabOrder** ().

        This function was introduced in Qt 4.4.
        """
        ...

    def eventFilter(self, watched: QtCore.QObject, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#eventFilter

        **[override virtual protected] bool QGraphicsScene::eventFilter(QObject
        * watched , QEvent * event )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).

        **QGraphicsScene**  filters **QApplication** 's events to detect palette
        and font changes.
        """
        ...

    def setActiveWindow(self, widget: QGraphicsWidget) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#setActiveWindow

        **void QGraphicsScene::setActiveWindow(QGraphicsWidget * widget )**

        Activates **widget** , which must be a widget in this scene. You can
        also pass 0 for **widget** , in which case **QGraphicsScene**  will
        deactivate any currently active window.

        This function was introduced in Qt 4.4.

        **See also** **activeWindow** () and **QGraphicsWidget::isActiveWindow**
        ().
        """
        ...

    def activeWindow(self) -> QGraphicsWidget:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#activeWindow

        **QGraphicsWidget *QGraphicsScene::activeWindow() const**

        Returns the current active window, or `nullptr` if no window is
        currently active.

        This function was introduced in Qt 4.4.

        **See also** **QGraphicsScene::setActiveWindow** ().
        """
        ...

    def setPalette(self, palette: QtGui.QPalette) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#palette-prop

        **palette : QPalette**

        This property holds the scene's default palette

        This property provides the scene's palette. The scene palette defaults
        to, and resolves all its entries from, **QApplication::palette** .

        If the scene's palette changes, either directly through setPalette() or
        indirectly when the application palette changes, **QGraphicsScene**
        first sends itself a **PaletteChange**  event, and it then sends
        **PaletteChange**  events to all top-level widget items in the scene.
        These items respond by resolving their own palettes to the scene, and
        they then notify their children, who again notify their children, and so
        on, until all widget items have updated their palettes.

        Changing the scene palette, (directly or indirectly through
        **QApplication::setPalette** (),) automatically schedules a redraw the
        entire scene.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QPalette **palette** () const
        void **setPalette** (const QPalette &
        **palette** )

        **See also** **QWidget::palette** , **QApplication::setPalette** (),
        **font** , and **style** ().
        """
        ...

    def palette(self) -> QtGui.QPalette:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#palette-prop

        **palette : QPalette**

        This property holds the scene's default palette

        This property provides the scene's palette. The scene palette defaults
        to, and resolves all its entries from, **QApplication::palette** .

        If the scene's palette changes, either directly through setPalette() or
        indirectly when the application palette changes, **QGraphicsScene**
        first sends itself a **PaletteChange**  event, and it then sends
        **PaletteChange**  events to all top-level widget items in the scene.
        These items respond by resolving their own palettes to the scene, and
        they then notify their children, who again notify their children, and so
        on, until all widget items have updated their palettes.

        Changing the scene palette, (directly or indirectly through
        **QApplication::setPalette** (),) automatically schedules a redraw the
        entire scene.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QPalette **palette** () const
        void **setPalette** (const QPalette &
        **palette** )

        **See also** **QWidget::palette** , **QApplication::setPalette** (),
        **font** , and **style** ().
        """
        ...

    def setFont(self, font: QtGui.QFont) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#font-prop

        **font : QFont**

        This property holds the scene's default font

        This property provides the scene's font. The scene font defaults to, and
        resolves all its entries from, **QApplication::font** .

        If the scene's font changes, either directly through setFont() or
        indirectly when the application font changes, **QGraphicsScene**  first
        sends itself a **FontChange**  event, and it then sends **FontChange**
        events to all top-level widget items in the scene. These items respond
        by resolving their own fonts to the scene, and they then notify their
        children, who again notify their children, and so on, until all widget
        items have updated their fonts.

        Changing the scene font, (directly or indirectly through
        **QApplication::setFont** (),) automatically schedules a redraw the
        entire scene.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **See also** **QWidget::font** , **QApplication::setFont** (),
        **palette** , and **style** ().
        """
        ...

    def font(self) -> QtGui.QFont:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#font-prop

        **font : QFont**

        This property holds the scene's default font

        This property provides the scene's font. The scene font defaults to, and
        resolves all its entries from, **QApplication::font** .

        If the scene's font changes, either directly through setFont() or
        indirectly when the application font changes, **QGraphicsScene**  first
        sends itself a **FontChange**  event, and it then sends **FontChange**
        events to all top-level widget items in the scene. These items respond
        by resolving their own fonts to the scene, and they then notify their
        children, who again notify their children, and so on, until all widget
        items have updated their fonts.

        Changing the scene font, (directly or indirectly through
        **QApplication::setFont** (),) automatically schedules a redraw the
        entire scene.

        This property was introduced in Qt 4.4.

        **Access functions:**

        QFont **font** () const
        void **setFont** (const QFont & **font** )

        **See also** **QWidget::font** , **QApplication::setFont** (),
        **palette** , and **style** ().
        """
        ...

    def setStyle(self, style: QStyle) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#setStyle

        **void QGraphicsScene::setStyle(QStyle * style )**

        Sets or replaces the style of the scene to **style** , and reparents the
        style to this scene. Any previously assigned style is deleted. The
        scene's style defaults to **QApplication::style** (), and serves as the
        default for all **QGraphicsWidget**  items in the scene.

        Changing the style, either directly by calling this function, or
        indirectly by calling **QApplication::setStyle** (), will automatically
        update the style for all widgets in the scene that do not have a style
        explicitly assigned to them.

        If **style** is `nullptr`, **QGraphicsScene**  will revert to
        **QApplication::style** ().

        This function was introduced in Qt 4.4.

        **See also** **style** ().
        """
        ...

    def style(self) -> QStyle:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#style

        **QStyle *QGraphicsScene::style() const**

        Returns the scene's style, or the same as **QApplication::style** () if
        the scene has not been explicitly assigned a style.

        This function was introduced in Qt 4.4.

        **See also** **setStyle** ().
        """
        ...

    def addWidget(
        self,
        widget: QWidget,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> QGraphicsProxyWidget:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addWidget

        **QGraphicsProxyWidget *QGraphicsScene::addWidget(QWidget * widget ,
        Qt::WindowFlags wFlags = Qt::WindowFlags())**

        Creates a new **QGraphicsProxyWidget**  for **widget** , adds it to the
        scene, and returns a pointer to the proxy. **wFlags** set the default
        window flags for the embedding proxy widget.

        The item's position is initialized to (0, 0).

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        Note that widgets with the **Qt::WA_PaintOnScreen**  widget attribute
        set and widgets that wrap an external application or controller are not
        supported. Examples are **QOpenGLWidget**  and QAxWidget.

        **See also** **addEllipse** (), **addLine** (), **addPixmap** (),
        **addPixmap** (), **addRect** (), **addText** (), **addSimpleText** (),
        and **addItem** ().
        """
        ...

    def selectionArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#selectionArea

        **QPainterPath QGraphicsScene::selectionArea() const**

        Returns the selection area that was previously set with
        **setSelectionArea** (), or an empty **QPainterPath**  if no selection
        area has been set.

        **See also** **setSelectionArea** ().
        """
        ...

    def setBspTreeDepth(self, depth: int) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#bspTreeDepth-prop

        **bspTreeDepth : int**

        This property holds the depth of **QGraphicsScene** 's BSP index tree

        This property has no effect when **NoIndex**  is used.

        This value determines the depth of **QGraphicsScene** 's BSP tree. The
        depth directly affects **QGraphicsScene** 's performance and memory
        usage; the latter growing exponentially with the depth of the tree. With
        an optimal tree depth, **QGraphicsScene**  can instantly determine the
        locality of items, even for scenes with thousands or millions of items.
        This also greatly improves rendering performance.

        By default, the value is 0, in which case Qt will guess a reasonable
        default depth based on the size, location and number of items in the
        scene. If these parameters change frequently, however, you may
        experience slowdowns as **QGraphicsScene**  retunes the depth
        internally. You can avoid potential slowdowns by fixating the tree depth
        through setting this property.

        The depth of the tree and the size of the scene rectangle decide the
        granularity of the scene's partitioning. The size of each scene segment
        is determined by the following algorithm:

        **QSizeF**  segmentSize = sceneRect().size() / pow(2, depth - 1);

        The BSP tree has an optimal size when each segment contains between 0
        and 10 items.

        This property was introduced in Qt 4.3.

        **Access functions:**

        int **bspTreeDepth** () const
        void **setBspTreeDepth** (int **depth**
        )

        **See also** **itemIndexMethod** .
        """
        ...

    def bspTreeDepth(self) -> int:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#bspTreeDepth-prop

        **bspTreeDepth : int**

        This property holds the depth of **QGraphicsScene** 's BSP index tree

        This property has no effect when **NoIndex**  is used.

        This value determines the depth of **QGraphicsScene** 's BSP tree. The
        depth directly affects **QGraphicsScene** 's performance and memory
        usage; the latter growing exponentially with the depth of the tree. With
        an optimal tree depth, **QGraphicsScene**  can instantly determine the
        locality of items, even for scenes with thousands or millions of items.
        This also greatly improves rendering performance.

        By default, the value is 0, in which case Qt will guess a reasonable
        default depth based on the size, location and number of items in the
        scene. If these parameters change frequently, however, you may
        experience slowdowns as **QGraphicsScene**  retunes the depth
        internally. You can avoid potential slowdowns by fixating the tree depth
        through setting this property.

        The depth of the tree and the size of the scene rectangle decide the
        granularity of the scene's partitioning. The size of each scene segment
        is determined by the following algorithm:

        **QSizeF**  segmentSize = sceneRect().size() / pow(2, depth - 1);

        The BSP tree has an optimal size when each segment contains between 0
        and 10 items.

        This property was introduced in Qt 4.3.

        **Access functions:**

        int **bspTreeDepth** () const
        void **setBspTreeDepth** (int **depth**
        )

        **See also** **itemIndexMethod** .
        """
        ...

    def drawForeground(self, painter: QtGui.QPainter, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#drawForeground

        **[virtual protected] void QGraphicsScene::drawForeground(QPainter *
        painter , const QRectF & rect )**

        Draws the foreground of the scene using **painter** , after the
        background and all items have been drawn. Reimplement this function to
        provide a custom foreground for the scene.

        All painting is done in **scene** coordinates. The **rect** parameter is
        the exposed rectangle.

        If all you want is to define a color, texture or gradient for the
        foreground, you can call **setForegroundBrush** () instead.

        **See also** **drawBackground** () and **drawItems** ().
        """
        ...

    def drawBackground(self, painter: QtGui.QPainter, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#drawBackground

        **[virtual protected] void QGraphicsScene::drawBackground(QPainter *
        painter , const QRectF & rect )**

        Draws the background of the scene using **painter** , before any items
        and the foreground are drawn. Reimplement this function to provide a
        custom background for the scene.

        All painting is done in **scene** coordinates. The **rect** parameter is
        the exposed rectangle.

        If all you want is to define a color, texture, or gradient for the
        background, you can call **setBackgroundBrush** () instead.

        **See also** **drawForeground** () and **drawItems** ().
        """
        ...

    def inputMethodEvent(self, event: QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#inputMethodEvent

        **[virtual protected] void
        QGraphicsScene::inputMethodEvent(QInputMethodEvent * event )**

        This event handler, for event **event** , can be reimplemented in a
        subclass to receive input method events for the scene.

        The default implementation forwards the event to the **focusItem** ().
        If no item currently has focus or the current focus item does not accept
        input methods, this function does nothing.

        **See also** **QGraphicsItem::inputMethodEvent** ().
        """
        ...

    def wheelEvent(self, event: "QGraphicsSceneWheelEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#wheelEvent

        **[virtual protected] void
        QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent * wheelEvent )**

        This event handler, for event **wheelEvent** , can be reimplemented in a
        subclass to receive mouse wheel events for the scene.

        By default, the event is delivered to the topmost visible item under the
        cursor. If ignored, the event propagates to the item beneath, and again
        until the event is accepted, or it reaches the scene. If no items accept
        the event, it is ignored.

        Note: See **items** () for a definition of which items are considered
        visible by this function.

        **See also** **QGraphicsItem::wheelEvent** ().
        """
        ...

    def mouseDoubleClickEvent(self, event: "QGraphicsSceneMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#mouseDoubleClickEvent

        **[virtual protected] void
        QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *
        mouseEvent )**

        This event handler, for event **mouseEvent** , can be reimplemented in a
        subclass to receive mouse doubleclick events for the scene.

        If someone doubleclicks on the scene, the scene will first receive a
        mouse press event, followed by a release event (i.e., a click), then a
        doubleclick event, and finally a release event. If the doubleclick event
        is delivered to a different item than the one that received the first
        press and release, it will be delivered as a press event. However,
        tripleclick events are not delivered as doubleclick events in this case.

        The default implementation is similar to **mousePressEvent** ().

        Note: See **items** () for a definition of which items are considered
        visible by this function.

        **See also** **QGraphicsItem::mousePressEvent** (),
        **QGraphicsItem::mouseMoveEvent** (),
        **QGraphicsItem::mouseReleaseEvent** (), and
        **QGraphicsItem::setAcceptedMouseButtons** ().
        """
        ...

    def mouseReleaseEvent(self, event: "QGraphicsSceneMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#mouseReleaseEvent

        **[virtual protected] void
        QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent * mouseEvent
        )**

        This event handler, for event **mouseEvent** , can be reimplemented in a
        subclass to receive mouse release events for the scene.

        The default implementation depends on the mouse grabber state. If there
        is no mouse grabber, the event is ignored. Otherwise, if there is a
        mouse grabber item, the event is sent to the mouse grabber. If this
        mouse release represents the last pressed button on the mouse, the mouse
        grabber item then loses the mouse grab.

        **See also** **QGraphicsItem::mousePressEvent** (),
        **QGraphicsItem::mouseMoveEvent** (),
        **QGraphicsItem::mouseDoubleClickEvent** (), and
        **QGraphicsItem::setAcceptedMouseButtons** ().
        """
        ...

    def mouseMoveEvent(self, event: "QGraphicsSceneMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#mouseMoveEvent

        **[virtual protected] void
        QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent * mouseEvent )**

        This event handler, for event **mouseEvent** , can be reimplemented in a
        subclass to receive mouse move events for the scene.

        The default implementation depends on the mouse grabber state. If there
        is a mouse grabber item, the event is sent to the mouse grabber. If
        there are any items that accept hover events at the current position,
        the event is translated into a hover event and accepted; otherwise it's
        ignored.

        **See also** **QGraphicsItem::mousePressEvent** (),
        **QGraphicsItem::mouseReleaseEvent** (),
        **QGraphicsItem::mouseDoubleClickEvent** (), and
        **QGraphicsItem::setAcceptedMouseButtons** ().
        """
        ...

    def mousePressEvent(self, event: "QGraphicsSceneMouseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#mousePressEvent

        **[virtual protected] void
        QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent * mouseEvent
        )**

        This event handler, for event **mouseEvent** , can be reimplemented in a
        subclass to receive mouse press events for the scene.

        The default implementation depends on the state of the scene. If there
        is a mouse grabber item, then the event is sent to the mouse grabber.
        Otherwise, it is forwarded to the topmost visible item that accepts
        mouse events at the scene position from the event, and that item
        promptly becomes the mouse grabber item.

        If there is no item at the given position on the scene, the selection
        area is reset, any focus item loses its input focus, and the event is
        then ignored.

        Note: See **items** () for a definition of which items are considered
        visible by this function.

        **See also** **QGraphicsItem::mousePressEvent** () and
        **QGraphicsItem::setAcceptedMouseButtons** ().
        """
        ...

    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#keyReleaseEvent

        **[virtual protected] void QGraphicsScene::keyReleaseEvent(QKeyEvent *
        keyEvent )**

        This event handler, for event **keyEvent** , can be reimplemented in a
        subclass to receive key release events. The default implementation
        forwards the event to current focus item.

        **See also** **QGraphicsItem::keyReleaseEvent** () and **focusItem** ().
        """
        ...

    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#keyPressEvent

        **[virtual protected] void QGraphicsScene::keyPressEvent(QKeyEvent *
        keyEvent )**

        This event handler, for event **keyEvent** , can be reimplemented in a
        subclass to receive keypress events. The default implementation forwards
        the event to current focus item.

        **See also** **QGraphicsItem::keyPressEvent** () and **focusItem** ().
        """
        ...

    def helpEvent(self, event: "QGraphicsSceneHelpEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#helpEvent

        **[virtual protected] void
        QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent * helpEvent )**

        This event handler, for event **helpEvent** , can be reimplemented in a
        subclass to receive help events. The events are of type
        **QEvent::ToolTip** , which are created when a tooltip is requested.

        The default implementation shows the tooltip of the topmost visible
        item, i.e., the item with the highest z-value, at the mouse cursor
        position. If no item has a tooltip set, this function does nothing.

        Note: See **items** () for a definition of which items are considered
        visible by this function.

        **See also** **QGraphicsItem::toolTip** () and
        **QGraphicsSceneHelpEvent** .
        """
        ...

    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#focusOutEvent

        **[virtual protected] void QGraphicsScene::focusOutEvent(QFocusEvent *
        focusEvent )**

        This event handler, for event **focusEvent** , can be reimplemented in a
        subclass to receive focus out events.

        The default implementation removes focus from any focus item, then
        removes focus from the scene.

        **See also** **QGraphicsItem::focusInEvent** ().
        """
        ...

    def focusInEvent(self, event: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#focusInEvent

        **[virtual protected] void QGraphicsScene::focusInEvent(QFocusEvent *
        focusEvent )**

        This event handler, for event **focusEvent** , can be reimplemented in a
        subclass to receive focus in events.

        The default implementation sets focus on the scene, and then on the last
        focus item.

        **See also** **QGraphicsItem::focusOutEvent** ().
        """
        ...

    def dropEvent(self, event: "QGraphicsSceneDragDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#dropEvent

        **[virtual protected] void
        QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent * event )**

        This event handler, for event **event** , can be reimplemented in a
        subclass to receive drop events for the scene.

        **See also** **QGraphicsItem::dropEvent** (), **dragEnterEvent** (),
        **dragMoveEvent** (), and **dragLeaveEvent** ().
        """
        ...

    def dragLeaveEvent(self, event: "QGraphicsSceneDragDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#dragLeaveEvent

        **[virtual protected] void
        QGraphicsScene::dragLeaveEvent(QGraphicsSceneDragDropEvent * event )**

        This event handler, for event **event** , can be reimplemented in a
        subclass to receive drag leave events for the scene.

        **See also** **QGraphicsItem::dragLeaveEvent** (), **dragEnterEvent**
        (), **dragMoveEvent** (), and **dropEvent** ().
        """
        ...

    def dragMoveEvent(self, event: "QGraphicsSceneDragDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#dragMoveEvent

        **[virtual protected] void
        QGraphicsScene::dragMoveEvent(QGraphicsSceneDragDropEvent * event )**

        This event handler, for event **event** , can be reimplemented in a
        subclass to receive drag move events for the scene.

        Note: See **items** () for a definition of which items are considered
        visible by this function.

        **See also** **QGraphicsItem::dragMoveEvent** (), **dragEnterEvent** (),
        **dragLeaveEvent** (), and **dropEvent** ().
        """
        ...

    def dragEnterEvent(self, event: "QGraphicsSceneDragDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#dragEnterEvent

        **[virtual protected] void
        QGraphicsScene::dragEnterEvent(QGraphicsSceneDragDropEvent * event )**

        This event handler, for event **event** , can be reimplemented in a
        subclass to receive drag enter events for the scene.

        The default implementation accepts the event and prepares the scene to
        accept drag move events.

        **See also** **QGraphicsItem::dragEnterEvent** (), **dragMoveEvent** (),
        **dragLeaveEvent** (), and **dropEvent** ().
        """
        ...

    def contextMenuEvent(self, event: "QGraphicsSceneContextMenuEvent") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#contextMenuEvent

        **[virtual protected] void
        QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent *
        contextMenuEvent )**

        This event handler, for event **contextMenuEvent** , can be
        reimplemented in a subclass to receive context menu events. The default
        implementation forwards the event to the topmost visible item that
        accepts context menu events at the position of the event. If no items
        accept context menu events at this position, the event is ignored.

        Note: See **items** () for a definition of which items are considered
        visible by this function.

        **See also** **QGraphicsItem::contextMenuEvent** ().
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#event

        **[override virtual protected] bool QGraphicsScene::event(QEvent * event
        )**

        Reimplements: **QObject::event** (QEvent *e).

        Processes the event **event** , and dispatches it to the respective
        event handlers.

        In addition to calling the convenience event handlers, this function is
        responsible for converting mouse move events to hover events for when
        there is no mouse grabber item. Hover events are delivered directly to
        items; there is no convenience function for them.

        Unlike **QWidget** , **QGraphicsScene**  does not have the convenience
        functions **enterEvent()**  and **leaveEvent()** . Use this function to
        obtain those events instead.

        Returns `true` if **event** has been recognized and processed;
        otherwise, returns `false`.

        **See also** **contextMenuEvent** (), **keyPressEvent** (),
        **keyReleaseEvent** (), **mousePressEvent** (), **mouseMoveEvent** (),
        **mouseReleaseEvent** (), **mouseDoubleClickEvent** (), **focusInEvent**
        (), and **focusOutEvent** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#clear

        **[slot] void QGraphicsScene::clear()**

        Removes and deletes all items from the scene, but otherwise leaves the
        state of the scene unchanged.

        This function was introduced in Qt 4.4.

        **See also** **addItem** ().
        """
        ...

    @typing.overload
    def invalidate(
        self,
        rect: QtCore.QRectF = ...,
        layers: typing.Union[
            "QGraphicsScene.SceneLayers", "QGraphicsScene.SceneLayer"
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#invalidate

        **[slot] void QGraphicsScene::invalidate(const QRectF & rect = QRectF(),
        QGraphicsScene::SceneLayers layers = AllLayers)**

        Invalidates and schedules a redraw of the **layers** in **rect** on the
        scene. Any cached content in **layers** is unconditionally invalidated
        and redrawn.

        You can use this function overload to notify **QGraphicsScene**  of
        changes to the background or the foreground of the scene. This function
        is commonly used for scenes with tile-based backgrounds to notify
        changes when **QGraphicsView**  has enabled **CacheBackground** .

        Example:

        **QRectF**  TileScene::rectForTile(int x, int y) const
            {
                //
        Return the rectangle for the tile at position (x, y).
                return
        **QRectF** (x * tileWidth, y * tileHeight, tileWidth, tileHeight);
            }
        void TileScene::setTile(int x, int y, const **QPixmap**  &pixmap)
            {
        // Sets or replaces the tile at position (x, y) with pixmap.
                if
        (x >= 0 && x < numTilesH && y >= 0 && y < numTilesV) {
        tiles[y][x] = pixmap;
                    invalidate(rectForTile(x, y),
        BackgroundLayer);
                }
            }

            void
        TileScene::drawBackground(**QPainter**  *painter, const **QRectF**
        &exposed)
            {
                // Draws all tiles that intersect the exposed
        area.
                for (int y = 0; y < numTilesV; ++y) {
                    for (int
        x = 0; x < numTilesH; ++x) {
                        **QRectF**  rect =
        rectForTile(x, y);
                        if (exposed.intersects(rect))
        painter->drawPixmap(rect.topLeft(), tiles[y][x]);
                    }
        }
            }

        Note that **QGraphicsView**  currently supports background caching only
        (see **QGraphicsView::CacheBackground** ). This function is equivalent
        to calling **update** () if any layer but **BackgroundLayer**  is
        passed.

        **See also** **QGraphicsView::resetCachedContent** ().
        """
        ...

    @typing.overload
    def invalidate(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        layers: typing.Union[
            "QGraphicsScene.SceneLayers", "QGraphicsScene.SceneLayer"
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#invalidate-1

        **void QGraphicsScene::invalidate(qreal x , qreal y , qreal w , qreal h
        , QGraphicsScene::SceneLayers layers = AllLayers)**

        This is an overloaded function.

        This convenience function is equivalent to calling invalidate(**QRectF**
        ( **x** , **y** , **w** , **h** ), **layers** );

        This function was introduced in Qt 4.3.
        """
        ...

    @typing.overload
    def update(self, rect: QtCore.QRectF = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#update

        **[slot] void QGraphicsScene::update(const QRectF & rect = QRectF())**

        Schedules a redraw of the area **rect** on the scene.

        **See also** **sceneRect** () and **changed** ().
        """
        ...

    @typing.overload
    def update(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#update-1

        **void QGraphicsScene::update(qreal x , qreal y , qreal w , qreal h )**

        This is an overloaded function.

        This function is equivalent to calling update(**QRectF** ( **x** , **y**
        , **w** , **h** ));

        This function was introduced in Qt 4.3.
        """
        ...

    def advance(self) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#advance

        **[slot] void QGraphicsScene::advance()**

        This slot **advances** the scene by one step, by calling
        **QGraphicsItem::advance** () for all items on the scene. This is done
        in two phases: in the first phase, all items are notified that the scene
        is about to change, and in the second phase all items are notified that
        they can move. In the first phase, **QGraphicsItem::advance** () is
        called passing a value of 0 as an argument, and 1 is passed in the
        second phase.

        Note that you can also use the **Animation Framework**  for animations.

        **See also** **QGraphicsItem::advance** () and **QTimeLine** .
        """
        ...

    def views(self) -> typing.List["QGraphicsView"]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#views

        **QList<QGraphicsView *> QGraphicsScene::views() const**

        Returns a list of all the views that display this scene.

        **See also** **QGraphicsView::scene** ().
        """
        ...

    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#inputMethodQuery

        **[virtual] QVariant
        QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery query ) const**

        This method is used by input methods to query a set of properties of the
        scene to be able to support complex input method operations as support
        for surrounding text and reconversions.

        The **query** parameter specifies which property is queried.

        **See also** **QWidget::inputMethodQuery** ().
        """
        ...

    def setForegroundBrush(
        self,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#foregroundBrush-prop

        **foregroundBrush : QBrush**

        This property holds the foreground brush of the scene.

        Change this property to set the scene's foreground to a different color,
        gradient or texture.

        The foreground is drawn after (on top of) the items. The default
        foreground brush is **Qt::NoBrush**  ( i.e. the foreground is not
        drawn).

        Example:

        **QGraphicsScene**  scene;
            **QGraphicsView**  view(&scene);
        view.show();

            // a white semi-transparent foreground
        scene.setForegroundBrush(**QColor** (255, 255, 255, 127));

            // a
        grid foreground
            scene.setForegroundBrush(**QBrush** (Qt::lightGray,
        Qt::CrossPattern));

        **QGraphicsScene::render** () calls **drawForeground** () to draw the
        scene foreground. For more detailed control over how the foreground is
        drawn, you can reimplement the **drawForeground** () function in a
        **QGraphicsScene**  subclass.

        **Access functions:**

        QBrush **foregroundBrush** () const
        void **setForegroundBrush** (const
        QBrush & **brush** )
        """
        ...

    def foregroundBrush(self) -> QtGui.QBrush:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#foregroundBrush-prop

        **foregroundBrush : QBrush**

        This property holds the foreground brush of the scene.

        Change this property to set the scene's foreground to a different color,
        gradient or texture.

        The foreground is drawn after (on top of) the items. The default
        foreground brush is **Qt::NoBrush**  ( i.e. the foreground is not
        drawn).

        Example:

        **QGraphicsScene**  scene;
            **QGraphicsView**  view(&scene);
        view.show();

            // a white semi-transparent foreground
        scene.setForegroundBrush(**QColor** (255, 255, 255, 127));

            // a
        grid foreground
            scene.setForegroundBrush(**QBrush** (Qt::lightGray,
        Qt::CrossPattern));

        **QGraphicsScene::render** () calls **drawForeground** () to draw the
        scene foreground. For more detailed control over how the foreground is
        drawn, you can reimplement the **drawForeground** () function in a
        **QGraphicsScene**  subclass.

        **Access functions:**

        QBrush **foregroundBrush** () const
        void **setForegroundBrush** (const
        QBrush & **brush** )
        """
        ...

    def setBackgroundBrush(
        self,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#backgroundBrush-prop

        **backgroundBrush : QBrush**

        This property holds the background brush of the scene.

        Set this property to changes the scene's background to a different
        color, gradient or texture. The default background brush is
        **Qt::NoBrush** . The background is drawn before (behind) the items.

        Example:

        **QGraphicsScene**  scene;
            **QGraphicsView**  view(&scene);
        view.show();

            // a blue background
        scene.setBackgroundBrush(Qt::blue);

            // a gradient background
        **QRadialGradient**  gradient(0, 0, 10);
        gradient.setSpread(**QGradient** ::RepeatSpread);
        scene.setBackgroundBrush(gradient);

        **QGraphicsScene::render** () calls **drawBackground** () to draw the
        scene background. For more detailed control over how the background is
        drawn, you can reimplement **drawBackground** () in a subclass of
        **QGraphicsScene** .

        **Access functions:**

        QBrush **backgroundBrush** () const
        void **setBackgroundBrush** (const
        QBrush & **brush** )
        """
        ...

    def backgroundBrush(self) -> QtGui.QBrush:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#backgroundBrush-prop

        **backgroundBrush : QBrush**

        This property holds the background brush of the scene.

        Set this property to changes the scene's background to a different
        color, gradient or texture. The default background brush is
        **Qt::NoBrush** . The background is drawn before (behind) the items.

        Example:

        **QGraphicsScene**  scene;
            **QGraphicsView**  view(&scene);
        view.show();

            // a blue background
        scene.setBackgroundBrush(Qt::blue);

            // a gradient background
        **QRadialGradient**  gradient(0, 0, 10);
        gradient.setSpread(**QGradient** ::RepeatSpread);
        scene.setBackgroundBrush(gradient);

        **QGraphicsScene::render** () calls **drawBackground** () to draw the
        scene background. For more detailed control over how the background is
        drawn, you can reimplement **drawBackground** () in a subclass of
        **QGraphicsScene** .

        **Access functions:**

        QBrush **backgroundBrush** () const
        void **setBackgroundBrush** (const
        QBrush & **brush** )
        """
        ...

    def mouseGrabberItem(self) -> QGraphicsItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#mouseGrabberItem

        **QGraphicsItem *QGraphicsScene::mouseGrabberItem() const**

        Returns the current mouse grabber item, or `nullptr` if no item is
        currently grabbing the mouse. The mouse grabber item is the item that
        receives all mouse events sent to the scene.

        An item becomes a mouse grabber when it receives and accepts a mouse
        press event, and it stays the mouse grabber until either of the
        following events occur:

        * If the item receives a mouse release event when there are no other
        buttons pressed, it loses the mouse grab.
          * If the item becomes
        invisible (i.e., someone calls `item->setVisible(false)`), or if it
        becomes disabled (i.e., someone calls `item->setEnabled(false)`), it
        loses the mouse grab.
          * If the item is removed from the scene, it
        loses the mouse grab.

        If the item loses its mouse grab, the scene will ignore all mouse events
        until a new item grabs the mouse (i.e., until a new item receives a
        mouse press event).
        """
        ...

    def clearFocus(self) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#clearFocus

        **void QGraphicsScene::clearFocus()**

        Clears focus from the scene. If any item has focus when this function is
        called, it will lose focus, and regain focus again once the scene
        regains focus.

        A scene that does not have focus ignores key events.

        **See also** **hasFocus** (), **setFocus** (), and **setFocusItem** ().
        """
        ...

    def setFocus(self, focusReason: QtCore.Qt.FocusReason = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#setFocus

        **void QGraphicsScene::setFocus(Qt::FocusReason focusReason =
        Qt::OtherFocusReason)**

        Sets focus on the scene by sending a **QFocusEvent**  to the scene,
        passing **focusReason** as the reason. If the scene regains focus after
        having previously lost it while an item had focus, the last focus item
        will receive focus with **focusReason** as the reason.

        If the scene already has focus, this function does nothing.

        **See also** **hasFocus** (), **clearFocus** (), and **setFocusItem**
        ().
        """
        ...

    def hasFocus(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#hasFocus

        **bool QGraphicsScene::hasFocus() const**

        Returns `true` if the scene has focus; otherwise returns `false`. If the
        scene has focus, it will will forward key events from **QKeyEvent**  to
        any item that has focus.

        **See also** **setFocus** () and **setFocusItem** ().
        """
        ...

    def setFocusItem(
        self, item: QGraphicsItem, focusReason: QtCore.Qt.FocusReason = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#setFocusItem

        **void QGraphicsScene::setFocusItem(QGraphicsItem * item ,
        Qt::FocusReason focusReason = Qt::OtherFocusReason)**

        Sets the scene's focus item to **item** , with the focus reason
        **focusReason** , after removing focus from any previous item that may
        have had focus.

        If **item** is `nullptr`, or if it either does not accept focus (i.e.,
        it does not have the **QGraphicsItem::ItemIsFocusable**  flag enabled),
        or is not visible or not enabled, this function only removes focus from
        any previous focusitem.

        If item is not `nullptr`, and the scene does not currently have focus
        (i.e., **hasFocus** () returns `false`), this function will call
        **setFocus** () automatically.

        **See also** **focusItem** (), **hasFocus** (), and **setFocus** ().
        """
        ...

    def focusItem(self) -> QGraphicsItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#focusItem

        **QGraphicsItem *QGraphicsScene::focusItem() const**

        When the scene is active, this functions returns the scene's current
        focus item, or `nullptr` if no item currently has focus. When the scene
        is inactive, this functions returns the item that will gain input focus
        when the scene becomes active.

        The focus item receives keyboard input when the scene receives a key
        event.

        **See also** **setFocusItem** (), **QGraphicsItem::hasFocus** (), and
        **isActive** ().
        """
        ...

    def removeItem(self, item: QGraphicsItem) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#removeItem

        **void QGraphicsScene::removeItem(QGraphicsItem * item )**

        Removes the item **item** and all its children from the scene. The
        ownership of **item** is passed on to the caller (i.e.,
        **QGraphicsScene**  will no longer delete **item** when destroyed).

        **See also** **addItem** ().
        """
        ...

    def addText(self, text: str, font: QtGui.QFont = ...) -> QGraphicsTextItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addText

        **QGraphicsTextItem *QGraphicsScene::addText(const QString & text ,
        const QFont & font = QFont())**

        Creates and adds a text item to the scene, and returns the item pointer.
        The text string is initialized to **text** , and its font is initialized
        to **font**.

        The item's position is initialized to (0, 0).

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        **See also** **addEllipse** (), **addLine** (), **addPixmap** (),
        **addPixmap** (), **addRect** (), **addItem** (), and **addWidget** ().
        """
        ...

    def addSimpleText(
        self, text: str, font: QtGui.QFont = ...
    ) -> QGraphicsSimpleTextItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addSimpleText

        **QGraphicsSimpleTextItem *QGraphicsScene::addSimpleText(const QString &
        text , const QFont & font = QFont())**

        Creates and adds a **QGraphicsSimpleTextItem**  to the scene, and
        returns the item pointer. The text string is initialized to **text** ,
        and its font is initialized to **font**.

        The item's position is initialized to (0, 0).

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        **See also** **addEllipse** (), **addLine** (), **addPixmap** (),
        **addPixmap** (), **addRect** (), **addItem** (), and **addWidget** ().
        """
        ...

    @typing.overload
    def addRect(
        self,
        rect: QtCore.QRectF,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
    ) -> QGraphicsRectItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addRect

        **QGraphicsRectItem *QGraphicsScene::addRect(const QRectF & rect , const
        QPen & pen = QPen(), const QBrush & brush = QBrush())**

        Creates and adds a rectangle item to the scene, and returns the item
        pointer. The geometry of the rectangle is defined by **rect** , and its
        pen and brush are initialized to **pen** and **brush**.

        Note that the item's geometry is provided in item coordinates, and its
        position is initialized to (0, 0). For example, if a **QRect** (50, 50,
        100, 100) is added, its top-left corner will be at (50, 50) relative to
        the origin in the item's coordinate system.

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        **See also** **addEllipse** (), **addLine** (), **addPixmap** (),
        **addPixmap** (), **addText** (), **addItem** (), and **addWidget** ().
        """
        ...

    @typing.overload
    def addRect(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
    ) -> QGraphicsRectItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addRect-1

        **QGraphicsRectItem *QGraphicsScene::addRect(qreal x , qreal y , qreal w
        , qreal h , const QPen & pen = QPen(), const QBrush & brush =
        QBrush())**

        This convenience function is equivalent to calling addRect(**QRectF** (
        **x** , **y** , **w** , **h** ), **pen** , **brush** ).

        This function was introduced in Qt 4.3.
        """
        ...

    def addPolygon(
        self,
        polygon: QtGui.QPolygonF,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
    ) -> QGraphicsPolygonItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addPolygon

        **QGraphicsPolygonItem *QGraphicsScene::addPolygon(const QPolygonF &
        polygon , const QPen & pen = QPen(), const QBrush & brush = QBrush())**

        Creates and adds a polygon item to the scene, and returns the item
        pointer. The polygon is defined by **polygon** , and its pen and brush
        are initialized to **pen** and **brush**.

        Note that the item's geometry is provided in item coordinates, and its
        position is initialized to (0, 0).

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        **See also** **addEllipse** (), **addLine** (), **addPath** (),
        **addRect** (), **addText** (), **addItem** (), and **addWidget** ().
        """
        ...

    def addPixmap(self, pixmap: QtGui.QPixmap) -> QGraphicsPixmapItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addPixmap

        **QGraphicsPixmapItem *QGraphicsScene::addPixmap(const QPixmap & pixmap
        )**

        Creates and adds a pixmap item to the scene, and returns the item
        pointer. The pixmap is defined by **pixmap**.

        Note that the item's geometry is provided in item coordinates, and its
        position is initialized to (0, 0).

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        **See also** **addEllipse** (), **addLine** (), **addPath** (),
        **addRect** (), **addText** (), **addItem** (), and **addWidget** ().
        """
        ...

    def addPath(
        self,
        path: QtGui.QPainterPath,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
    ) -> QGraphicsPathItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addPath

        **QGraphicsPathItem *QGraphicsScene::addPath(const QPainterPath & path ,
        const QPen & pen = QPen(), const QBrush & brush = QBrush())**

        Creates and adds a path item to the scene, and returns the item pointer.
        The geometry of the path is defined by **path** , and its pen and brush
        are initialized to **pen** and **brush**.

        Note that the item's geometry is provided in item coordinates, and its
        position is initialized to (0, 0).

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        **See also** **addEllipse** (), **addLine** (), **addPixmap** (),
        **addRect** (), **addText** (), **addItem** (), and **addWidget** ().
        """
        ...

    @typing.overload
    def addLine(
        self,
        line: QtCore.QLineF,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
    ) -> QGraphicsLineItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addLine

        **QGraphicsLineItem *QGraphicsScene::addLine(const QLineF & line , const
        QPen & pen = QPen())**

        Creates and adds a line item to the scene, and returns the item pointer.
        The geometry of the line is defined by **line** , and its pen is
        initialized to **pen**.

        Note that the item's geometry is provided in item coordinates, and its
        position is initialized to (0, 0).

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        **See also** **addEllipse** (), **addPath** (), **addPixmap** (),
        **addRect** (), **addText** (), **addItem** (), and **addWidget** ().
        """
        ...

    @typing.overload
    def addLine(
        self,
        x1: float,
        y1: float,
        x2: float,
        y2: float,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
    ) -> QGraphicsLineItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addLine-1

        **QGraphicsLineItem *QGraphicsScene::addLine(qreal x1 , qreal y1 , qreal
        x2 , qreal y2 , const QPen & pen = QPen())**

        This convenience function is equivalent to calling addLine(**QLineF** (
        **x1** , **y1** , **x2** , **y2** ), **pen** ).

        This function was introduced in Qt 4.3.
        """
        ...

    @typing.overload
    def addEllipse(
        self,
        rect: QtCore.QRectF,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
    ) -> QGraphicsEllipseItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addEllipse

        **QGraphicsEllipseItem *QGraphicsScene::addEllipse(const QRectF & rect ,
        const QPen & pen = QPen(), const QBrush & brush = QBrush())**

        Creates and adds an ellipse item to the scene, and returns the item
        pointer. The geometry of the ellipse is defined by **rect** , and its
        pen and brush are initialized to **pen** and **brush**.

        Note that the item's geometry is provided in item coordinates, and its
        position is initialized to (0, 0).

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        `true`), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        **See also** **addLine** (), **addPath** (), **addPixmap** (),
        **addRect** (), **addText** (), **addItem** (), and **addWidget** ().
        """
        ...

    @typing.overload
    def addEllipse(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ] = ...,
    ) -> QGraphicsEllipseItem:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addEllipse-1

        **QGraphicsEllipseItem *QGraphicsScene::addEllipse(qreal x , qreal y ,
        qreal w , qreal h , const QPen & pen = QPen(), const QBrush & brush =
        QBrush())**

        This convenience function is equivalent to calling addEllipse(**QRectF**
        ( **x** , **y** , **w** , **h** ), **pen** , **brush** ).

        This function was introduced in Qt 4.3.
        """
        ...

    def addItem(self, item: QGraphicsItem) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#addItem

        **void QGraphicsScene::addItem(QGraphicsItem * item )**

        Adds or moves the **item** and all its childen to this scene. This scene
        takes ownership of the **item**.

        If the item is visible (i.e., **QGraphicsItem::isVisible** () returns
        true), **QGraphicsScene**  will emit **changed** () once control goes
        back to the event loop.

        If the item is already in a different scene, it will first be removed
        from its old scene, and then added to this scene as a top-level.

        **QGraphicsScene**  will send ItemSceneChange notifications to **item**
        while it is added to the scene. If item does not currently belong to a
        scene, only one notification is sent. If it does belong to scene already
        (i.e., it is moved to this scene), **QGraphicsScene**  will send an
        addition notification as the item is removed from its previous scene.

        If the item is a panel, the scene is active, and there is no active
        panel in the scene, then the item will be activated.

        **See also** **removeItem** (), **addEllipse** (), **addLine** (),
        **addPath** (), **addPixmap** (), **addRect** (), **addText** (),
        **addWidget** (), and **Sorting** .
        """
        ...

    def destroyItemGroup(self, group: QGraphicsItemGroup) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#destroyItemGroup

        **void QGraphicsScene::destroyItemGroup(QGraphicsItemGroup * group )**

        Reparents all items in **group** to **group** 's parent item, then
        removes **group** from the scene, and finally deletes it. The items'
        positions and transformations are mapped from the group to the group's
        parent.

        **See also** **createItemGroup** () and
        **QGraphicsItemGroup::removeFromGroup** ().
        """
        ...

    def createItemGroup(
        self, items: typing.Iterable[QGraphicsItem]
    ) -> QGraphicsItemGroup:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#createItemGroup

        **QGraphicsItemGroup *QGraphicsScene::createItemGroup(const
        QList<QGraphicsItem *> & items )**

        Groups all items in **items** into a new **QGraphicsItemGroup** , and
        returns a pointer to the group. The group is created with the common
        ancestor of **items** as its parent, and with position (0, 0). The items
        are all reparented to the group, and their positions and transformations
        are mapped to the group. If **items** is empty, this function will
        return an empty top-level **QGraphicsItemGroup** .

        **QGraphicsScene**  has ownership of the group item; you do not need to
        delete it. To dismantle (ungroup) a group, call **destroyItemGroup** ().

        **See also** **destroyItemGroup** () and
        **QGraphicsItemGroup::addToGroup** ().
        """
        ...

    def clearSelection(self) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#clearSelection

        **[slot] void QGraphicsScene::clearSelection()**

        Clears the current selection.

        **See also** **setSelectionArea** () and **selectedItems** ().
        """
        ...

    @typing.overload
    def setSelectionArea(
        self, path: QtGui.QPainterPath, deviceTransform: QtGui.QTransform
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#setSelectionArea

        **void QGraphicsScene::setSelectionArea(const QPainterPath & path ,
        const QTransform & deviceTransform )**

        Sets the selection area to **path**. All items within this area are
        immediately selected, and all items outside are unselected. You can get
        the list of all selected items by calling **selectedItems** ().

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        For an item to be selected, it must be marked as **selectable**
        (**QGraphicsItem::ItemIsSelectable** ).

        This function was introduced in Qt 4.6.

        **See also** **clearSelection** () and **selectionArea** ().
        """
        ...

    @typing.overload
    def setSelectionArea(
        self,
        path: QtGui.QPainterPath,
        mode: QtCore.Qt.ItemSelectionMode = ...,
        deviceTransform: QtGui.QTransform = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#setSelectionArea-1

        **void QGraphicsScene::setSelectionArea(const QPainterPath & path ,
        Qt::ItemSelectionMode mode = Qt::IntersectsItemShape, const QTransform &
        deviceTransform = QTransform())**

        This is an overloaded function.

        Sets the selection area to **path** using **mode** to determine if items
        are included in the selection area.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        This function was introduced in Qt 4.6.

        **See also** **clearSelection** () and **selectionArea** ().
        """
        ...

    @typing.overload
    def setSelectionArea(
        self,
        path: QtGui.QPainterPath,
        selectionOperation: QtCore.Qt.ItemSelectionOperation,
        mode: QtCore.Qt.ItemSelectionMode = ...,
        deviceTransform: QtGui.QTransform = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#setSelectionArea-2

        **void QGraphicsScene::setSelectionArea(const QPainterPath & path ,
        Qt::ItemSelectionOperation selectionOperation , Qt::ItemSelectionMode
        mode = Qt::IntersectsItemShape, const QTransform & deviceTransform =
        QTransform())**

        This is an overloaded function.

        Sets the selection area to **path** using **mode** to determine if items
        are included in the selection area.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        **selectionOperation** determines what to do with the currently selected
        items.

        This function was introduced in Qt 5.5.

        **See also** **clearSelection** () and **selectionArea** ().
        """
        ...

    def selectedItems(self) -> typing.List[QGraphicsItem]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#selectedItems

        **QList<QGraphicsItem *> QGraphicsScene::selectedItems() const**

        Returns a list of all currently selected items. The items are returned
        in no particular order.

        **See also** **setSelectionArea** ().
        """
        ...

    def collidingItems(
        self, item: QGraphicsItem, mode: QtCore.Qt.ItemSelectionMode = ...
    ) -> typing.List[QGraphicsItem]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#collidingItems

        **QList<QGraphicsItem *> QGraphicsScene::collidingItems(const
        QGraphicsItem * item , Qt::ItemSelectionMode mode =
        Qt::IntersectsItemShape) const**

        Returns a list of all items that collide with **item**. Collisions are
        determined by calling **QGraphicsItem::collidesWithItem** (); the
        collision detection is determined by **mode**. By default, all items
        whose shape intersects **item** or is contained inside **item** 's shape
        are returned.

        The items are returned in descending stacking order (i.e., the first
        item in the list is the uppermost item, and the last item is the
        lowermost item).

        **See also** **items** (), **itemAt** (),
        **QGraphicsItem::collidesWithItem** (), and **Sorting** .
        """
        ...

    @typing.overload
    def items(self, order: QtCore.Qt.SortOrder = ...) -> typing.List[QGraphicsItem]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#items

        **QList<QGraphicsItem *> QGraphicsScene::items(Qt::SortOrder order =
        Qt::DescendingOrder) const**

        Returns an ordered list of all items on the scene. **order** decides the
        stacking order.

        **See also** **addItem** (), **removeItem** (), and **Sorting** .
        """
        ...

    @typing.overload
    def items(
        self,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        mode: QtCore.Qt.ItemSelectionMode = ...,
        order: QtCore.Qt.SortOrder = ...,
        deviceTransform: QtGui.QTransform = ...,
    ) -> typing.List[QGraphicsItem]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#items-1

        **QList<QGraphicsItem *> QGraphicsScene::items(const QPointF & pos ,
        Qt::ItemSelectionMode mode = Qt::IntersectsItemShape, Qt::SortOrder
        order = Qt::DescendingOrder, const QTransform & deviceTransform =
        QTransform()) const**

        Returns all visible items that, depending on **mode** , are at the
        specified **pos** in a list sorted using **order**. In this case,
        "visible" defines items for which: isVisible() returns `true`,
        effectiveOpacity() returns a value greater than 0.0 (which is fully
        transparent) and the parent item does not clip it.

        The default value for **mode** is **Qt::IntersectsItemShape** ; all
        items whose exact shape intersects with **pos** are returned.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        This function was introduced in Qt 4.6.

        **See also** **itemAt** () and **Sorting** .
        """
        ...

    @typing.overload
    def items(
        self,
        rect: QtCore.QRectF,
        mode: QtCore.Qt.ItemSelectionMode = ...,
        order: QtCore.Qt.SortOrder = ...,
        deviceTransform: QtGui.QTransform = ...,
    ) -> typing.List[QGraphicsItem]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#items-2

        **QList<QGraphicsItem *> QGraphicsScene::items(const QRectF & rect ,
        Qt::ItemSelectionMode mode = Qt::IntersectsItemShape, Qt::SortOrder
        order = Qt::DescendingOrder, const QTransform & deviceTransform =
        QTransform()) const**

        This is an overloaded function.

        Returns all visible items that, depending on **mode** , are either
        inside or intersect with the specified **rect** , in a list sorted using
        **order**. In this case, "visible" defines items for which: isVisible()
        returns `true`, effectiveOpacity() returns a value greater than 0.0
        (which is fully transparent) and the parent item does not clip it.

        The default value for **mode** is **Qt::IntersectsItemShape** ; all
        items whose exact shape intersects with or is contained by **rect** are
        returned.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        This function was introduced in Qt 4.6.

        **See also** **itemAt** () and **Sorting** .
        """
        ...

    @typing.overload
    def items(
        self,
        polygon: QtGui.QPolygonF,
        mode: QtCore.Qt.ItemSelectionMode = ...,
        order: QtCore.Qt.SortOrder = ...,
        deviceTransform: QtGui.QTransform = ...,
    ) -> typing.List[QGraphicsItem]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#items-3

        **QList<QGraphicsItem *> QGraphicsScene::items(const QPolygonF & polygon
        , Qt::ItemSelectionMode mode = Qt::IntersectsItemShape, Qt::SortOrder
        order = Qt::DescendingOrder, const QTransform & deviceTransform =
        QTransform()) const**

        This is an overloaded function.

        Returns all visible items that, depending on **mode** , are either
        inside or intersect with the specified **polygon** , in a list sorted
        using **order**. In this case, "visible" defines items for which:
        isVisible() returns `true`, effectiveOpacity() returns a value greater
        than 0.0 (which is fully transparent) and the parent item does not clip
        it.

        The default value for **mode** is **Qt::IntersectsItemShape** ; all
        items whose exact shape intersects with or is contained by **polygon**
        are returned.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        This function was introduced in Qt 4.6.

        **See also** **itemAt** () and **Sorting** .
        """
        ...

    @typing.overload
    def items(
        self,
        path: QtGui.QPainterPath,
        mode: QtCore.Qt.ItemSelectionMode = ...,
        order: QtCore.Qt.SortOrder = ...,
        deviceTransform: QtGui.QTransform = ...,
    ) -> typing.List[QGraphicsItem]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#items-4

        **QList<QGraphicsItem *> QGraphicsScene::items(const QPainterPath & path
        , Qt::ItemSelectionMode mode = Qt::IntersectsItemShape, Qt::SortOrder
        order = Qt::DescendingOrder, const QTransform & deviceTransform =
        QTransform()) const**

        This is an overloaded function.

        Returns all visible items that, depending on **mode** , are either
        inside or intersect with the specified **path** , in a list sorted using
        **order**. In this case, "visible" defines items for which: isVisible()
        returns `true`, effectiveOpacity() returns a value greater than 0.0
        (which is fully transparent) and the parent item does not clip it.

        The default value for **mode** is **Qt::IntersectsItemShape** ; all
        items whose exact shape intersects with or is contained by **path** are
        returned.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        This function was introduced in Qt 4.6.

        **See also** **itemAt** () and **Sorting** .
        """
        ...

    @typing.overload
    def items(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        mode: QtCore.Qt.ItemSelectionMode,
        order: QtCore.Qt.SortOrder,
        deviceTransform: QtGui.QTransform = ...,
    ) -> typing.List[QGraphicsItem]:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#items-6

        **QList<QGraphicsItem *> QGraphicsScene::items(qreal x , qreal y , qreal
        w , qreal h , Qt::ItemSelectionMode mode , Qt::SortOrder order , const
        QTransform & deviceTransform = QTransform()) const**

        This is an overloaded function.

        Returns all visible items that, depending on **mode** , are either
        inside or intersect with the rectangle defined by **x** , **y** , **w**
        and **h** , in a list sorted using **order**. In this case, "visible"
        defines items for which: isVisible() returns `true`, effectiveOpacity()
        returns a value greater than 0.0 (which is fully transparent) and the
        parent item does not clip it.

        **deviceTransform** is the transformation that applies to the view, and
        needs to be provided if the scene contains items that ignore
        transformations.

        This function was introduced in Qt 4.6.
        """
        ...

    def itemsBoundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#itemsBoundingRect

        **QRectF QGraphicsScene::itemsBoundingRect() const**

        Calculates and returns the bounding rect of all items on the scene. This
        function works by iterating over all items, and because of this, it can
        be slow for large scenes.

        **See also** **sceneRect** ().
        """
        ...

    def setItemIndexMethod(self, method: "QGraphicsScene.ItemIndexMethod") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#itemIndexMethod-prop

        **itemIndexMethod : ItemIndexMethod**

        This property holds the item indexing method.

        **QGraphicsScene**  applies an indexing algorithm to the scene, to speed
        up item discovery functions like **items** () and **itemAt** ().
        Indexing is most efficient for static scenes (i.e., where items don't
        move around). For dynamic scenes, or scenes with many animated items,
        the index bookkeeping can outweight the fast lookup speeds.

        For the common case, the default index method **BspTreeIndex**  works
        fine. If your scene uses many animations and you are experiencing
        slowness, you can disable indexing by calling
        `setItemIndexMethod(NoIndex)`.

        **Access functions:**

        QGraphicsScene::ItemIndexMethod **itemIndexMethod** () const
        void
        **setItemIndexMethod** (QGraphicsScene::ItemIndexMethod **method** )

        **See also** **bspTreeDepth** .
        """
        ...

    def itemIndexMethod(self) -> "QGraphicsScene.ItemIndexMethod":
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#itemIndexMethod-prop

        **itemIndexMethod : ItemIndexMethod**

        This property holds the item indexing method.

        **QGraphicsScene**  applies an indexing algorithm to the scene, to speed
        up item discovery functions like **items** () and **itemAt** ().
        Indexing is most efficient for static scenes (i.e., where items don't
        move around). For dynamic scenes, or scenes with many animated items,
        the index bookkeeping can outweight the fast lookup speeds.

        For the common case, the default index method **BspTreeIndex**  works
        fine. If your scene uses many animations and you are experiencing
        slowness, you can disable indexing by calling
        `setItemIndexMethod(NoIndex)`.

        **Access functions:**

        QGraphicsScene::ItemIndexMethod **itemIndexMethod** () const
        void
        **setItemIndexMethod** (QGraphicsScene::ItemIndexMethod **method** )

        **See also** **bspTreeDepth** .
        """
        ...

    def render(
        self,
        painter: QtGui.QPainter,
        target: QtCore.QRectF = ...,
        source: QtCore.QRectF = ...,
        mode: QtCore.Qt.AspectRatioMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#render

        **void QGraphicsScene::render(QPainter * painter , const QRectF & target
        = QRectF(), const QRectF & source = QRectF(), Qt::AspectRatioMode
        aspectRatioMode = Qt::KeepAspectRatio)**

        Renders the **source** rect from scene into **target** , using
        **painter**. This function is useful for capturing the contents of the
        scene onto a paint device, such as a **QImage**  (e.g., to take a
        screenshot), or for printing with QPrinter. For example:

        **QGraphicsScene**  scene;
            scene.addItem(...
            ...
            QPrinter
        printer(QPrinter::HighResolution);
        printer.setPaperSize(QPrinter::A4);

            **QPainter**
        painter(&printer);
            scene.render(&painter);

        If **source** is a null rect, this function will use **sceneRect** () to
        determine what to render. If **target** is a null rect, the dimensions
        of **painter** 's paint device will be used.

        The source rect contents will be transformed according to
        **aspectRatioMode** to fit into the target rect. By default, the aspect
        ratio is kept, and **source** is scaled to fit in **target**.

        **See also** **QGraphicsView::render** ().
        """
        ...

    @typing.overload
    def setSceneRect(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#sceneRect-prop

        **sceneRect : QRectF**

        This property holds the scene rectangle; the bounding rectangle of the
        scene

        The scene rectangle defines the extent of the scene. It is primarily
        used by **QGraphicsView**  to determine the view's default scrollable
        area, and by **QGraphicsScene**  to manage item indexing.

        If unset, or if set to a null **QRectF** , sceneRect() will return the
        largest bounding rect of all items on the scene since the scene was
        created (i.e., a rectangle that grows when items are added to or moved
        in the scene, but never shrinks).

        **Access functions:**

        QRectF **sceneRect** () const
        void **setSceneRect** (const QRectF &
        **rect** )
        void **setSceneRect** (qreal **x** , qreal **y** , qreal
        **w** , qreal **h** )

        **See also** **width** (), **height** (), and
        **QGraphicsView::sceneRect** .
        """
        ...

    @typing.overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#sceneRect-prop

        **sceneRect : QRectF**

        This property holds the scene rectangle; the bounding rectangle of the
        scene

        The scene rectangle defines the extent of the scene. It is primarily
        used by **QGraphicsView**  to determine the view's default scrollable
        area, and by **QGraphicsScene**  to manage item indexing.

        If unset, or if set to a null **QRectF** , sceneRect() will return the
        largest bounding rect of all items on the scene since the scene was
        created (i.e., a rectangle that grows when items are added to or moved
        in the scene, but never shrinks).

        **Access functions:**

        QRectF **sceneRect** () const
        void **setSceneRect** (const QRectF &
        **rect** )
        void **setSceneRect** (qreal **x** , qreal **y** , qreal
        **w** , qreal **h** )

        **See also** **width** (), **height** (), and
        **QGraphicsView::sceneRect** .
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#height

        **qreal QGraphicsScene::height() const**

        This convenience function is equivalent to calling
        `sceneRect().height()`.

        **See also** **width** ().
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#width

        **qreal QGraphicsScene::width() const**

        This convenience function is equivalent to calling **sceneRect**
        ().width().

        **See also** **height** ().
        """
        ...

    def sceneRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#sceneRect-prop

        **sceneRect : QRectF**

        This property holds the scene rectangle; the bounding rectangle of the
        scene

        The scene rectangle defines the extent of the scene. It is primarily
        used by **QGraphicsView**  to determine the view's default scrollable
        area, and by **QGraphicsScene**  to manage item indexing.

        If unset, or if set to a null **QRectF** , sceneRect() will return the
        largest bounding rect of all items on the scene since the scene was
        created (i.e., a rectangle that grows when items are added to or moved
        in the scene, but never shrinks).

        **Access functions:**

        QRectF **sceneRect** () const
        void **setSceneRect** (const QRectF &
        **rect** )
        void **setSceneRect** (qreal **x** , qreal **y** , qreal
        **w** , qreal **h** )

        **See also** **width** (), **height** (), and
        **QGraphicsView::sceneRect** .
        """
        ...

    @property
    def changed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#changed

        **[signal] void QGraphicsScene::changed(const QList<QRectF> & region )**

        This signal is emitted by **QGraphicsScene**  when control reaches the
        event loop, if the scene content changes. The **region** parameter
        contains a list of scene rectangles that indicate the area that has been
        changed.

        **See also** **QGraphicsView::updateScene** ().
        """
        ...

    @property
    def focusItemChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#focusItemChanged

        **[signal] void QGraphicsScene::focusItemChanged(QGraphicsItem *
        newFocusItem , QGraphicsItem * oldFocusItem , Qt::FocusReason reason )**

        This signal is emitted by **QGraphicsScene**  whenever focus changes in
        the scene (i.e., when an item gains or loses input focus, or when focus
        passes from one item to another). You can connect to this signal if you
        need to keep track of when other items gain input focus. It is
        particularly useful for implementing virtual keyboards, input methods,
        and cursor items.

        **oldFocusItem** is a pointer to the item that previously had focus, or
        0 if no item had focus before the signal was emitted. **newFocusItem**
        is a pointer to the item that gained input focus, or `nullptr` if focus
        was lost. **reason** is the reason for the focus change (e.g., if the
        scene was deactivated while an input field had focus, **oldFocusItem**
        would point to the input field item, **newFocusItem** would be
        `nullptr`, and **reason** would be **Qt::ActiveWindowFocusReason** .
        """
        ...

    @property
    def sceneRectChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#sceneRectChanged

        **[signal] void QGraphicsScene::sceneRectChanged(const QRectF & rect )**

        This signal is emitted by **QGraphicsScene**  whenever the scene rect
        changes. The **rect** parameter is the new scene rectangle.

        **See also** **QGraphicsView::updateSceneRect** ().
        """
        ...

    @property
    def selectionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscene.html#selectionChanged

        **[signal] void QGraphicsScene::selectionChanged()**

        This signal is emitted by **QGraphicsScene**  whenever the selection
        changes. You can call **selectedItems** () to get the new list of
        selected items.

        The selection changes whenever an item is selected or unselected, a
        selection area is set, cleared or otherwise changed, if a preselected
        item is added to the scene, or if a selected item is removed from the
        scene.

        **QGraphicsScene**  emits this signal only once for group selection
        operations. For example, if you set a selection area, select or unselect
        a **QGraphicsItemGroup** , or if you add or remove from the scene a
        parent item that contains several selected items, selectionChanged() is
        emitted only once after the operation has completed (instead of once for
        each item).

        This function was introduced in Qt 4.3.

        **See also** **setSelectionArea** (), **selectedItems** (), and
        **QGraphicsItem::setSelected** ().
        """
        ...
