"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QDirModel(QtCore.QAbstractItemModel):
    """
    https://doc.qt.io/qt-5/qdirmodel.html

    **Detailed Description**

    The usage of QDirModel is not recommended anymore. The **QFileSystemModel**
    class is a more performant alternative.

    This class provides access to the local filesystem, providing functions for
    renaming and removing files and directories, and for creating new
    directories. In the simplest case, it can be used with a suitable display
    widget as part of a browser or filer.

    QDirModel keeps a cache with file information. The cache needs to be updated
    with **refresh** ().

    QDirModel can be accessed using the standard interface provided by
    **QAbstractItemModel** , but it also provides some convenience functions
    that are specific to a directory model. The **fileInfo** () and **isDir** ()
    functions provide information about the underlying files and directories
    related to items in the model.

    Directories can be created and removed using **mkdir** (), **rmdir** (), and
    the model will be automatically updated to take the changes into account.

    **Note:** QDirModel requires an instance of **QApplication** .

    **See also** **nameFilters** (), **setFilter** (), **filter** (),
    **QListView** , **QTreeView** , **QFileSystemModel** , **Dir View Example**
    , and **Model Classes** .
    """

    class Roles(int):
        FileIconRole: QDirModel = ...
        FilePathRole: QDirModel = ...
        FileNameRole: QDirModel = ...

    @typing.overload
    def __init__(
        self,
        nameFilters: typing.Iterable[str],
        filters: typing.Union[QtCore.QDir.Filters, QtCore.QDir.Filter],
        sort: typing.Union[QtCore.QDir.SortFlags, QtCore.QDir.SortFlag],
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#QDirModel

        **QDirModel::QDirModel(const QStringList & nameFilters , QDir::Filters
        filters , QDir::SortFlags sort , QObject * parent = nullptr)**

        Constructs a new directory model with the given **parent**. Only those
        files matching the **nameFilters** and the **filters** are included in
        the model. The sort order is given by the **sort** flags.
        """
        ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#QDirModel-1

        **QDirModel::QDirModel(QObject * parent = nullptr)**

        Constructs a directory model with the given **parent**.
        """
        ...

    def fileInfo(self, index: QtCore.QModelIndex) -> QtCore.QFileInfo:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#fileInfo

        **QFileInfo QDirModel::fileInfo(const QModelIndex & index ) const**

        Returns the file information for the specified model **index**.

        **Note:** If the model index represents a symbolic link in the
        underlying filing system, the file information returned will contain
        information about the symbolic link itself, regardless of whether
        **resolveSymlinks**  is enabled or not.

        **See also** **QFileInfo::symLinkTarget** ().
        """
        ...

    def fileIcon(self, index: QtCore.QModelIndex) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#fileIcon

        **QIcon QDirModel::fileIcon(const QModelIndex & index ) const**

        Returns the icons for the item stored in the model under the given
        **index**.
        """
        ...

    def fileName(self, index: QtCore.QModelIndex) -> str:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#fileName

        **QString QDirModel::fileName(const QModelIndex & index ) const**

        Returns the name of the item stored in the model under the **index**
        given.
        """
        ...

    def filePath(self, index: QtCore.QModelIndex) -> str:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#filePath

        **QString QDirModel::filePath(const QModelIndex & index ) const**

        Returns the path of the item stored in the model under the **index**
        given.
        """
        ...

    def remove(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#remove

        **bool QDirModel::remove(const QModelIndex & index )**

        Removes the model item **index** from the directory model and **deletes
        the corresponding file from the file system** , returning true if
        successful. If the item cannot be removed, false is returned.

        **Warning:** This function deletes files from the file system; it does
        **not** move them to a location where they can be recovered.

        **See also** **rmdir** ().
        """
        ...

    def rmdir(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#rmdir

        **bool QDirModel::rmdir(const QModelIndex & index )**

        Removes the directory corresponding to the model item **index** in the
        directory model and **deletes the corresponding directory from the file
        system** , returning true if successful. If the directory cannot be
        removed, false is returned.

        **Warning:** This function deletes directories from the file system; it
        does **not** move them to a location where they can be recovered.

        **See also** **remove** ().
        """
        ...

    def mkdir(self, parent: QtCore.QModelIndex, name: str) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#mkdir

        **QModelIndex QDirModel::mkdir(const QModelIndex & parent , const
        QString & name )**

        Create a directory with the **name** in the **parent** model item.
        """
        ...

    def isDir(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#isDir

        **bool QDirModel::isDir(const QModelIndex & index ) const**

        Returns `true` if the model item **index** represents a directory;
        otherwise returns `false`.
        """
        ...

    def refresh(self, parent: QtCore.QModelIndex = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#refresh

        **[slot] void QDirModel::refresh(const QModelIndex & parent =
        QModelIndex())**

        **QDirModel**  caches file information. This function updates the cache.
        The **parent** parameter is the directory from which the model is
        updated; the default value will update the model from root directory of
        the file system (the entire model).
        """
        ...

    def lazyChildCount(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#lazyChildCount-prop

        **lazyChildCount : bool**

        This property holds whether the directory model optimizes the
        **hasChildren**  function to only check if the item is a directory.

        If this property is set to false, the directory model will make sure
        that a directory actually containes any files before reporting that it
        has children. Otherwise the directory model will report that an item has
        children if the item is a directory.

        This property is `false` by default

        **Access functions:**

        bool **lazyChildCount** () const
        void **setLazyChildCount** (bool
        **enable** )
        """
        ...

    def setLazyChildCount(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#lazyChildCount-prop

        **lazyChildCount : bool**

        This property holds whether the directory model optimizes the
        **hasChildren**  function to only check if the item is a directory.

        If this property is set to false, the directory model will make sure
        that a directory actually containes any files before reporting that it
        has children. Otherwise the directory model will report that an item has
        children if the item is a directory.

        This property is `false` by default

        **Access functions:**

        bool **lazyChildCount** () const
        void **setLazyChildCount** (bool
        **enable** )
        """
        ...

    def isReadOnly(self) -> bool:
        ...

    def setReadOnly(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#readOnly-prop

        **readOnly : bool**

        This property holds whether the directory model allows writing to the
        file system

        If this property is set to false, the directory model will allow
        renaming, copying and deleting of files and directories.

        This property is `true` by default

        **Access functions:**

        bool **isReadOnly** () const
        void **setReadOnly** (bool **enable** )
        """
        ...

    def resolveSymlinks(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#resolveSymlinks-prop

        **resolveSymlinks : bool**

        This property holds whether the directory model should resolve symbolic
        links

        This is only relevant on operating systems that support symbolic links.

        **Access functions:**

        bool **resolveSymlinks** () const
        void **setResolveSymlinks** (bool
        **enable** )

        **Member Function Documentation**
        """
        ...

    def setResolveSymlinks(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#resolveSymlinks-prop

        **resolveSymlinks : bool**

        This property holds whether the directory model should resolve symbolic
        links

        This is only relevant on operating systems that support symbolic links.

        **Access functions:**

        bool **resolveSymlinks** () const
        void **setResolveSymlinks** (bool
        **enable** )

        **Member Function Documentation**
        """
        ...

    def sorting(self) -> QtCore.QDir.SortFlags:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#sorting

        **QDir::SortFlags QDirModel::sorting() const**

        Returns the sorting method used for the directory model.

        **See also** **setSorting** () and **QDir::SortFlags** .
        """
        ...

    def setSorting(
        self, sort: typing.Union[QtCore.QDir.SortFlags, QtCore.QDir.SortFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#setSorting

        **void QDirModel::setSorting(QDir::SortFlags sort )**

        Sets the directory model's sorting order to that specified by **sort**.

        **See also** **sorting** () and **QDir::SortFlags** .
        """
        ...

    def filter(self) -> QtCore.QDir.Filters:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#filter

        **QDir::Filters QDirModel::filter() const**

        Returns the filter specification for the directory model.

        **See also** **setFilter** () and **QDir::Filters** .
        """
        ...

    def setFilter(
        self, filters: typing.Union[QtCore.QDir.Filters, QtCore.QDir.Filter]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#setFilter

        **void QDirModel::setFilter(QDir::Filters filters )**

        Sets the directory model's filter to that specified by **filters**.

        Note that the filter you set should always include the **QDir::AllDirs**
        enum value, otherwise **QDirModel**  won't be able to read the directory
        structure.

        **See also** **filter** () and **QDir::Filters** .
        """
        ...

    def nameFilters(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#nameFilters

        **QStringList QDirModel::nameFilters() const**

        Returns a list of filters applied to the names in the model.

        **See also** **setNameFilters** ().
        """
        ...

    def setNameFilters(self, filters: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#setNameFilters

        **void QDirModel::setNameFilters(const QStringList & filters )**

        Sets the name **filters** for the directory model.

        **See also** **nameFilters** ().
        """
        ...

    def iconProvider(self) -> "QFileIconProvider":
        """
        https://doc.qt.io/qt-5/qdirmodel.html#iconProvider

        **QFileIconProvider *QDirModel::iconProvider() const**

        Returns the file icon provider for this directory model.

        **See also** **setIconProvider** ().
        """
        ...

    def setIconProvider(self, provider: "QFileIconProvider") -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#setIconProvider

        **void QDirModel::setIconProvider(QFileIconProvider * provider )**

        Sets the **provider** of file icons for the directory model.

        **See also** **iconProvider** ().
        """
        ...

    def supportedDropActions(self) -> QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#supportedDropActions

        **[override virtual] Qt::DropActions QDirModel::supportedDropActions()
        const**

        Reimplements: **QAbstractItemModel::supportedDropActions** () const.

        Returns the drop actions supported by this model.

        **See also** **Qt::DropActions** .
        """
        ...

    def dropMimeData(
        self,
        data: QtCore.QMimeData,
        action: QtCore.Qt.DropAction,
        row: int,
        column: int,
        parent: QtCore.QModelIndex,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#dropMimeData

        **[override virtual] bool QDirModel::dropMimeData(const QMimeData * data
        , Qt::DropAction action , int row , int column , const QModelIndex &
        parent )**

        Reimplements: **QAbstractItemModel::dropMimeData** (const QMimeData
        *data, Qt::DropAction action, int row, int column, const QModelIndex
        &parent).

        Handles the **data** supplied by a drag and drop operation that ended
        with the given **action** over the row in the model specified by the
        **row** and **column** and by the **parent** index.

        Returns `true` if the drop was successful, and false otherwise.

        **See also** **supportedDropActions** ().
        """
        ...

    def mimeData(
        self, indexes: typing.Iterable[QtCore.QModelIndex]
    ) -> QtCore.QMimeData:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#mimeData

        **[override virtual] QMimeData *QDirModel::mimeData(const
        QModelIndexList & indexes ) const**

        Reimplements: **QAbstractItemModel::mimeData** (const QModelIndexList
        &indexes) const.

        Returns an object that contains a serialized description of the
        specified **indexes**. The format used to describe the items
        corresponding to the indexes is obtained from the **mimeTypes** ()
        function.

        If the list of indexes is empty, 0 is returned rather than a serialized
        empty list.
        """
        ...

    def mimeTypes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#mimeTypes

        **[override virtual] QStringList QDirModel::mimeTypes() const**

        Reimplements: **QAbstractItemModel::mimeTypes** () const.

        Returns a list of MIME types that can be used to describe a list of
        items in the model.
        """
        ...

    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#sort

        **[override virtual] void QDirModel::sort(int column , Qt::SortOrder
        order = Qt::AscendingOrder)**

        Reimplements: **QAbstractItemModel::sort** (int column, Qt::SortOrder
        order).

        Sort the model items in the **column** using the **order** given. The
        order is a value defined in **Qt::SortOrder** .
        """
        ...

    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#flags

        **[override virtual] Qt::ItemFlags QDirModel::flags(const QModelIndex &
        index ) const**

        Reimplements: **QAbstractItemModel::flags** (const QModelIndex &index)
        const.

        Returns the item flags for the given **index** in the model.

        **See also** **Qt::ItemFlags** .
        """
        ...

    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#hasChildren

        **[override virtual] bool QDirModel::hasChildren(const QModelIndex &
        parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::hasChildren** (const QModelIndex
        &parent) const.

        Returns `true` if the **parent** model item has children; otherwise
        returns `false`.
        """
        ...

    def headerData(
        self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#headerData

        **[override virtual] QVariant QDirModel::headerData(int section ,
        Qt::Orientation orientation , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::headerData** (int section,
        Qt::Orientation orientation, int role) const.

        Returns the data stored under the given **role** for the specified
        **section** of the header with the given **orientation**.
        """
        ...

    def setData(
        self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#setData

        **[override virtual] bool QDirModel::setData(const QModelIndex & index ,
        const QVariant & value , int role = Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setData** (const QModelIndex &index,
        const QVariant &value, int role).

        Sets the data for the model item **index** with the given **role** to
        the data referenced by the **value**. Returns `true` if successful;
        otherwise returns `false`.

        **See also** **data** () and **Qt::ItemDataRole** .
        """
        ...

    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#data

        **[override virtual] QVariant QDirModel::data(const QModelIndex & index
        , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::data** (const QModelIndex &index,
        int role) const.

        Returns the data for the model item **index** with the given **role**.

        **See also** **setData** ().
        """
        ...

    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#columnCount

        **[override virtual] int QDirModel::columnCount(const QModelIndex &
        parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::columnCount** (const QModelIndex
        &parent) const.

        Returns the number of columns in the **parent** model item.
        """
        ...

    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#rowCount

        **[override virtual] int QDirModel::rowCount(const QModelIndex & parent
        = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount** (const QModelIndex
        &parent) const.

        Returns the number of rows in the **parent** model item.
        """
        ...

    @typing.overload
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#parent

        **[override virtual] QModelIndex QDirModel::parent(const QModelIndex &
        child ) const**

        Reimplements: **QAbstractItemModel::parent** (const QModelIndex &index)
        const.

        Return the parent of the given **child** model item.
        """
        ...

    @typing.overload
    def parent(self) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#parent

        **[override virtual] QModelIndex QDirModel::parent(const QModelIndex &
        child ) const**

        Reimplements: **QAbstractItemModel::parent** (const QModelIndex &index)
        const.

        Return the parent of the given **child** model item.
        """
        ...

    @typing.overload
    def index(
        self, row: int, column: int, parent: QtCore.QModelIndex = ...
    ) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#index

        **[override virtual] QModelIndex QDirModel::index(int row , int column ,
        const QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::index** (int row, int column, const
        QModelIndex &parent) const.

        Returns the model item index for the item in the **parent** with the
        given **row** and **column**.
        """
        ...

    @typing.overload
    def index(self, path: str, column: int = ...) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qdirmodel.html#index-1

        **QModelIndex QDirModel::index(const QString & path , int column = 0)
        const**

        This is an overloaded function.

        Returns the model item index for the given **path**.
        """
        ...
