"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QButtonGroup(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qbuttongroup.html

    **Detailed Description**

    QButtonGroup provides an abstract container into which button widgets can be
    placed. It does not provide a visual representation of this container (see
    **QGroupBox**  for a container widget), but instead manages the states of
    each of the buttons in the group.

    An **exclusive**  button group switches off all checkable (toggle) buttons
    except the one that has been clicked. By default, a button group is
    exclusive. The buttons in a button group are usually checkable
    **QPushButton** s, **QCheckBox** es (normally for non-exclusive button
    groups), or **QRadioButton** s. If you create an exclusive button group, you
    should ensure that one of the buttons in the group is initially checked;
    otherwise, the group will initially be in a state where no buttons are
    checked.

    A button can be added to the group with **addButton** () and removed with
    **removeButton** (). If the group is exclusive, the currently checked button
    is available with **checkedButton** (). If a button is clicked, the
    **buttonClicked** () signal is emitted; for a checkable button in an
    exclusive group this means that the button has been checked. The list of
    buttons in the group is returned by **buttons** ().

    In addition, QButtonGroup can map between integers and buttons. You can
    assign an integer id to a button with **setId** (), and retrieve it with
    **id** (). The id of the currently checked button is available with
    **checkedId** (), and there is an overloaded signal **buttonClicked** ()
    which emits the id of the button. The id `-1` is reserved by QButtonGroup to
    mean "no such button". The purpose of the mapping mechanism is to simplify
    the representation of enum values in a user interface.

    **See also** **QGroupBox** , **QPushButton** , **QCheckBox** , and
    **QRadioButton** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#QButtonGroup

        **QButtonGroup::QButtonGroup(QObject * parent = nullptr)**

        Constructs a new, empty button group with the given **parent**.

        **See also** **addButton** () and **setExclusive** ().
        """
        ...

    def checkedId(self) -> int:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#checkedId

        **int QButtonGroup::checkedId() const**

        Returns the id of the **checkedButton** (), or -1 if no button is
        checked.

        This function was introduced in Qt 4.1.

        **See also** **setId** ().
        """
        ...

    def id(self, button: QAbstractButton) -> int:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#id

        **int QButtonGroup::id(QAbstractButton * button ) const**

        Returns the id for the specified **button** , or -1 if no such button
        exists.

        This function was introduced in Qt 4.1.

        **See also** **setId** ().
        """
        ...

    def setId(self, button: QAbstractButton, id: int) -> None:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#setId

        **void QButtonGroup::setId(QAbstractButton * button , int id )**

        Sets the **id** for the specified **button**. Note that **id** cannot be
        -1.

        This function was introduced in Qt 4.1.

        **See also** **id** ().
        """
        ...

    def checkedButton(self) -> QAbstractButton:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#checkedButton

        **QAbstractButton *QButtonGroup::checkedButton() const**

        Returns the button group's checked button, or `nullptr` if no buttons
        are checked.

        **See also** **buttonClicked** ().
        """
        ...

    def button(self, id: int) -> QAbstractButton:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#button

        **QAbstractButton *QButtonGroup::button(int id ) const**

        Returns the button with the specified **id** , or `nullptr` if no such
        button exists.

        This function was introduced in Qt 4.1.
        """
        ...

    def buttons(self) -> typing.List[QAbstractButton]:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#buttons

        **QList<QAbstractButton *> QButtonGroup::buttons() const**

        Returns the button group's list of buttons. This may be empty.

        **See also** **addButton** () and **removeButton** ().
        """
        ...

    def removeButton(self, a0: QAbstractButton) -> None:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#removeButton

        **void QButtonGroup::removeButton(QAbstractButton * button )**

        Removes the given **button** from the button group.

        **See also** **addButton** () and **buttons** ().
        """
        ...

    def addButton(self, a0: QAbstractButton, id: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#addButton

        **void QButtonGroup::addButton(QAbstractButton * button , int id = -1)**

        Adds the given **button** to the button group. If **id** is -1, an id
        will be assigned to the button. Automatically assigned ids are
        guaranteed to be negative, starting with -2. If you are assigning your
        own ids, use positive values to avoid conflicts.

        **See also** **removeButton** () and **buttons** ().
        """
        ...

    def exclusive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#exclusive-prop

        **exclusive : bool**

        This property holds whether the button group is exclusive

        If this property is `true`, then only one button in the group can be
        checked at any given time. The user can click on any button to check it,
        and that button will replace the existing one as the checked button in
        the group.

        In an exclusive group, the user cannot uncheck the currently checked
        button by clicking on it; instead, another button in the group must be
        clicked to set the new checked button for that group.

        By default, this property is `true`.

        **Access functions:**

        bool **exclusive** () const
        void **setExclusive** ( **bool** )

        **Member Function Documentation**
        """
        ...

    def setExclusive(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#exclusive-prop

        **exclusive : bool**

        This property holds whether the button group is exclusive

        If this property is `true`, then only one button in the group can be
        checked at any given time. The user can click on any button to check it,
        and that button will replace the existing one as the checked button in
        the group.

        In an exclusive group, the user cannot uncheck the currently checked
        button by clicking on it; instead, another button in the group must be
        clicked to set the new checked button for that group.

        By default, this property is `true`.

        **Access functions:**

        bool **exclusive** () const
        void **setExclusive** ( **bool** )

        **Member Function Documentation**
        """
        ...

    @property
    def buttonClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#buttonClicked

        **[signal] void QButtonGroup::buttonClicked(QAbstractButton * button )**

        This signal is emitted when the given **button** is clicked. A button is
        clicked when it is first pressed and then released, when its shortcut
        key is typed, or when **QAbstractButton::click** () or
        **QAbstractButton::animateClick** () is programmatically called.

        **Note:** Signal **buttonClicked** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(buttonGroup, QOverload<**QAbstractButton**
        \\*>::of(&**QButtonGroup** ::buttonClicked),
        [=](**QAbstractButton**  *button){ /* ... */ });

        **See also** **checkedButton** () and **QAbstractButton::clicked** ().
        """
        ...

    @property
    def buttonPressed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#buttonPressed

        **[signal] void QButtonGroup::buttonPressed(QAbstractButton * button )**

        This signal is emitted when the given **button** is pressed down.

        **Note:** Signal **buttonPressed** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(buttonGroup, QOverload<**QAbstractButton**
        \\*>::of(&**QButtonGroup** ::buttonPressed),
        [=](**QAbstractButton**  *button){ /* ... */ });

        This function was introduced in Qt 4.2.

        **See also** **QAbstractButton::pressed** ().
        """
        ...

    @property
    def buttonReleased(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#buttonReleased

        **[signal] void QButtonGroup::buttonReleased(QAbstractButton * button
        )**

        This signal is emitted when the given **button** is released.

        **Note:** Signal **buttonReleased** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(buttonGroup, QOverload<**QAbstractButton**
        \\*>::of(&**QButtonGroup** ::buttonReleased),
        [=](**QAbstractButton**  *button){ /* ... */ });

        This function was introduced in Qt 4.2.

        **See also** **QAbstractButton::released** ().
        """
        ...

    @property
    def buttonToggled(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#buttonToggled

        **[signal] void QButtonGroup::buttonToggled(QAbstractButton * button ,
        bool checked )**

        This signal is emitted when the given **button** is toggled. **checked**
        is true if the button is checked, or false if the button is unchecked.

        **Note:** Signal **buttonToggled** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(buttonGroup, QOverload<**QAbstractButton**  *,
        bool>::of(&**QButtonGroup** ::buttonToggled),
        [=](**QAbstractButton**  *button, bool checked){ /* ... */ });

        This function was introduced in Qt 5.2.

        **See also** **QAbstractButton::toggled** ().
        """
        ...

    @property
    def idClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#idClicked

        **[signal] void QButtonGroup::idClicked(int id )**

        This signal is emitted when a button with the given **id** is clicked.

        This function was introduced in Qt 5.15.

        **See also** **checkedButton** () and **QAbstractButton::clicked** ().
        """
        ...

    @property
    def idPressed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#idPressed

        **[signal] void QButtonGroup::idPressed(int id )**

        This signal is emitted when a button with the given **id** is pressed
        down.

        This function was introduced in Qt 5.15.

        **See also** **QAbstractButton::pressed** ().
        """
        ...

    @property
    def idReleased(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#idReleased

        **[signal] void QButtonGroup::idReleased(int id )**

        This signal is emitted when a button with the given **id** is released.

        This function was introduced in Qt 5.15.

        **See also** **QAbstractButton::released** ().
        """
        ...

    @property
    def idToggled(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qbuttongroup.html#idToggled

        **[signal] void QButtonGroup::idToggled(int id , bool checked )**

        This signal is emitted when a button with the given **id** is toggled.
        **checked** is true if the button is checked, or false if the button is
        unchecked.

        This function was introduced in Qt 5.15.

        **See also** **QAbstractButton::toggled** ().
        """
        ...
