"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5.QtWebSockets import *


class QWebSocket(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qwebsocket.html

    **Detailed Description**

    WebSockets is a web technology providing full-duplex communications channels
    over a single TCP connection. The WebSocket protocol was standardized by the
    IETF as **RFC 6455**  in 2011. QWebSocket can both be used in a client
    application and server application.

    This class was modeled after **QAbstractSocket** .

    QWebSocket currently does not support **WebSocket Extensions**  and
    **WebSocket Subprotocols** .

    QWebSocket only supports version 13 of the WebSocket protocol, as outlined
    in **RFC 6455** .

    **Note:** Some proxies do not understand certain HTTP headers used during a
    WebSocket handshake. In that case, non-secure WebSocket connections fail.
    The best way to mitigate against this problem is to use WebSocket over a
    secure connection.

    **Warning:** To generate masks, this implementation of WebSockets uses the
    reasonably secure **QRandomGenerator::global** ()->generate() function. For
    more information about the importance of good masking, see **"Talking to
    Yourself for Fun and Profit" by Lin-Shung Huang et al** . The best measure
    against attacks mentioned in the document above, is to use QWebSocket over a
    secure connection ( **wss://** ). In general, always be careful to not have
    3rd party script access to a QWebSocket in your application.

    **See also** **QAbstractSocket** , **QTcpSocket** , and **QWebSocket client
    example** .
    """

    def __init__(
        self,
        origin: str = ...,
        version: "QWebSocketProtocol.Version" = ...,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#QWebSocket-1

        **QWebSocket::QWebSocket(const QString & origin = QString(),
        QWebSocketProtocol::Version version = QWebSocketProtocol::VersionLatest,
        QObject * parent = nullptr)**

        Creates a new QWebSocket with the given **origin** , the **version** of
        the protocol to use and **parent**.

        The **origin** of the client is as specified in **RFC 6454** . (The
        **origin** is not required for non-web browser clients (see **RFC 6455**
        )). The **origin** may not contain new line characters, otherwise the
        connection will be aborted immediately during the handshake phase.

        **Note:** Currently only V13 (**RFC 6455** ) is supported
        """
        ...

    @staticmethod
    def maxOutgoingFrameSize() -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#maxOutgoingFrameSize

        **[static] quint64 QWebSocket::maxOutgoingFrameSize()**

        Returns the maximum supported size of an outgoing websocket frame for
        this websocket implementation.

        This function was introduced in Qt 5.15.
        """
        ...

    def outgoingFrameSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#outgoingFrameSize

        **quint64 QWebSocket::outgoingFrameSize() const**

        Returns the maximum size of an outgoing websocket frame.

        This function was introduced in Qt 5.15.

        **See also** **setOutgoingFrameSize** ().
        """
        ...

    def setOutgoingFrameSize(self, outgoingFrameSize: int) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#setOutgoingFrameSize

        **void QWebSocket::setOutgoingFrameSize(quint64 outgoingFrameSize )**

        Sets the maximum size of an outgoing websocket frame to
        **outgoingFrameSize**. The accepted range is between 0 and
        **maxOutgoingFrameSize** (), default is 512kB. The purpose of this
        function is to adapt to the maximum allowed frame size of the receiver.

        This function was introduced in Qt 5.15.

        **See also** **outgoingFrameSize** ().
        """
        ...

    @staticmethod
    def maxIncomingFrameSize() -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#maxIncomingFrameSize

        **[static] quint64 QWebSocket::maxIncomingFrameSize()**

        Returns the maximum supported size of an incoming websocket frame for
        this websocket implementation.

        This function was introduced in Qt 5.15.
        """
        ...

    @staticmethod
    def maxIncomingMessageSize() -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#maxIncomingMessageSize

        **[static] quint64 QWebSocket::maxIncomingMessageSize()**

        Returns the maximum supported size of an incoming websocket message for
        this websocket implementation.

        This function was introduced in Qt 5.15.
        """
        ...

    def maxAllowedIncomingMessageSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#maxAllowedIncomingMessageSize

        **quint64 QWebSocket::maxAllowedIncomingMessageSize() const**

        Returns the maximum allowed size of an incoming websocket message.

        This function was introduced in Qt 5.15.

        **See also** **setMaxAllowedIncomingMessageSize** ().
        """
        ...

    def setMaxAllowedIncomingMessageSize(
        self, maxAllowedIncomingMessageSize: int
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#setMaxAllowedIncomingMessageSize

        **void QWebSocket::setMaxAllowedIncomingMessageSize(quint64
        maxAllowedIncomingMessageSize )**

        Sets the maximum allowed size of an incoming websocket message to
        **maxAllowedIncomingMessageSize**. If an incoming message exceeds this
        limit, the peer gets disconnected. The accepted range is between 0 and
        **maxIncomingMessageSize** (), default is **maxIncomingMessageSize** ().
        The purpose of this function is to avoid exhausting virtual memory.

        This function was introduced in Qt 5.15.

        **See also** **maxAllowedIncomingMessageSize** ().
        """
        ...

    def maxAllowedIncomingFrameSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#maxAllowedIncomingFrameSize

        **quint64 QWebSocket::maxAllowedIncomingFrameSize() const**

        Returns the maximum allowed size of an incoming websocket frame.

        This function was introduced in Qt 5.15.

        **See also** **setMaxAllowedIncomingFrameSize** ().
        """
        ...

    def setMaxAllowedIncomingFrameSize(self, maxAllowedIncomingFrameSize: int) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#setMaxAllowedIncomingFrameSize

        **void QWebSocket::setMaxAllowedIncomingFrameSize(quint64
        maxAllowedIncomingFrameSize )**

        Sets the maximum allowed size of an incoming websocket frame to
        **maxAllowedIncomingFrameSize**. If an incoming frame exceeds this
        limit, the peer gets disconnected. The accepted range is between 0 and
        **maxIncomingFrameSize** (), default is **maxIncomingFrameSize** (). The
        purpose of this function is to avoid exhausting virtual memory.

        This function was introduced in Qt 5.15.

        **See also** **maxAllowedIncomingFrameSize** ().
        """
        ...

    def bytesToWrite(self) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#bytesToWrite

        **qint64 QWebSocket::bytesToWrite() const**

        Returns the number of bytes that are waiting to be written. The bytes
        are written when control goes back to the event loop or when **flush**
        () is called.

        This function was introduced in Qt 5.12.

        **See also** **flush** .
        """
        ...

    def ping(
        self, payload: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#ping

        **[slot] void QWebSocket::ping(const QByteArray & payload =
        QByteArray())**

        Pings the server to indicate that the connection is still alive.
        Additional **payload** can be sent along the ping message.

        The size of the **payload** cannot be bigger than 125. If it is larger,
        the **payload** is clipped to 125 bytes.

        **See also** **pong** ().
        """
        ...

    @typing.overload
    def open(self, url: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#open

        **[slot] void QWebSocket::open(const QUrl & url )**

        Opens a WebSocket connection using the given **url**.

        If the url contains newline characters (\\r\\n), then the error signal
        will be emitted with **QAbstractSocket::ConnectionRefusedError**  as
        error type.
        """
        ...

    @typing.overload
    def open(self, request: QtNetwork.QNetworkRequest) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#open-1

        **[slot] void QWebSocket::open(const QNetworkRequest & request )**

        Opens a WebSocket connection using the given **request**.

        The **request** url will be used to open the WebSocket connection.
        Headers present in the request will be sent to the server in the upgrade
        request, together with the ones needed for the websocket handshake.

        This function was introduced in Qt 5.6.
        """
        ...

    def close(
        self, closeCode: "QWebSocketProtocol.CloseCode" = ..., reason: str = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#close

        **[slot] void QWebSocket::close(QWebSocketProtocol::CloseCode closeCode
        = QWebSocketProtocol::CloseCodeNormal, const QString & reason =
        QString())**

        Gracefully closes the socket with the given **closeCode** and
        **reason**.

        Any data in the write buffer is flushed before the socket is closed. The
        **closeCode** is a **QWebSocketProtocol::CloseCode**  indicating the
        reason to close, and **reason** describes the reason of the closure more
        in detail. All control frames, including the Close frame, are limited to
        125 bytes. Since two of these are used for **closeCode** the maximum
        length of **reason** is 123! If **reason** exceeds this limit it will be
        truncated.
        """
        ...

    def request(self) -> QtNetwork.QNetworkRequest:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#request

        **QNetworkRequest QWebSocket::request() const**

        Returns the request that was or will be used to open this socket.

        This function was introduced in Qt 5.6.
        """
        ...

    def sslConfiguration(self) -> QtNetwork.QSslConfiguration:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#sslConfiguration

        **QSslConfiguration QWebSocket::sslConfiguration() const**

        Returns the socket's SSL configuration state. The default SSL
        configuration of a socket is to use the default ciphers, default CA
        certificates, no local private key or certificate. The SSL configuration
        also contains fields that can change with time without notice.

        **See also** **setSslConfiguration** ().
        """
        ...

    def setSslConfiguration(
        self, sslConfiguration: QtNetwork.QSslConfiguration
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#setSslConfiguration

        **void QWebSocket::setSslConfiguration(const QSslConfiguration &
        sslConfiguration )**

        Sets the socket's SSL configuration to be the contents of
        **sslConfiguration**.

        This function sets the local certificate, the ciphers, the private key
        and the CA certificates to those stored in **sslConfiguration**. It is
        not possible to set the SSL-state related fields.

        **See also** **sslConfiguration** ().
        """
        ...

    @typing.overload
    def ignoreSslErrors(self, errors: typing.Iterable[QtNetwork.QSslError]) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#ignoreSslErrors

        **[slot] void QWebSocket::ignoreSslErrors()**

        This slot tells **QWebSocket**  to ignore errors during **QWebSocket**
        's handshake phase and continue connecting. If you want to continue with
        the connection even if errors occur during the handshake phase, then you
        must call this slot, either from a slot connected to **sslErrors** (),
        or before the handshake phase. If you don't call this slot, either in
        response to errors or before the handshake, the connection will be
        dropped after the **sslErrors** () signal has been emitted.

        **Warning:** Be sure to always let the user inspect the errors reported
        by the **sslErrors** () signal, and only call this method upon
        confirmation from the user that proceeding is ok. If there are
        unexpected errors, the connection should be aborted. Calling this method
        without inspecting the actual errors will most likely pose a security
        risk for your application. Use it with great care!

        **See also** **sslErrors** (), **QSslSocket::ignoreSslErrors** (), and
        **QNetworkReply::ignoreSslErrors** ().
        """
        ...

    @typing.overload
    def ignoreSslErrors(self) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#ignoreSslErrors-1

        **void QWebSocket::ignoreSslErrors(const QList<QSslError> & errors )**

        This is an overloaded function.

        This method tells **QWebSocket**  to ignore the errors given in
        **errors**.

        Note that you can set the expected certificate in the SSL error: If, for
        instance, you want to connect to a server that uses a self-signed
        certificate, consider the following snippet:

        **QList** <**QSslCertificate** > cert = **QSslCertificate**
        ::fromPath(QLatin1String("server-certificate.pem"));
            **QSslError**
        error(**QSslError** ::SelfSignedCertificate, cert.at(0));
            **QList**
        <**QSslError** > expectedSslErrors;
            expectedSslErrors.append(error);
        QWebSocket socket;
            socket.ignoreSslErrors(expectedSslErrors);
        socket.open(**QUrl** (**QStringLiteral** ("wss://myserver.at.home")));

        Multiple calls to this function will replace the list of errors that
        were passed in previous calls. You can clear the list of errors you want
        to ignore by calling this function with an empty list.

        **See also** **sslErrors** ().
        """
        ...

    def sendBinaryMessage(
        self, data: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#sendBinaryMessage

        **qint64 QWebSocket::sendBinaryMessage(const QByteArray & data )**

        Sends the given **data** over the socket as a binary message and returns
        the number of bytes actually sent.

        **See also** **sendTextMessage** ().
        """
        ...

    def sendTextMessage(self, message: str) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#sendTextMessage

        **qint64 QWebSocket::sendTextMessage(const QString & message )**

        Sends the given **message** over the socket as a text message and
        returns the number of bytes actually sent.

        **See also** **sendBinaryMessage** ().
        """
        ...

    def closeReason(self) -> str:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#closeReason

        **QString QWebSocket::closeReason() const**

        Returns the reason why the socket was closed.

        **See also** **closeCode** ().
        """
        ...

    def closeCode(self) -> "QWebSocketProtocol.CloseCode":
        """
        https://doc.qt.io/qt-5/qwebsocket.html#closeCode

        **QWebSocketProtocol::CloseCode QWebSocket::closeCode() const**

        Returns the code indicating why the socket was closed.

        **See also** **QWebSocketProtocol::CloseCode**  and **closeReason** ().
        """
        ...

    def origin(self) -> str:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#origin

        **QString QWebSocket::origin() const**

        Returns the current origin.
        """
        ...

    def requestUrl(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#requestUrl

        **QUrl QWebSocket::requestUrl() const**

        Returns the url the socket is connected to or will connect to.
        """
        ...

    def resourceName(self) -> str:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#resourceName

        **QString QWebSocket::resourceName() const**

        Returns the name of the resource currently accessed.
        """
        ...

    def version(self) -> "QWebSocketProtocol.Version":
        """
        https://doc.qt.io/qt-5/qwebsocket.html#version

        **QWebSocketProtocol::Version QWebSocket::version() const**

        Returns the version the socket is currently using.
        """
        ...

    def state(self) -> QtNetwork.QAbstractSocket.SocketState:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#state

        **QAbstractSocket::SocketState QWebSocket::state() const**

        Returns the current state of the socket.
        """
        ...

    def setPauseMode(
        self,
        pauseMode: typing.Union[
            QtNetwork.QAbstractSocket.PauseModes, QtNetwork.QAbstractSocket.PauseMode
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#setPauseMode

        **void QWebSocket::setPauseMode(QAbstractSocket::PauseModes pauseMode
        )**

        Controls whether to pause upon receiving a notification. The
        **pauseMode** parameter specifies the conditions in which the socket
        should be paused.

        The only notification currently supported is **sslErrors** (). If set to
        PauseOnSslErrors, data transfer on the socket will be paused and needs
        to be enabled explicitly again by calling **resume** (). By default,
        this option is set to PauseNever. This option must be called before
        connecting to the server, otherwise it will result in undefined
        behavior.

        **See also** **pauseMode** () and **resume** ().
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#resume

        **void QWebSocket::resume()**

        Continues data transfer on the socket. This method should only be used
        after the socket has been set to pause upon notifications and a
        notification has been received. The only notification currently
        supported is **sslErrors** (). Calling this method if the socket is not
        paused results in undefined behavior.

        **See also** **pauseMode** () and **setPauseMode** ().
        """
        ...

    def setReadBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#setReadBufferSize

        **void QWebSocket::setReadBufferSize(qint64 size )**

        Sets the size of **QWebSocket** 's internal read buffer to be **size**
        bytes.

        If the buffer size is limited to a certain size, **QWebSocket**  won't
        buffer more than this size of data. Exceptionally, a buffer size of 0
        means that the read buffer is unlimited and all incoming data is
        buffered. This is the default. This option is useful if you only read
        the data at certain points in time (for example, in a real-time
        streaming application) or if you want to protect your socket against
        receiving too much data, which may eventually cause your application to
        run out of memory.

        **See also** **readBufferSize** ().
        """
        ...

    def readBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#readBufferSize

        **qint64 QWebSocket::readBufferSize() const**

        Returns the size in bytes of the readbuffer that is used by the socket.

        **See also** **setReadBufferSize** ().
        """
        ...

    def maskGenerator(self) -> QMaskGenerator:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#maskGenerator

        **const QMaskGenerator *QWebSocket::maskGenerator() const**

        Returns the mask generator that is currently used by this **QWebSocket**
        .

        **See also** **setMaskGenerator** ().
        """
        ...

    def setMaskGenerator(self, maskGenerator: QMaskGenerator) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#setMaskGenerator

        **void QWebSocket::setMaskGenerator(const QMaskGenerator * maskGenerator
        )**

        Sets the generator to use for creating masks to **maskGenerator**. The
        default **QWebSocket**  generator can be reset by supplying a
        **nullptr**. The mask generator can be changed at any time, even while
        the connection is open.

        **See also** **maskGenerator** ().
        """
        ...

    def setProxy(self, networkProxy: QtNetwork.QNetworkProxy) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#setProxy

        **void QWebSocket::setProxy(const QNetworkProxy & networkProxy )**

        Sets the proxy to **networkProxy**

        **See also** **proxy** ().
        """
        ...

    def proxy(self) -> QtNetwork.QNetworkProxy:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#proxy

        **QNetworkProxy QWebSocket::proxy() const**

        Returns the currently configured proxy

        **See also** **setProxy** ().
        """
        ...

    def peerPort(self) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#peerPort

        **quint16 QWebSocket::peerPort() const**

        Returns the peerport
        """
        ...

    def peerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#peerName

        **QString QWebSocket::peerName() const**

        Returns the peerName
        """
        ...

    def peerAddress(self) -> QtNetwork.QHostAddress:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#peerAddress

        **QHostAddress QWebSocket::peerAddress() const**

        Returns the peer address
        """
        ...

    def pauseMode(self) -> QtNetwork.QAbstractSocket.PauseModes:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#pauseMode

        **QAbstractSocket::PauseModes QWebSocket::pauseMode() const**

        Returns the pause mode of this socket

        **See also** **setPauseMode** ().
        """
        ...

    def localPort(self) -> int:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#localPort

        **quint16 QWebSocket::localPort() const**

        Returns the local port
        """
        ...

    def localAddress(self) -> QtNetwork.QHostAddress:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#localAddress

        **QHostAddress QWebSocket::localAddress() const**

        Returns the local address
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#isValid

        **bool QWebSocket::isValid() const**

        Returns `true` if the socket is ready for reading and writing; otherwise
        returns `false`.
        """
        ...

    def flush(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#flush

        **bool QWebSocket::flush()**

        This function writes as much as possible from the internal write buffer
        to the underlying network socket, without blocking. If any data was
        written, this function returns true; otherwise false is returned. Call
        this function if you need **QWebSocket**  to start sending buffered data
        immediately. The number of bytes successfully written depends on the
        operating system. In most cases, you do not need to call this function,
        because **QWebSocket**  will start sending data automatically once
        control goes back to the event loop.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#errorString

        **QString QWebSocket::errorString() const**

        Returns a human-readable description of the last error that occurred

        **See also** **error** ().
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#abort

        **void QWebSocket::abort()**

        Aborts the current socket and resets the socket. Unlike **close** (),
        this function immediately closes the socket, discarding any pending data
        in the write buffer.
        """
        ...

    @property
    def aboutToClose(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#aboutToClose

        **[signal] void QWebSocket::aboutToClose()**

        This signal is emitted when the socket is about to close. Connect this
        signal if you have operations that need to be performed before the
        socket closes (e.g., if you have data in a separate buffer that needs to
        be written to the device).

        **See also** **close** ().
        """
        ...

    @property
    def binaryFrameReceived(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#binaryFrameReceived

        **[signal] void QWebSocket::binaryFrameReceived(const QByteArray & frame
        , bool isLastFrame )**

        This signal is emitted whenever a binary frame is received. The
        **frame** contains the data and **isLastFrame** indicates whether this
        is the last frame of the complete message.

        This signal can be used to process large messages frame by frame,
        instead of waiting for the complete message to arrive.

        **See also** **textFrameReceived** ().
        """
        ...

    @property
    def binaryMessageReceived(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#binaryMessageReceived

        **[signal] void QWebSocket::binaryMessageReceived(const QByteArray &
        message )**

        This signal is emitted whenever a binary message is received. The
        **message** contains the received bytes.

        **See also** **textMessageReceived** ().
        """
        ...

    @property
    def bytesWritten(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#bytesWritten

        **[signal] void QWebSocket::bytesWritten(qint64 bytes )**

        This signal is emitted every time a payload of data has been written to
        the socket. The **bytes** argument is set to the number of bytes that
        were written in this payload.

        **Note:** This signal has the same meaning both for secure and non-
        secure WebSockets. As opposed to **QSslSocket** , bytesWritten() is only
        emitted when encrypted data is effectively written (see
        **QSslSocket::encryptedBytesWritten** ()).

        **See also** **close** ().
        """
        ...

    @property
    def connected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#connected

        **[signal] void QWebSocket::connected()**

        Emitted when a connection is successfully established. A connection is
        successfully established when the socket is connected and the handshake
        was successful.

        **See also** **open** () and **disconnected** ().
        """
        ...

    @property
    def disconnected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#disconnected

        **[signal] void QWebSocket::disconnected()**

        Emitted when the socket is disconnected.

        **See also** **close** () and **connected** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#error

        **QAbstractSocket::SocketError QWebSocket::error() const**

        Returns the type of error that last occurred

        **See also** **errorString** ().
        """
        ...

    @property
    def pong(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#pong

        **[signal] void QWebSocket::pong(quint64 elapsedTime , const QByteArray
        & payload )**

        Emitted when a pong message is received in reply to a previous ping.
        **elapsedTime** contains the roundtrip time in milliseconds and
        **payload** contains an optional payload that was sent with the ping.

        **See also** **ping** ().
        """
        ...

    @property
    def preSharedKeyAuthenticationRequired(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#preSharedKeyAuthenticationRequire
        d

        **[signal] void QWebSocket::preSharedKeyAuthenticationRequired(QSslPreSh
        aredKeyAuthenticator * authenticator )**

        This signal is emitted if the SSL/TLS handshake negotiates a PSK
        ciphersuite, and therefore a PSK authentication is then required.

        When using PSK, the client must send to the server a valid identity and
        a valid pre shared key, in order for the SSL handshake to continue.
        Applications can provide this information in a slot connected to this
        signal, by filling in the passed **authenticator** object according to
        their needs.

        **Note:** Ignoring this signal, or failing to provide the required
        credentials, will cause the handshake to fail, and therefore the
        connection to be aborted.

        **Note:** The **authenticator** object is owned by the websocket and
        must not be deleted by the application.

        This function was introduced in Qt 5.8.

        **See also** **QSslPreSharedKeyAuthenticator**  and
        **QSslSocket::preSharedKeyAuthenticationRequired** ().
        """
        ...

    @property
    def proxyAuthenticationRequired(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#proxyAuthenticationRequired

        **[signal] void QWebSocket::proxyAuthenticationRequired(const
        QNetworkProxy & proxy , QAuthenticator * authenticator )**

        This signal can be emitted when a **proxy** that requires authentication
        is used. The **authenticator** object can then be filled in with the
        required details to allow authentication and continue the connection.

        **Note:** It is not possible to use a QueuedConnection to connect to
        this signal, as the connection will fail if the authenticator has not
        been filled in with new information when the signal returns.

        **See also** **QAuthenticator**  and **QNetworkProxy** .
        """
        ...

    @property
    def readChannelFinished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#readChannelFinished

        **[signal] void QWebSocket::readChannelFinished()**

        This signal is emitted when the input (reading) stream is closed in this
        device. It is emitted as soon as the closing is detected.

        **See also** **close** ().
        """
        ...

    @property
    def sslErrors(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#sslErrors

        **[signal] void QWebSocket::sslErrors(const QList<QSslError> & errors
        )**

        **QWebSocket**  emits this signal after the SSL handshake to indicate
        that one or more errors have occurred while establishing the identity of
        the peer. The errors are usually an indication that **QWebSocket**  is
        unable to securely identify the peer. Unless any action is taken, the
        connection will be dropped after this signal has been emitted. If you
        want to continue connecting despite the errors that have occurred, you
        must call **QWebSocket::ignoreSslErrors** () from inside a slot
        connected to this signal. If you need to access the error list at a
        later point, you can call sslErrors() (without arguments).

        **errors** contains one or more errors that prevent **QWebSocket**  from
        verifying the identity of the peer.

        **Note:** You cannot use **Qt::QueuedConnection**  when connecting to
        this signal, or calling **QWebSocket::ignoreSslErrors** () will have no
        effect.
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#stateChanged

        **[signal] void QWebSocket::stateChanged(QAbstractSocket::SocketState
        state )**

        This signal is emitted whenever **QWebSocket** 's state changes. The
        **state** parameter is the new state.

        **Note:****QAbstractSocket::ConnectedState**  is emitted after the
        handshake with the server has succeeded.

        **QAbstractSocket::SocketState**  is not a registered metatype, so for
        queued connections, you will have to register it with
        Q_REGISTER_METATYPE() and **qRegisterMetaType** ().

        **See also** **state** ().
        """
        ...

    @property
    def textFrameReceived(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#textFrameReceived

        **[signal] void QWebSocket::textFrameReceived(const QString & frame ,
        bool isLastFrame )**

        This signal is emitted whenever a text frame is received. The **frame**
        contains the data and **isLastFrame** indicates whether this is the last
        frame of the complete message.

        This signal can be used to process large messages frame by frame,
        instead of waiting for the complete message to arrive.

        **See also** **binaryFrameReceived** ().
        """
        ...

    @property
    def textMessageReceived(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebsocket.html#textMessageReceived

        **[signal] void QWebSocket::textMessageReceived(const QString & message
        )**

        This signal is emitted whenever a text message is received. The
        **message** contains the received text.

        **See also** **binaryMessageReceived** ().
        """
        ...
