"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtWebChannel import *


class QWebChannel(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qwebchannel.html

    **Detailed Description**

    The QWebChannel fills the gap between C++ applications and HTML/JavaScript
    applications. By publishing a **QObject**  derived object to a QWebChannel
    and using the **qwebchannel.js**  on the HTML side, one can transparently
    access properties and public slots and methods of the **QObject** . No
    manual message passing and serialization of data is required, property
    updates and signal emission on the C++ side get automatically transmitted to
    the potentially remotely running HTML clients. On the client side, a
    JavaScript object will be created for any published C++ **QObject** . It
    mirrors the C++ object's API and thus is intuitively useable.

    The C++ QWebChannel API makes it possible to talk to any HTML client, which
    could run on a local or even remote machine. The only limitation is that the
    HTML client supports the JavaScript features used by `qwebchannel.js`. As
    such, one can interact with basically any modern HTML browser or standalone
    JavaScript runtime, such as node.js.

    There also exists a declarative **WebChannel API** .

    **See also** **Qt WebChannel Standalone Example**  and **JavaScript API** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#QWebChannel-1

        **QWebChannel::QWebChannel(QObject * parent = Q_NULLPTR)**

        Constructs the QWebChannel object with the given **parent**.

        Note that a QWebChannel is only fully operational once you connect it to
        a **QWebChannelAbstractTransport** . The HTML clients also need to be
        setup appropriately using [`qwebchannel.js`** .
        """
        ...

    def disconnectFrom(self, transport: "QWebChannelAbstractTransport") -> None:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#disconnectFrom

        **[slot] void QWebChannel::disconnectFrom(QWebChannelAbstractTransport *
        transport )**

        Disconnects the **QWebChannel**  from the **transport** object.

        **See also** **QWebChannel::connectTo** ().
        """
        ...

    def connectTo(self, transport: "QWebChannelAbstractTransport") -> None:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#connectTo

        **[slot] void QWebChannel::connectTo(QWebChannelAbstractTransport *
        transport )**

        Connects the **QWebChannel**  to the given **transport** object.

        The transport object then handles the communication between the C++
        application and a remote HTML client.

        **See also** **QWebChannelAbstractTransport**  and
        **QWebChannel::disconnectFrom** ().
        """
        ...

    def setBlockUpdates(self, block: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#blockUpdates-prop

        **blockUpdates : bool**

        When set to true, updates are blocked and remote clients will not be
        notified about property changes.

        The changes are recorded and sent to the clients once updates become
        unblocked again by setting this property to false. By default, updates
        are not blocked.

        **Access functions:**

        bool **blockUpdates** () const
        void **setBlockUpdates** (bool
        **block** )

        **Notifier signal:**

        void **blockUpdatesChanged** (bool **block** )

        **Member Function Documentation**
        """
        ...

    def blockUpdates(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#blockUpdates-prop

        **blockUpdates : bool**

        When set to true, updates are blocked and remote clients will not be
        notified about property changes.

        The changes are recorded and sent to the clients once updates become
        unblocked again by setting this property to false. By default, updates
        are not blocked.

        **Access functions:**

        bool **blockUpdates** () const
        void **setBlockUpdates** (bool
        **block** )

        **Notifier signal:**

        void **blockUpdatesChanged** (bool **block** )

        **Member Function Documentation**
        """
        ...

    def deregisterObject(self, object: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#deregisterObject

        **void QWebChannel::deregisterObject(QObject * object )**

        Deregisters the given **object** from the **QWebChannel** .

        Remote clients will receive a `destroyed` signal for the given object.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QWebChannel::registerObjects** (),
        **QWebChannel::registerObject** (), and
        **QWebChannel::registeredObjects** ().
        """
        ...

    def registerObject(self, id: str, object: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#registerObject

        **void QWebChannel::registerObject(const QString & id , QObject * object
        )**

        Registers a single object to the **QWebChannel** .

        The properties, signals and public methods of the **object** are
        published to the remote clients. There, an object with the identifier
        **id** is then constructed.

        **Note:** A current limitation is that objects must be registered before
        any client is initialized.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QWebChannel::registerObjects** (),
        **QWebChannel::deregisterObject** (), and
        **QWebChannel::registeredObjects** ().
        """
        ...

    def registeredObjects(self) -> typing.Dict[str, QtCore.QObject]:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#registeredObjects

        **QHash<QString, QObject *> QWebChannel::registeredObjects() const**

        Returns the map of registered objects that are published to remote
        clients.

        **See also** **QWebChannel::registerObjects** (),
        **QWebChannel::registerObject** (), and
        **QWebChannel::deregisterObject** ().
        """
        ...

    def registerObjects(self, objects: typing.Dict[str, QtCore.QObject]) -> None:
        """
        https://doc.qt.io/qt-5/qwebchannel.html#registerObjects

        **void QWebChannel::registerObjects(const QHash<QString, QObject *> &
        objects )**

        Registers a group of objects to the **QWebChannel** .

        The properties, signals and public invokable methods of the objects are
        published to the remote clients. There, an object with the identifier
        used as key in the **objects** map is then constructed.

        **Note:** A current limitation is that objects must be registered before
        any client is initialized.

        **See also** **QWebChannel::registerObject** (),
        **QWebChannel::deregisterObject** (), and
        **QWebChannel::registeredObjects** ().
        """
        ...

    @property
    def blockUpdatesChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
