"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt5.QtSensors import *


class QGyroscopeReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qgyroscopereading.html

    **Detailed Description**

    **QGyroscopeReading Units**

    The reading contains 3 values, measured in degrees per second that define
    the movement of the device around the x, y and z axes. Unlike
    **QRotationReading** , the values represent the current angular velocity
    rather than a fixed rotation. The measurements are in degrees per second.

    ![](images/sensors-coordinates3.jpg)
    """

    def setZ(self, z: float) -> None:
        """
        https://doc.qt.io/qt-5/qgyroscopereading.html#setZ

        **void QGyroscopeReading::setZ(qreal z )**

        Sets the angular velocity around the z axis to **z**.

        **See also** **z** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-5/qgyroscopereading.html#z-prop

        **z : const qreal**

        This property holds the angular velocity around the z axis.

        Measured as degrees per second.

        **Access functions:**

        qreal **z** () const

        **See also** **QGyroscopeReading Units** .

        **Member Function Documentation**
        """
        ...

    def setY(self, y: float) -> None:
        """
        https://doc.qt.io/qt-5/qgyroscopereading.html#setY

        **void QGyroscopeReading::setY(qreal y )**

        Sets the angular velocity around the y axis to **y**.

        **See also** **y** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-5/qgyroscopereading.html#y-prop

        **y : const qreal**

        This property holds the angular velocity around the y axis.

        Measured as degrees per second.

        **Access functions:**

        qreal **y** () const

        **See also** **QGyroscopeReading Units** .
        """
        ...

    def setX(self, x: float) -> None:
        """
        https://doc.qt.io/qt-5/qgyroscopereading.html#setX

        **void QGyroscopeReading::setX(qreal x )**

        Sets the angular velocity around the x axis to **x**.

        **See also** **x** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-5/qgyroscopereading.html#x-prop

        **x : const qreal**

        This property holds the angular velocity around the x axis.

        Measured as degrees per second.

        **Access functions:**

        qreal **x** () const

        **See also** **QGyroscopeReading Units** .
        """
        ...
