"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGSimpleTextureNode(QSGGeometryNode):
    """
    https://doc.qt.io/qt-5/qsgsimpletexturenode.html

    **Detailed Description**

    **Warning:** The simple texture node class must have a texture before being
    added to the scene graph to be rendered.

    **Warning:** This utility class is only functional when running with the
    default or software backends of the Qt Quick scenegraph. As an alternative,
    prefer using **QSGImageNode**  via **QQuickWindow::createImageNode** () or
    **QSGEngine::createImageNode** ().
    """

    class TextureCoordinatesTransformFlag(int):
        NoTransform: QSGSimpleTextureNode = ...
        MirrorHorizontally: QSGSimpleTextureNode = ...
        MirrorVertically: QSGSimpleTextureNode = ...

    class TextureCoordinatesTransformMode(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QSGSimpleTextureNode.TextureCoordinatesTransformMode",
                "QSGSimpleTextureNode.TextureCoordinatesTransformFlag",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(
            self, a0: "QSGSimpleTextureNode.TextureCoordinatesTransformMode"
        ) -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGSimpleTextureNode.TextureCoordinatesTransformMode":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#QSGSimpleTextureNode

        **QSGSimpleTextureNode::QSGSimpleTextureNode()**

        Constructs a new simple texture node
        """
        ...

    def sourceRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#sourceRect

        **QRectF QSGSimpleTextureNode::sourceRect() const**

        Returns the source rect of this texture node.

        This function was introduced in Qt 5.5.

        **See also** **setSourceRect** ().
        """
        ...

    @typing.overload
    def setSourceRect(self, r: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#setSourceRect

        **void QSGSimpleTextureNode::setSourceRect(const QRectF & r )**

        Sets the source rect of this texture node to **r**.

        This function was introduced in Qt 5.5.

        **See also** **sourceRect** ().
        """
        ...

    @typing.overload
    def setSourceRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#setSourceRect-1

        **void QSGSimpleTextureNode::setSourceRect(qreal x , qreal y , qreal w ,
        qreal h )**

        This is an overloaded function.

        Sets the rectangle of this texture node to show its texture from ( **x**
        , **y** ) and have width **w** and height **h** relatively to the
        **QSGTexture::textureSize** .

        This function was introduced in Qt 5.5.
        """
        ...

    def ownsTexture(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#ownsTexture

        **bool QSGSimpleTextureNode::ownsTexture() const**

        Returns `true` if the node takes ownership of the texture; otherwise
        returns `false`.

        This function was introduced in Qt 5.4.

        **See also** **setOwnsTexture** ().
        """
        ...

    def setOwnsTexture(self, owns: bool) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#setOwnsTexture

        **void QSGSimpleTextureNode::setOwnsTexture(bool owns )**

        Sets whether the node takes ownership of the texture to **owns**.

        By default, the node does not take ownership of the texture.

        This function was introduced in Qt 5.4.

        **See also** **ownsTexture** () and **setTexture** ().
        """
        ...

    def textureCoordinatesTransform(
        self,
    ) -> "QSGSimpleTextureNode.TextureCoordinatesTransformMode":
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#textureCoordinatesTrans
        form

        **QSGSimpleTextureNode::TextureCoordinatesTransformMode
        QSGSimpleTextureNode::textureCoordinatesTransform() const**

        Returns the mode used to generate texture coordinates for this node.

        **See also** **setTextureCoordinatesTransform** ().
        """
        ...

    def setTextureCoordinatesTransform(
        self,
        mode: typing.Union[
            "QSGSimpleTextureNode.TextureCoordinatesTransformMode",
            "QSGSimpleTextureNode.TextureCoordinatesTransformFlag",
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#setTextureCoordinatesTr
        ansform

        **void QSGSimpleTextureNode::setTextureCoordinatesTransform(QSGSimpleTex
        tureNode::TextureCoordinatesTransformMode mode )**

        Sets the method used to generate texture coordinates to **mode**. This
        can be used to obtain correct orientation of the texture. This is
        commonly needed when using a third party OpenGL library to render to
        texture as OpenGL has an inverted y-axis relative to Qt Quick.

        **See also** **textureCoordinatesTransform** ().
        """
        ...

    def filtering(self) -> "QSGTexture.Filtering":
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#filtering

        **QSGTexture::Filtering QSGSimpleTextureNode::filtering() const**

        Returns the filtering currently set on this texture node

        **See also** **setFiltering** ().
        """
        ...

    def setFiltering(self, filtering: "QSGTexture.Filtering") -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#setFiltering

        **void QSGSimpleTextureNode::setFiltering(QSGTexture::Filtering
        filtering )**

        Sets the filtering to be used for this texture node to **filtering**.

        For smooth scaling, use **QSGTexture::Linear** ; for normal scaling, use
        **QSGTexture::Nearest** .

        **See also** **filtering** ().
        """
        ...

    def texture(self) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#texture

        **QSGTexture *QSGSimpleTextureNode::texture() const**

        Returns the texture for this texture node

        **See also** **setTexture** ().
        """
        ...

    def setTexture(self, texture: "QSGTexture") -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#setTexture

        **void QSGSimpleTextureNode::setTexture(QSGTexture * texture )**

        Sets the texture of this texture node to **texture**.

        Use **setOwnsTexture** () to set whether the node should take ownership
        of the texture. By default, the node does not take ownership.

        **Warning:** A texture node must have a texture before being added to
        the scenegraph to be rendered.

        **See also** **texture** ().
        """
        ...

    def rect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#rect

        **QRectF QSGSimpleTextureNode::rect() const**

        Returns the target rect of this texture node.

        **See also** **setRect** ().
        """
        ...

    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#setRect

        **void QSGSimpleTextureNode::setRect(const QRectF & r )**

        Sets the target rect of this texture node to **r**.

        **See also** **rect** ().
        """
        ...

    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-5/qsgsimpletexturenode.html#setRect-1

        **void QSGSimpleTextureNode::setRect(qreal x , qreal y , qreal w , qreal
        h )**

        This is an overloaded function.

        Sets the rectangle of this texture node to begin at ( **x** , **y** )
        and have width **w** and height **h**.
        """
        ...
