"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt5.QtQuick import *


class QSGOpaqueTextureMaterial(QSGMaterial):
    """
    https://doc.qt.io/qt-5/qsgopaquetexturematerial.html

    **Detailed Description**

    **Warning:** This utility class is only functional when running with the
    default backend of the Qt Quick scenegraph.

    The opaque textured material will fill every pixel in a geometry with the
    supplied texture. The material does not respect the opacity of the
    **QSGMaterialShader::RenderState** , so opacity nodes in the parent chain of
    nodes using this material, have no effect.

    The geometry to be rendered with an opaque texture material requires
    vertices in attribute location 0 and texture coordinates in attribute
    location 1. The texture coordinate is a 2-dimensional floating-point tuple.
    The **QSGGeometry::defaultAttributes_TexturedPoint2D**  returns an attribute
    set compatible with this material.

    The texture to be rendered can be set using **setTexture** (). How the
    texture should be rendered can be specified using **setMipmapFiltering** (),
    **setFiltering** (), **setHorizontalWrapMode** () and
    **setVerticalWrapMode** (). The rendering state is set on the texture
    instance just before it is bound.

    The opaque textured material respects the current matrix and the alpha
    channel of the texture. It will disregard the accumulated opacity in the
    scenegraph.

    A texture material must have a texture set before it is used as a material
    in the scene graph.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#QSGOpaqueTextureMat
        erial

        **QSGOpaqueTextureMaterial::QSGOpaqueTextureMaterial()**

        Creates a new QSGOpaqueTextureMaterial.

        The default mipmap filtering and filtering mode is set to
        **QSGTexture::Nearest** . The default wrap modes is set to
        `QSGTexture::ClampToEdge`.
        """
        ...

    def anisotropyLevel(self) -> QSGTexture.AnisotropyLevel:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#anisotropyLevel

        **QSGTexture::AnisotropyLevel
        QSGOpaqueTextureMaterial::anisotropyLevel() const**

        Returns this material's anistropy level.

        **See also** **setAnisotropyLevel** ().
        """
        ...

    def setAnisotropyLevel(self, level: QSGTexture.AnisotropyLevel) -> None:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#setAnisotropyLevel

        **void
        QSGOpaqueTextureMaterial::setAnisotropyLevel(QSGTexture::AnisotropyLevel
        level )**

        Sets this material's anistropy level to **level**.

        **See also** **anisotropyLevel** ().
        """
        ...

    def verticalWrapMode(self) -> QSGTexture.WrapMode:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#verticalWrapMode

        **QSGTexture::WrapMode QSGOpaqueTextureMaterial::verticalWrapMode()
        const**

        Returns this material's vertical wrap mode.

        The default vertical wrap mode is `QSGTexture::ClampToEdge`.

        **See also** **setVerticalWrapMode** ().
        """
        ...

    def setVerticalWrapMode(self, mode: QSGTexture.WrapMode) -> None:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#setVerticalWrapMode

        **void
        QSGOpaqueTextureMaterial::setVerticalWrapMode(QSGTexture::WrapMode mode
        )**

        Sets the vertical wrap mode to **mode**.

        The vertical wrap mode is set on the texture instance just before the
        texture is bound for rendering.

        **See also** **verticalWrapMode** ().
        """
        ...

    def horizontalWrapMode(self) -> QSGTexture.WrapMode:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#horizontalWrapMode

        **QSGTexture::WrapMode QSGOpaqueTextureMaterial::horizontalWrapMode()
        const**

        Returns this material's horizontal wrap mode.

        The default horizontal wrap mode is `QSGTexture::ClampToEdge`.

        **See also** **setHorizontalWrapMode** ().
        """
        ...

    def setHorizontalWrapMode(self, mode: QSGTexture.WrapMode) -> None:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#setHorizontalWrapMo
        de

        **void
        QSGOpaqueTextureMaterial::setHorizontalWrapMode(QSGTexture::WrapMode
        mode )**

        Sets the horizontal wrap mode to **mode**.

        The horizontal wrap mode is set on the texture instance just before the
        texture is bound for rendering.

        **See also** **horizontalWrapMode** ().
        """
        ...

    def filtering(self) -> QSGTexture.Filtering:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#filtering

        **QSGTexture::Filtering QSGOpaqueTextureMaterial::filtering() const**

        Returns this material's filtering mode.

        The default filtering is `QSGTexture::Nearest`.

        **See also** **setFiltering** ().
        """
        ...

    def setFiltering(self, filtering: QSGTexture.Filtering) -> None:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#setFiltering

        **void QSGOpaqueTextureMaterial::setFiltering(QSGTexture::Filtering
        filtering )**

        Sets the filtering to **filtering**.

        The filtering mode is set on the texture instance just before the
        texture is bound for rendering.

        **See also** **filtering** ().
        """
        ...

    def mipmapFiltering(self) -> QSGTexture.Filtering:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#mipmapFiltering

        **QSGTexture::Filtering QSGOpaqueTextureMaterial::mipmapFiltering()
        const**

        Returns this material's mipmap filtering mode.

        The default mipmap mode is `QSGTexture::Nearest`.

        **See also** **setMipmapFiltering** ().
        """
        ...

    def setMipmapFiltering(self, filtering: QSGTexture.Filtering) -> None:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#setMipmapFiltering

        **void
        QSGOpaqueTextureMaterial::setMipmapFiltering(QSGTexture::Filtering
        filtering )**

        Sets the mipmap mode to **filtering**.

        The mipmap filtering mode is set on the texture instance just before the
        texture is bound for rendering.

        If the texture does not have mipmapping support, enabling mipmapping has
        no effect.

        **See also** **mipmapFiltering** ().
        """
        ...

    def texture(self) -> QSGTexture:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#texture

        **QSGTexture *QSGOpaqueTextureMaterial::texture() const**

        Returns this texture material's texture.

        **See also** **setTexture** ().
        """
        ...

    def setTexture(self, texture: QSGTexture) -> None:
        """
        https://doc.qt.io/qt-5/qsgopaquetexturematerial.html#setTexture

        **void QSGOpaqueTextureMaterial::setTexture(QSGTexture * texture )**

        Sets the texture of this material to **texture**.

        The material does not take ownership of the texture.

        **See also** **texture** ().
        """
        ...

    def compare(self, other: QSGMaterial) -> int:
        ...

    def createShader(self) -> QSGMaterialShader:
        ...

    def type(self) -> QSGMaterialType:
        ...
