"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *
from PyQt5 import sip


class QSGMaterialRhiShader(QSGMaterialShader):
    """
    https://doc.qt.io/qt-5/qsgmaterialrhishader.html

    **Detailed Description**

    QSGMaterialRhiShader is a modern, cross-platform alternative to
    **QSGMaterialShader** . The latter is tied to OpenGL and GLSL by design,
    whereas QSGMaterialRhiShader is based on QShader, a container for multiple
    versions of a graphics shader together with reflection information.

    **Note:** All classes with QSG prefix should be used solely on the scene
    graph's rendering thread. See **Scene Graph and Rendering**  for more
    information.
    """

    class Flag(int):
        UpdatesGraphicsPipelineState: QSGMaterialRhiShader = ...

    class RenderState(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGMaterialRhiShader.RenderState") -> None:
            ...

        def uniformData(self) -> QtCore.QByteArray:
            ...

        def devicePixelRatio(self) -> float:
            ...

        def determinant(self) -> float:
            ...

        def deviceRect(self) -> QtCore.QRect:
            ...

        def viewportRect(self) -> QtCore.QRect:
            ...

        def projectionMatrix(self) -> QtGui.QMatrix4x4:
            ...

        def modelViewMatrix(self) -> QtGui.QMatrix4x4:
            ...

        def combinedMatrix(self) -> QtGui.QMatrix4x4:
            ...

        def opacity(self) -> float:
            ...

        def isOpacityDirty(self) -> bool:
            ...

        def isMatrixDirty(self) -> bool:
            ...

        def dirtyStates(self) -> QSGMaterialShader.RenderState.DirtyStates:
            ...

    class GraphicsPipelineState(sip.simplewrapper):
        class CullMode(int):
            CullNone: QSGMaterialRhiShader = ...
            CullFront: QSGMaterialRhiShader = ...
            CullBack: QSGMaterialRhiShader = ...

        class ColorMaskComponent(int):
            R: QSGMaterialRhiShader = ...
            G: QSGMaterialRhiShader = ...
            B: QSGMaterialRhiShader = ...
            A: QSGMaterialRhiShader = ...

        class BlendFactor(int):
            Zero: QSGMaterialRhiShader = ...
            One: QSGMaterialRhiShader = ...
            SrcColor: QSGMaterialRhiShader = ...
            OneMinusSrcColor: QSGMaterialRhiShader = ...
            DstColor: QSGMaterialRhiShader = ...
            OneMinusDstColor: QSGMaterialRhiShader = ...
            SrcAlpha: QSGMaterialRhiShader = ...
            OneMinusSrcAlpha: QSGMaterialRhiShader = ...
            DstAlpha: QSGMaterialRhiShader = ...
            OneMinusDstAlpha: QSGMaterialRhiShader = ...
            ConstantColor: QSGMaterialRhiShader = ...
            OneMinusConstantColor: QSGMaterialRhiShader = ...
            ConstantAlpha: QSGMaterialRhiShader = ...
            OneMinusConstantAlpha: QSGMaterialRhiShader = ...
            SrcAlphaSaturate: QSGMaterialRhiShader = ...
            Src1Color: QSGMaterialRhiShader = ...
            OneMinusSrc1Color: QSGMaterialRhiShader = ...
            Src1Alpha: QSGMaterialRhiShader = ...
            OneMinusSrc1Alpha: QSGMaterialRhiShader = ...

        class ColorMask(sip.simplewrapper):
            @typing.overload
            def __init__(self) -> None:
                ...

            @typing.overload
            def __init__(
                self,
                f: typing.Union[
                    "QSGMaterialRhiShader.GraphicsPipelineState.ColorMask",
                    "QSGMaterialRhiShader.GraphicsPipelineState.ColorMaskComponent",
                ],
            ) -> None:
                ...

            @typing.overload
            def __init__(
                self, a0: "QSGMaterialRhiShader.GraphicsPipelineState.ColorMask"
            ) -> None:
                ...

            def __hash__(self) -> int:
                ...

            def __bool__(self) -> int:
                ...

            def __invert__(
                self,
            ) -> "QSGMaterialRhiShader.GraphicsPipelineState.ColorMask":
                ...

            def __index__(self) -> int:
                ...

            def __int__(self) -> int:
                ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGMaterialRhiShader.GraphicsPipelineState") -> None:
            ...

    class Flags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QSGMaterialRhiShader.Flags", "QSGMaterialRhiShader.Flag"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QSGMaterialRhiShader.Flags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QSGMaterialRhiShader.Flags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialrhishader.html#QSGMaterialRhiShader

        **QSGMaterialRhiShader::QSGMaterialRhiShader()**

        Constructs a new QSGMaterialRhiShader.
        """
        ...

    def setFlag(
        self,
        flags: typing.Union["QSGMaterialRhiShader.Flags", "QSGMaterialRhiShader.Flag"],
        on: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsgmaterialrhishader.html#setFlag

        **void QSGMaterialRhiShader::setFlag(QSGMaterialRhiShader::Flags flags ,
        bool on = true)**

        Sets the **flags** on this material shader if **on** is true; otherwise
        clears the specified flags.
        """
        ...

    def flags(self) -> "QSGMaterialRhiShader.Flags":
        """
        https://doc.qt.io/qt-5/qsgmaterialrhishader.html#flags

        **QSGMaterialRhiShader::Flags QSGMaterialRhiShader::flags() const**

        Returns the currently set flags for this material shader.
        """
        ...

    def updateGraphicsPipelineState(
        self,
        state: "QSGMaterialRhiShader.RenderState",
        ps: "QSGMaterialRhiShader.GraphicsPipelineState",
        newMaterial: QSGMaterial,
        oldMaterial: QSGMaterial,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qsgmaterialrhishader.html#updateGraphicsPipelineS
        tate

        **[virtual] bool QSGMaterialRhiShader::updateGraphicsPipelineState(QSGMa
        terialRhiShader::RenderState & state ,
        QSGMaterialRhiShader::GraphicsPipelineState * ps , QSGMaterial *
        newMaterial , QSGMaterial * oldMaterial )**

        This function is called by the scene graph to enable the material to
        provide a custom set of graphics state. The set of states that are
        customizable by material is limited to blending and related settings.

        **Note:** This function is only called when the
        **UpdatesGraphicsPipelineState**  flag was enabled via setFlags(). By
        default it is not set, and so this function is never called.

        The return value must be `true` whenever a change was made to any of the
        members in **ps**.

        **Note:** The contents of **ps** is not persistent between invocations
        of this function.

        The current rendering **state** is passed from the scene graph.

        The subclass specific state can be extracted from **newMaterial**. When
        **oldMaterial** is null, this shader was just activated.
        """
        ...

    def updateSampledImage(
        self,
        state: "QSGMaterialRhiShader.RenderState",
        binding: int,
        newMaterial: QSGMaterial,
        oldMaterial: QSGMaterial,
    ) -> "QSGTexture":
        """
        https://doc.qt.io/qt-5/qsgmaterialrhishader.html#updateSampledImage

        **[virtual] void QSGMaterialRhiShader::updateSampledImage(QSGMaterialRhi
        Shader::RenderState & state , int binding , QSGTexture ** texture ,
        QSGMaterial * newMaterial , QSGMaterial * oldMaterial )**

        This function is called by the scene graph to prepare using a sampled
        image in the shader, typically in form of a combined image sampler.

        **binding** is the binding number of the sampler. The function is called
        for each variable in the material's shaders'
        **QShaderDescription::combinedImageSamplers** ().

        When * **texture** is null, it must be set to a **QSGTexture**  pointer
        before returning. When non-null, it is up to the material to decide if a
        new `QSGTexture *` is stored to it, or if it updates some parameters on
        the already known **QSGTexture** . The ownership of the **QSGTexture**
        is not transferred.

        The current rendering **state** is passed from the scene graph. It is up
        to the material to enqueue the texture data uploads to the
        QRhiResourceUpdateBatch retriveable via
        **RenderState::resourceUpdateBatch** ().

        The subclass specific state can be extracted from **newMaterial**.

        **oldMaterial** can be used to minimize changes. When **oldMaterial** is
        null, this shader was just activated.
        """
        ...

    def updateUniformData(
        self,
        state: "QSGMaterialRhiShader.RenderState",
        newMaterial: QSGMaterial,
        oldMaterial: QSGMaterial,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qsgmaterialrhishader.html#updateUniformData

        **[virtual] bool QSGMaterialRhiShader::updateUniformData(QSGMaterialRhiS
        hader::RenderState & state , QSGMaterial * newMaterial , QSGMaterial *
        oldMaterial )**

        This function is called by the scene graph to get the contents of the
        shader program's uniform buffer updated. The implementation is not
        expected to perform any real graphics operations, it is merely
        responsible for copying data to the **QByteArray**  returned from
        **RenderState::uniformData** (). The scene graph takes care of making
        that buffer visible in the shaders.

        The current rendering **state** is passed from the scene graph. If the
        state indicates that any relevant state is dirty, the implementation
        must update the appropriate region in the buffer data that is accessible
        via **RenderState::uniformData** (). When a state, such as, matrix or
        opacity, is not dirty, there is no need to touch the corresponding
        region since the data is persistent.

        The return value must be `true` whenever any change was made to the
        uniform data.

        The subclass specific state, such as the color of a flat color material,
        should be extracted from **newMaterial** to update the relevant regions
        in the buffer accordingly.

        **oldMaterial** can be used to minimize buffer changes (which are
        typically memcpy calls) when updating material states. When
        **oldMaterial** is null, this shader was just activated.
        """
        ...
