"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtQml import *
from PyQt5 import sip


class QJSEngine(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qjsengine.html

    **Detailed Description**

    **Evaluating Scripts**

    Use **evaluate** () to evaluate script code.

    **QJSEngine**  myEngine;
        **QJSValue**  three = myEngine.evaluate("1 +
    2");

    **evaluate** () returns a **QJSValue**  that holds the result of the
    evaluation. The **QJSValue**  class provides functions for converting the
    result to various C++ types (e.g. **QJSValue::toString** () and
    **QJSValue::toNumber** ()).

    The following code snippet shows how a script function can be defined and
    then invoked from C++ using **QJSValue::call** ():

    **QJSValue**  fun = myEngine.evaluate("(function(a, b) { return a + b; })");
    **QJSValueList**  args;
        args << 1 << 2;
        **QJSValue**  threeAgain =
    fun.call(args);

    As can be seen from the above snippets, a script is provided to the engine
    in the form of a string. One common way of loading scripts is by reading the
    contents of a file and passing it to **evaluate** ():

    **QString**  fileName = "helloworld.qs";
        **QFile**
    scriptFile(fileName);
        if (!scriptFile.open(**QIODevice** ::ReadOnly))
    // handle error
        **QTextStream**  stream(&scriptFile);
        **QString**
    contents = stream.readAll();
        scriptFile.close();
    myEngine.evaluate(contents, fileName);

    Here we pass the name of the file as the second argument to **evaluate** ().
    This does not affect evaluation in any way; the second argument is a
    general-purpose string that is stored in the `Error` object for debugging
    purposes.

    For larger pieces of functionality, you may want to encapsulate your code
    and data into modules. A module is a file that contains script code,
    variables, etc., and uses export statements to describe its interface
    towards the rest of the application. With the help of import statements, a
    module can refer to functionality from other modules. This allows building a
    scripted application from smaller connected building blocks in a safe way.
    In contrast, the approach of using **evaluate** () carries the risk that
    internal variables or functions from one **evaluate** () call accidentally
    pollute the global object and affect subsequent evaluations.

    The following example provides a module that can add numbers:

    export function sum(left, right)
        {
            return left + right
        }

    This module can be loaded with QJSEngine::import() if it is saved under the
    name `math.mjs`:

    QJSvalue module = myEngine.importModule("./math.mjs");
        **QJSValue**
    sumFunction = module.property("sum");
        **QJSValue**  result =
    sumFunction.call(args);

    Modules can also use functionality from other modules using import
    statements:

    import { sum } from "./math.mjs";
        export function addTwice(left, right)
    {
            return sum(left, right) * 2;
        }

    **Engine Configuration**

    The **globalObject** () function returns the **Global Object** associated
    with the script engine. Properties of the Global Object are accessible from
    any script code (i.e. they are global variables). Typically, before
    evaluating "user" scripts, you will want to configure a script engine by
    adding one or more properties to the Global Object:

    myEngine.globalObject().setProperty("myNumber", 123);
        ...
    **QJSValue**  myNumberPlusOne = myEngine.evaluate("myNumber + 1");

    Adding custom properties to the scripting environment is one of the standard
    means of providing a scripting API that is specific to your application.
    Usually these custom properties are objects created by the **newQObject** ()
    or **newObject** () functions.

    **Script Exceptions**

    **evaluate** () can throw a script exception (e.g. due to a syntax error).
    If it does, then **evaluate** () returns the value that was thrown
    (typically an `Error` object). Use **QJSValue::isError** () to check for
    exceptions.

    For detailed information about the error, use **QJSValue::toString** () to
    obtain an error message, and use **QJSValue::property** () to query the
    properties of the `Error` object. The following properties are available:

    * `name`
      * `message`
      * `fileName`
      * `lineNumber`
      * `stack`

    **QJSValue**  result = myEngine.evaluate(...);
        if (result.isError())
    **qDebug** ()
                    << "Uncaught exception at line"
    << result.property("lineNumber").toInt()
                    << ":" <<
    result.toString();

    **Script Object Creation**

    Use **newObject** () to create a JavaScript object; this is the C++
    equivalent of the script statement `new Object()`. You can use the object-
    specific functionality in **QJSValue**  to manipulate the script object
    (e.g. **QJSValue::setProperty** ()). Similarly, use **newArray** () to
    create a JavaScript array object.

    **QObject Integration**

    Use **newQObject** () to wrap a **QObject**  (or subclass) pointer.
    **newQObject** () returns a proxy script object; properties, children, and
    signals and slots of the **QObject**  are available as properties of the
    proxy object. No binding code is needed because it is done dynamically using
    the Qt meta object system.

    **QPushButton**  *button = new **QPushButton** ;
        **QJSValue**
    scriptButton = myEngine.newQObject(button);
    myEngine.globalObject().setProperty("button", scriptButton);
    myEngine.evaluate("button.checkable = true");

        **qDebug** () <<
    scriptButton.property("checkable").toBool();
    scriptButton.property("show").call(); // call the show() slot

    Use **newQMetaObject** () to wrap a **QMetaObject** ; this gives you a
    "script representation" of a **QObject** -based class. **newQMetaObject** ()
    returns a proxy script object; enum values of the class are available as
    properties of the proxy object.

    Constructors exposed to the meta-object system (using **Q_INVOKABLE** ) can
    be called from the script to create a new **QObject**  instance with
    JavaScriptOwnership. For example, given the following class definition:

    class MyObject : public **QObject**
        {
            Q_OBJECT

        public:
    Q_INVOKABLE MyObject() {}
        };

    The `staticMetaObject` for the class can be exposed to JavaScript like so:

    **QJSValue**  jsMetaObject =
    engine.newQMetaObject(&MyObject::staticMetaObject);
    engine.globalObject().setProperty("MyObject", jsMetaObject);

    Instances of the class can then be created in JavaScript:

    engine.evaluate("var myObject = new MyObject()");

    **Note:** Currently only classes using the **Q_OBJECT**  macro are
    supported; it is not possible to expose the `staticMetaObject` of a
    **Q_GADGET**  class to JavaScript.

    **Dynamic QObject Properties**

    Dynamic **QObject**  properties are not supported. For example, the
    following code will not work:

    **QJSEngine**  engine;

        **QObject**  *myQObject = new **QObject**
    ();
        myQObject->setProperty("dynamicProperty", 3);

        **QJSValue**
    myScriptQObject = engine.newQObject(myQObject);
    engine.globalObject().setProperty("myObject", myScriptQObject);
    **qDebug** () << engine.evaluate("myObject.dynamicProperty").toInt();

    **Extensions**

    QJSEngine provides a compliant ECMAScript implementation. By default,
    familiar utilities like logging are not available, but they can can be
    installed via the **installExtensions** () function.

    **See also** **QJSValue** , **Making Applications Scriptable** , and **List
    of JavaScript Objects and Functions** .
    """

    class Extension(int):
        TranslationExtension: QJSEngine = ...
        ConsoleExtension: QJSEngine = ...
        GarbageCollectionExtension: QJSEngine = ...
        AllExtensions: QJSEngine = ...

    class Extensions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QJSEngine.Extensions", "QJSEngine.Extension"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QJSEngine.Extensions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QJSEngine.Extensions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qjsengine.html#QJSEngine

        **QJSEngine::QJSEngine()**

        Constructs a QJSEngine object.

        The **globalObject** () is initialized to have properties as described
        in **ECMA-262** , Section 15.1.
        """
        ...

    @typing.overload
    def __init__(self, parent: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-5/qjsengine.html#QJSEngine-1

        **QJSEngine::QJSEngine(QObject * parent )**

        Constructs a QJSEngine object with the given **parent**.

        The **globalObject** () is initialized to have properties as described
        in **ECMA-262** , Section 15.1.
        """
        ...

    def setUiLanguage(self, language: str) -> None:
        """
        https://doc.qt.io/qt-5/qjsengine.html#uiLanguage-prop

        **uiLanguage : QString**

        This property holds the language to be used for translating user
        interface strings

        This property holds the name of the language to be used for user
        interface string translations. It is exposed for reading and writing as
        `Qt.uiLanguage` when the **QJSEngine::TranslationExtension**  is
        installed on the engine. It is always exposed in instances of
        **QQmlEngine** .

        You can set the value freely and use it in bindings. It is recommended
        to set it after installing translators in your application. By
        convention, an empty string means no translation from the language used
        in the source code is intended to occur.

        This property was introduced in Qt 5.15.

        **Access functions:**

        QString **uiLanguage** () const
        void **setUiLanguage** (const QString
        & **language** )

        **Notifier signal:**

        void **uiLanguageChanged** ()

        **Member Function Documentation**
        """
        ...

    def uiLanguage(self) -> str:
        """
        https://doc.qt.io/qt-5/qjsengine.html#uiLanguage-prop

        **uiLanguage : QString**

        This property holds the language to be used for translating user
        interface strings

        This property holds the name of the language to be used for user
        interface string translations. It is exposed for reading and writing as
        `Qt.uiLanguage` when the **QJSEngine::TranslationExtension**  is
        installed on the engine. It is always exposed in instances of
        **QQmlEngine** .

        You can set the value freely and use it in bindings. It is recommended
        to set it after installing translators in your application. By
        convention, an empty string means no translation from the language used
        in the source code is intended to occur.

        This property was introduced in Qt 5.15.

        **Access functions:**

        QString **uiLanguage** () const
        void **setUiLanguage** (const QString
        & **language** )

        **Notifier signal:**

        void **uiLanguageChanged** ()

        **Member Function Documentation**
        """
        ...

    def isInterrupted(self) -> bool:
        """
        https://doc.qt.io/qt-5/qjsengine.html#isInterrupted

        **bool QJSEngine::isInterrupted() const**

        Returns whether JavaScript execution is currently interrupted.

        This function was introduced in Qt 5.14.

        **See also** **setInterrupted** ().
        """
        ...

    def setInterrupted(self, interrupted: bool) -> None:
        """
        https://doc.qt.io/qt-5/qjsengine.html#setInterrupted

        **void QJSEngine::setInterrupted(bool interrupted )**

        Interrupts or re-enables JavaScript execution.

        If **interrupted** is `true`, any JavaScript executed by this engine
        immediately aborts and returns an error object until this function is
        called again with a value of `false` for **interrupted**.

        This function is thread safe. You may call it from a different thread in
        order to interrupt, for example, an infinite loop in JavaScript.

        This function was introduced in Qt 5.14.

        **See also** **isInterrupted** ().
        """
        ...

    @typing.overload
    def throwError(self, message: str) -> None:
        """
        https://doc.qt.io/qt-5/qjsengine.html#throwError

        **void QJSEngine::throwError(const QString & message )**

        Throws a run-time error (exception) with the given **message**.

        This method is the C++ counterpart of a `throw()` expression in
        JavaScript. It enables C++ code to report run-time errors to
        **QJSEngine** . Therefore it should only be called from C++ code that
        was invoked by a JavaScript function through **QJSEngine** .

        When returning from C++, the engine will interrupt the normal flow of
        execution and call the the next pre-registered exception handler with an
        error object that contains the given **message**. The error object will
        point to the location of the top-most context on the JavaScript caller
        stack; specifically, it will have properties `lineNumber`, `fileName`
        and `stack`. These properties are described in **Script Exceptions** .

        In the following example a C++ method in **FileAccess.cpp** throws an
        error in **qmlFile.qml** at the position where `readFileAsText()` is
        called:

        // qmlFile.qml
            function someFunction() {
              ...
              var text =
        FileAccess.readFileAsText("/path/to/file.txt");
            }

        // FileAccess.cpp
            // Assuming that FileAccess is a QObject-derived
        class that has been
            // registered as a singleton type and provides
        an invokable method
            // readFileAsText()

            **QJSValue**
        FileAccess::readFileAsText(const **QString**  & filePath) {
        **QFile**  file(filePath);

              if (!file.open(**QIODevice**
        ::ReadOnly)) {
                jsEngine->throwError(file.errorString());
        return **QString** ();
              }

              ...
              return content;
        }

        It is also possible to catch the thrown error in JavaScript:

        // qmlFile.qml
            function someFunction() {
              ...
              var text;
        try {
                text = FileAccess.readFileAsText("/path/to/file.txt");
        } catch (error) {
                console.warn("In " + error.fileName + ":" +
        "error.lineNumber" +
                             ": " + error.message);
              }
        }

        If you need a more specific run-time error to describe an exception, you
        can use the **throwError(QJSValue::ErrorType errorType, const QString
        &message)**  overload.

        This function was introduced in Qt 5.12.

        **See also** **Script Exceptions** .
        """
        ...

    @typing.overload
    def throwError(self, errorType: "QJSValue.ErrorType", message: str = ...) -> None:
        """
        https://doc.qt.io/qt-5/qjsengine.html#throwError-1

        **void QJSEngine::throwError(QJSValue::ErrorType errorType , const
        QString & message = QString())**

        This function overloads throwError().

        Throws a run-time error (exception) with the given **errorType** and
        **message**.

        // Assuming that DataEntry is a QObject-derived class that has been
        // registered as a singleton type and provides an invokable method
        // setAge().

            void DataEntry::setAge(int age) {
              if (age <
        0 || age > 200) {
                jsEngine->throwError(**QJSValue**
        ::RangeError,
                                     "Age must be between 0 and
        200");
              }
              ...
            }

        This function was introduced in Qt 5.12.

        **See also** **Script Exceptions**  and **newErrorObject** ().
        """
        ...

    def newErrorObject(
        self, errorType: "QJSValue.ErrorType", message: str = ...
    ) -> "QJSValue":
        """
        https://doc.qt.io/qt-5/qjsengine.html#newErrorObject

        **QJSValue QJSEngine::newErrorObject(QJSValue::ErrorType errorType ,
        const QString & message = QString())**

        Creates a JavaScript object of class Error, with **message** as the
        error message.

        The prototype of the created object will be **errorType**.

        This function was introduced in Qt 5.12.

        **See also** **newObject** (), **throwError** (), and
        **QJSValue::isError** ().
        """
        ...

    def importModule(self, fileName: str) -> "QJSValue":
        """
        https://doc.qt.io/qt-5/qjsengine.html#importModule

        **QJSValue QJSEngine::importModule(const QString & fileName )**

        Imports the module located at **fileName** and returns a module
        namespace object that contains all exported variables, constants and
        functions as properties.

        If this is the first time the module is imported in the engine, the file
        is loaded from the specified location in either the local file system or
        the Qt resource system and evaluated as an ECMAScript module. The file
        is expected to be encoded in UTF-8 text.

        Subsequent imports of the same module will return the previously
        imported instance. Modules are singletons and remain around until the
        engine is destroyed.

        The specified **fileName** will internally be normalized using
        **QFileInfo::canonicalFilePath** (). That means that multiple imports of
        the same file on disk using different relative paths will load the file
        only once.

        **Note:** If an exception is thrown during the loading of the module,
        the return value will be the exception (typically an `Error` object; see
        **QJSValue::isError** ()).

        This function was introduced in Qt 5.12.
        """
        ...

    def newQMetaObject(self, metaObject: QtCore.QMetaObject) -> "QJSValue":
        """
        https://doc.qt.io/qt-5/qjsengine.html#newQMetaObject

        **QJSValue QJSEngine::newQMetaObject(const QMetaObject * metaObject )**

        Creates a JavaScript object that wraps the given **QMetaObject**  The
        **metaObject** must outlive the script engine. It is recommended to only
        use this method with static metaobjects.

        When called as a constructor, a new instance of the class will be
        created. Only constructors exposed by **Q_INVOKABLE**  will be visible
        from the script engine.

        This function was introduced in Qt 5.8.

        **See also** **newQObject** () and **QObject Integration** .
        """
        ...

    def installExtensions(
        self,
        extensions: typing.Union["QJSEngine.Extensions", "QJSEngine.Extension"],
        object: typing.Union[
            "QJSValue", "QJSValue.SpecialValue", bool, int, float, str
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qjsengine.html#installExtensions

        **void QJSEngine::installExtensions(QJSEngine::Extensions extensions ,
        const QJSValue & object = QJSValue())**

        Installs JavaScript **extensions** to add functionality that is not
        available in a standard ECMAScript implementation.

        The extensions are installed on the given **object** , or on the
        **Global Object**  if no object is specified.

        Several extensions can be installed at once by `OR`-ing the enum values:

        installExtensions(**QJSEngine** ::TranslationExtension | **QJSEngine**
        ::ConsoleExtension);

        This function was introduced in Qt 5.6.

        **See also** **Extension** .
        """
        ...

    def installTranslatorFunctions(
        self,
        object: typing.Union[
            "QJSValue", "QJSValue.SpecialValue", bool, int, float, str
        ] = ...,
    ) -> None:
        ...

    def collectGarbage(self) -> None:
        """
        https://doc.qt.io/qt-5/qjsengine.html#collectGarbage

        **void QJSEngine::collectGarbage()**

        Runs the garbage collector.

        The garbage collector will attempt to reclaim memory by locating and
        disposing of objects that are no longer reachable in the script
        environment.

        Normally you don't need to call this function; the garbage collector
        will automatically be invoked when the **QJSEngine**  decides that it's
        wise to do so (i.e. when a certain number of new objects have been
        created). However, you can call this function to explicitly request that
        garbage collection should be performed as soon as possible.
        """
        ...

    def newQObject(self, object: QtCore.QObject) -> "QJSValue":
        """
        https://doc.qt.io/qt-5/qjsengine.html#newQObject

        **QJSValue QJSEngine::newQObject(QObject * object )**

        Creates a JavaScript object that wraps the given **QObject**  **object**
        , using JavaScriptOwnership.

        Signals and slots, properties and children of **object** are available
        as properties of the created **QJSValue** .

        If **object** is a null pointer, this function returns a null value.

        If a default prototype has been registered for the **object** 's class
        (or its superclass, recursively), the prototype of the new script object
        will be set to be that default prototype.

        If the given **object** is deleted outside of the engine's control, any
        attempt to access the deleted **QObject** 's members through the
        JavaScript wrapper object (either by script code or C++) will result in
        a **script exception** .

        **See also** **QJSValue::toQObject** ().
        """
        ...

    def newArray(self, length: int = ...) -> "QJSValue":
        """
        https://doc.qt.io/qt-5/qjsengine.html#newArray

        **QJSValue QJSEngine::newArray(uint length = 0)**

        Creates a JavaScript object of class Array with the given **length**.

        **See also** **newObject** ().
        """
        ...

    def newObject(self) -> "QJSValue":
        """
        https://doc.qt.io/qt-5/qjsengine.html#newObject

        **QJSValue QJSEngine::newObject()**

        Creates a JavaScript object of class Object.

        The prototype of the created object will be the Object prototype object.

        **See also** **newArray** () and **QJSValue::setProperty** ().
        """
        ...

    def evaluate(
        self, program: str, fileName: str = ..., lineNumber: int = ...
    ) -> "QJSValue":
        """
        https://doc.qt.io/qt-5/qjsengine.html#evaluate

        **QJSValue QJSEngine::evaluate(const QString & program , const QString &
        fileName = QString(), int lineNumber = 1)**

        Evaluates **program** , using **lineNumber** as the base line number,
        and returns the result of the evaluation.

        The script code will be evaluated in the context of the global object.

        The evaluation of **program** can cause an **exception**  in the engine;
        in this case the return value will be the exception that was thrown
        (typically an `Error` object; see **QJSValue::isError** ()).

        **lineNumber** is used to specify a starting line number for **program**
        ; line number information reported by the engine that pertains to this
        evaluation will be based on this argument. For example, if **program**
        consists of two lines of code, and the statement on the second line
        causes a script exception, the exception line number would be
        **lineNumber** plus one. When no starting line number is specified, line
        numbers will be 1-based.

        **fileName** is used for error reporting. For example, in error objects
        the file name is accessible through the "fileName" property if it is
        provided with this function.

        **Note:** If an exception was thrown and the exception value is not an
        Error instance (i.e., **QJSValue::isError** () returns `false`), the
        exception value will still be returned, but there is currently no API
        for detecting that an exception did occur in this case.
        """
        ...

    def globalObject(self) -> "QJSValue":
        """
        https://doc.qt.io/qt-5/qjsengine.html#globalObject

        **QJSValue QJSEngine::globalObject() const**

        Returns this engine's Global Object.

        By default, the Global Object contains the built-in objects that are
        part of **ECMA-262** , such as Math, Date and String. Additionally, you
        can set properties of the Global Object to make your own extensions
        available to all script code. Non-local variables in script code will be
        created as properties of the Global Object, as well as local variables
        in global code.
        """
        ...

    @property
    def uiLanguageChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
