"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtPrintSupport import *


class QPrinter(QtGui.QPagedPaintDevice):
    """
    https://doc.qt.io/qt-5/qprinter.html

    **Detailed Description**

    This device represents a series of pages of printed output, and is used in
    almost exactly the same way as other paint devices such as **QWidget**  and
    **QPixmap** . A set of additional functions are provided to manage device-
    specific features, such as orientation and resolution, and to step through
    the pages in a document as it is generated.

    When printing directly to a printer on Windows or macOS, QPrinter uses the
    built-in printer drivers. On X11, QPrinter uses the **Common Unix Printing
    System (CUPS)**  to send PDF output to the printer. As an alternative, the
    **printProgram** () function can be used to specify the command or utility
    to use instead of the system default.

    Note that setting parameters like paper size and resolution on an invalid
    printer is undefined. You can use **QPrinter::isValid** () to verify this
    before changing any parameters.

    QPrinter supports a number of parameters, most of which can be changed by
    the end user through a **print dialog** . In general, QPrinter passes these
    functions onto the underlying **QPrintEngine** .

    The most important parameters are:

    * setOrientation() tells QPrinter which page orientation to use.
      *
    setPaperSize() tells QPrinter what paper size to expect from the printer.
    * **setResolution** () tells QPrinter what resolution you wish the printer
    to provide, in dots per inch (DPI).
      * **setFullPage** () tells QPrinter
    whether you want to deal with the full page or just with the part the
    printer can draw on.
      * **setCopyCount** () tells QPrinter how many copies
    of the document it should print.

    Many of these functions can only be called before the actual printing begins
    (i.e., before **QPainter::begin** () is called). This usually makes sense
    because, for example, it's not possible to change the number of copies when
    you are halfway through printing. There are also some settings that the user
    sets (through the printer dialog) and that applications are expected to
    obey. See **QAbstractPrintDialog** 's documentation for more details.

    When **QPainter::begin** () is called, the QPrinter it operates on is
    prepared for a new page, enabling the **QPainter**  to be used immediately
    to paint the first page in a document. Once the first page has been painted,
    **newPage** () can be called to request a new blank page to paint on, or
    **QPainter::end** () can be called to finish printing. The second page and
    all following pages are prepared using a call to **newPage** () before they
    are painted.

    The first page in a document does not need to be preceded by a call to
    **newPage** (). You only need to calling **newPage** () after
    **QPainter::begin** () if you need to insert a blank page at the beginning
    of a printed document. Similarly, calling **newPage** () after the last page
    in a document is painted will result in a trailing blank page appended to
    the end of the printed document.

    If you want to abort the print job, **abort** () will try its best to stop
    printing. It may cancel the entire job or just part of it.

    Since QPrinter can print to any **QPrintEngine**  subclass, it is possible
    to extend printing support to cover new types of printing subsystem by
    subclassing **QPrintEngine**  and reimplementing its interface.

    **See also** **QPrintDialog**  and **Qt Print Support** .
    """

    class DuplexMode(int):
        DuplexNone: QPrinter = ...
        DuplexAuto: QPrinter = ...
        DuplexLongSide: QPrinter = ...
        DuplexShortSide: QPrinter = ...

    class Unit(int):
        Millimeter: QPrinter = ...
        Point: QPrinter = ...
        Inch: QPrinter = ...
        Pica: QPrinter = ...
        Didot: QPrinter = ...
        Cicero: QPrinter = ...
        DevicePixel: QPrinter = ...

    class PrintRange(int):
        AllPages: QPrinter = ...
        Selection: QPrinter = ...
        PageRange: QPrinter = ...
        CurrentPage: QPrinter = ...

    class OutputFormat(int):
        NativeFormat: QPrinter = ...
        PdfFormat: QPrinter = ...

    class PrinterState(int):
        Idle: QPrinter = ...
        Active: QPrinter = ...
        Aborted: QPrinter = ...
        Error: QPrinter = ...

    class PaperSource(int):
        OnlyOne: QPrinter = ...
        Lower: QPrinter = ...
        Middle: QPrinter = ...
        Manual: QPrinter = ...
        Envelope: QPrinter = ...
        EnvelopeManual: QPrinter = ...
        Auto: QPrinter = ...
        Tractor: QPrinter = ...
        SmallFormat: QPrinter = ...
        LargeFormat: QPrinter = ...
        LargeCapacity: QPrinter = ...
        Cassette: QPrinter = ...
        FormSource: QPrinter = ...
        MaxPageSource: QPrinter = ...
        Upper: QPrinter = ...
        CustomSource: QPrinter = ...
        LastPaperSource: QPrinter = ...

    class ColorMode(int):
        GrayScale: QPrinter = ...
        Color: QPrinter = ...

    class PageOrder(int):
        FirstPageFirst: QPrinter = ...
        LastPageFirst: QPrinter = ...

    class Orientation(int):
        Portrait: QPrinter = ...
        Landscape: QPrinter = ...

    class PrinterMode(int):
        ScreenResolution: QPrinter = ...
        PrinterResolution: QPrinter = ...
        HighResolution: QPrinter = ...

    @typing.overload
    def __init__(self, mode: "QPrinter.PrinterMode" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#QPrinter

        **QPrinter::QPrinter(QPrinter::PrinterMode mode = ScreenResolution)**

        Creates a new printer object with the given **mode**.
        """
        ...

    @typing.overload
    def __init__(
        self, printer: "QPrinterInfo", mode: "QPrinter.PrinterMode" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#QPrinter-1

        **QPrinter::QPrinter(const QPrinterInfo & printer ,
        QPrinter::PrinterMode mode = ScreenResolution)**

        Creates a new printer object with the given **printer** and **mode**.

        This function was introduced in Qt 4.4.
        """
        ...

    def pdfVersion(self) -> QtGui.QPagedPaintDevice.PdfVersion:
        """
        https://doc.qt.io/qt-5/qprinter.html#pdfVersion

        **QPagedPaintDevice::PdfVersion QPrinter::pdfVersion() const**

        Returns the PDF version for this printer. The default is
        `PdfVersion_1_4`.

        This function was introduced in Qt 5.10.

        **See also** **setPdfVersion** ().
        """
        ...

    def setPdfVersion(self, version: QtGui.QPagedPaintDevice.PdfVersion) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setPdfVersion

        **void QPrinter::setPdfVersion(QPagedPaintDevice::PdfVersion version )**

        Sets the PDF version for this printer to **version**.

        If **version** is the same value as currently set then no change will be
        made.

        This function was introduced in Qt 5.10.

        **See also** **pdfVersion** ().
        """
        ...

    def paperName(self) -> str:
        ...

    def setPaperName(self, paperName: str) -> None:
        ...

    def setEngines(
        self, printEngine: QPrintEngine, paintEngine: QtGui.QPaintEngine
    ) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setEngines

        **[protected] void QPrinter::setEngines(QPrintEngine * printEngine ,
        QPaintEngine * paintEngine )**

        This function is used by subclasses of **QPrinter**  to specify custom
        print and paint engines ( **printEngine** and **paintEngine** ,
        respectively).

        **QPrinter**  does not take ownership of the engines, so you need to
        manage these engine instances yourself.

        Note that changing the engines will reset the printer state and all its
        properties.

        This function was introduced in Qt 4.1.

        **See also** **printEngine** (), **paintEngine** (), and
        **setOutputFormat** ().
        """
        ...

    def metric(self, a0: QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def getPageMargins(
        self, unit: "QPrinter.Unit"
    ) -> typing.Tuple[float, float, float, float]:
        ...

    def setPageMargins(
        self,
        left: float,
        top: float,
        right: float,
        bottom: float,
        unit: "QPrinter.Unit",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setPageMargins

        **bool QPrinter::setPageMargins(const QMarginsF & margins )**

        Set the page margins to **margins** using the current units. Returns
        `true` if the page margins were set successfully.

        **See also** **pageLayout** () and **setPageLayout** ().
        """
        ...

    def setMargins(self, m: QtGui.QPagedPaintDevice.Margins) -> None:
        ...

    def printRange(self) -> "QPrinter.PrintRange":
        """
        https://doc.qt.io/qt-5/qprinter.html#printRange

        **QPrinter::PrintRange QPrinter::printRange() const**

        Returns the page range of the **QPrinter** . After the print setup
        dialog has been opened, this function returns the value selected by the
        user.

        This function was introduced in Qt 4.1.

        **See also** **setPrintRange** ().
        """
        ...

    def setPrintRange(self, range: "QPrinter.PrintRange") -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setPrintRange

        **void QPrinter::setPrintRange(QPrinter::PrintRange range )**

        Sets the print range option in to be **range**.

        This function was introduced in Qt 4.1.

        **See also** **printRange** ().
        """
        ...

    def toPage(self) -> int:
        """
        https://doc.qt.io/qt-5/qprinter.html#toPage

        **int QPrinter::toPage() const**

        Returns the number of the last page in a range of pages to be printed
        (the "to page" setting). Pages in a document are numbered according to
        the convention that the first page is page 1.

        By default, this function returns a special value of 0, meaning that the
        "to page" setting is unset.

        **Note:** If **fromPage** () and toPage() both return 0, this indicates
        that **the whole document will be printed**.

        The programmer is responsible for reading this setting and printing
        accordingly.

        This function was introduced in Qt 4.1.

        **See also** **setFromTo** () and **fromPage** ().
        """
        ...

    def fromPage(self) -> int:
        """
        https://doc.qt.io/qt-5/qprinter.html#fromPage

        **int QPrinter::fromPage() const**

        Returns the number of the first page in a range of pages to be printed
        (the "from page" setting). Pages in a document are numbered according to
        the convention that the first page is page 1.

        By default, this function returns a special value of 0, meaning that the
        "from page" setting is unset.

        **Note:** If fromPage() and **toPage** () both return 0, this indicates
        that **the whole document will be printed**.

        This function was introduced in Qt 4.1.

        **See also** **setFromTo** () and **toPage** ().
        """
        ...

    def setFromTo(self, fromPage: int, toPage: int) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setFromTo

        **void QPrinter::setFromTo(int from , int to )**

        Sets the range of pages to be printed to cover the pages with numbers
        specified by **from** and **to** , where **from** corresponds to the
        first page in the range and **to** corresponds to the last.

        **Note:** Pages in a document are numbered according to the convention
        that the first page is page 1. However, if **from** and **to** are both
        set to 0, the **whole document will be printed**.

        This function is mostly used to set a default value that the user can
        override in the print dialog when you call setup().

        This function was introduced in Qt 4.1.

        **See also** **fromPage** () and **toPage** ().
        """
        ...

    def printEngine(self) -> QPrintEngine:
        """
        https://doc.qt.io/qt-5/qprinter.html#printEngine

        **QPrintEngine *QPrinter::printEngine() const**

        Returns the print engine used by the printer.

        This function was introduced in Qt 4.1.
        """
        ...

    def paintEngine(self) -> QtGui.QPaintEngine:
        """
        https://doc.qt.io/qt-5/qprinter.html#paintEngine

        **[override virtual] QPaintEngine *QPrinter::paintEngine() const**

        Reimplements: **QPaintDevice::paintEngine** () const.

        Returns the paint engine used by the printer.
        """
        ...

    def printerState(self) -> "QPrinter.PrinterState":
        """
        https://doc.qt.io/qt-5/qprinter.html#printerState

        **QPrinter::PrinterState QPrinter::printerState() const**

        Returns the current state of the printer. This may not always be
        accurate (for example if the printer doesn't have the capability of
        reporting its state to the operating system).
        """
        ...

    def abort(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinter.html#abort

        **bool QPrinter::abort()**

        Aborts the current print run. Returns `true` if the print run was
        successfully aborted and **printerState** () will return
        **QPrinter::Aborted** ; otherwise returns `false`.

        It is not always possible to abort a print job. For example, all the
        data has gone to the printer but the printer cannot or will not cancel
        the job when asked to.
        """
        ...

    def newPage(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinter.html#newPage

        **[override virtual] bool QPrinter::newPage()**

        Reimplements: **QPagedPaintDevice::newPage** ().

        Tells the printer to eject the current page and to continue printing on
        a new page. Returns `true` if this was successful; otherwise returns
        `false`.

        Calling newPage() on an inactive **QPrinter**  object will always fail.
        """
        ...

    @typing.overload
    def pageRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qprinter.html#pageRect-1

        **QRectF QPrinter::pageRect(QPrinter::Unit unit ) const**

        Returns the page's rectangle in **unit** ; this is usually smaller than
        the paperRect() since the page normally has margins between its borders
        and the paper.

        This function was introduced in Qt 4.4.

        **See also** **paperSize** ().
        """
        ...

    @typing.overload
    def pageRect(self, a0: "QPrinter.Unit") -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qprinter.html#pageRect-1

        **QRectF QPrinter::pageRect(QPrinter::Unit unit ) const**

        Returns the page's rectangle in **unit** ; this is usually smaller than
        the paperRect() since the page normally has margins between its borders
        and the paper.

        This function was introduced in Qt 4.4.

        **See also** **paperSize** ().
        """
        ...

    @typing.overload
    def paperRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qprinter.html#paperRect-1

        **QRectF QPrinter::paperRect(QPrinter::Unit unit ) const**

        Returns the paper's rectangle in **unit** ; this is usually larger than
        the pageRect().

        This function was introduced in Qt 4.4.

        **See also** **pageRect** ().
        """
        ...

    @typing.overload
    def paperRect(self, a0: "QPrinter.Unit") -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qprinter.html#paperRect-1

        **QRectF QPrinter::paperRect(QPrinter::Unit unit ) const**

        Returns the paper's rectangle in **unit** ; this is usually larger than
        the pageRect().

        This function was introduced in Qt 4.4.

        **See also** **pageRect** ().
        """
        ...

    def doubleSidedPrinting(self) -> bool:
        ...

    def setDoubleSidedPrinting(self, enable: bool) -> None:
        ...

    def fontEmbeddingEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinter.html#fontEmbeddingEnabled

        **bool QPrinter::fontEmbeddingEnabled() const**

        Returns `true` if font embedding is enabled.

        This function was introduced in Qt 4.1.

        **See also** **setFontEmbeddingEnabled** ().
        """
        ...

    def setFontEmbeddingEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setFontEmbeddingEnabled

        **void QPrinter::setFontEmbeddingEnabled(bool enable )**

        Enabled or disables font embedding depending on **enable**.

        This function was introduced in Qt 4.1.

        **See also** **fontEmbeddingEnabled** ().
        """
        ...

    def supportedResolutions(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qprinter.html#supportedResolutions

        **QList<int> QPrinter::supportedResolutions() const**

        Returns a list of the resolutions (a list of dots-per-inch integers)
        that the printer says it supports.

        For X11 where all printing is directly to PDF, this function will always
        return a one item list containing only the PDF resolution, i.e., 72 (72
        dpi -- but see **PrinterMode** ).
        """
        ...

    def duplex(self) -> "QPrinter.DuplexMode":
        """
        https://doc.qt.io/qt-5/qprinter.html#duplex

        **QPrinter::DuplexMode QPrinter::duplex() const**

        Returns the current duplex mode.

        This function was introduced in Qt 4.4.

        **See also** **setDuplex** ().
        """
        ...

    def setDuplex(self, duplex: "QPrinter.DuplexMode") -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setDuplex

        **void QPrinter::setDuplex(QPrinter::DuplexMode duplex )**

        Enables double sided printing based on the **duplex** mode.

        This function was introduced in Qt 4.4.

        **See also** **duplex** ().
        """
        ...

    def paperSource(self) -> "QPrinter.PaperSource":
        """
        https://doc.qt.io/qt-5/qprinter.html#paperSource

        **QPrinter::PaperSource QPrinter::paperSource() const**

        Returns the printer's paper source. This is `Manual` or a printer tray
        or paper cassette.

        **See also** **setPaperSource** ().
        """
        ...

    def setPaperSource(self, a0: "QPrinter.PaperSource") -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setPaperSource

        **void QPrinter::setPaperSource(QPrinter::PaperSource source )**

        Sets the paper source setting to **source**.

        Windows only: This option can be changed while printing and will take
        effect from the next call to **newPage** ()

        **See also** **paperSource** ().
        """
        ...

    def supportsMultipleCopies(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinter.html#supportsMultipleCopies

        **bool QPrinter::supportsMultipleCopies() const**

        Returns `true` if the printer supports printing multiple copies of the
        same document in one job; otherwise false is returned.

        On most systems this function will return true. However, on X11 systems
        that do not support CUPS, this function will return false. That means
        the application has to handle the number of copies by printing the same
        document the required number of times.

        This function was introduced in Qt 4.7.

        **See also** **setCopyCount** () and **copyCount** ().
        """
        ...

    def copyCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qprinter.html#copyCount

        **int QPrinter::copyCount() const**

        Returns the number of copies that will be printed. The default value is
        1.

        This function was introduced in Qt 4.7.

        **See also** **setCopyCount** () and **supportsMultipleCopies** ().
        """
        ...

    def setCopyCount(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setCopyCount

        **void QPrinter::setCopyCount(int count )**

        Sets the number of copies to be printed to **count**.

        The printer driver reads this setting and prints the specified number of
        copies.

        This function was introduced in Qt 4.7.

        **See also** **copyCount** () and **supportsMultipleCopies** ().
        """
        ...

    def fullPage(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinter.html#fullPage

        **bool QPrinter::fullPage() const**

        Returns `true` if the origin of the printer's coordinate system is at
        the corner of the page and false if it is at the edge of the printable
        area.

        See **setFullPage** () for details and caveats.

        **See also** **setFullPage** () and **pageLayout** ().
        """
        ...

    def setFullPage(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setFullPage

        **void QPrinter::setFullPage(bool fp )**

        If **fp** is true, enables support for painting over the entire page;
        otherwise restricts painting to the printable area reported by the
        device.

        By default, full page printing is disabled. In this case, the origin of
        the **QPrinter** 's coordinate system coincides with the top-left corner
        of the printable area.

        If full page printing is enabled, the origin of the **QPrinter** 's
        coordinate system coincides with the top-left corner of the paper
        itself. In this case, the **device metrics**  will report the exact same
        dimensions as indicated by **PaperSize** . It may not be possible to
        print on the entire physical page because of the printer's margins, so
        the application must account for the margins itself.

        **See also** **fullPage** (), **pageLayout** (), **setPageSize** (),
        **width** (), and **height** ().
        """
        ...

    def collateCopies(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinter.html#collateCopies

        **bool QPrinter::collateCopies() const**

        Returns `true` if collation is turned on when multiple copies is
        selected. Returns `false` if it is turned off when multiple copies is
        selected. When collating is turned off the printing of each individual
        page will be repeated the numCopies() amount before the next page is
        started. With collating turned on all pages are printed before the next
        copy of those pages is started.

        This function was introduced in Qt 4.1.

        **See also** **setCollateCopies** ().
        """
        ...

    def setCollateCopies(self, collate: bool) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setCollateCopies

        **void QPrinter::setCollateCopies(bool collate )**

        Sets the default value for collation checkbox when the print dialog
        appears. If **collate** is true, it will enable
        setCollateCopiesEnabled(). The default value is false. This value will
        be changed by what the user presses in the print dialog.

        This function was introduced in Qt 4.1.

        **See also** **collateCopies** ().
        """
        ...

    def colorMode(self) -> "QPrinter.ColorMode":
        """
        https://doc.qt.io/qt-5/qprinter.html#colorMode

        **QPrinter::ColorMode QPrinter::colorMode() const**

        Returns the current color mode.

        **See also** **setColorMode** ().
        """
        ...

    def setColorMode(self, a0: "QPrinter.ColorMode") -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setColorMode

        **void QPrinter::setColorMode(QPrinter::ColorMode newColorMode )**

        Sets the printer's color mode to **newColorMode** , which can be either
        `Color` or `GrayScale`.

        **See also** **colorMode** ().
        """
        ...

    def resolution(self) -> int:
        """
        https://doc.qt.io/qt-5/qprinter.html#resolution

        **int QPrinter::resolution() const**

        Returns the current assumed resolution of the printer, as set by
        **setResolution** () or by the printer driver.

        **See also** **setResolution** ().
        """
        ...

    def setResolution(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setResolution

        **void QPrinter::setResolution(int dpi )**

        Requests that the printer prints at **dpi** or as near to **dpi** as
        possible.

        This setting affects the coordinate system as returned by, for example
        **QPainter::viewport** ().

        This function must be called before **QPainter::begin** () to have an
        effect on all platforms.

        **See also** **resolution** () and **setPaperSize** ().
        """
        ...

    def pageOrder(self) -> "QPrinter.PageOrder":
        """
        https://doc.qt.io/qt-5/qprinter.html#pageOrder

        **QPrinter::PageOrder QPrinter::pageOrder() const**

        Returns the current page order.

        The default page order is `FirstPageFirst`.

        **See also** **setPageOrder** ().
        """
        ...

    def setPageOrder(self, a0: "QPrinter.PageOrder") -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setPageOrder

        **void QPrinter::setPageOrder(QPrinter::PageOrder pageOrder )**

        Sets the page order to **pageOrder**.

        The page order can be **QPrinter::FirstPageFirst**  or
        **QPrinter::LastPageFirst** . The application is responsible for reading
        the page order and printing accordingly.

        This function is mostly useful for setting a default value that the user
        can override in the print dialog.

        This function is only supported under X11.

        **See also** **pageOrder** ().
        """
        ...

    @typing.overload
    def paperSize(self) -> QtGui.QPagedPaintDevice.PageSize:
        ...

    @typing.overload
    def paperSize(self, unit: "QPrinter.Unit") -> QtCore.QSizeF:
        ...

    @typing.overload
    def setPaperSize(self, a0: QtGui.QPagedPaintDevice.PageSize) -> None:
        ...

    @typing.overload
    def setPaperSize(self, paperSize: QtCore.QSizeF, unit: "QPrinter.Unit") -> None:
        ...

    def setPageSizeMM(self, size: QtCore.QSizeF) -> None:
        ...

    def orientation(self) -> "QPrinter.Orientation":
        ...

    def setOrientation(self, a0: "QPrinter.Orientation") -> None:
        ...

    def creator(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinter.html#creator

        **QString QPrinter::creator() const**

        Returns the name of the application that created the document.

        **See also** **setCreator** ().
        """
        ...

    def setCreator(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setCreator

        **void QPrinter::setCreator(const QString & creator )**

        Sets the name of the application that created the document to
        **creator**.

        This function is only applicable to the X11 version of Qt. If no creator
        name is specified, the creator will be set to "Qt" followed by some
        version number.

        **See also** **creator** ().
        """
        ...

    def docName(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinter.html#docName

        **QString QPrinter::docName() const**

        Returns the document name.

        **See also** **setDocName** () and
        **QPrintEngine::PrintEnginePropertyKey** .
        """
        ...

    def setDocName(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setDocName

        **void QPrinter::setDocName(const QString & name )**

        Sets the document name to **name**.

        On X11, the document name is for example used as the default output
        filename in **QPrintDialog** . Note that the document name does not
        affect the file name if the printer is printing to a file. Use the
        setOutputFile() function for this.

        **See also** **docName** () and **QPrintEngine::PrintEnginePropertyKey**
        .
        """
        ...

    def printProgram(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinter.html#printProgram

        **QString QPrinter::printProgram() const**

        Returns the name of the program that sends the print output to the
        printer.

        The default is to return an empty string; meaning that **QPrinter**
        will try to be smart in a system-dependent way. On X11 only, you can set
        it to something different to use a specific print program. On the other
        platforms, this returns an empty string.

        **See also** **setPrintProgram** () and **setPrinterSelectionOption**
        ().
        """
        ...

    def setPrintProgram(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setPrintProgram

        **void QPrinter::setPrintProgram(const QString & printProg )**

        Sets the name of the program that should do the print job to
        **printProg**.

        On X11, this function sets the program to call with the PDF output. On
        other platforms, it has no effect.

        **See also** **printProgram** ().
        """
        ...

    def outputFileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinter.html#outputFileName

        **QString QPrinter::outputFileName() const**

        Returns the name of the output file. By default, this is an empty string
        (indicating that the printer shouldn't print to file).

        **See also** **setOutputFileName** () and
        **QPrintEngine::PrintEnginePropertyKey** .
        """
        ...

    def setOutputFileName(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setOutputFileName

        **void QPrinter::setOutputFileName(const QString & fileName )**

        Sets the name of the output file to **fileName**.

        Setting a null or empty name (0 or "") disables printing to a file.
        Setting a non-empty name enables printing to a file.

        This can change the value of **outputFormat** (). If the file name has
        the ".pdf" suffix PDF is generated. If the file name has a suffix other
        than ".pdf", the output format used is the one set with
        **setOutputFormat** ().

        **QPrinter**  uses Qt's cross-platform PDF print engines respectively.
        If you can produce this format natively, for example macOS can generate
        PDF's from its print engine, set the output format back to
        **NativeFormat** .

        **See also** **outputFileName** () and **setOutputFormat** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qprinter.html#isValid

        **bool QPrinter::isValid() const**

        Returns `true` if the printer currently selected is a valid printer in
        the system, or a pure PDF printer; otherwise returns `false`.

        To detect other failures check the output of **QPainter::begin** () or
        **QPrinter::newPage** ().

        **QPrinter**  printer;
                printer.setOutputFormat(**QPrinter**
        ::PdfFormat);
        printer.setOutputFileName("/foobar/nonwritable.pdf");
        **QPainter**  painter;
                if (! painter.begin(&printer)) { //
        failed to open file
                    **qWarning** ("failed to open file, is
        it writable?");
                    return 1;
                }
        painter.drawText(10, 10, "Test");
                if (! printer.newPage()) {
        **qWarning** ("failed in flushing page to disk, disk full?");
        return 1;
                }
                painter.drawText(10, 10, "Test 2");
        painter.end();

        This function was introduced in Qt 4.4.

        **See also** **setPrinterName** ().
        """
        ...

    def printerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qprinter.html#printerName

        **QString QPrinter::printerName() const**

        Returns the printer name. This value is initially set to the name of the
        default printer.

        **See also** **setPrinterName** ().
        """
        ...

    def setPrinterName(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setPrinterName

        **void QPrinter::setPrinterName(const QString & name )**

        Sets the printer name to **name**.

        If the **name** is empty then the output format will be set to
        **PdfFormat** .

        If the **name** is not a valid printer then no change will be made.

        If the **name** is a valid printer then the output format will be set to
        **NativeFormat** .

        **See also** **printerName** (), **isValid** (), and **setOutputFormat**
        ().
        """
        ...

    def outputFormat(self) -> "QPrinter.OutputFormat":
        """
        https://doc.qt.io/qt-5/qprinter.html#outputFormat

        **QPrinter::OutputFormat QPrinter::outputFormat() const**

        Returns the output format for this printer.

        This function was introduced in Qt 4.1.

        **See also** **setOutputFormat** ().
        """
        ...

    def setOutputFormat(self, format: "QPrinter.OutputFormat") -> None:
        """
        https://doc.qt.io/qt-5/qprinter.html#setOutputFormat

        **void QPrinter::setOutputFormat(QPrinter::OutputFormat format )**

        Sets the output format for this printer to **format**.

        If **format** is the same value as currently set then no change will be
        made.

        If **format** is **NativeFormat**  then the **printerName**  will be set
        to the default printer. If there are no valid printers configured then
        no change will be made. If you want to set **NativeFormat**  with a
        specific **printerName**  then use **setPrinterName** ().

        This function was introduced in Qt 4.1.

        **See also** **outputFormat** () and **setPrinterName** ().
        """
        ...
