"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtPositioning import *


class QGeoPolygon(QGeoShape):
    """
    https://doc.qt.io/qt-5/qgeopolygon.html

    **Detailed Description**

    The polygon is defined by an ordered list of QGeoCoordinates representing
    its perimeter.

    Each two adjacent elements in this list are intended to be connected
    together by the shortest line segment of constant bearing passing through
    both elements. This type of connection can cross the date line in the
    longitudinal direction, but never crosses the poles.

    This is relevant for the calculation of the bounding box returned by
    **QGeoShape::boundingGeoRectangle** () for this shape, which will have the
    latitude of the top left corner set to the maximum latitude in the path
    point set. Similarly, the latitude of the bottom right corner will be the
    minimum latitude in the path point set.

    This class is a **Q_GADGET** . It can be **directly used from C++ and QML**
    .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#QGeoPolygon

        **QGeoPolygon::QGeoPolygon()**

        Constructs a new, empty geo polygon.
        """
        ...

    @typing.overload
    def __init__(self, path: typing.Iterable[QGeoCoordinate]) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#QGeoPolygon-1

        **QGeoPolygon::QGeoPolygon(const QList<QGeoCoordinate> & path )**

        Constructs a new geo polygon from the coordinates specified in **path**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoPolygon") -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#QGeoPolygon-2

        **QGeoPolygon::QGeoPolygon(const QGeoPolygon & other )**

        Constructs a new geo polygon from the contents of **other**.
        """
        ...

    @typing.overload
    def __init__(self, other: QGeoShape) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#QGeoPolygon-3

        **QGeoPolygon::QGeoPolygon(const QGeoShape & other )**

        Constructs a new geo polygon from the contents of **other**.
        """
        ...

    def perimeter(self) -> typing.List[typing.Any]:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#perimeter

        **[protected] QVariantList QGeoPolygon::perimeter() const**

        Returns all the elements of the polygon's perimeter.

        This function was introduced in QtPositioning 5.12.

        **See also** **setPerimeter** ().
        """
        ...

    def setPerimeter(self, path: typing.Iterable[typing.Any]) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#setPerimeter

        **[protected] void QGeoPolygon::setPerimeter(const QVariantList & path
        )**

        Sets all the elements of the polygon's perimeter based on a list of
        coordinates ( **path** ). .

        This function was introduced in QtPositioning 5.12.

        **See also** **perimeter** ().
        """
        ...

    def holesCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#holesCount

        **int QGeoPolygon::holesCount() const**

        Returns the number of holes.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.12.
        """
        ...

    def removeHole(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#removeHole

        **void QGeoPolygon::removeHole(int index )**

        Removes element at position **index** from the holes **QList** .

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.12.
        """
        ...

    def holePath(self, index: int) -> typing.List[QGeoCoordinate]:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#holePath

        **const QList<QGeoCoordinate> QGeoPolygon::holePath(int index ) const**

        Returns a **QList** <**QGeoCoordinate** > which represents the hole at
        **index**.

        This function was introduced in Qt 5.12.
        """
        ...

    def hole(self, index: int) -> typing.List[typing.Any]:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#hole

        **const QVariantList QGeoPolygon::hole(int index ) const**

        Returns a **QVariant**  containing a **QVariant**  containing a
        **QList** <**QGeoCoordinate** > which represents the hole at **index**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.12.
        """
        ...

    @typing.overload
    def addHole(self, holePath: typing.Iterable[QGeoCoordinate]) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#addHole

        **void QGeoPolygon::addHole(const QVariant & holePath )**

        Sets the **holePath** for a hole inside the polygon. The hole is a
        **QVariant**  containing a **QList** <**QGeoCoordinate** >.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.12.
        """
        ...

    @typing.overload
    def addHole(self, holePath: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#addHole-1

        **void QGeoPolygon::addHole(const QList<QGeoCoordinate> & holePath )**

        Overloaded method. Sets the **holePath** for a hole inside the polygon.
        The hole is a **QList** <**QGeoCoordinate** >.

        This function was introduced in Qt 5.12.
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#toString

        **QString QGeoPolygon::toString() const**

        Returns the geo polygon properties as a string.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @typing.overload
    def removeCoordinate(self, coordinate: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#removeCoordinate

        **void QGeoPolygon::removeCoordinate(const QGeoCoordinate & coordinate
        )**

        Removes the last occurrence of **coordinate** from the polygon.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @typing.overload
    def removeCoordinate(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#removeCoordinate-1

        **void QGeoPolygon::removeCoordinate(int index )**

        Removes element at position **index** from the polygon.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def containsCoordinate(self, coordinate: QGeoCoordinate) -> bool:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#containsCoordinate

        **bool QGeoPolygon::containsCoordinate(const QGeoCoordinate & coordinate
        ) const**

        Returns true if the polygon's perimeter contains **coordinate** as one
        of the elements.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def coordinateAt(self, index: int) -> QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#coordinateAt

        **QGeoCoordinate QGeoPolygon::coordinateAt(int index ) const**

        Returns the coordinate at **index** .

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def replaceCoordinate(self, index: int, coordinate: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#replaceCoordinate

        **void QGeoPolygon::replaceCoordinate(int index , const QGeoCoordinate &
        coordinate )**

        Replaces the path element at the specified **index** with
        **coordinate**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def insertCoordinate(self, index: int, coordinate: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#insertCoordinate

        **void QGeoPolygon::insertCoordinate(int index , const QGeoCoordinate &
        coordinate )**

        Inserts **coordinate** at the specified **index**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def addCoordinate(self, coordinate: QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#addCoordinate

        **void QGeoPolygon::addCoordinate(const QGeoCoordinate & coordinate )**

        Appends **coordinate** to the polygon.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#size

        **int QGeoPolygon::size() const**

        Returns the number of elements in the polygon.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.10.
        """
        ...

    def length(self, indexFrom: int = ..., indexTo: int = ...) -> float:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#length

        **double QGeoPolygon::length(int indexFrom = 0, int indexTo = -1)
        const**

        Returns the length of the polygon's perimeter, in meters, from the
        element **indexFrom** to the element **indexTo**. The length is intended
        to be the sum of the shortest distances for each pair of adjacent
        points.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def translated(
        self, degreesLatitude: float, degreesLongitude: float
    ) -> "QGeoPolygon":
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#translated

        **QGeoPolygon QGeoPolygon::translated(double degreesLatitude , double
        degreesLongitude ) const**

        Returns a copy of this geo polygon translated by **degreesLatitude**
        northwards and **degreesLongitude** eastwards.

        Negative values of **degreesLatitude** and **degreesLongitude**
        correspond to southward and westward translation respectively.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **translate** ().
        """
        ...

    def translate(self, degreesLatitude: float, degreesLongitude: float) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#translate

        **void QGeoPolygon::translate(double degreesLatitude , double
        degreesLongitude )**

        Translates this geo polygon by **degreesLatitude** northwards and
        **degreesLongitude** eastwards.

        Negative values of **degreesLatitude** and **degreesLongitude**
        correspond to southward and westward translation respectively.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def path(self) -> typing.List[QGeoCoordinate]:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#path

        **const QList<QGeoCoordinate> &QGeoPolygon::path() const**

        Returns all the elements of the polygon's boundary.

        **See also** **setPath** ().
        """
        ...

    def setPath(self, path: typing.Iterable[QGeoCoordinate]) -> None:
        """
        https://doc.qt.io/qt-5/qgeopolygon.html#setPath

        **void QGeoPolygon::setPath(const QList<QGeoCoordinate> & path )**

        Sets the **path** for the polygon.

        **See also** **path** ().
        """
        ...
