"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtNfc import *


class QNearFieldShareTarget(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qnearfieldsharetarget.html

    **Detailed Description**

    The QNearFieldShareTarget class can be used for sharing NDEF message or
    files to a remote NFC enabled device supporting the same protocol.

    **See also** **QNearFieldShareManager** .
    """

    def shareError(self) -> QNearFieldShareManager.ShareError:
        """
        https://doc.qt.io/qt-5/qnearfieldsharetarget.html#shareError

        **QNearFieldShareManager::ShareError QNearFieldShareTarget::shareError()
        const**

        Returns the error code of the error that occurred.
        """
        ...

    def isShareInProgress(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldsharetarget.html#isShareInProgress

        **bool QNearFieldShareTarget::isShareInProgress() const**

        Returns true if data or file sharing is in progress, otherwise returns
        false.
        """
        ...

    def cancel(self) -> None:
        """
        https://doc.qt.io/qt-5/qnearfieldsharetarget.html#cancel

        **void QNearFieldShareTarget::cancel()**

        Cancel the data or file sharing in progress.
        """
        ...

    @typing.overload
    def share(self, message: QNdefMessage) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldsharetarget.html#share

        **bool QNearFieldShareTarget::share(const QNdefMessage & message )**

        Share the NDEF **message** via the share target. This method starts
        sharing asynchronously and returns immediately. The method returns true
        if the request is accepted, otherwise returns false. Sharing is
        completed when the **shareFinished** () signal is emitted.
        """
        ...

    @typing.overload
    def share(self, files: typing.Iterable[QtCore.QFileInfo]) -> bool:
        """
        https://doc.qt.io/qt-5/qnearfieldsharetarget.html#share-1

        **bool QNearFieldShareTarget::share(const QList<QFileInfo> & files )**

        Share the **files** via the share target. This method starts sharing
        asynchronously and returns immediately. The method returns true if the
        request is accepted, otherwise returns false. Sharing is completed when
        the **shareFinished** () signal is emitted.
        """
        ...

    def shareModes(self) -> QNearFieldShareManager.ShareModes:
        """
        https://doc.qt.io/qt-5/qnearfieldsharetarget.html#shareModes

        **QNearFieldShareManager::ShareModes QNearFieldShareTarget::shareModes()
        const**

        Returns the share mode supported by the share target.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldsharetarget.html#error

        **[signal] void
        QNearFieldShareTarget::error(QNearFieldShareManager::ShareError error
        )**

        This signal is emitted whenever an **error** occurs during transfer.
        """
        ...

    @property
    def shareFinished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qnearfieldsharetarget.html#shareFinished

        **[signal] void QNearFieldShareTarget::shareFinished()**

        This signal is emitted whenever a data or file transfer has completed
        successfully.
        """
        ...
