"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import sip


class QSslEllipticCurve(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsslellipticcurve.html

    **Detailed Description**

    The class QSslEllipticCurve represents an elliptic curve for use by
    elliptic-curve cipher algorithms.

    Elliptic curves can be constructed from a "short name" (SN)
    (**fromShortName** ()), and by a call to
    **QSslConfiguration::supportedEllipticCurves** ().

    QSslEllipticCurve instances can be compared for equality and can be used as
    keys in **QHash**  and **QSet** . They cannot be used as key in a **QMap** .

    **Note:** This class is currently only supported in OpenSSL.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsslellipticcurve.html#QSslEllipticCurve

        **QSslEllipticCurve::QSslEllipticCurve()**

        Constructs an invalid elliptic curve.

        **See also** **isValid** () and
        **QSslConfiguration::supportedEllipticCurves** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QSslEllipticCurve") -> None:
        """
        https://doc.qt.io/qt-5/qsslellipticcurve.html#QSslEllipticCurve

        **QSslEllipticCurve::QSslEllipticCurve()**

        Constructs an invalid elliptic curve.

        **See also** **isValid** () and
        **QSslConfiguration::supportedEllipticCurves** ().
        """
        ...

    def __hash__(self) -> int:
        ...

    def isTlsNamedCurve(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslellipticcurve.html#isTlsNamedCurve

        **bool QSslEllipticCurve::isTlsNamedCurve() const**

        Returns true if this elliptic curve is one of the named curves that can
        be used in the key exchange when using an elliptic curve cipher with
        TLS; false otherwise.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsslellipticcurve.html#isValid

        **bool QSslEllipticCurve::isValid() const**

        Returns true if this elliptic curve is a valid curve, false otherwise.
        """
        ...

    def longName(self) -> str:
        """
        https://doc.qt.io/qt-5/qsslellipticcurve.html#longName

        **QString QSslEllipticCurve::longName() const**

        Returns the conventional long name for this curve. If this curve is
        invalid, returns an empty string.

        **See also** **shortName** ().
        """
        ...

    def shortName(self) -> str:
        """
        https://doc.qt.io/qt-5/qsslellipticcurve.html#shortName

        **QString QSslEllipticCurve::shortName() const**

        Returns the conventional short name for this curve. If this curve is
        invalid, returns an empty string.

        **See also** **longName** ().
        """
        ...

    @staticmethod
    def fromLongName(name: str) -> "QSslEllipticCurve":
        """
        https://doc.qt.io/qt-5/qsslellipticcurve.html#fromLongName

        **[static] QSslEllipticCurve QSslEllipticCurve::fromLongName(const
        QString & name )**

        Returns an **QSslEllipticCurve**  instance representing the named curve
        **name**. The **name** is a long name for the curve, whose exact
        spelling depends on the SSL implementation.

        If the given **name** is not supported, returns an invalid
        **QSslEllipticCurve**  instance.

        **Note:** The OpenSSL implementation of this function treats the name
        case-sensitively.

        **See also** **longName** ().
        """
        ...

    @staticmethod
    def fromShortName(name: str) -> "QSslEllipticCurve":
        """
        https://doc.qt.io/qt-5/qsslellipticcurve.html#fromShortName

        **[static] QSslEllipticCurve QSslEllipticCurve::fromShortName(const
        QString & name )**

        Returns an **QSslEllipticCurve**  instance representing the named curve
        **name**. The **name** is the conventional short name for the curve, as
        represented by RFC 4492 (for instance `secp521r1`), or as NIST short
        names (for instance `P-256`). The actual set of recognized names depends
        on the SSL implementation.

        If the given **name** is not supported, returns an invalid
        **QSslEllipticCurve**  instance.

        **Note:** The OpenSSL implementation of this function treats the name
        case-sensitively.

        **See also** **shortName** ().
        """
        ...
