"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QOcspResponse(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qocspresponse.html

    **Detailed Description**

    The QOcspResponse class represents the revocation status of a server's
    certficate, received by the client-side socket during the TLS handshake.
    **QSslSocket**  must be configured with OCSP stapling enabled.

    **See also** **QSslSocket** , **QSslSocket::ocspResponses** (),
    **certificateStatus** (), **revocationReason** (), **responder** (),
    **subject** (), **QOcspCertificateStatus** , **QOcspRevocationReason** ,
    **QSslConfiguration::setOcspStaplingEnabled** (),
    **QSslConfiguration::ocspStaplingEnabled** (), and
    **QSslConfiguration::peerCertificate** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qocspresponse.html#QOcspResponse

        **QOcspResponse::QOcspResponse()**

        Creates a new response with status QOcspCertificateStatus::Unknown and
        revocation reason QOcspRevocationReason::None.

        This function was introduced in Qt 5.13.

        **See also** **QOcspCertificateStatus** .
        """
        ...

    @typing.overload
    def __init__(self, other: "QOcspResponse") -> None:
        """
        https://doc.qt.io/qt-5/qocspresponse.html#QOcspResponse-1

        **QOcspResponse::QOcspResponse(const QOcspResponse & other )**

        Copy-constructs a QOcspResponse instance.

        This function was introduced in Qt 5.13.
        """
        ...

    def __hash__(self) -> int:
        ...

    def swap(self, other: "QOcspResponse") -> None:
        """
        https://doc.qt.io/qt-5/qocspresponse.html#swap

        **void QOcspResponse::swap(QOcspResponse & other )**

        Swaps this response with **other**.

        This function was introduced in Qt 5.13.
        """
        ...

    def subject(self) -> "QSslCertificate":
        """
        https://doc.qt.io/qt-5/qocspresponse.html#subject

        **QSslCertificate QOcspResponse::subject() const**

        This function returns a certificate, for which this response was issued.

        This function was introduced in Qt 5.13.
        """
        ...

    def responder(self) -> "QSslCertificate":
        """
        https://doc.qt.io/qt-5/qocspresponse.html#responder

        **class QSslCertificate QOcspResponse::responder() const**

        This function returns a certificate used to sign OCSP response.

        This function was introduced in Qt 5.13.
        """
        ...

    def revocationReason(self) -> QOcspRevocationReason:
        """
        https://doc.qt.io/qt-5/qocspresponse.html#revocationReason

        **QOcspRevocationReason QOcspResponse::revocationReason() const**

        Returns the reason for revocation.

        This function was introduced in Qt 5.13.
        """
        ...

    def certificateStatus(self) -> QOcspCertificateStatus:
        """
        https://doc.qt.io/qt-5/qocspresponse.html#certificateStatus

        **QOcspCertificateStatus QOcspResponse::certificateStatus() const**

        Returns the certificate status.

        This function was introduced in Qt 5.13.

        **See also** **QOcspCertificateStatus** .
        """
        ...
