"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QNetworkDatagram(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qnetworkdatagram.html

    **Detailed Description**

    QNetworkDatagram can be used with the **QUdpSocket**  class to represent the
    full information contained in a UDP (User Datagram Protocol) datagram.
    QNetworkDatagram encapsulates the following information of a datagram:

    * the payload data;
      * the sender address and port number;
      * the
    destination address and port number;
      * the remaining hop count limit (on
    IPv4, this field is usually called "time to live" - TTL);
      * the network
    interface index the datagram was received on or to be sent on.

    **QUdpSocket**  will try to match a common behavior as much as possible on
    all operating systems, but not all of the metadata above can be obtained in
    some operating systems. Metadata that cannot be set on the datagram when
    sending with **QUdpSocket::writeDatagram** () will be silently discarded.

    Upon reception, the **senderAddress** () and **senderPort** () properties
    contain the address and port of the peer that sent the datagram, while
    **destinationAddress** () and **destinationPort** () contain the target that
    was contained in the datagram. That is usually an address local to the
    current machine, but it can also be an IPv4 broadcast address (such as
    "255.255.255.255") or an IPv4 or IPv6 multicast address. Applications may
    find it useful to determine if the datagram was sent specifically to this
    machine via unicast addressing or whether it was sent to multiple
    destinations.

    When sending, the **senderAddress** () and **senderPort** () should contain
    the local address to be used when sending. The sender address must be an
    address that is assigned to this machine, which can be obtained using
    **QNetworkInterface** , and the port number must be the port number that the
    socket is bound to. Either field can be left unset and will be filled in by
    the operating system with default values. The **destinationAddress** () and
    **destinationPort** () fields may be set to a target address different from
    the one the UDP socket is currently associated with.

    Usually, when sending a datagram in reply to a datagram previously received,
    one will set the **destinationAddress** () to be the **senderAddress** () of
    the incoming datagram and similarly for the port numbers. To facilitate this
    common process, QNetworkDatagram provides the function **makeReply** ().

    The hopCount() function contains, for a received datagram, the remaining hop
    count limit for the packet. When sending, it contains the hop count limit to
    be set. Most protocols will leave this value set to the default and let the
    operating system decide on the best value to be used. Multicasting over IPv4
    often uses this field to indicate the scope of the multicast group (link-
    local, local to an organization or global).

    The **interfaceIndex** () function contains the index of the operating
    system's interface that received the packet. This value is the same one that
    can be set on a **QHostAddress::scopeId** () property and matches the
    **QNetworkInterface::index** () property. When sending packets to global
    addresses, it is not necessary to set the interface index as the operating
    system will choose the correct one using the system routing table. This
    property is important when sending datagrams to link-local destinations,
    whether unicast or multicast.

    **Feature support**

    Some features of QNetworkDatagram are not supported in all operating
    systems. Only the address and ports of the remote host (sender in received
    packets and destination for outgoing packets) are supported in all systems.
    On most operating systems, the other features are supported only for IPv6.
    Software should check at runtime whether the rest could be determined for
    IPv4 addresses.

    The current feature support is as follows:

    Operating systemLocal addressHop countInterface index
    **FreeBSD**
    SupportedSupportedOnly for IPv6
    LinuxSupportedSupportedSupported
    OS
    XSupportedSupportedOnly for IPv6
    Other Unix supporting RFC 3542Only for
    IPv6Only for IPv6Only for IPv6
    Windows
    (desktop)SupportedSupportedSupported
    Windows RTNot supportedNot
    supportedNot supported

    **See also** **QUdpSocket**  and **QNetworkInterface** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#QNetworkDatagram

        **QNetworkDatagram::QNetworkDatagram()**

        Creates a QNetworkDatagram object with no payload data and undefined
        destination address.

        The payload can be modified by using **setData** () and the destination
        address can be set with **setDestination** ().

        If the destination address is left undefined,
        **QUdpSocket::writeDatagram** () will attempt to send the datagram to
        the address last associated with, by using **QUdpSocket::connectToHost**
        ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
        destinationAddress: typing.Union[
            QHostAddress, QHostAddress.SpecialAddress
        ] = ...,
        port: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#QNetworkDatagram-1

        **QNetworkDatagram::QNetworkDatagram(const QByteArray & data , const
        QHostAddress & destinationAddress = QHostAddress(), quint16 port = 0)**

        Creates a QNetworkDatagram object and sets **data** as the payload data,
        along with **destinationAddress** and **port** as the destination
        address of the datagram.
        """
        ...

    @typing.overload
    def __init__(self, other: "QNetworkDatagram") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#QNetworkDatagram-2

        **QNetworkDatagram::QNetworkDatagram(const QNetworkDatagram & other )**

        Creates a copy of the **other** datagram, including the payload and
        metadata.

        To create a datagram suitable for sending in a reply, use
        **QNetworkDatagram::makeReply** ();
        """
        ...

    def makeReply(
        self, payload: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> "QNetworkDatagram":
        ...

    def setData(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#setData

        **void QNetworkDatagram::setData(const QByteArray & data )**

        Sets the data payload of this datagram to **data**. It is usually not
        necessary to call this function on received datagrams. For outgoing
        datagrams, this function sets the data to be sent on the network.

        Since datagrams can empty, an empty **QByteArray**  is a valid value for
        **data**.

        **See also** **data** ().
        """
        ...

    def data(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#data

        **QByteArray QNetworkDatagram::data() const**

        Returns the data payload of this datagram. For a datagram received from
        the network, it contains the payload of the datagram. For an outgoing
        datagram, it is the datagram to be sent.

        Note that datagrams can be transmitted with no data, so the returned
        **QByteArray**  may be empty.

        **See also** **setData** ().
        """
        ...

    def setHopLimit(self, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#setHopLimit

        **void QNetworkDatagram::setHopLimit(int count )**

        Sets the hop count limit associated with this datagram to **count**. The
        hop count limit is the number of nodes that are allowed to forward the
        IP packet before it expires and an error is sent back to the sender of
        the datagram. In IPv4, this value is usually known as "time to live"
        (TTL).

        It is usually not necessary to call this function on datagrams received
        from the network.

        If this is an outgoing packet, this is the value to be set in the IP
        header upon sending. The valid range for the value is 1 to 255. This
        function also accepts a value of -1 to indicate that the operating
        system should choose the value.

        **See also** **hopLimit** ().
        """
        ...

    def hopLimit(self) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#hopLimit

        **int QNetworkDatagram::hopLimit() const**

        Returns the hop count limit associated with this datagram. The hop count
        limit is the number of nodes that are allowed to forward the IP packet
        before it expires and an error is sent back to the sender of the
        datagram. In IPv4, this value is usually known as "time to live" (TTL).

        If this datagram was received from the network, this is the remaining
        hop count of the datagram after reception and was decremented by 1 by
        each node that forwarded the packet. A value of -1 indicates that the
        hop limit count not be obtained.

        If this is an outgoing datagram, this is the value to be set in the IP
        header upon sending. A value of -1 indicates the operating system should
        choose the value.

        **See also** **setHopLimit** ().
        """
        ...

    def setDestination(
        self,
        address: typing.Union[QHostAddress, QHostAddress.SpecialAddress],
        port: int,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#setDestination

        **void QNetworkDatagram::setDestination(const QHostAddress & address ,
        quint16 port )**

        Sets the destination address associated with this datagram to be the
        address **address** and port number **port**. The destination address
        and port numbers are usually set by **QUdpSocket**  upon reception, so
        there's no need to call this function on a received datagram.

        For outgoing datagrams, this function can be used to set the address the
        datagram should be sent to. It can be the unicast address used to
        communicate with the peer or a broadcast or multicast address to send to
        a group of devices.

        **See also** **QUdpSocket::writeDatagram** (), **destinationAddress**
        (), **destinationPort** (), and **setSender** ().
        """
        ...

    def setSender(
        self,
        address: typing.Union[QHostAddress, QHostAddress.SpecialAddress],
        port: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#setSender

        **void QNetworkDatagram::setSender(const QHostAddress & address ,
        quint16 port = 0)**

        Sets the sender address associated with this datagram to be the address
        **address** and port number **port**. The sender address and port
        numbers are usually set by **QUdpSocket**  upon reception, so there's no
        need to call this function on a received datagram.

        For outgoing datagrams, this function can be used to set the address the
        datagram should carry. The address **address** must usually be one of
        the local addresses assigned to this machine, which can be obtained
        using **QNetworkInterface** . If left unset, the operating system will
        choose the most appropriate address to use given the destination in
        question.

        The port number **port** must be the port number associated with the
        socket, if there is one. The value of 0 can be used to indicate that the
        operating system should choose the port number.

        **See also** **QUdpSocket::writeDatagram** (), **senderAddress** (),
        **senderPort** (), and **setDestination** ().
        """
        ...

    def destinationPort(self) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#destinationPort

        **int QNetworkDatagram::destinationPort() const**

        Returns the port number of the destination associated with this
        datagram. For a datagram received from the network, it is the local port
        number that the peer node sent the datagram to. For an outgoing
        datagram, it is the peer port the datagram should be sent to.

        If no destination address was associated with this datagram, this
        function returns -1.

        **See also** **destinationAddress** (), **senderPort** (), and
        **setDestination** ().
        """
        ...

    def senderPort(self) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#senderPort

        **int QNetworkDatagram::senderPort() const**

        Returns the port number of the sender associated with this datagram. For
        a datagram received from the network, it is the port number that the
        peer node sent the datagram from. For an outgoing datagram, it is the
        local port the datagram should be sent from.

        If no sender address was associated with this datagram, this function
        returns -1.

        **See also** **senderAddress** (), **destinationPort** (), and
        **setSender** ().
        """
        ...

    def destinationAddress(self) -> QHostAddress:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#destinationAddress

        **QHostAddress QNetworkDatagram::destinationAddress() const**

        Returns the destination address associated with this datagram. For a
        datagram received from the network, it is the address the peer node sent
        the datagram to, which can either be a local address of this machine or
        a multicast or broadcast address. For an outgoing datagrams, it is the
        address the datagram should be sent to.

        If no destination address was set on this datagram, the returned object
        will report true to **QHostAddress::isNull** ().

        **See also** **senderAddress** (), **destinationPort** (), and
        **setDestination** ().
        """
        ...

    def senderAddress(self) -> QHostAddress:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#senderAddress

        **QHostAddress QNetworkDatagram::senderAddress() const**

        Returns the sender address associated with this datagram. For a datagram
        received from the network, it is the address of the peer node that sent
        the datagram. For an outgoing datagrams, it is the local address to be
        used when sending.

        If no sender address was set on this datagram, the returned object will
        report true to **QHostAddress::isNull** ().

        **See also** **destinationAddress** (), **senderPort** (), and
        **setSender** ().
        """
        ...

    def setInterfaceIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#setInterfaceIndex

        **void QNetworkDatagram::setInterfaceIndex(uint index )**

        Sets the interface index this datagram is associated with to **index**.
        The interface index is a positive number that uniquely identifies the
        network interface in the operating system. This number matches the value
        returned by **QNetworkInterface::index** () for the interface.

        It is usually not necessary to call this function on datagrams received
        from the network.

        If this is an outgoing packet, this is the index of the interface the
        datagram should be sent on. A value of 0 indicates that the operating
        system should choose the interface based on other factors.

        Note that the interface index can also be set with
        **QHostAddress::setScopeId** () for IPv6 destination addresses and then
        with **setDestination** (). If the scope ID set in the destination
        address and **index** are different and neither is zero, it is undefined
        which interface the operating system will send the datagram on.

        **See also** **interfaceIndex** () and setInterfaceIndex().
        """
        ...

    def interfaceIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#interfaceIndex

        **uint QNetworkDatagram::interfaceIndex() const**

        Returns the interface index this datagram is associated with. The
        interface index is a positive number that uniquely identifies the
        network interface in the operating system. This number matches the value
        returned by **QNetworkInterface::index** () for the interface.

        If this datagram was received from the network, this is the index of the
        interface that the packet was received from. If this is an outgoing
        datagram, this is the index of the interface that the datagram should be
        sent on.

        A value of 0 indicates that the interface index is unknown.

        **See also** **setInterfaceIndex** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#isNull

        **bool QNetworkDatagram::isNull() const**

        Returns true if this **QNetworkDatagram**  object is null. This function
        is the opposite of **isValid** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#isValid

        **bool QNetworkDatagram::isValid() const**

        Returns true if this **QNetworkDatagram**  object is valid. A valid
        **QNetworkDatagram**  object contains at least one sender or receiver
        address. Valid datagrams can contain empty payloads.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#clear

        **void QNetworkDatagram::clear()**

        Clears the payload data and metadata in this **QNetworkDatagram**
        object, resetting them to their default values.
        """
        ...

    def swap(self, other: "QNetworkDatagram") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkdatagram.html#swap

        **void QNetworkDatagram::swap(QNetworkDatagram & other )**

        Swaps this instance with **other**.
        """
        ...
