"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import sip


class QDnsServiceRecord(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdnsservicerecord.html

    **Detailed Description**

    When performing a lookup on a service, zero or more records will be
    returned. Each record is represented by a QDnsServiceRecord instance.

    The meaning of the fields is defined in **RFC 2782** .

    **See also** **QDnsLookup** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#QDnsServiceRecord

        **QDnsServiceRecord::QDnsServiceRecord()**

        Constructs an empty service record object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QDnsServiceRecord") -> None:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#QDnsServiceRecord-1

        **QDnsServiceRecord::QDnsServiceRecord(const QDnsServiceRecord & other
        )**

        Constructs a copy of **other**.
        """
        ...

    def weight(self) -> int:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#weight

        **quint16 QDnsServiceRecord::weight() const**

        Returns the weight for this service record.

        The weight field specifies a relative weight for entries with the same
        priority. Entries with higher weights should be selected with a higher
        probability.
        """
        ...

    def timeToLive(self) -> int:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#timeToLive

        **quint32 QDnsServiceRecord::timeToLive() const**

        Returns the duration in seconds for which this record is valid.
        """
        ...

    def target(self) -> str:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#target

        **QString QDnsServiceRecord::target() const**

        Returns the domain name of the target host for this service record.
        """
        ...

    def priority(self) -> int:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#priority

        **quint16 QDnsServiceRecord::priority() const**

        Returns the priority for this service record.

        A client must attempt to contact the target host with the lowest-
        numbered priority.
        """
        ...

    def port(self) -> int:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#port

        **quint16 QDnsServiceRecord::port() const**

        Returns the port on the target host for this service record.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#name

        **QString QDnsServiceRecord::name() const**

        Returns the name for this record.
        """
        ...

    def swap(self, other: "QDnsServiceRecord") -> None:
        """
        https://doc.qt.io/qt-5/qdnsservicerecord.html#swap

        **void QDnsServiceRecord::swap(QDnsServiceRecord & other )**

        Swaps this service record instance with **other**. This function is very
        fast and never fails.
        """
        ...
