"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QVideoEncoderSettingsControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qvideoencodersettingscontrol.html

    **Detailed Description**

    If a **QMediaService**  supports encoding video data it will implement
    QVideoEncoderSettingsControl. This control provides information about the
    limits of restricted video encoder options and allows the selection of a set
    of video encoder settings as specified in a **QVideoEncoderSettings**
    object.

    The functionality provided by this control is exposed to application code
    through the **QMediaRecorder**  class.

    The interface name of QVideoEncoderSettingsControl is `org.qt-
    project.qt.videoencodersettingscontrol/5.0` as defined in
    **QVideoEncoderSettingsControl_iid** .

    **See also** **QMediaRecorder** , **QVideoEncoderSettings** , and
    **QMediaService::requestControl** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettingscontrol.html#QVideoEncoderSe
        ttingsControl

        **[protected]
        QVideoEncoderSettingsControl::QVideoEncoderSettingsControl(QObject *
        parent = nullptr)**

        Create a new video encoder settings control object with the given
        **parent**.
        """
        ...

    def setVideoSettings(self, settings: QVideoEncoderSettings) -> None:
        """
        https://doc.qt.io/qt-5/qvideoencodersettingscontrol.html#setVideoSetting
        s

        **[pure virtual] void
        QVideoEncoderSettingsControl::setVideoSettings(const
        QVideoEncoderSettings & settings )**

        Sets the selected video encoder **settings**.

        **See also** **videoSettings** ().
        """
        ...

    def videoSettings(self) -> QVideoEncoderSettings:
        """
        https://doc.qt.io/qt-5/qvideoencodersettingscontrol.html#videoSettings

        **[pure virtual] QVideoEncoderSettings
        QVideoEncoderSettingsControl::videoSettings() const**

        Returns the video encoder settings.

        The returned value may be different tha passed to
        **QVideoEncoderSettingsControl::setVideoSettings** () if the settings
        contains the default or undefined parameters. In this case if the
        undefined parameters are already resolved, they should be returned.

        **See also** **setVideoSettings** ().
        """
        ...

    def videoCodecDescription(self, codec: str) -> str:
        """
        https://doc.qt.io/qt-5/qvideoencodersettingscontrol.html#videoCodecDescr
        iption

        **[pure virtual] QString
        QVideoEncoderSettingsControl::videoCodecDescription(const QString &
        codec ) const**

        Returns a description of a video **codec**.
        """
        ...

    def supportedVideoCodecs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qvideoencodersettingscontrol.html#supportedVideoC
        odecs

        **[pure virtual] QStringList
        QVideoEncoderSettingsControl::supportedVideoCodecs() const**

        Returns the list of supported video codecs.
        """
        ...

    def supportedFrameRates(
        self, settings: QVideoEncoderSettings
    ) -> typing.Tuple[typing.List[float], bool]:
        """
        https://doc.qt.io/qt-5/qvideoencodersettingscontrol.html#supportedFrameR
        ates

        **[pure virtual] QList<qreal>
        QVideoEncoderSettingsControl::supportedFrameRates(const
        QVideoEncoderSettings & settings , bool * continuous = nullptr) const**

        Returns a list of supported frame rates.

        If non null video **settings** parameter is passed, the returned list is
        reduced to frame rates supported with partial settings like **video
        codec**  or **video resolution**  applied.

        If the encoder supports arbitrary frame rates within the supported
        range, * **continuous** is set to true, otherwise * **continuous** is
        set to false.

        **See also** **QVideoEncoderSettings::frameRate** ().
        """
        ...

    def supportedResolutions(
        self, settings: QVideoEncoderSettings
    ) -> typing.Tuple[typing.List[QtCore.QSize], bool]:
        """
        https://doc.qt.io/qt-5/qvideoencodersettingscontrol.html#supportedResolu
        tions

        **[pure virtual] QList<QSize>
        QVideoEncoderSettingsControl::supportedResolutions(const
        QVideoEncoderSettings & settings , bool * continuous = nullptr) const**

        Returns a list of supported resolutions.

        If non null video **settings** parameter is passed, the returned list is
        reduced to resolution supported with partial settings like **video
        codec**  or **frame rate**  applied.

        If the encoder supports arbitrary resolutions within the supported
        resolutions range, * **continuous** is set to true, otherwise *
        **continuous** is set to false.

        **See also** **QVideoEncoderSettings::resolution** ().
        """
        ...
