"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMetaDataWriterControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmetadatawritercontrol.html

    **Detailed Description**

    If a **QMediaService**  can provide write access to the meta-data of its
    current media it will implement QMetaDataWriterControl. This control
    provides functions for both retrieving and setting meta-data values. Meta-
    data may be addressed by the keys defined in the **QMediaMetaData**
    namespace.

    The functionality provided by this control is exposed to application code by
    the meta-data members of **QMediaObject** , and so meta-data access is
    potentially available in any of the media object classes. Any media service
    may implement QMetaDataControl.

    The interface name of QMetaDataWriterControl is `org.qt-
    project.qt.metadatawritercontrol/5.0` as defined in
    **QMetaDataWriterControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaObject** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#QMetaDataWriterContro
        l

        **[protected] QMetaDataWriterControl::QMetaDataWriterControl(QObject *
        parent = nullptr)**

        Construct a QMetaDataWriterControl with **parent**. This class is meant
        as a base class for service specific meta data providers so this
        constructor is protected.
        """
        ...

    def availableMetaData(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#availableMetaData

        **[pure virtual] QStringList QMetaDataWriterControl::availableMetaData()
        const**

        Returns a list of keys there is meta-data available for.
        """
        ...

    def setMetaData(self, key: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#setMetaData

        **[pure virtual] void QMetaDataWriterControl::setMetaData(const QString
        & key , const QVariant & value )**

        Sets the **value** of the meta-data element with the given **key**.

        **See also** **metaData** ().
        """
        ...

    def metaData(self, key: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#metaData

        **[pure virtual] QVariant QMetaDataWriterControl::metaData(const QString
        & key ) const**

        Returns the meta-data for the given **key**.

        **See also** **setMetaData** ().
        """
        ...

    def isMetaDataAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#isMetaDataAvailable

        **[pure virtual] bool QMetaDataWriterControl::isMetaDataAvailable()
        const**

        Identifies if meta-data is available from a media service.

        Returns true if the meta-data is available and false otherwise.
        """
        ...

    def isWritable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#isWritable

        **[pure virtual] bool QMetaDataWriterControl::isWritable() const**

        Identifies if a media service's meta-data can be edited.

        Returns true if the meta-data is writable and false otherwise.
        """
        ...

    @property
    def metaDataAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#metaDataAvailableChan
        ged

        **[signal] void QMetaDataWriterControl::metaDataAvailableChanged(bool
        available )**

        Signal the availability of meta-data has changed, **available** will be
        true if the multimedia object has meta-data.
        """
        ...

    @property
    def metaDataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#metaDataChanged

        **[signal] void QMetaDataWriterControl::metaDataChanged()**

        Signal the changes of meta-data.

        If multiple meta-data elements are changed, metaDataChanged(const
        **QString**  &key, const **QVariant**  &value) signal is emitted for
        each of them with metaDataChanged() changed emitted once.

        **Note:** Signal **metaDataChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(metaDataWriterControl,
        QOverload<>::of(&**QMetaDataWriterControl** ::metaDataChanged),
        [=](){ /* ... */ });
        """
        ...

    @property
    def metaDataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#metaDataChanged-1

        **[signal] void QMetaDataWriterControl::metaDataChanged(const QString &
        key , const QVariant & value )**

        Signal the changes of one meta-data element **value** with the given
        **key**.

        **Note:** Signal **metaDataChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(metaDataWriterControl, QOverload<const **QString**  &, const
        **QVariant**  &>::of(&**QMetaDataWriterControl** ::metaDataChanged),
        [=](const **QString**  &key, const **QVariant**  &value){ /* ... */ });
        """
        ...

    @property
    def writableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmetadatawritercontrol.html#writableChanged

        **[signal] void QMetaDataWriterControl::writableChanged(bool writable
        )**

        Signal a change in the writable status of meta-data, **writable** will
        be true if meta-data elements can be added or adjusted.
        """
        ...
