"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaStreamsControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmediastreamscontrol.html

    **Detailed Description**

    The QMediaStreamsControl class provides descriptions of the available media
    streams and allows individual streams to be activated and deactivated.

    The interface name of QMediaStreamsControl is `org.qt-
    project.qt.mediastreamscontrol/5.0` as defined in
    **QMediaStreamsControl_iid** .

    **See also** **QMediaService::requestControl** ().
    """

    class StreamType(int):
        UnknownStream: QMediaStreamsControl = ...
        VideoStream: QMediaStreamsControl = ...
        AudioStream: QMediaStreamsControl = ...
        SubPictureStream: QMediaStreamsControl = ...
        DataStream: QMediaStreamsControl = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediastreamscontrol.html#QMediaStreamsControl

        **[protected] QMediaStreamsControl::QMediaStreamsControl(QObject *
        parent = nullptr)**

        Constructs a new media streams control with the given **parent**.
        """
        ...

    def setActive(self, streamNumber: int, state: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmediastreamscontrol.html#setActive

        **[pure virtual] void QMediaStreamsControl::setActive(int streamNumber ,
        bool state )**

        Sets the active **state** of media stream **streamNumber**.

        Setting the active state of a media stream to true will activate it. If
        any other stream of the same type was previously active it will be
        deactivated. Setting the active state fo a media stream to false will
        deactivate it.

        **See also** **isActive** ().
        """
        ...

    def isActive(self, streamNumber: int) -> bool:
        """
        https://doc.qt.io/qt-5/qmediastreamscontrol.html#isActive

        **[pure virtual] bool QMediaStreamsControl::isActive(int streamNumber
        )**

        Returns true if the media stream **streamNumber** is active.
        """
        ...

    def metaData(self, streamNumber: int, key: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmediastreamscontrol.html#metaData

        **[pure virtual] QVariant QMediaStreamsControl::metaData(int
        streamNumber , const QString & key )**

        Returns the meta-data value of **key** for the given **streamNumber**.

        Useful metadata keys are QMediaMetaData::Title,
        QMediaMetaData::Description and QMediaMetaData::Language.
        """
        ...

    def streamType(self, streamNumber: int) -> "QMediaStreamsControl.StreamType":
        """
        https://doc.qt.io/qt-5/qmediastreamscontrol.html#streamType

        **[pure virtual] QMediaStreamsControl::StreamType
        QMediaStreamsControl::streamType(int streamNumber )**

        Return the type of media stream **streamNumber**.
        """
        ...

    def streamCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediastreamscontrol.html#streamCount

        **[pure virtual] int QMediaStreamsControl::streamCount()**

        Returns the number of media streams.
        """
        ...

    @property
    def activeStreamsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediastreamscontrol.html#activeStreamsChanged

        **[signal] void QMediaStreamsControl::activeStreamsChanged()**

        The signal is emitted when the active streams list is changed.
        """
        ...

    @property
    def streamsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediastreamscontrol.html#streamsChanged

        **[signal] void QMediaStreamsControl::streamsChanged()**

        The signal is emitted when the available streams list is changed.
        """
        ...
