"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5 import sip


class QMediaResource(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmediaresource.html

    **Detailed Description**

    A media resource is composed of a **URL**  containing the location of the
    resource and a set of properties that describe the format of the resource.
    The properties provide a means to assess a resource without first attempting
    to load it, and in situations where media be represented by multiple
    alternative representations provide a means to select the appropriate
    resource.

    Media made available by a remote services can often be available in multiple
    encodings or quality levels, this allows a client to select an appropriate
    resource based on considerations such as codecs supported, network
    bandwidth, and display constraints. QMediaResource includes information such
    as the **MIME type** , **audio**  and **video**  codecs, **audio**  and
    **video**  bit rates, and **resolution**  so these constraints and others
    can be evaluated.

    The only mandatory property of a QMediaResource is the **url** ().

    **See also** **QMediaContent** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#QMediaResource

        **QMediaResource::QMediaResource()**

        Constructs a null media resource.
        """
        ...

    @typing.overload
    def __init__(self, url: QtCore.QUrl, mimeType: str = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#QMediaResource-1

        **QMediaResource::QMediaResource(const QUrl & url , const QString &
        mimeType = QString())**

        Constructs a media resource with the given **mimeType** from a **url**.
        """
        ...

    @typing.overload
    def __init__(self, request: QtNetwork.QNetworkRequest, mimeType: str = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#QMediaResource-2

        **QMediaResource::QMediaResource(const QNetworkRequest & request , const
        QString & mimeType = QString())**

        Constructs a media resource with the given **mimeType** from a network
        **request**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QMediaResource") -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#QMediaResource-3

        **QMediaResource::QMediaResource(const QMediaResource & other )**

        Constructs a copy of a media resource **other**.
        """
        ...

    @typing.overload
    def setResolution(self, resolution: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setResolution

        **void QMediaResource::setResolution(const QSize & resolution )**

        Sets the **resolution** in pixels of a media resource.

        **See also** **resolution** ().
        """
        ...

    @typing.overload
    def setResolution(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setResolution-1

        **void QMediaResource::setResolution(int width , int height )**

        Sets the **width** and **height** in pixels of a media resource.
        """
        ...

    def resolution(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#resolution

        **QSize QMediaResource::resolution() const**

        Returns the resolution in pixels of a media resource.

        This may be null is the resolution is unknown, or the resource contains
        no pixel data (i.e. the resource is an audio stream.

        **See also** **setResolution** ().
        """
        ...

    def setVideoBitRate(self, rate: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setVideoBitRate

        **void QMediaResource::setVideoBitRate(int rate )**

        Sets the bit **rate** in bits per second of a media resource's video
        stream.

        **See also** **videoBitRate** ().
        """
        ...

    def videoBitRate(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#videoBitRate

        **int QMediaResource::videoBitRate() const**

        Returns the bit rate in bits per second of a media resource's video
        stream.

        This may be zero if the bit rate is unknown, or the resource contains no
        video stream.

        **See also** **setVideoBitRate** ().
        """
        ...

    def setChannelCount(self, channels: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setChannelCount

        **void QMediaResource::setChannelCount(int channels )**

        Sets the number of audio **channels** in a media resource.

        **See also** **channelCount** ().
        """
        ...

    def channelCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#channelCount

        **int QMediaResource::channelCount() const**

        Returns the number of audio channels in a media resource.

        This may be zero if the sample size is unknown, or the resource contains
        no audio stream.

        **See also** **setChannelCount** ().
        """
        ...

    def setSampleRate(self, frequency: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setSampleRate

        **void QMediaResource::setSampleRate(int sampleRate )**

        Sets the audio **sampleRate** of a media resource.

        **See also** **sampleRate** ().
        """
        ...

    def sampleRate(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#sampleRate

        **int QMediaResource::sampleRate() const**

        Returns the audio sample rate of a media resource.

        This may be zero if the sample size is unknown, or the resource contains
        no audio stream.

        **See also** **setSampleRate** ().
        """
        ...

    def setAudioBitRate(self, rate: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setAudioBitRate

        **void QMediaResource::setAudioBitRate(int rate )**

        Sets the bit **rate** in bits per second of a media resource's video
        stream.

        **See also** **audioBitRate** ().
        """
        ...

    def audioBitRate(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#audioBitRate

        **int QMediaResource::audioBitRate() const**

        Returns the bit rate in bits per second of a media resource's audio
        stream.

        This may be zero if the bit rate is unknown, or the resource contains no
        audio stream.

        **See also** **setAudioBitRate** ().
        """
        ...

    def setDataSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setDataSize

        **void QMediaResource::setDataSize(const qint64 size )**

        Sets the **size** in bytes of a media resource.

        **See also** **dataSize** ().
        """
        ...

    def dataSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#dataSize

        **qint64 QMediaResource::dataSize() const**

        Returns the size in bytes of a media resource.

        This may be zero if the size is unknown.

        **See also** **setDataSize** ().
        """
        ...

    def setVideoCodec(self, codec: str) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setVideoCodec

        **void QMediaResource::setVideoCodec(const QString & codec )**

        Sets the video **codec** of media resource.

        **See also** **videoCodec** ().
        """
        ...

    def videoCodec(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#videoCodec

        **QString QMediaResource::videoCodec() const**

        Returns the video codec of a media resource.

        This may be null if the media resource does not contain a video stream,
        or the codec is unknonwn.

        **See also** **setVideoCodec** ().
        """
        ...

    def setAudioCodec(self, codec: str) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setAudioCodec

        **void QMediaResource::setAudioCodec(const QString & codec )**

        Sets the audio **codec** of a media resource.

        **See also** **audioCodec** ().
        """
        ...

    def audioCodec(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#audioCodec

        **QString QMediaResource::audioCodec() const**

        Returns the audio codec of a media resource.

        This may be null if the media resource does not contain an audio stream,
        or the codec is unknown.

        **See also** **setAudioCodec** ().
        """
        ...

    def setLanguage(self, language: str) -> None:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#setLanguage

        **void QMediaResource::setLanguage(const QString & language )**

        Sets the **language** of a media resource.

        **See also** **language** ().
        """
        ...

    def language(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#language

        **QString QMediaResource::language() const**

        Returns the language of a media resource as an ISO 639-2 code.

        This may be null if the language is unknown.

        **See also** **setLanguage** ().
        """
        ...

    def mimeType(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#mimeType

        **QString QMediaResource::mimeType() const**

        Returns the MIME type of a media resource.

        This may be null if the MIME type is unknown.
        """
        ...

    def request(self) -> QtNetwork.QNetworkRequest:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#request

        **QNetworkRequest QMediaResource::request() const**

        Returns the network request associated with this media resource.
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#url

        **QUrl QMediaResource::url() const**

        Returns the URL of a media resource.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediaresource.html#isNull

        **bool QMediaResource::isNull() const**

        Identifies if a media resource is null.

        Returns true if the resource is null, and false otherwise.
        """
        ...
