"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QMediaPlayer(QMediaObject):
    """
    https://doc.qt.io/qt-5/qmediaplayer.html

    **Detailed Description**

    The QMediaPlayer class is a high level media playback class. It can be used
    to playback such content as songs, movies and internet radio. The content to
    playback is specified as a **QMediaContent**  object, which can be thought
    of as a main or canonical URL with additional information attached. When
    provided with a **QMediaContent**  playback may be able to commence.

    player = new **QMediaPlayer** ;
        connect(player,
    SIGNAL(positionChanged(**qint64** )), this, SLOT(positionChanged(**qint64**
    )));
        player->setMedia(**QUrl**
    ::fromLocalFile("/Users/me/Music/coolsong.mp3"));
        player->setVolume(50);
    player->play();

    **QVideoWidget**  can be used with QMediaPlayer for video rendering and
    **QMediaPlaylist**  for accessing playlist functionality.

    playlist = new **QMediaPlaylist** ;
        playlist->addMedia(**QUrl**
    ("http://example.com/movie1.mp4"));
        playlist->addMedia(**QUrl**
    ("http://example.com/movie2.mp4"));
        playlist->addMedia(**QUrl**
    ("http://example.com/movie3.mp4"));
        playlist->setCurrentIndex(1);
    player = new **QMediaPlayer** ;
        player->setPlaylist(playlist);
    videoWidget = new **QVideoWidget** ;
    player->setVideoOutput(videoWidget);
        videoWidget->show();
    player->play();

    Since QMediaPlayer is a **QMediaObject** , you can use several of the
    **QMediaObject**  functions for things like:

    * Accessing the currently playing media's metadata
    (**QMediaObject::metaData** () and **predefined meta-data keys** )
      *
    Checking to see if the media playback service is currently available
    (**QMediaObject::availability** ())

    **See also** **QMediaObject** , **QMediaService** , **QVideoWidget** , and
    **QMediaPlaylist** .
    """

    class Error(int):
        NoError: QMediaPlayer = ...
        ResourceError: QMediaPlayer = ...
        FormatError: QMediaPlayer = ...
        NetworkError: QMediaPlayer = ...
        AccessDeniedError: QMediaPlayer = ...
        ServiceMissingError: QMediaPlayer = ...

    class Flag(int):
        LowLatency: QMediaPlayer = ...
        StreamPlayback: QMediaPlayer = ...
        VideoSurface: QMediaPlayer = ...

    class MediaStatus(int):
        UnknownMediaStatus: QMediaPlayer = ...
        NoMedia: QMediaPlayer = ...
        LoadingMedia: QMediaPlayer = ...
        LoadedMedia: QMediaPlayer = ...
        StalledMedia: QMediaPlayer = ...
        BufferingMedia: QMediaPlayer = ...
        BufferedMedia: QMediaPlayer = ...
        EndOfMedia: QMediaPlayer = ...
        InvalidMedia: QMediaPlayer = ...

    class State(int):
        StoppedState: QMediaPlayer = ...
        PlayingState: QMediaPlayer = ...
        PausedState: QMediaPlayer = ...

    class Flags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QMediaPlayer.Flags", "QMediaPlayer.Flag"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QMediaPlayer.Flags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QMediaPlayer.Flags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self,
        parent: typing.Optional[QtCore.QObject] = ...,
        flags: typing.Union["QMediaPlayer.Flags", "QMediaPlayer.Flag"] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#QMediaPlayer

        **QMediaPlayer::QMediaPlayer(QObject * parent = nullptr,
        QMediaPlayer::Flags flags = Flags())**

        Construct a QMediaPlayer instance parented to **parent** and with
        **flags**.
        """
        ...

    def supportedCustomAudioRoles(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#supportedCustomAudioRoles

        **QStringList QMediaPlayer::supportedCustomAudioRoles() const**

        Returns a list of supported custom audio roles. An empty list may
        indicate that the supported custom audio roles aren't known. The list
        may not be complete.

        This function was introduced in Qt 5.11.

        **See also** **customAudioRole** .
        """
        ...

    def setCustomAudioRole(self, audioRole: str) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#customAudioRole-prop

        **customAudioRole : QString**

        This property holds the role of the audio stream played by the media
        player.

        It can be set to specify the type of audio being played when the backend
        supports audio roles unknown to Qt. Specifying a role allows the system
        to make appropriate decisions when it comes to volume, routing or post-
        processing.

        The audio role must be set before calling **setMedia** ().

        **audioRole**  is set to **QAudio::CustomRole**  when this property is
        set.

        This property was introduced in Qt 5.11.

        **Access functions:**

        QString **customAudioRole** () const
        void **setCustomAudioRole**
        (const QString & **audioRole** )

        **Notifier signal:**

        void ****customAudioRoleChanged** ** (const QString & **role** )

        **See also** **supportedCustomAudioRoles** ().
        """
        ...

    def customAudioRole(self) -> str:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#customAudioRole-prop

        **customAudioRole : QString**

        This property holds the role of the audio stream played by the media
        player.

        It can be set to specify the type of audio being played when the backend
        supports audio roles unknown to Qt. Specifying a role allows the system
        to make appropriate decisions when it comes to volume, routing or post-
        processing.

        The audio role must be set before calling **setMedia** ().

        **audioRole**  is set to **QAudio::CustomRole**  when this property is
        set.

        This property was introduced in Qt 5.11.

        **Access functions:**

        QString **customAudioRole** () const
        void **setCustomAudioRole**
        (const QString & **audioRole** )

        **Notifier signal:**

        void ****customAudioRoleChanged** ** (const QString & **role** )

        **See also** **supportedCustomAudioRoles** ().
        """
        ...

    def supportedAudioRoles(self) -> typing.List[QAudio.Role]:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#supportedAudioRoles

        **QList<QAudio::Role> QMediaPlayer::supportedAudioRoles() const**

        Returns a list of supported audio roles.

        If setting the audio role is not supported, an empty list is returned.

        This function was introduced in Qt 5.6.

        **See also** **audioRole** .
        """
        ...

    def setAudioRole(self, audioRole: QAudio.Role) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#audioRole-prop

        **audioRole : QAudio::Role**

        This property holds the role of the audio stream played by the media
        player.

        It can be set to specify the type of audio being played, allowing the
        system to make appropriate decisions when it comes to volume, routing or
        post-processing.

        The audio role must be set before calling **setMedia** ().

        **customAudioRole**  is cleared when this property is set to anything
        other than **QAudio::CustomRole** .

        This property was introduced in Qt 5.6.

        **Access functions:**

        QAudio::Role **audioRole** () const
        void **setAudioRole**
        (QAudio::Role **audioRole** )

        **Notifier signal:**

        void ****audioRoleChanged** ** (QAudio::Role **role** )

        **See also** **supportedAudioRoles** ().
        """
        ...

    def audioRole(self) -> QAudio.Role:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#audioRole-prop

        **audioRole : QAudio::Role**

        This property holds the role of the audio stream played by the media
        player.

        It can be set to specify the type of audio being played, allowing the
        system to make appropriate decisions when it comes to volume, routing or
        post-processing.

        The audio role must be set before calling **setMedia** ().

        **customAudioRole**  is cleared when this property is set to anything
        other than **QAudio::CustomRole** .

        This property was introduced in Qt 5.6.

        **Access functions:**

        QAudio::Role **audioRole** () const
        void **setAudioRole**
        (QAudio::Role **audioRole** )

        **Notifier signal:**

        void ****audioRoleChanged** ** (QAudio::Role **role** )

        **See also** **supportedAudioRoles** ().
        """
        ...

    def unbind(self, a0: QtCore.QObject) -> None:
        ...

    def bind(self, a0: QtCore.QObject) -> bool:
        ...

    def networkConfigurationChanged(
        self, configuration: QtNetwork.QNetworkConfiguration
    ) -> None:
        ...

    def setNetworkConfigurations(
        self, configurations: typing.Iterable[QtNetwork.QNetworkConfiguration]
    ) -> None:
        ...

    def setPlaylist(self, playlist: "QMediaPlaylist") -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#playlist-prop

        **playlist : QMediaPlaylist***

        This property holds the media playlist being used by the player object.

        The player object will use the current playlist item for selection of
        the content to be played.

        By default this property is set to null.

        If the media playlist is used as a source,
        **QMediaPlayer::currentMedia**  is updated with a current playlist item.
        The current source should be selected with
        **QMediaPlaylist::setCurrentIndex** (int) instead of
        **QMediaPlayer::setMedia** (), otherwise the current playlist will be
        discarded.

        **Access functions:**

        QMediaPlaylist * **playlist** () const
        void **setPlaylist**
        (QMediaPlaylist * **playlist** )

        **See also** **QMediaContent** .
        """
        ...

    def setMedia(
        self, media: QMediaContent, stream: typing.Optional[QtCore.QIODevice] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#setMedia

        **[slot] void QMediaPlayer::setMedia(const QMediaContent & media ,
        QIODevice * stream = nullptr)**

        Sets the current **media** source.

        If a **stream** is supplied; media data will be read from it instead of
        resolving the media source. In this case the url should be provided to
        resolve additional information about the media such as mime type. The
        **stream** must be open and readable. For macOS the **stream** should be
        also seekable.

        Setting the media to a null **QMediaContent**  will cause the player to
        discard all information relating to the current media source and to
        cease all I/O operations related to that media.

        **Note:** This function returns immediately after recording the
        specified source of the media. It does not wait for the media to finish
        loading and does not check for errors. Listen for the
        **mediaStatusChanged** () and **error** () signals to be notified when
        the media is loaded and when an error occurs during loading.

        Since Qt 5.12.2, the url scheme `gst-pipeline` provides custom pipelines
        for the GStreamer backend.

        player = new **QMediaPlayer** ;
            player->setMedia(**QUrl** ("gst-
        pipeline: videotestsrc ! autovideosink"));
            player->play();

        If **QAbstractVideoSurface**  is used as the video output, `qtvideosink`
        can be used as a video sink element directly in the pipeline. After that
        the surface will receive the video frames in
        **QAbstractVideoSurface::present** ().

        class Surface : public **QAbstractVideoSurface** 
            {
            public:
        Surface(**QObject**  *p) : **QAbstractVideoSurface** (p) { }
        **QList** <**QVideoFrame** ::PixelFormat>
        supportedPixelFormats(**QAbstractVideoBuffer** ::HandleType) const
        override
                {
                    // Make sure that the driver supports
        this pixel format.
                    return **QList** <**QVideoFrame**
        ::PixelFormat>() << **QVideoFrame** ::Format_YUYV;
                }
        // Video frames are handled here.
                bool present(const
        **QVideoFrame**  &) override { return true; }
            };
    
            player =
        new **QMediaPlayer** ;
            player->setVideoOutput(new Surface(player));
        player->setMedia(**QUrl** ("gst-pipeline: videotestsrc ! qtvideosink"));
        player->play();

        If **QVideoWidget**  is used as the video output and the pipeline
        contains a video sink element named `qtvideosink`, current
        **QVideoWidget**  will be used to render the video.

        player = new **QMediaPlayer** ;
            videoWidget = new **QVideoWidget** ;
        videoWidget->show();
            player->setVideoOutput(videoWidget);
        player->setMedia(**QUrl** ("gst-pipeline: videotestsrc ! xvimagesink
        name=\\"qtvideosink\\""));
            player->play();

        If the pipeline contains appsrc element, it will be used to push data
        from **stream**.

        **QImage**  img("images/qt-logo.png");
            img =
        img.convertToFormat(**QImage** ::Format_ARGB32);
            **QByteArray**
        ba(reinterpret_cast<const char \\*>(img.bits()), img.sizeInBytes());
        **QBuffer**  buffer(&ba);
            buffer.open(**QIODevice** ::ReadOnly);
        player = new **QMediaPlayer** ;
            player->setMedia(**QUrl** ("gst-
        pipeline: appsrc blocksize=4294967295 ! \\
        video/x-raw,format=BGRx,framerate=30/1,width=200,height=147 ! \\
        coloreffects preset=heat ! videoconvert ! video/x-raw,format=I420 !
        jpegenc ! rtpjpegpay ! \\
                udpsink host=127.0.0.1 port=5000"),
        &buffer);
            player->play();
    
            **QMediaPlayer**  *receiver = new
        **QMediaPlayer** ;
            videoWidget = new **QVideoWidget** ;
        receiver->setVideoOutput(videoWidget);
            receiver->setMedia(**QUrl**
        ("gst-pipeline: udpsrc port=5000 ! \\
                application/x-rtp,encoding-
        name=JPEG,payload=26 ! rtpjpegdepay ! jpegdec ! \\
                xvimagesink
        name=qtvideosink"));
            receiver->play();
            // Content will be shown
        in this widget.
            videoWidget->show();

        **Note:** Setter function for property **media** .

        **See also** **media** ().
        """
        ...

    def setPlaybackRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#playbackRate-prop

        **playbackRate : qreal**

        This property holds the playback rate of the current media.

        This value is a multiplier applied to the media's standard play rate. By
        default this value is 1.0, indicating that the media is playing at the
        standard pace. Values higher than 1.0 will increase the rate of play.
        Values less than zero can be set and indicate the media should rewind at
        the multiplier of the standard pace.

        Not all playback services support change of the playback rate. It is
        framework defined as to the status and quality of audio and video while
        fast forwarding or rewinding.

        **Access functions:**

        qreal **playbackRate** () const
        void **setPlaybackRate** (qreal
        **rate** )

        **Notifier signal:**

        void ****playbackRateChanged** ** (qreal **rate** )
        """
        ...

    def setMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#muted-prop

        **muted : bool**

        This property holds the muted state of the current media.

        The value will be true if the playback volume is muted; otherwise false.

        **Access functions:**

        bool **isMuted** () const
        void **setMuted** (bool **muted** )

        **Notifier signal:**

        void ****mutedChanged** ** (bool **muted** )
        """
        ...

    def setVolume(self, volume: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#volume-prop

        **volume : int**

        This property holds the current playback volume.

        The playback volume is scaled linearly, ranging from `0` (silence) to
        `100` (full volume). Values outside this range will be clamped.

        By default the volume is `100`.

        UI volume controls should usually be scaled nonlinearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control. See **QAudio::convertVolume** () for more details.

        **Access functions:**

        int **volume** () const
        void **setVolume** (int **volume** )

        **Notifier signal:**

        void ****volumeChanged** ** (int **volume** )

        **Member Function Documentation**
        """
        ...

    def setPosition(self, position: int) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#position-prop

        **position : qint64**

        This property holds the playback position of the current media.

        The value is the current playback position, expressed in milliseconds
        since the beginning of the media. Periodically changes in the position
        will be indicated with the signal **positionChanged** (), the interval
        between updates can be set with **QMediaObject** 's method
        **setNotifyInterval** ().

        **Access functions:**

        qint64 **position** () const
        void **setPosition** (qint64 **position**
        )

        **Notifier signal:**

        void ****positionChanged** ** (qint64 **position** )
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#stop

        **[slot] void QMediaPlayer::stop()**

        Stop playing, and reset the play position to the beginning.
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#pause

        **[slot] void QMediaPlayer::pause()**

        Pause playing the current source.
        """
        ...

    def play(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#play

        **[slot] void QMediaPlayer::play()**

        Start or resume playing the current source.
        """
        ...

    def availability(self) -> "QMultimedia.AvailabilityStatus":
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#availability

        **[override virtual] QMultimedia::AvailabilityStatus
        QMediaPlayer::availability() const**

        Reimplements: **QMediaObject::availability** () const.
        """
        ...

    def currentNetworkConfiguration(self) -> QtNetwork.QNetworkConfiguration:
        ...

    def errorString(self) -> str:
        ...

    def playbackRate(self) -> float:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#playbackRate-prop

        **playbackRate : qreal**

        This property holds the playback rate of the current media.

        This value is a multiplier applied to the media's standard play rate. By
        default this value is 1.0, indicating that the media is playing at the
        standard pace. Values higher than 1.0 will increase the rate of play.
        Values less than zero can be set and indicate the media should rewind at
        the multiplier of the standard pace.

        Not all playback services support change of the playback rate. It is
        framework defined as to the status and quality of audio and video while
        fast forwarding or rewinding.

        **Access functions:**

        qreal **playbackRate** () const
        void **setPlaybackRate** (qreal
        **rate** )

        **Notifier signal:**

        void ****playbackRateChanged** ** (qreal **rate** )
        """
        ...

    def isSeekable(self) -> bool:
        ...

    def bufferStatus(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#bufferStatus-prop

        **bufferStatus : const int**

        This property holds the percentage of the temporary buffer filled before
        playback begins or resumes, from `0` (empty) to `100` (full).

        When the player object is buffering; this property holds the percentage
        of the temporary buffer that is filled. The buffer will need to reach
        100% filled before playback can start or resume, at which time
        **mediaStatus** () will return **BufferedMedia**  or **BufferingMedia**
        . If the value is anything lower than `100`, **mediaStatus** () will
        return **StalledMedia** .

        **Access functions:**

        int **bufferStatus** () const

        **Notifier signal:**

        void ****bufferStatusChanged** ** (int **percentFilled** )

        **See also** **mediaStatus** ().
        """
        ...

    def isVideoAvailable(self) -> bool:
        ...

    def isAudioAvailable(self) -> bool:
        ...

    def isMuted(self) -> bool:
        ...

    def volume(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#volume-prop

        **volume : int**

        This property holds the current playback volume.

        The playback volume is scaled linearly, ranging from `0` (silence) to
        `100` (full volume). Values outside this range will be clamped.

        By default the volume is `100`.

        UI volume controls should usually be scaled nonlinearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control. See **QAudio::convertVolume** () for more details.

        **Access functions:**

        int **volume** () const
        void **setVolume** (int **volume** )

        **Notifier signal:**

        void ****volumeChanged** ** (int **volume** )

        **Member Function Documentation**
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#position-prop

        **position : qint64**

        This property holds the playback position of the current media.

        The value is the current playback position, expressed in milliseconds
        since the beginning of the media. Periodically changes in the position
        will be indicated with the signal **positionChanged** (), the interval
        between updates can be set with **QMediaObject** 's method
        **setNotifyInterval** ().

        **Access functions:**

        qint64 **position** () const
        void **setPosition** (qint64 **position**
        )

        **Notifier signal:**

        void ****positionChanged** ** (qint64 **position** )
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#duration-prop

        **duration : const qint64**

        This property holds the duration of the current media.

        The value is the total playback time in milliseconds of the current
        media. The value may change across the life time of the **QMediaPlayer**
        object and may not be available when initial playback begins, connect to
        the **durationChanged** () signal to receive status notifications.

        **Access functions:**

        qint64 **duration** () const

        **Notifier signal:**

        void ****durationChanged** ** (qint64 **duration** )
        """
        ...

    def mediaStatus(self) -> "QMediaPlayer.MediaStatus":
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#mediaStatus-prop

        **mediaStatus : const MediaStatus**

        This property holds the status of the current media stream.

        The stream status describes how the playback of the current stream is
        progressing.

        By default this property is **QMediaPlayer::NoMedia**

        **Access functions:**

        QMediaPlayer::MediaStatus **mediaStatus** () const

        **Notifier signal:**

        void ****mediaStatusChanged** ** (QMediaPlayer::MediaStatus **status** )

        **See also** **state** .
        """
        ...

    def state(self) -> "QMediaPlayer.State":
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#state-prop

        **state : const State**

        This property holds the media player's playback state.

        By default this property is QMediaPlayer::Stopped

        **Access functions:**

        QMediaPlayer::State **state** () const

        **Notifier signal:**

        void ****stateChanged** ** (QMediaPlayer::State **state** )

        **See also** **mediaStatus** (), **play** (), **pause** (), and **stop**
        ().
        """
        ...

    def currentMedia(self) -> QMediaContent:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#currentMedia-prop

        **currentMedia : const QMediaContent**

        This property holds the current active media content being played by the
        player object. This value could be different from
        **QMediaPlayer::media**  property if a playlist is used. In this case
        currentMedia indicates the current media content being processed by the
        player, while **QMediaPlayer::media**  property contains the original
        playlist.

        **Access functions:**

        QMediaContent **currentMedia** () const

        **Notifier signal:**

        void ****currentMediaChanged** ** (const QMediaContent & **media** )

        **See also** **QMediaContent**  and **media** ().
        """
        ...

    def playlist(self) -> "QMediaPlaylist":
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#playlist-prop

        **playlist : QMediaPlaylist***

        This property holds the media playlist being used by the player object.

        The player object will use the current playlist item for selection of
        the content to be played.

        By default this property is set to null.

        If the media playlist is used as a source,
        **QMediaPlayer::currentMedia**  is updated with a current playlist item.
        The current source should be selected with
        **QMediaPlaylist::setCurrentIndex** (int) instead of
        **QMediaPlayer::setMedia** (), otherwise the current playlist will be
        discarded.

        **Access functions:**

        QMediaPlaylist * **playlist** () const
        void **setPlaylist**
        (QMediaPlaylist * **playlist** )

        **See also** **QMediaContent** .
        """
        ...

    def mediaStream(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#mediaStream

        **const QIODevice *QMediaPlayer::mediaStream() const**

        Returns the stream source of media data.

        This is only valid if a stream was passed to **setMedia** ().

        **See also** **setMedia** ().
        """
        ...

    def media(self) -> QMediaContent:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#media-prop

        **media : QMediaContent**

        This property holds the active media source being used by the player
        object.

        The player object will use the **QMediaContent**  for selection of the
        content to be played.

        By default this property has a null **QMediaContent** .

        Setting this property to a null **QMediaContent**  will cause the player
        to discard all information relating to the current media source and to
        cease all I/O operations related to that media.

        **Access functions:**

        QMediaContent **media** () const
        void ****setMedia** ** (const
        QMediaContent & **media** , QIODevice * **stream** = nullptr)

        **Notifier signal:**

        void ****mediaChanged** ** (const QMediaContent & **media** )

        **See also** **QMediaContent**  and **currentMedia** ().
        """
        ...

    @typing.overload
    def setVideoOutput(self, a0: QVideoWidget) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#setVideoOutput

        **void QMediaPlayer::setVideoOutput(QVideoWidget * output )**

        Attach a **QVideoWidget**  video **output** to the media player.

        If the media player has already video output attached, it will be
        replaced with a new one.
        """
        ...

    @typing.overload
    def setVideoOutput(self, a0: QGraphicsVideoItem) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#setVideoOutput-1

        **void QMediaPlayer::setVideoOutput(QGraphicsVideoItem * output )**

        Attach a **QGraphicsVideoItem**  video **output** to the media player.

        If the media player has already video output attached, it will be
        replaced with a new one.
        """
        ...

    @typing.overload
    def setVideoOutput(self, surface: QAbstractVideoSurface) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#setVideoOutput-2

        **void QMediaPlayer::setVideoOutput(QAbstractVideoSurface * surface )**

        Sets a video **surface** as the video output of a media player.

        If a video output has already been set on the media player the new
        surface will replace it.
        """
        ...

    @typing.overload
    def setVideoOutput(self, surfaces: typing.Iterable[QAbstractVideoSurface]) -> None:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#setVideoOutput-3

        **void QMediaPlayer::setVideoOutput(const QVector<QAbstractVideoSurface
        *> & surfaces )**

        Sets multiple video surfaces as the video output of a media player. This
        allows the media player to render video frames on different surfaces.

        All video surfaces must support at least one shared
        `QVideoFrame::PixelFormat`.

        If a video output has already been set on the media player the new
        surfaces will replace it.

        This function was introduced in Qt 5.15.

        **See also** **QAbstractVideoSurface::supportedPixelFormats** .
        """
        ...

    @staticmethod
    def supportedMimeTypes(
        flags: typing.Union["QMediaPlayer.Flags", "QMediaPlayer.Flag"] = ...
    ) -> typing.List[str]:
        ...

    @staticmethod
    def hasSupport(
        mimeType: str,
        codecs: typing.Iterable[str] = ...,
        flags: typing.Union["QMediaPlayer.Flags", "QMediaPlayer.Flag"] = ...,
    ) -> "QMultimedia.SupportEstimate":
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#hasSupport

        **[static] QMultimedia::SupportEstimate QMediaPlayer::hasSupport(const
        QString & mimeType , const QStringList & codecs = QStringList(),
        QMediaPlayer::Flags flags = Flags())**

        Returns the level of support a media player has for a **mimeType** and a
        set of **codecs**.

        The **flags** argument allows additional requirements such as
        performance indicators to be specified.
        """
        ...

    @property
    def audioAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#audioAvailableChanged

        **[signal] void QMediaPlayer::audioAvailableChanged(bool available )**

        Signals the availability of audio content has changed to **available**.

        **Note:** Notifier signal for property **audioAvailable** .
        """
        ...

    @property
    def audioRoleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#audioRoleChanged

        **[signal] void QMediaPlayer::audioRoleChanged(QAudio::Role role )**

        Signals that the audio **role** of the media player has changed.

        **Note:** Notifier signal for property **audioRole** .

        This function was introduced in Qt 5.6.
        """
        ...

    @property
    def bufferStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#bufferStatusChanged

        **[signal] void QMediaPlayer::bufferStatusChanged(int percentFilled )**

        Signal the amount of the local buffer filled as a percentage by
        **percentFilled**.

        **Note:** Notifier signal for property **bufferStatus** .
        """
        ...

    @property
    def currentMediaChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#currentMediaChanged

        **[signal] void QMediaPlayer::currentMediaChanged(const QMediaContent &
        media )**

        Signals that the current playing content has been changed to **media**.

        **Note:** Notifier signal for property **currentMedia** .

        **See also** **currentMedia** () and **mediaChanged** ().
        """
        ...

    @property
    def customAudioRoleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#customAudioRoleChanged

        **[signal] void QMediaPlayer::customAudioRoleChanged(const QString &
        role )**

        Signals that the audio **role** of the media player has changed.

        **Note:** Notifier signal for property **customAudioRole** .

        This function was introduced in Qt 5.11.
        """
        ...

    @property
    def durationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#durationChanged

        **[signal] void QMediaPlayer::durationChanged(qint64 duration )**

        Signal the duration of the content has changed to **duration** ,
        expressed in milliseconds.

        **Note:** Notifier signal for property **duration** .
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#error

        **QMediaPlayer::Error QMediaPlayer::error() const**

        Returns the current error state.
        """
        ...

    @property
    def mediaChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#mediaChanged

        **[signal] void QMediaPlayer::mediaChanged(const QMediaContent & media
        )**

        Signals that the media source has been changed to **media**.

        **Note:** Notifier signal for property **media** .

        **See also** **media** () and **currentMediaChanged** ().
        """
        ...

    @property
    def mediaStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#mediaStatusChanged

        **[signal] void
        QMediaPlayer::mediaStatusChanged(QMediaPlayer::MediaStatus status )**

        Signals that the **status** of the current media has changed.

        **Note:** Notifier signal for property **mediaStatus** .

        **See also** **mediaStatus** ().
        """
        ...

    @property
    def mutedChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#mutedChanged

        **[signal] void QMediaPlayer::mutedChanged(bool muted )**

        Signal the mute state has changed to **muted**.

        **Note:** Notifier signal for property **muted** .
        """
        ...

    @property
    def playbackRateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#playbackRateChanged

        **[signal] void QMediaPlayer::playbackRateChanged(qreal rate )**

        Signals the **playbackRate**  has changed to **rate**.

        **Note:** Notifier signal for property **playbackRate** .
        """
        ...

    @property
    def positionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#positionChanged

        **[signal] void QMediaPlayer::positionChanged(qint64 position )**

        Signal the position of the content has changed to **position** ,
        expressed in milliseconds.

        **Note:** Notifier signal for property **position** .
        """
        ...

    @property
    def seekableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#seekableChanged

        **[signal] void QMediaPlayer::seekableChanged(bool seekable )**

        Signals the **seekable** status of the player object has changed.

        **Note:** Notifier signal for property **seekable** .
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#stateChanged

        **[signal] void QMediaPlayer::stateChanged(QMediaPlayer::State state )**

        Signal the **state** of the Player object has changed.

        **Note:** Notifier signal for property **state** .
        """
        ...

    @property
    def videoAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#videoAvailableChanged

        **[signal] void QMediaPlayer::videoAvailableChanged(bool videoAvailable
        )**

        Signal the availability of visual content has changed to
        **videoAvailable**.

        **Note:** Notifier signal for property **videoAvailable** .
        """
        ...

    @property
    def volumeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaplayer.html#volumeChanged

        **[signal] void QMediaPlayer::volumeChanged(int volume )**

        Signal the playback volume has changed to **volume**.

        **Note:** Notifier signal for property **volume** .
        """
        ...
