"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore


class QMediaControl(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qmediacontrol.html

    **Detailed Description**

    Media controls provide an interface to individual features provided by a
    media service. Most services implement a principal control which exposes the
    core functionality of the service and a number of optional controls which
    expose any additional functionality.

    A pointer to a control implemented by a media service can be obtained using
    the **QMediaService::requestControl** () member of **QMediaService** . If
    the service doesn't implement a control it will instead return a null
    pointer.

    **QMediaPlayerControl**  *control = qobject_cast<**QMediaPlayerControl**
    *>(
                mediaService->requestControl("org.qt-
    project.qt.mediaplayercontrol/5.0"));

    Alternatively if the IId of the control has been declared using
    **Q_MEDIA_DECLARE_CONTROL**  the template version of
    **QMediaService::requestControl** () can be used to request the service
    without explicitly passing the IId or using **qobject_cast** ().

    **QMediaPlayerControl**  *control =
    mediaService->requestControl<**QMediaPlayerControl**  *>();

    Most application code will not interface directly with a media service's
    controls, instead the **QMediaObject**  which owns the service acts as an
    intermediary between one or more controls and the application.

    **See also** **QMediaService**  and **QMediaObject** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediacontrol.html#QMediaControl

        **[protected] QMediaControl::QMediaControl(QObject * parent = nullptr)**

        Constructs a media control with the given **parent**.
        """
        ...
